/*
 * Decompiled with CFR 0.152.
 */
import com.cognos.crconfig.CRConfigConsole;
import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgSplashScreen;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.CnfgWizardFrame;
import com.cognos.crconfig.CnfgWizardPage;
import com.cognos.crconfig.data.DataManager;
import com.cognos.i18n.ToolkitResources;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class CRConfig {
    public static void main(String[] args) {
        boolean succeed;
        boolean bSilentMode = false;
        boolean bConfigMode = false;
        boolean bForceSave = false;
        boolean bStop = false;
        boolean bUseDefaultEncoding = true;
        boolean bSkipLockCheck = false;
        boolean bWizardMode = false;
        boolean bRunTestOnly = false;
        boolean bWorkGroup = false;
        boolean bTestWLPConf = false;
        boolean bNextIsLocale = false;
        String sLocale = null;
        boolean bNextIsExportFile = false;
        String sExportFileName = null;
        boolean bNextIsWizardName = false;
        String sWizardName = null;
        boolean bUsingCustomServiceName = false;
        boolean bNextIsServiceName = false;
        String sCustomServiceName = null;
        boolean bNextIsStartupFile = false;
        String sConfigINIFileName = null;
        String sTestFolderName = null;
        boolean bDoNotRunTest = false;
        boolean bDoNotDecryptCredentials = false;
        boolean bDoNotVerifyPorts = false;
        boolean bTakeEnv = false;
        boolean bAcceptCert = false;
        Object[] testWLPCommand = new String[3];
        for (int i = 0; i < args.length; ++i) {
            if (bNextIsLocale) {
                bNextIsLocale = false;
                sLocale = args[i];
                continue;
            }
            if (bNextIsExportFile) {
                bNextIsExportFile = false;
                sExportFileName = args[i];
                continue;
            }
            if (bNextIsWizardName) {
                bNextIsWizardName = false;
                sWizardName = args[i].toLowerCase();
                continue;
            }
            if (bNextIsServiceName) {
                sCustomServiceName = args[i];
                bNextIsServiceName = false;
                continue;
            }
            if (bNextIsStartupFile) {
                bNextIsStartupFile = false;
                DataManager.getInstance().loadStartupFile(args[i]);
                continue;
            }
            if (bWorkGroup) {
                sConfigINIFileName = args[i];
                continue;
            }
            if (bRunTestOnly) {
                sTestFolderName = args[i];
                continue;
            }
            if (args[i].equals("-s")) {
                bSilentMode = true;
            }
            if (args[i].equals("-config")) {
                bSilentMode = true;
                bConfigMode = true;
            }
            if (args[i].equals("-save")) {
                bSilentMode = true;
                bConfigMode = true;
                bForceSave = true;
            }
            if (args[i].equals("-csn")) {
                bUsingCustomServiceName = true;
                bNextIsServiceName = true;
            }
            if (args[i].equals("-stop")) {
                bSilentMode = true;
                bStop = true;
                continue;
            }
            if (args[i].equals("-e")) {
                bSilentMode = true;
                bNextIsExportFile = true;
                continue;
            }
            if (args[i].equals("-l")) {
                bNextIsLocale = true;
                continue;
            }
            if (args[i].equals("-d")) {
                CnfgLog.enableDebug();
                continue;
            }
            if (args[i].equals("-log")) {
                CnfgLog.redirectOutput("../logs", "cogconfig");
                continue;
            }
            if (args[i].equals("-utf8")) {
                bUseDefaultEncoding = false;
                continue;
            }
            if (args[i].equals("-nolockcheck")) {
                bSkipLockCheck = true;
                continue;
            }
            if (args[i].equals("-wiz")) {
                bWizardMode = true;
                bNextIsWizardName = true;
                continue;
            }
            if (args[i].equals("-test")) {
                bSilentMode = true;
                bRunTestOnly = true;
                continue;
            }
            if (args[i].equals("-startupfile")) {
                bNextIsStartupFile = true;
                continue;
            }
            if (args[i].equals("-trunkstart") || args[i].equals("-notest")) {
                bSilentMode = true;
                bDoNotRunTest = true;
                continue;
            }
            if (args[i].equals("-h")) {
                CRConfig.printHelpAndExit();
                continue;
            }
            if (args[i].equals("-trunksetup")) {
                CnfgUtils.setInternalSetup(true);
                continue;
            }
            if (args[i].equals("-workgroup")) {
                bWorkGroup = true;
                bStop = false;
                CnfgLog.redirectOutput("../logs", "cogconfig");
                continue;
            }
            if (args[i].equals("-workgroup_nostart")) {
                bWorkGroup = true;
                bStop = true;
                continue;
            }
            if (args[i].equals("-expandstart")) {
                bSilentMode = true;
                bDoNotDecryptCredentials = true;
                continue;
            }
            if (args[i].equals("-smoketest")) {
                CnfgUtils.setSmoketestSetup(true);
                continue;
            }
            if (args[i].equals("-takeEnv")) {
                bTakeEnv = true;
                DataManager.setRespectEnvVar(true);
                continue;
            }
            if (args[i].equals("-noverifyports")) {
                bSilentMode = true;
                bDoNotVerifyPorts = true;
                continue;
            }
            if (args[i].equals("-acceptcert")) {
                bAcceptCert = true;
                continue;
            }
            if (!args[i].equals("-testwlpcognosserver") && !args[i].equals("-testwlpdatasetservice")) continue;
            bTestWLPConf = true;
            if (CRConfig.parseTestWLPArgs(args, i)) {
                System.arraycopy(args, i, testWLPCommand, 0, 3);
                break;
            }
            System.arraycopy(args, i, testWLPCommand, 0, 1);
            break;
        }
        CnfgLog.redirectOutput("../logs", "cogconfig");
        CnfgLog.info("========== Cognos Configuration =========");
        if (bTakeEnv) {
            CnfgLog.info("Some environment variables are taking place of what were in config");
        }
        CRConfig.setupLocalResource(sLocale);
        CRConfig.setupSystemProperties(bAcceptCert, bUsingCustomServiceName, sCustomServiceName);
        if (bTestWLPConf) {
            CnfgLog.info("Start testing wlp file upgrade, command is: " + Arrays.toString(testWLPCommand));
            succeed = CnfgUtils.testWLPConfFiles((String[])testWLPCommand);
            CnfgLog.info("Finish testing wlp file upgrade with status: '" + (succeed ? "Succeed" : "Failed") + "'.");
            System.exit(succeed ? 0 : 1);
        }
        if (bWorkGroup) {
            CnfgLog.info("Start configuration and launch the IBM Cognos servers for WorkGroup install... ...");
            succeed = CnfgUtils.ConfigureAndLaunch(sConfigINIFileName, !bStop);
            CnfgLog.info("Finish launching IBM Cognos servers for WorkGroup install with status: '" + (succeed ? "Succeed" : "Failed") + "'.");
            System.exit(succeed ? 0 : 1);
        }
        if (bSilentMode) {
            String sError = CnfgUtils.validateJavaVersion();
            if (sError != null) {
                CnfgLog.error(sError);
                System.out.println(sError);
                System.exit(1);
            }
            System.setProperty("java.awt.headless", "true");
            DataManager.getInstance().addView("CNFGUI");
            CRConfigConsole console = new CRConfigConsole();
            console.setConfigOnlyMode(bConfigMode);
            console.setForceSaveMode(bForceSave);
            console.setStartWithNoTestMode(bDoNotRunTest);
            console.setStartWithNoVerifyPorts(bDoNotVerifyPorts);
            DataManager.getInstance().setDoNotDecryptCredentials(bDoNotDecryptCredentials);
            if (bStop) {
                console.stopService();
            } else {
                console.begin(sExportFileName, bUseDefaultEncoding, bSkipLockCheck, bRunTestOnly, sTestFolderName);
            }
        } else if (bWizardMode && sWizardName != null && sWizardName.length() > 0) {
            CRConfig.doWizardMode(sWizardName, bSkipLockCheck);
        } else {
            CRConfig.doGraphicMode(bSkipLockCheck);
        }
    }

    private static void setupLocalResource(String sLocale) {
        int dotIndex;
        if (sLocale == null) {
            sLocale = CnfgPreferences.getInstance().getProperty("language", "en");
        }
        String sLang = "";
        String sCountry = "";
        String sVariant = "";
        int dashChar = 45;
        int dotChar = 46;
        String sNormalizedLocale = ToolkitResources.normalizeLocaleIdentifier((String)sLocale);
        int dashIndex = sNormalizedLocale.indexOf(dashChar);
        if (dashIndex < 0) {
            dotIndex = sNormalizedLocale.indexOf(dotChar);
            if (dotIndex >= 0) {
                sLang = sNormalizedLocale.substring(0, dotIndex).toLowerCase();
                sVariant = sNormalizedLocale.substring(dotIndex + 1);
            } else {
                sLang = sNormalizedLocale.toLowerCase();
            }
        } else {
            dotIndex = sNormalizedLocale.indexOf(dotChar, dashIndex + 1);
            sLang = sNormalizedLocale.substring(0, dashIndex).toLowerCase();
            if (dotIndex >= 0) {
                sCountry = sNormalizedLocale.substring(dashIndex + 1, dotIndex).toUpperCase();
                sVariant = sNormalizedLocale.substring(dotIndex + 1);
            } else {
                sCountry = sNormalizedLocale.substring(dashIndex + 1).toUpperCase();
            }
        }
        Locale locale = new Locale(sLang, sCountry, sVariant);
        try {
            CnfgResource.setJVMInitialLocale(Locale.getDefault());
            ResourceBundle rb = ResourceBundle.getBundle("cogconfig", locale);
            CnfgResource.setResourceBundle(rb);
            Locale rbLocale = rb.getLocale();
            if (rbLocale.getLanguage().length() == 0 && rbLocale.getCountry().length() == 0 && rbLocale.getVariant().length() == 0) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CRConfig - Reverted to the default 'cogconfig' property file (English), setting locale to English.");
                }
                Locale.setDefault(Locale.ENGLISH);
                CnfgResource.setLocale(Locale.ENGLISH);
            } else {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CRConfig - Found 'cogconfig' property file for locale '" + rbLocale + "'");
                }
                Locale.setDefault(rbLocale);
                CnfgResource.setLocale(rbLocale);
            }
        }
        catch (MissingResourceException mre) {
            CnfgLog.error(mre);
            CnfgLog.error("'cogconfig' property file for locale '" + locale.getDisplayName(Locale.ENGLISH) + "' not found. As well, unable to find the default property file.");
            System.exit(1);
        }
    }

    private static void setupSystemProperties(boolean bAcceptCert, boolean bUsingCustomServiceName, String sCustomServiceName) {
        System.setProperty("COG_ROOT", DataManager.getPathToInstallDir());
        System.setProperty("install.dir", DataManager.getPathToInstallDir());
        if (bAcceptCert) {
            CnfgLog.info("set system property CamCryptoAcceptSSLCertDefaultAnswer to yes");
            System.setProperty("CamCryptoAcceptSSLCertDefaultAnswer", "yes");
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug(DataManager.getSystemInfo());
        }
        if (bUsingCustomServiceName) {
            CnfgPreferences.getInstance().setProperty("CustomServiceName", sCustomServiceName);
        }
    }

    private static void doWizardMode(String sWizardName, boolean bSkipLockCheck) {
        DataManager.getInstance().addView(sWizardName);
        boolean noGraphics = false;
        try {
            String sLookAndFeel = UIManager.getSystemLookAndFeelClassName();
            if (sLookAndFeel.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                UIManager.setLookAndFeel(sLookAndFeel);
            } else {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            CRConfigFrame mainFrame = null;
            try {
                mainFrame = CRConfigFrame.getInstance();
            }
            catch (ExceptionInInitializerError e) {
                noGraphics = true;
                throw e;
            }
            mainFrame.init(true);
            mainFrame.toFront();
            CnfgSplashScreen splash = new CnfgSplashScreen(mainFrame, "cogconfigspl", false);
            mainFrame.setSplashScreen(splash);
            splash.toFront();
            splash.setVisible(true);
            CnfgWizard wiz = CnfgWizard.getInstance();
            wiz.setCurrentWizard(true, sWizardName);
            CnfgWizardFrame wizFrame = new CnfgWizardFrame();
            mainFrame.getLock(bSkipLockCheck, false);
            mainFrame.initDataManager();
            wiz.setWizardContent(sWizardName);
            wizFrame.loadData(wiz);
            CnfgWizardPage cwp = wiz.getCurrentWizardPage();
            splash.setVisible(false);
            splash.dispose();
            if (cwp != null) {
                mainFrame.checkJava();
                wizFrame.setVisible(true);
                wizFrame.refresh(cwp);
            } else {
                String sMessage = new StringBuffer(CnfgResource.getMessage("Message.wizard.load.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.run.failed.explanation")).append("\n").append(CnfgResource.getMessage("Message.wizard.load.failed.resolution")).toString();
                String sTitle = CnfgResource.getMessage("Application.title");
                JOptionPane.showMessageDialog(CRConfigFrame.getInstance(), sMessage, sTitle, 0);
                System.exit(1);
            }
        }
        catch (Throwable e) {
            CnfgLog.error(e);
            Throwable cause = e.getCause();
            if (cause != null) {
                CnfgLog.error(cause);
            }
            if (!noGraphics) {
                String sMessage = new StringBuffer(CnfgResource.getMessage("Message.run.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.run.failed.explanation")).append("\n").append(e.toString()).append("\n").append(CnfgResource.getMessage("Message.run.failed.resolution")).toString();
                String sTitle = CnfgResource.getMessage("Application.title");
                JOptionPane.showMessageDialog(CRConfigFrame.getInstance(), sMessage, sTitle, 0);
            }
            System.exit(1);
        }
    }

    private static void doGraphicMode(boolean bSkipLockCheck) {
        String sError = CnfgUtils.validateJavaVersion();
        if (sError != null) {
            CnfgLog.error(sError);
            String sTitle = CnfgResource.getMessage("Application.title");
            JOptionPane.showMessageDialog(CRConfigFrame.getInstance(), sError, sTitle, 0);
            System.exit(1);
        }
        DataManager.getInstance().addView("CNFGUI");
        boolean noGraphics = false;
        try {
            String sLookAndFeel = UIManager.getSystemLookAndFeelClassName();
            if (sLookAndFeel.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                UIManager.setLookAndFeel(sLookAndFeel);
            } else {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            CRConfigFrame mainFrame = null;
            try {
                mainFrame = CRConfigFrame.getInstance();
            }
            catch (ExceptionInInitializerError e) {
                noGraphics = true;
                throw e;
            }
            mainFrame.init(false);
            mainFrame.toFront();
            CnfgSplashScreen splash = new CnfgSplashScreen(mainFrame, "cogconfigspl", false);
            mainFrame.setSplashScreen(splash);
            mainFrame.setVisible(true);
            splash.toFront();
            splash.setVisible(true);
            mainFrame.setEnabled(false);
            mainFrame.getLock(bSkipLockCheck, true);
            mainFrame.initDataManager();
            splash.setVisible(false);
            splash.dispose();
            mainFrame.repaint();
            mainFrame.checkJava();
            mainFrame.setEnabled(true);
        }
        catch (Throwable e) {
            CnfgLog.error(e);
            Throwable cause = e.getCause();
            if (cause != null) {
                CnfgLog.error(cause);
            }
            if (!noGraphics) {
                String sMessage = new StringBuffer(CnfgResource.getMessage("Message.run.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.run.failed.explanation")).append("\n").append(e.toString()).append("\n").append(CnfgResource.getMessage("Message.run.failed.resolution")).toString();
                String sTitle = CnfgResource.getMessage("Application.title");
                JOptionPane.showMessageDialog(CRConfigFrame.getInstance(), sMessage, sTitle, 0);
            }
            System.exit(1);
        }
    }

    private static boolean parseTestWLPArgs(String[] args, int i) {
        int nextidx;
        String nextarg;
        return i < args.length - 1 && (nextarg = args[nextidx = i + 1]) != null && (nextarg.equalsIgnoreCase("-serverxml") || nextarg.equalsIgnoreCase("-bootstrap") || nextarg.equalsIgnoreCase("-jvmoptions")) && nextidx < args.length - 1 && (nextarg = args[nextidx + 1]) != null && nextarg.length() > 0;
    }

    private static void printHelpAndExit() {
        StringBuilder msg = new StringBuilder("IBM Cognos Configuration\n").append("Usage: cogconfig [options]").append("\n\tOptions:").append("\n\t\t-s : \n\t\t\tValidate, save, test and start the services silently").append("\n\t\t-config :\n\t\t\tValidate the existing configuration. If anything has changed, it will save the configuration to disk.\n\t\t\tIf this is CM install and is running, it will also populate the AAA settings to the server.\n\t\t\tThis option doesn't test and start the services.").append("\n\t\t-save :\n\t\t\tForce to save configuration to disk.\n\t\t\tIf this is CM install and is running, it will also populate the AAA settings to the server.\n\t\t\tThis option doesn't test and start the services.").append("\n\t\t-csn <name> :\n\t\t\tUse custom service name <name>").append("\n\t\t-stop :\n\t\t\tStop all services").append("\n\t\t-e <file> :\n\t\t\tExport configuration to file <file>").append("\n\t\t-l <locale> :\n\t\t\tDisplay the config UI in <locale> language").append("\n\t\t-d :\n\t\t\tEnable debug mode").append("\n\t\t-nolockcheck :\n\t\t\tDon't check for lock file").append("\n\t\t-test <node name to test>:\n\t\t\tTest configuration silently. You may specify the node name to test, e.g. -test AAA").append("\n\t\t-notest :\n\t\t\tValidate, save and start the services silently without testing.").append("\n\t\t-startupfile <path>\n\t\t\tImport the configuration file specified by <path>. (if path is \"-\", stdin is used)").append("\n\t\t-takeEnv :\n\t\t\tSupported list of environment variables, prefixed by ").append("IBMCA_CNFG_").append(" will override those in original cogconfig.").append("\n\t\t-acceptcert :\n\t\t\tIndicates accepting CA cert explicitly when first time start CA with https.").append("\n\t\t-testwlpcognosserver|testwlpdatasetservice -serverxml|bootstrap|jvmoptions <wlp conf file name> :\n\t\t\tLoad the specified file and save it with upgrade changes.");
        System.out.println(msg.toString());
        System.exit(0);
    }
}

