/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.State;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class AliasRoot {
    private String winURI = "";
    private String unixURI = "";
    public static final String winURIstr = "winURI";
    public static final String unixURIstr = "unixURI";
    private static final String fileSchemeString = "file://";

    public AliasRoot() {
    }

    public AliasRoot(String winURI, String unixURI) {
        if (winURI != null) {
            this.winURI = winURI;
        }
        if (unixURI != null) {
            this.unixURI = unixURI;
        }
    }

    public AliasRoot(AliasRoot aliasRoot) {
        this.winURI = aliasRoot.winURI;
        this.unixURI = aliasRoot.unixURI;
    }

    public String getWindowsURI() {
        return this.winURI;
    }

    public String getUnixURI() {
        return this.unixURI;
    }

    public boolean hasWindowsURI() {
        return !this.winURI.isEmpty();
    }

    public boolean hasUnixURI() {
        return !this.unixURI.isEmpty();
    }

    public void setWindowsURI(String uri) {
        this.winURI = uri;
    }

    public void setUnixURI(String uri) {
        this.unixURI = uri;
    }

    public String getDisplayValue() {
        if (!this.winURI.isEmpty() && !this.unixURI.isEmpty()) {
            return this.winURI + ", " + this.unixURI;
        }
        if (!this.winURI.isEmpty()) {
            return this.winURI;
        }
        return this.unixURI;
    }

    public boolean isEmpty() {
        return !(this.winURI != null && !this.winURI.isEmpty() || this.unixURI != null && !this.unixURI.isEmpty());
    }

    public String toString() {
        return this.getDisplayValue();
    }

    public State validate() {
        State state = new State();
        if (this.isEmpty()) {
            state.setValue(State.ERROR);
            state.setCode(1);
            Object[] args = new Object[]{CnfgResource.getMessage("Label.DialogAliasRoots.hdrValue")};
            state.setMessage(CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args));
            return state;
        }
        state = this.validateWinURI(this.winURI);
        if (!state.isOK()) {
            state.insertMessage(CnfgResource.getMessage("Label.DialogAliasRootsURI.win") + ": ");
        }
        if (state.isError()) {
            return state;
        }
        State unixState = this.validateUnixURI(this.unixURI);
        if (!unixState.isOK()) {
            unixState.insertMessage(CnfgResource.getMessage("Label.DialogAliasRootsURI.unix") + ": ");
        }
        if (unixState.isError()) {
            return unixState;
        }
        if (CnfgUtils.isWindowsPlatform()) {
            return state;
        }
        return unixState;
    }

    private State validateWinURI(String winURI) {
        State state = new State();
        if (!winURI.isEmpty()) {
            URI uri = this.convertStringToURI(winURI, state);
            if (!state.isOK()) {
                return state;
            }
            state = this.validateURI(uri);
            if (!state.isOK()) {
                return state;
            }
            if (CnfgUtils.isWindowsPlatform()) {
                File file = null;
                String path = null;
                String authority = uri.getAuthority();
                if (authority == null) {
                    file = new File(uri);
                    path = file.getAbsolutePath();
                } else {
                    if (this.isWinDriveName(authority)) {
                        state.setValue(State.ERROR);
                        state.setCode(2);
                        Object[] args = new Object[]{authority};
                        state.setMessage(CnfgResource.getMessage("Message.errorOnValidation.aliasRootsURI.winError", args));
                        return state;
                    }
                    path = "\\\\" + uri.getAuthority() + uri.getPath().replace('/', '\\');
                    file = new File(path);
                }
                if (!file.exists()) {
                    state.setValue(State.WARNING);
                    state.setCode(2);
                    Object[] args = new Object[]{path};
                    state.setMessage(CnfgResource.getMessage("Message.errorOnEditPath.pathnotexist.notification", args));
                }
            }
        } else if (CnfgUtils.isWindowsPlatform()) {
            state.setValue(State.ERROR);
            state.setCode(1);
            Object[] args = new Object[]{CnfgResource.getMessage("Label.DialogAliasRootsURI.win")};
            state.setMessage(CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args));
        }
        return state;
    }

    private boolean isWinDriveName(String value) {
        return value.length() == 2 && Character.isLetter(value.charAt(0)) && value.charAt(1) == ':';
    }

    private State validateUnixURI(String unixURI) {
        State state = new State();
        if (!unixURI.isEmpty()) {
            File file;
            URI uri = this.convertStringToURI(unixURI, state);
            if (!state.isOK()) {
                return state;
            }
            if (uri.getAuthority() != null) {
                state.setValue(State.ERROR);
                state.setCode(2);
                state.setMessage(CnfgResource.getMessage("Message.errorOnValidation.uri.authorityUnsupported"));
                return state;
            }
            state = this.validateURI(uri);
            if (!state.isOK()) {
                return state;
            }
            if (CnfgUtils.isUnixPlatform() && !(file = new File(uri)).exists()) {
                state.setValue(State.WARNING);
                state.setCode(2);
                Object[] args = new Object[]{file.getAbsolutePath()};
                state.setMessage(CnfgResource.getMessage("Message.errorOnEditPath.pathnotexist.notification", args));
            }
        } else if (CnfgUtils.isUnixPlatform()) {
            state.setValue(State.ERROR);
            state.setCode(1);
            Object[] args = new Object[]{CnfgResource.getMessage("Label.DialogAliasRootsURI.unix")};
            state.setMessage(CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args));
        }
        return state;
    }

    private URI convertStringToURI(String uriStr, State state) {
        URI uri;
        block5: {
            uri = null;
            if (!uriStr.startsWith(fileSchemeString)) {
                this.setURIError(state);
                return uri;
            }
            try {
                String encodedURI = URIUtil.encodePath((String)uriStr, (String)"UTF8");
                uri = new URI(encodedURI);
            }
            catch (URISyntaxException e) {
                this.setURIError(state);
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug(e);
                }
            }
            catch (URIException e) {
                this.setURIError(state);
                if (!CnfgLog.isDebugEnabled()) break block5;
                CnfgLog.debug(e);
            }
        }
        return uri;
    }

    private void setURIError(State state) {
        state.setValue(State.ERROR);
        state.setCode(2);
        state.setMessage(CnfgResource.getMessage("Message.errorOnValidation.absoluteURI.error"));
    }

    private State validateURI(URI uri) {
        State state = new State();
        String scheme = uri.getScheme();
        if (scheme == null || scheme.compareToIgnoreCase("file") != 0) {
            state.setValue(State.ERROR);
            state.setCode(2);
            state.setMessage(CnfgResource.getMessage("Message.errorOnValidation.uri.fileFormatInvalid"));
            return state;
        }
        String path = uri.getPath();
        if (path.isEmpty()) {
            state.setValue(State.ERROR);
            state.setCode(2);
            state.setMessage(CnfgResource.getMessage("Message.errorOnValidation.url.path"));
            return state;
        }
        if (path.indexOf("./") >= 0 || path.indexOf(".\\") >= 0 || path.endsWith(".")) {
            state.setValue(State.ERROR);
            state.setCode(2);
            state.setMessage(CnfgResource.getMessage("Message.errorOnValidation.absoluteURI.error"));
            return state;
        }
        return state;
    }
}

