/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.AliasRoot;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.MappingBaseModel;
import com.cognos.crconfig.State;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.editors.EditorAliasRootURI;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AliasRootsModel
extends MappingBaseModel {
    @Override
    protected void loadModel() throws DataManagerException {
        this.m_tmPageModels = new MappingBaseModel.emTableModel[1];
        this.m_tmPageModels[0] = new emTableModelAliasRoots("aliasRoots");
        this.m_tabCount = 1;
        this.m_paramTabCount = 0;
        this.loadData();
    }

    public void validate(List<String> lErrors) {
        if (!this.m_tmPageModels[0].isValid()) {
            String sLabel = "";
            String sParentLabel = "";
            Parameter aliasRoots = DataManager.getInstance().findParm("aliasRoots");
            if (aliasRoots != null) {
                sLabel = aliasRoots.getLabel();
                if (aliasRoots.getParent() != null) {
                    sParentLabel = aliasRoots.getParent().getLabel();
                }
            }
            Object[] args = new Object[]{sLabel, sParentLabel};
            String sMessage = CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args);
            lErrors.add(sMessage);
        }
    }

    private class emTableModelAliasRoots
    extends MappingBaseModel.emTableModel {
        private static final long serialVersionUID = -2900667648830401755L;

        public emTableModelAliasRoots(String tagName) {
            super(AliasRootsModel.this, tagName, "aliasRoot");
            this.m_key = new ArrayList();
            this.COL_CUSTOM = 1;
            this.COL_KEY = 2;
            this.COL_VALUE = 3;
            this.COL_DESC = -1;
            this.m_browser = EditorAliasRootURI.class;
        }

        @Override
        public String getColumnName(int col) {
            if (col == this.COL_KEY) {
                return CnfgResource.getMessage("Label.DialogAliasRoots.hdrKey");
            }
            if (col == this.COL_VALUE) {
                return CnfgResource.getMessage("Label.DialogAliasRoots.hdrValue");
            }
            return super.getColumnName(col);
        }

        public State validateKey(String key) {
            State state = new State();
            if (key.isEmpty()) {
                state.setValue(State.ERROR);
                state.setCode(1);
                Object[] args = new Object[]{CnfgResource.getMessage("Label.DialogAliasRoots.hdrKey")};
                state.setMessage(CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args));
                return state;
            }
            String illegalCharacters = "=;";
            for (char ch : "=;".toCharArray()) {
                if (key.indexOf(ch) < 0) continue;
                state.setValue(State.ERROR);
                state.setCode(1);
                Object[] args = new Object[]{""};
                args[0] = Character.valueOf(ch);
                state.setMessage(CnfgResource.getMessage("Message.errorOnValidation.invalidCharsInAliasRoot", args));
                return state;
            }
            String scheme = "alias:";
            try {
                new URI("alias:" + key);
            }
            catch (URISyntaxException e) {
                state.setValue(State.ERROR);
                state.setCode(1);
                Object[] args = new Object[]{""};
                int ind = e.getIndex();
                if (ind > -1) {
                    args[0] = Character.valueOf(key.charAt(ind - "alias:".length()));
                }
                state.setMessage(CnfgResource.getMessage("Message.errorOnValidation.invalidCharsInAliasRoot", args));
                return state;
            }
            return state;
        }

        @Override
        public int isRowValid(int row) {
            State state = new State();
            AliasRoot value = (AliasRoot)this.m_value.get(row);
            state = this.validateKey((String)this.m_key.get(row));
            if (state.isOK()) {
                state = value.validate();
            }
            if (state.isOK()) {
                String sKey = ((String)this.m_key.get(row)).toString();
                for (int j = 0; j < this.m_key.size(); ++j) {
                    String sName;
                    if (j == row || sKey.compareTo(sName = ((String)this.m_key.get(j)).toString()) != 0) continue;
                    state.setValue(State.ERROR);
                    state.setCode(4);
                    Object[] args = new Object[]{sKey};
                    state.setMessage(CnfgResource.getMessage("Message.globalConfiguration.existing.entry", args));
                    break;
                }
            }
            if (this.m_valid.size() > row) {
                this.m_valid.set(row, state);
            } else {
                this.m_valid.add(state);
            }
            return state.getCode();
        }

        protected int add(String key, AliasRoot value) {
            this.m_select.add(new Boolean(false));
            if (this.m_key != null) {
                this.m_key.add(key);
            }
            this.m_value.add(value);
            int iRes = this.isRowValid(this.m_key.lastIndexOf(key));
            if (iRes > 0) {
                AliasRootsModel.this.setDirtyFlag(true);
            }
            this.fireTableRowsInserted(this.m_count, this.m_count);
            return this.m_count++;
        }

        @Override
        protected void load(Element parentElement) {
            Element itemElement;
            Iterator elementIterator = parentElement.elements("parameter").iterator();
            Element valueElement = null;
            while (elementIterator.hasNext()) {
                Element paramElement = (Element)elementIterator.next();
                String sPName = paramElement.attributeValue("name", "");
                if (sPName == null || !sPName.equals("aliasRoots")) continue;
                valueElement = paramElement;
                break;
            }
            if (null != valueElement && null != (itemElement = valueElement.element("value"))) {
                for (Element entry : itemElement.elements("item")) {
                    if (this.m_key == null) continue;
                    String key = null;
                    Element nameElement = entry.element("name");
                    if (nameElement == null) continue;
                    key = nameElement.getText();
                    AliasRoot value = new AliasRoot();
                    if (key != null && key.length() > 0) {
                        Element winElement = entry.element("windowsURI");
                        Element unixElement = entry.element("unixURI");
                        if (winElement != null && unixElement != null) {
                            value.setWindowsURI(winElement.getText());
                            value.setUnixURI(unixElement.getText());
                        }
                    }
                    if (value == null) continue;
                    this.add(key, value);
                }
            }
        }

        @Override
        public Object getEmptyValue() {
            return new AliasRoot();
        }

        @Override
        protected void save(Element parentElement) {
            Element itemElement;
            Iterator elementIterator = parentElement.elements("parameter").iterator();
            Element valueElement = null;
            while (elementIterator.hasNext()) {
                Element paramElement = (Element)elementIterator.next();
                String sPName = paramElement.attributeValue("name", "");
                if (sPName == null || !sPName.equals("aliasRoots")) continue;
                valueElement = paramElement;
                break;
            }
            if (valueElement == null) {
                valueElement = DocumentHelper.createElement((String)"parameter");
                Attribute name = DocumentHelper.createAttribute((Element)valueElement, (String)"name", (String)"aliasRoots");
                valueElement.add(name);
                parentElement.add(valueElement);
                Element newValueElement = DocumentHelper.createElement((String)"value");
                valueElement.add(newValueElement);
            }
            if (null != valueElement && null != (itemElement = valueElement.element("value"))) {
                for (Element entry : itemElement.elements("item")) {
                    itemElement.remove(entry);
                }
                Iterator valueIterator = this.m_value.iterator();
                int indOfEntry = 0;
                while (valueIterator.hasNext()) {
                    AliasRoot entry = (AliasRoot)valueIterator.next();
                    String winURI = entry.getWindowsURI();
                    String unixURI = entry.getUnixURI();
                    if (!winURI.isEmpty() || !unixURI.isEmpty()) {
                        Element newItemElement = DocumentHelper.createElement((String)"item");
                        itemElement.add(newItemElement);
                        Element nameElem = DocumentHelper.createElement((String)"name");
                        String keyValue = (String)this.m_key.get(indOfEntry);
                        nameElem.setText(keyValue);
                        newItemElement.add(nameElem);
                        Element winURIElem = DocumentHelper.createElement((String)"windowsURI");
                        winURIElem.setText(winURI);
                        newItemElement.add(winURIElem);
                        Element unixURIElem = DocumentHelper.createElement((String)"unixURI");
                        unixURIElem.setText(unixURI);
                        newItemElement.add(unixURIElem);
                    }
                    ++indOfEntry;
                }
            }
        }
    }
}

