/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgActionClient;
import com.cognos.crconfig.CnfgConsoleClient;
import com.cognos.crconfig.CnfgLock;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.cognos.crconfig.TaskCollectorException;
import com.cognos.crconfig.data.CnfgAction;
import com.cognos.crconfig.data.CnfgActionEngine;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.ConfigFileNotFoundException;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.StartupFileException;
import com.cognos.crconfig.data.service.CnfgServiceUtils;
import com.cognos.crconfig.data.service.ServiceFolder;
import com.cognos.crconfig.data.service.ServiceManager;
import com.cognos.crconfig.test.TestTaskManager;
import com.cognos.i18n.ToolkitResources;
import com.cognos.indications.LogIPFControl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CRConfigConsole
implements DataManager.ITaskCollector {
    protected static final String RESPONSE_FILEPATH = "../logs/cogconfig_response.csv";
    private OutputStreamWriter m_sw;
    private int m_errCode;
    private boolean m_bIPFInitialized;
    private static final String sMain = "\"[main]\"";
    private static final String sSep1 = ", \"";
    private static final String sSep2 = "\"\n";
    private boolean bConfigOnly = false;
    private boolean bForceSave = false;
    private boolean bStartWithNoTest = false;
    private boolean bStartWithNoVerifyPorts = false;

    public void setConfigOnlyMode(boolean value) {
        this.bConfigOnly = value;
    }

    public void setForceSaveMode(boolean bValue) {
        this.bForceSave = bValue;
    }

    public void setStartWithNoTestMode(boolean value) {
        this.bStartWithNoTest = value;
    }

    public void setStartWithNoVerifyPorts(boolean value) {
        this.bStartWithNoVerifyPorts = value;
    }

    public void begin(String exportFile, boolean defaultEncoding, boolean bSkipLockCheck, boolean bRunTest, String sTestFolderName) {
        try {
            block33: {
                DataManager dm = DataManager.getInstance();
                File resp_dir = dm.resolveEffectiveFilePath(RESPONSE_FILEPATH);
                this.backUpResponseFile(resp_dir);
                String encoding = ToolkitResources.getDefaultEncoding();
                this.m_sw = new OutputStreamWriter((OutputStream)new FileOutputStream(resp_dir), encoding);
                this.m_sw.write(new StringBuffer("INFO, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.silent.begin")).append(sSep2).toString());
                this.m_sw.write(new StringBuffer("EXEC, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.silent.load")).append(sSep2).toString());
                try {
                    boolean bGotIt = CnfgLock.getLock(bSkipLockCheck);
                    if (!bGotIt) {
                        this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.silent.getlock.failed.notification")).append(sSep2).toString());
                        this.m_errCode = 7;
                        break block33;
                    }
                    CnfgLock.deleteOnExit(bSkipLockCheck);
                    if (DataManager.getInstance().checkConfigurationFiles()) {
                        String dMessage = new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.explanation")).append("\n").append(CnfgResource.getMessage("Message.defaultConfig.create.notification")).toString();
                        this.m_sw.write(new StringBuffer("INFO, ").append(sMain).append(sSep1).append(dMessage).append(sSep2).toString());
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug(dMessage);
                        }
                    }
                    boolean bIsUpgraded = false;
                    if (dm.checkUpgrade()) {
                        try {
                            bIsUpgraded = dm.upgradeConfigFile();
                            if (bIsUpgraded) {
                                String sMessage = new StringBuffer(CnfgResource.getMessage("Message.upgradeConfig.notification")).append("\n").append(CnfgResource.getMessage("Message.upgradeConfig.success.notification")).toString();
                                this.m_sw.write(new StringBuffer("INFO, ").append(sMain).append(sSep1).append(sMessage).append(sSep2).toString());
                                if (CnfgLog.isDebugEnabled()) {
                                    CnfgLog.debug(sMessage);
                                }
                            }
                        }
                        catch (DataManagerException e) {
                            String sMessage = new StringBuffer(CnfgResource.getMessage("Message.upgradeConfig.notification")).append("\n").append(CnfgResource.getMessage("Message.upgradeConfig.failed.notification")).append("\n").toString();
                            DataManagerException upgradeException = new DataManagerException(sMessage + e.getMessage());
                            throw upgradeException;
                        }
                    }
                    String sIPFConfigFileName = (String)CnfgPreferences.getInstance().getProperty("IPFConfigFileName", "../configuration/cogconfigipf.xml", String.class);
                    this.m_bIPFInitialized = LogIPFControl.initialize((String)CCLConfigurationFactory.getInstance().resolveEffectivePath(sIPFConfigFileName));
                    dm.getConfig();
                    if (bIsUpgraded) {
                        dm.mergeServicesList(dm.getAllServices());
                        DataManager.getInstance().customizedUpgrade();
                    }
                    this.m_sw.write(new StringBuffer("SUCCESS, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.silent.status.success")).append(sSep2).toString());
                    String sError = CnfgUtils.checkJava();
                    if (sError != null) {
                        this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(sError).append(sSep2).toString());
                        this.m_sw.close();
                        this.m_errCode = 8;
                    } else {
                        CnfgConsoleClient actionClient = new CnfgConsoleClient(this.m_sw);
                        CnfgActionEngine engine = new CnfgActionEngine();
                        if (bRunTest) {
                            final ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
                            Folder testedFolder = null;
                            CnfgLog.debug("test foldername: " + sTestFolderName);
                            if (!StringUtils.isBlank((String)sTestFolderName)) {
                                testedFolder = DataManager.getInstance().findFolder(sTestFolderName, true);
                                CnfgLog.debug("found tested folder: " + (testedFolder != null ? "yes" : "no"));
                            }
                            if (testedFolder == null) {
                                testedFolder = dm.getRootFolder();
                            }
                            TestTaskManager.setIgnoreCheckingSaveConfig(true);
                            Map<String, ICnfgTest> initializedClasses = TestTaskManager.getTestTasks(this, testedFolder, tasklist, false, true, false, actionClient.getFeedback());
                            if (!engine.run(new CnfgAction(){

                                @Override
                                public ICnfgTask[] getTasks() {
                                    return CnfgTask.createTaskArray(tasklist);
                                }

                                @Override
                                public String getName() {
                                    return "test";
                                }
                            }, actionClient)) {
                                this.m_errCode = 9;
                            }
                            if (initializedClasses != null) {
                                TestTaskManager.terminateTestProviders(initializedClasses, actionClient.getFeedback());
                            }
                        } else {
                            dm.useDefaultEncoding(defaultEncoding);
                            if (exportFile != null) {
                                File file = new File(exportFile);
                                final ICnfgTask[] tasks = dm.getExportTasks(file);
                                if (!engine.run(new CnfgAction(){

                                    @Override
                                    public ICnfgTask[] getTasks() {
                                        return tasks;
                                    }
                                }, actionClient)) {
                                    this.m_errCode = 2;
                                }
                            } else {
                                this.startTaskCollecting();
                                final ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
                                Map<String, ICnfgTest> initializedClasses = this.getConsoleStartTasks(this, tasklist, actionClient);
                                this.endTaskCollecting();
                                if (!engine.run(new CnfgAction(){

                                    @Override
                                    public ICnfgTask[] getTasks() {
                                        return CnfgTask.createTaskArray(tasklist);
                                    }
                                }, actionClient)) {
                                    this.m_errCode = 2;
                                }
                                if (initializedClasses != null) {
                                    TestTaskManager.terminateTestProviders(initializedClasses, actionClient.getFeedback());
                                }
                            }
                        }
                        this.m_sw.write(new StringBuffer("INFO, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.silent.end")).append(sSep2).toString());
                        if (this.m_errCode == 0) {
                            CnfgUtils.saveJavaAndMachineInfo();
                        }
                    }
                }
                catch (StartupFileException e) {
                    CnfgLog.error(e);
                    this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append(sSep2).toString());
                    this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(e.getMessage()).append(sSep2).toString());
                    this.m_errCode = 3;
                }
                catch (ConfigFileNotFoundException e) {
                    CnfgLog.error(e);
                    this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append(sSep2).toString());
                    this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(e.getMessage()).append(sSep2).toString());
                    this.m_errCode = 3;
                }
            }
            this.m_sw.close();
        }
        catch (DataManagerException e) {
            try {
                this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(e.getMessage()).append(sSep2).toString());
                this.m_sw.close();
            }
            catch (IOException ioe) {
                CnfgLog.error(ioe);
            }
            CnfgLog.error(e);
            this.m_errCode = 1;
        }
        catch (IOException e) {
            CnfgLog.error(e);
            this.m_errCode = 4;
        }
        catch (SecurityException e) {
            CnfgLog.error(e);
            this.m_errCode = 5;
        }
        catch (Exception e) {
            CnfgLog.error(e);
            this.m_errCode = 6;
        }
        this.silentExit(this.m_errCode);
    }

    private void backUpResponseFile(File resp_dir) {
        if (resp_dir.exists()) {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_kkmmss").format(new Date());
            resp_dir.renameTo(new File("../logs/cogconfig_response.csv." + timeStamp + ".log"));
        }
    }

    public void stopService() {
        try {
            block23: {
                DataManager dm = DataManager.getInstance();
                File resp_dir = dm.resolveEffectiveFilePath(RESPONSE_FILEPATH);
                this.backUpResponseFile(resp_dir);
                String encoding = ToolkitResources.getDefaultEncoding();
                this.m_sw = new OutputStreamWriter((OutputStream)new FileOutputStream(resp_dir), encoding);
                String sIPFConfigFileName = (String)CnfgPreferences.getInstance().getProperty("IPFConfigFileName", "../configuration/cogconfigipf.xml", String.class);
                this.m_bIPFInitialized = LogIPFControl.initialize((String)CCLConfigurationFactory.getInstance().resolveEffectivePath(sIPFConfigFileName));
                this.m_sw.write(new StringBuffer("INFO, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.silent.begin")).append(sSep2).toString());
                this.m_sw.write(new StringBuffer("EXEC, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.silent.load")).append(sSep2).toString());
                try {
                    dm.getConfig();
                    this.m_sw.write(new StringBuffer("SUCCESS, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.silent.status.success")).append(sSep2).toString());
                    String sError = CnfgUtils.checkJava();
                    if (sError != null) {
                        this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(sError).append(sSep2).toString());
                        this.m_sw.close();
                        this.m_errCode = 8;
                        break block23;
                    }
                    CnfgConsoleClient actionClient = new CnfgConsoleClient(this.m_sw);
                    CnfgActionEngine engine = new CnfgActionEngine();
                    ArrayList<ICnfgTask> list = new ArrayList<ICnfgTask>();
                    boolean bBTSVIsInstalled = dm.isBTSVInstalled();
                    if (bBTSVIsInstalled) {
                        boolean bIsAvailable = ServiceManager.getCBSRegName() != null;
                        boolean bIsRunning = ServiceManager.isRunning();
                        if (bIsAvailable && bIsRunning) {
                            CnfgServiceUtils.createStopTask(list, null);
                        } else if (!bIsAvailable || !bBTSVIsInstalled) {
                            this.m_sw.write(new StringBuffer("INFO, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.service.status.notavailable")).append(sSep2).toString());
                        } else if (!bIsRunning) {
                            Object[] args = new Object[]{ServiceManager.getCBSRegName()};
                            this.m_sw.write(new StringBuffer("INFO, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.service.status.notrunning", args)).append(sSep2).toString());
                        }
                    } else {
                        this.m_sw.write(new StringBuffer("INFO, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.service.status.notavailable")).append(sSep2).toString());
                    }
                    List<ServiceFolder> lServices = dm.getServiceFolders(true);
                    for (int i = 0; i < lServices.size(); ++i) {
                        ServiceFolder fSFolder = lServices.get(i);
                        if (fSFolder == null || fSFolder == dm.getCBS() || fSFolder.getDisabled() || !fSFolder.getVisibility()) continue;
                        CnfgActionOld actionStop = fSFolder.findAction("stop");
                        if (fSFolder.isRunning()) {
                            ICnfgTask[] lStop;
                            if (actionStop == null || (lStop = fSFolder.createStopTasks(actionStop)) == null) continue;
                            for (int j = 0; j < lStop.length; ++j) {
                                list.add(lStop[j]);
                            }
                            continue;
                        }
                        Object[] args = new Object[]{fSFolder.getLabel()};
                        this.m_sw.write(new StringBuffer("INFO, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.service.status.notrunning", args)).append(sSep2).toString());
                    }
                    if (list.size() > 0) {
                        ICnfgTask[] tasks = new ICnfgTask[list.size()];
                        for (int i = 0; i < list.size(); ++i) {
                            tasks[i] = list.get(i);
                        }
                        final ICnfgTask[] taskList = tasks;
                        if (!engine.run(new CnfgAction(){

                            @Override
                            public ICnfgTask[] getTasks() {
                                return taskList;
                            }
                        }, actionClient)) {
                            this.m_errCode = 2;
                        }
                    }
                    this.m_sw.write(new StringBuffer("INFO, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.silent.end")).append(sSep2).toString());
                }
                catch (StartupFileException e) {
                    CnfgLog.error(e);
                    this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append(sSep2).toString());
                    this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(e.getMessage()).append(sSep2).toString());
                    this.m_errCode = 3;
                }
            }
            this.m_sw.close();
        }
        catch (DataManagerException e) {
            try {
                this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(e.getMessage()).append(sSep2).toString());
                this.m_sw.close();
            }
            catch (IOException ioe) {
                CnfgLog.error(ioe);
            }
            CnfgLog.error(e);
            this.m_errCode = 1;
        }
        catch (IOException e) {
            CnfgLog.error(e);
            this.m_errCode = 4;
        }
        catch (SecurityException e) {
            CnfgLog.error(e);
            this.m_errCode = 5;
        }
        catch (Exception e) {
            CnfgLog.error(e);
            this.m_errCode = 6;
        }
        this.silentExit(this.m_errCode);
    }

    private void silentExit(int exitCode) {
        CnfgLog.info("Silent exit with error code: " + exitCode);
        if (this.m_bIPFInitialized) {
            LogIPFControl.terminate();
        }
        CnfgUtils.saveAdditionalInfo();
        CnfgPreferences.getInstance().saveSettings();
        System.exit(exitCode);
    }

    public Map<String, ICnfgTest> getConsoleStartTasks(DataManager.ITaskCollector taskCollector, ArrayList<ICnfgTask> list, CnfgActionClient actionClient) {
        boolean bIsRunning;
        taskCollector.startTaskCollecting();
        DataManager dm = DataManager.getInstance();
        if (this.bConfigOnly) {
            CnfgLog.info("getConsoleStartTasks() - Config only mode detected.");
            if (this.bForceSave) {
                dm.setConfigDirtyFlag(true);
                dm.setForceSaveFlag(true);
                CnfgLog.info("getConsoleStartTasks() - Force to save configuration.");
            }
            dm.createCryptoTask(list);
            dm.createSaveConfigTask(list);
            dm.createSaveAppSvrConfigTask(list);
            return null;
        }
        dm.createValidationTask(list);
        dm.createCryptoTask(list);
        dm.createCheckEncryptedDataTask(list);
        dm.createBackupTask(list);
        boolean bIsAvailable = ServiceManager.getCBSRegName() != null;
        boolean bIsRegistered = ServiceManager.isRegistered();
        if (dm.isBTSVInstalled() && bIsAvailable && bIsRegistered && (bIsRunning = ServiceManager.isRunning())) {
            CnfgServiceUtils.createStopTask(list, null);
        }
        dm.createSaveConfigTask(list);
        dm.createSaveLocaleTask(list);
        dm.createSaveAppSvrConfigTask(list);
        if (dm.isInstalled("CM")) {
            CnfgServiceUtils.createCMUpgradeTask(list, "save");
        }
        Map<String, ICnfgTest> initializedClasses = null;
        if (!this.bStartWithNoTest && (initializedClasses = TestTaskManager.getTestTasks(taskCollector, dm.getRootFolder(), list, false, true, true, actionClient.getFeedback())) != null) {
            list.add(new TestTaskManager.TestActionPauseTask(actionClient));
        }
        List<ServiceFolder> lServices = dm.getRootFolder().getServiceFolders(true);
        for (int i = 0; i < lServices.size(); ++i) {
            ICnfgTask[] lStart;
            int j;
            ICnfgTask[] lStop;
            ServiceFolder fSFolder = lServices.get(i);
            if (fSFolder == null || fSFolder == dm.getCBS() || fSFolder.getDisabled() || !fSFolder.getVisibility()) continue;
            CnfgActionOld actionStart = fSFolder.findAction("start");
            CnfgActionOld actionStop = fSFolder.findAction("stop");
            if (fSFolder.isRunning() && actionStop != null && (lStop = fSFolder.createStopTasks(actionStop)) != null) {
                for (j = 0; j < lStop.length; ++j) {
                    list.add(lStop[j]);
                }
            }
            if (actionStart == null || (lStart = fSFolder.createStartTasks(actionStart, true)) == null) continue;
            for (j = 0; j < lStart.length; ++j) {
                list.add(lStart[j]);
            }
        }
        if (dm.isBTSVInstalled()) {
            CnfgServiceUtils.createStartTask(list, true, null, !this.bStartWithNoVerifyPorts);
        }
        taskCollector.endTaskCollecting();
        return initializedClasses;
    }

    @Override
    public void startTaskCollecting() {
    }

    @Override
    public void endTaskCollecting() {
    }

    @Override
    public void error(TaskCollectorException e) {
        Throwable cause = e.getCause();
        try {
            if (cause != null) {
                this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(cause.getMessage()).append(sSep2).toString());
                this.m_sw.close();
            } else {
                this.m_sw.write(new StringBuffer("ERROR, ").append(sMain).append(sSep1).append(e.getMessage()).append(sSep2).toString());
                this.m_sw.close();
            }
        }
        catch (IOException ioe) {
            CnfgLog.error(ioe);
        }
        if (cause != null) {
            CnfgLog.error(e.getCause());
        } else {
            CnfgLog.error(e.getMessage());
        }
        this.m_errCode = e.getErrorCode();
        this.silentExit(this.m_errCode);
    }
}

