/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgBorder;
import com.cognos.crconfig.CnfgFileChooser;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgLock;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgMenu;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgSplashScreen;
import com.cognos.crconfig.CnfgSwingAction;
import com.cognos.crconfig.CnfgTable;
import com.cognos.crconfig.CnfgTableModel;
import com.cognos.crconfig.CnfgTaskDialog;
import com.cognos.crconfig.CnfgTestInitializationFeedback;
import com.cognos.crconfig.CnfgTree;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.DialogConfigServersParameter;
import com.cognos.crconfig.DialogCreateNew;
import com.cognos.crconfig.DialogEditGlobalConfig;
import com.cognos.crconfig.DialogFontChooser;
import com.cognos.crconfig.DialogJavaValidation;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.DialogProperties;
import com.cognos.crconfig.DialogRename;
import com.cognos.crconfig.DialogRetrieveConfiguration;
import com.cognos.crconfig.GlobalConfigModel;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.cognos.crconfig.InformationPanel;
import com.cognos.crconfig.MenuToolbarLogicListener;
import com.cognos.crconfig.NavigationLabel;
import com.cognos.crconfig.ResetToDefaultListener;
import com.cognos.crconfig.TaskCollectorException;
import com.cognos.crconfig.WebBrowser;
import com.cognos.crconfig.data.CnfgAction;
import com.cognos.crconfig.data.CnfgActionEngine;
import com.cognos.crconfig.data.CnfgActionGenCrypto;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgNodeDeletedEvent;
import com.cognos.crconfig.data.CnfgNodeSwitchEvent;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.ConfigFileNotFoundException;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.ICnfgAction;
import com.cognos.crconfig.data.Option;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.StartupFileException;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.service.BootstrapServiceFolder;
import com.cognos.crconfig.data.service.CnfgServiceFolderChangedEvent;
import com.cognos.crconfig.data.service.CnfgServiceFolderChangedListener;
import com.cognos.crconfig.data.service.CnfgServiceUtils;
import com.cognos.crconfig.data.service.ServiceFolder;
import com.cognos.crconfig.data.service.ServiceManager;
import com.cognos.crconfig.test.TestTaskManager;
import com.cognos.indications.LogIPFControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;

public class CRConfigFrame
extends JFrame
implements ItemListener,
ServiceManager.ServiceManagerListener,
CnfgServiceFolderChangedListener,
DataManager.ITaskCollector {
    private static final long serialVersionUID = -4196025012128484810L;
    private StringBuffer m_listOfMnemonics = new StringBuffer();
    private CnfgSplashScreen splash = null;
    private static final CRConfigFrame INSTANCE = new CRConfigFrame();
    private static final String m_sLogsDir = "../logs";
    private JPanel m_topPanel;
    public CnfgActionEngine m_actionEngine;
    private CnfgTaskDialog m_taskDialog;
    private String m_sHelpPath;
    private String m_sContentsFileName;
    private String m_sCopyrightFileName;
    public static final int DEFAULT_WIDTH = 200;
    private static final int MIN_WIDTH = 150;
    private static final int MIN_HEIGHT = 20;
    private JPanel cLeftContentPanel;
    private JScrollPane cTreeScrollPane;
    private JPanel cExplorerPanel;
    private JLabel cExplorerLabel;
    protected CnfgTree cCnfgTree;
    private JPanel cRightContentPanel;
    private JScrollPane m_tableScrollPane;
    protected JScrollPane m_infoScrollPane;
    private JPanel cNavPathPanel;
    protected InformationPanel m_infoPanel;
    private NavigationLabel cNavPathLabel;
    private JSplitPane cSplitPane;
    protected JSplitPane m_infoTableSplitPane;
    protected static int m_maxCharWidth = 0;
    protected CnfgTable cCnfgTable;
    protected CnfgTableModel cCnfgTableModel;
    private JPanel m_xcStatusPanel;
    private JLabel m_xcStatusLabel;
    protected CnfgSwingAction m_actionFileSave;
    protected CnfgSwingAction m_actionFileSaveUTF8;
    protected CnfgSwingAction m_actionFileExport;
    protected CnfgSwingAction m_actionActionsGenWar;
    protected CnfgSwingAction m_actionFileExit;
    protected CnfgSwingAction m_actionViewToolbar;
    protected CnfgSwingAction m_actionViewInstallPath;
    protected CnfgSwingAction m_actionViewFont;
    protected CnfgSwingAction m_actionEditRename;
    protected CnfgSwingAction m_actionEditSwitch;
    protected CnfgSwingAction m_actionEditDelete;
    protected CnfgSwingAction m_actionActionsStart;
    protected CnfgSwingAction m_actionActionsStop;
    protected CnfgSwingAction m_actionActionsRestart;
    protected CnfgSwingAction m_actionActionsGlobalConfig;
    protected CnfgSwingAction m_actionActionsTest;
    protected CnfgSwingAction m_actionActionsVerifyConfig;
    protected CnfgSwingAction m_actionActionsCheckFlipper;
    protected CnfgSwingAction m_actionActionsVerifyConformance;
    protected CnfgSwingAction m_actionEditResetToDefault;
    protected CnfgSwingAction m_actionRetrieve;
    protected CnfgSwingAction m_actionHelpCognosOnTheWeb;
    protected CnfgSwingAction m_actionHelpAbout;
    private JMenuBar m_menuBar;
    private JMenuItem m_menuFileSave;
    private JMenuItem m_menuFileSaveUTF8;
    private JMenuItem m_menuFileExport;
    private JMenuItem m_menuActionsGenWar;
    private JMenuItem m_menuFileExit;
    private JCheckBoxMenuItem m_menuViewToolbar;
    private JCheckBoxMenuItem m_menuViewInstallPath;
    private JMenuItem m_menuViewFont;
    protected JMenu m_menuEditNew_main;
    protected JMenu m_menuEditNew_popup;
    private JMenuItem m_menuEditRename;
    private JMenuItem m_menuEditSwitch;
    private JMenuItem m_menuEditDelete;
    private JMenuItem m_menuActionsStart;
    private JMenuItem m_menuActionsStop;
    private JMenuItem m_menuActionsRestart;
    private JMenuItem m_menuActionsTest;
    private JMenuItem m_menuActionsVerifyConformance;
    private JMenuItem m_menuEditResetToDefault;
    private JMenuItem m_menuHelpContents;
    private JMenuItem m_menuHelpCognosOnTheWeb;
    private JMenuItem m_menuHelpAbout;
    private JMenuItem m_menuActionsVerifyConfig;
    private JMenuItem m_menuActionsCheckFlipper;
    private JToolBar m_toolBar;
    private Boolean m_bIsToolbarVisible = new Boolean(true);
    private Boolean m_bIsInstallPathVisible = new Boolean(false);
    protected JPopupMenu treePopupMenu;
    protected JPopupMenu tablePopupMenu;
    protected JMenuItem m_tableResetToDefault;
    protected MenuToolbarLogicListener m_mtblL;
    private ResetToDefaultListener m_rtdL;
    protected static final Insets ins = new Insets(0, 2, 0, 0);
    private JMenuItem m_menuActionsGlobalConfig;
    private DialogFontChooser m_fontChooser;
    private boolean m_bIPFInitialized;
    private StringBuffer m_sbInstallPath;

    public static CRConfigFrame getInstance() {
        return INSTANCE;
    }

    public void setSplashScreen(CnfgSplashScreen splash) {
        this.splash = splash;
    }

    public CnfgSplashScreen getSplashScreeen() {
        return this.splash;
    }

    public void checkJava() {
        if (DataManager.getInstance().useJCAM()) {
            int status = 0;
            try {
                CAMFactory.checkFIPSSupport();
            }
            catch (CAMCryptoException e) {
                String msg = e.getMessage();
                CnfgLog.error(msg);
                DialogMessage.showDialog(msg, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
                System.exit(55);
            }
            status = DataManager.getInstance().lightCurrentJavaValidation();
            if (status == 0) {
                CnfgUtils.saveJavaInfo();
                return;
            }
            Object[] messages = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.java.check.explanation")).append("\n").toString(), CnfgResource.getMessage("Message.request.user.to.wait")};
            final DialogMessage dlgProgress = DialogMessage.getWaitDialog(messages, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ACTION_RUNNING);
            BusyIndicationThread prg = new BusyIndicationThread(status, dlgProgress);
            prg.start();
            Runnable disposeDialog = new Runnable(){

                @Override
                public void run() {
                    dlgProgress.setVisible(true);
                }
            };
            SwingUtilities.invokeLater(disposeDialog);
            int ret = prg.getReturnedStatus();
            ArrayList<String> lErrors = prg.getReturnedErrors();
            if (ret != 0) {
                String str = DataManager.getJavaErrorMessage(ret);
                if (ret == 999) {
                    StringBuffer sBuf = new StringBuffer(str);
                    sBuf.append("\n\n").append(CnfgResource.getMessage("Message.task.error.cryptokeys.mismatch.regenkey.resolution"));
                    boolean isServiceRunning = false;
                    if (DataManager.getInstance().isBTSVInstalled() && ServiceManager.getCBSRegName() != null && ServiceManager.isRegistered() && ServiceManager.isRunning()) {
                        isServiceRunning = true;
                    }
                    if (isServiceRunning) {
                        String serviceName = ServiceManager.getCBSRegName();
                        Object[] arg3 = new Object[]{serviceName};
                        sBuf.append("\n\n").append(CnfgResource.getMessage("Message.task.error.cryptokeys.mismatch.regenkey.resolution.checkservice", arg3));
                    }
                    str = sBuf.toString();
                }
                DialogJavaValidation dlg = new DialogJavaValidation((Frame)this, str, lErrors, ret == 999);
                dlg.show();
                int result = dlg.getExitValue();
                if (result == 0) {
                    this.runAction(new CnfgAction(){

                        @Override
                        public ICnfgTask[] getTasks() {
                            return new CnfgActionGenCrypto().getTasks(new ArrayList(), new CnfgTestInitializationFeedback());
                        }
                    }, false);
                } else if (result == 1) {
                    System.exit(1);
                }
            }
            CnfgUtils.saveJavaInfo();
        }
    }

    private void addWizardListener() {
        CnfgWizard cCnfgWizard = CnfgWizard.getInstance();
        DataManager.getInstance().addCnfgDataLoadedListener(cCnfgWizard);
    }

    public void init(boolean isWizardMode) throws Exception {
        CnfgFontSetting.initializeGUIFont();
        try {
            DataManager.getInstance().resolveEffectiveFolderPath(m_sLogsDir);
        }
        catch (DataManagerException e) {
            CnfgLog.error(e);
        }
        if (CnfgUtils.isWindowsPlatform()) {
            UIDefaults defaults = UIManager.getDefaults();
            defaults.put("Menu.pressedBackground", defaults.get("Menu.background"));
            defaults.put("Menu.borderPainted", new Boolean(true));
            defaults.put("ScrollBar.track", new Color(240, 240, 240));
            BorderUIResource.EmptyBorderUIResource lineBorder = new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1);
            defaults.put("Table.focusCellHighlightBorder", lineBorder);
            defaults.put("Table.focusCellBackground", SystemColor.textHighlight);
            defaults.put("Table.focusCellForeground", SystemColor.textHighlightText);
            defaults.put("List.focusCellHighlightBorder", lineBorder);
        }
        this.m_sHelpPath = (String)CnfgPreferences.getInstance().getProperty("HelpPath", String.class);
        if (this.m_sHelpPath == null) {
            this.m_sHelpPath = "../webcontent/documentation";
            CnfgPreferences.getInstance().setProperty("HelpPath", this.m_sHelpPath);
        }
        this.m_sHelpPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(this.m_sHelpPath);
        this.m_sContentsFileName = (String)CnfgPreferences.getInstance().getProperty("HelpContentsFilename", String.class);
        if (this.m_sContentsFileName == null) {
            this.m_sContentsFileName = "ug_inst_crn_cnfg_a.html";
            CnfgPreferences.getInstance().setProperty("HelpContentsFilename", this.m_sContentsFileName);
        }
        this.m_sCopyrightFileName = (String)CnfgPreferences.getInstance().getProperty("HelpCopyrightFilename", String.class);
        if (this.m_sCopyrightFileName == null) {
            this.m_sCopyrightFileName = "cognos_copyright";
            CnfgPreferences.getInstance().setProperty("HelpCopyrightFilename", this.m_sCopyrightFileName);
        }
        this.m_actionEngine = new CnfgActionEngine();
        this.setDefaultCloseOperation(0);
        try {
            Object[] args = new Object[]{InetAddress.getLocalHost().getHostName()};
            this.setTitle(CnfgResource.getMessage("Application.titleWithServerName", args));
        }
        catch (UnknownHostException eee) {
            this.setTitle(CnfgResource.getMessage("Application.title"));
        }
        this.setIconImage(CnfgImageLoader.loadImage(CnfgUtils.isWindowsPlatform() ? "IBM_Cognos_Configuration.gif" : "IBM_Cognos_Configuration_32.gif"));
        this.getContentPane().setLayout(new BorderLayout());
        this.initActions();
        if (isWizardMode) {
            return;
        }
        ServiceManager.addListener(this);
        this.addWizardListener();
        this.createMenus();
        this.setJMenuBar(this.m_menuBar);
        this.createToolbar();
        this.createTable();
        this.createDualPane();
        this.m_topPanel = new JPanel();
        this.m_topPanel.setLayout(new BorderLayout());
        DevInfoListener dev = new DevInfoListener();
        ((JComponent)this.getContentPane()).registerKeyboardAction(dev, KeyStroke.getKeyStroke(114, 2), 1);
        ((JComponent)this.getContentPane()).registerKeyboardAction(dev, KeyStroke.getKeyStroke(114, 2), 2);
        this.m_topPanel.add((Component)this.m_toolBar, "Center");
        this.getContentPane().add((Component)this.m_topPanel, "North");
        this.m_xcStatusLabel = new JLabel("");
        EmptyBorder aBorder = new EmptyBorder(1, 3, 1, 1){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(Color.gray);
                g.drawLine(x, y + 3, x + width - 1, y + 3);
                g.drawLine(x, y + 3, x, y + height - 1);
                g.setColor(Color.white);
                g.drawLine(x + width - 1, y + 3, x + width - 1, y + height - 1);
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
        };
        this.m_xcStatusLabel.setBorder(aBorder);
        this.m_xcStatusPanel = new JPanel();
        this.m_xcStatusPanel.setLayout(new BorderLayout());
        this.m_xcStatusPanel.add(this.m_xcStatusLabel);
        this.m_xcStatusPanel.setPreferredSize(new Dimension(750, CnfgFontSetting.getControlHeight()));
        this.getContentPane().add((Component)this.m_xcStatusPanel, "South");
        this.m_bIsInstallPathVisible = this.getInstallPathState();
        if (this.m_bIsInstallPathVisible.booleanValue()) {
            this.m_menuViewInstallPath.setSelected(true);
            this.updateStatusLabel(true);
        } else {
            this.m_menuViewInstallPath.setSelected(false);
            this.updateStatusLabel(false);
        }
        this.m_xcStatusPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CRConfigFrame.this.updateStatusLabel(CRConfigFrame.this.m_bIsInstallPathVisible);
            }
        });
        this.m_bIsToolbarVisible = this.getToolbarState();
        if (this.m_bIsToolbarVisible.booleanValue()) {
            this.m_menuViewToolbar.setSelected(true);
            this.m_toolBar.setVisible(true);
        } else {
            this.m_menuViewToolbar.setSelected(false);
            this.m_toolBar.setVisible(false);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CRConfigFrame.this.action_Exit();
            }
        });
        Integer dimX = (Integer)CnfgPreferences.getInstance().getProperty("MainFrameSize.x", Integer.class);
        Integer dimY = (Integer)CnfgPreferences.getInstance().getProperty("MainFrameSize.y", Integer.class);
        if (dimX != null && dimY != null) {
            this.setSize(new Dimension(dimX, dimY));
        } else if (CnfgResource.getLocale().getLanguage().compareToIgnoreCase("en") == 0) {
            this.setSize(800, 575);
        } else {
            this.setSize(900, 600);
        }
        Dimension dim = this.getSize();
        Dimension bounds = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(new Point((bounds.width - dim.width) / 2, (bounds.height - dim.height) / 2));
        this.validate();
    }

    public void exit(int errorCode) {
        if (this.m_bIPFInitialized) {
            LogIPFControl.terminate();
        }
        System.exit(errorCode);
    }

    public void getLock(boolean bSkipLockCheck, boolean bContinueOnLock) {
        boolean bGotIt = CnfgLock.getLock(bSkipLockCheck);
        if (!bGotIt) {
            if (bContinueOnLock) {
                Object[] oMessage = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.getlock.failed.notification")).append("\n").toString(), new StringBuffer(CnfgResource.getMessage("Message.getlock.failed.explanation")).append("\n").toString(), CnfgResource.getMessage("Message.getlock.failed.exit.resolution")};
                if (DialogMessage.showDialog(oMessage, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_EXITCONTINUE, 0) == 0) {
                    this.exit(1);
                }
            } else {
                Object[] oMessage = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.getlock.failed.notification")).append("\n").toString(), new StringBuffer(CnfgResource.getMessage("Message.getlock.failedfatal.explanation")).append("\n").toString(), CnfgResource.getMessage("Message.getlock.failedfatal.resolution")};
                DialogMessage.showDialog(oMessage, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_OK, 0);
                this.exit(1);
            }
        }
        CnfgLock.deleteOnExit(bSkipLockCheck);
    }

    public void initDataManager() throws ConfigFileNotFoundException, DataManagerException {
        block11: {
            if (DataManager.getInstance().checkConfigurationFiles()) {
                String dMessage = new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.explanation")).append("\n").append(CnfgResource.getMessage("Message.defaultConfig.create.notification")).toString();
                Object[] oMessage = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append("\n").toString(), new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.explanation")).append("\n").toString(), new StringBuffer(CnfgResource.getMessage("Message.defaultConfig.create.notification")).append("\n").toString()};
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug(dMessage);
                }
                DialogMessage.showDialog(oMessage, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_INFORMATION, DialogMessage.OPTS_OK, 0);
            }
            boolean bIsUpgraded = false;
            if (DataManager.getInstance().checkUpgrade()) {
                try {
                    bIsUpgraded = DataManager.getInstance().upgradeConfigFile();
                    if (bIsUpgraded) {
                        String sMessage = new StringBuffer(CnfgResource.getMessage("Message.upgradeConfig.notification")).append("\n").append(CnfgResource.getMessage("Message.upgradeConfig.success.notification")).toString();
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug(sMessage);
                        }
                        Object[] oMessage = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.upgradeConfig.notification")).append("\n").toString(), new StringBuffer(CnfgResource.getMessage("Message.upgradeConfig.success.notification")).append("\n").toString()};
                        DialogMessage.showDialog(oMessage, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_INFORMATION, DialogMessage.OPTS_OK, 0);
                    }
                }
                catch (DataManagerException e) {
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.upgradeConfig.notification")).append("\n").append(CnfgResource.getMessage("Message.upgradeConfig.failed.notification")).append("\n").toString();
                    DataManagerException upgradeException = new DataManagerException(sMessage + e.getMessage());
                    throw upgradeException;
                }
            }
            String sIPFConfigFileName = (String)CnfgPreferences.getInstance().getProperty("IPFConfigFileName", "../configuration/cogconfigipf.xml", String.class);
            this.m_bIPFInitialized = LogIPFControl.initialize((String)CCLConfigurationFactory.getInstance().resolveEffectivePath(sIPFConfigFileName));
            try {
                DataManager.getInstance().getConfig();
                if (bIsUpgraded) {
                    DataManager.getInstance().mergeServicesList(DataManager.getInstance().getAllServices());
                    DataManager.getInstance().customizedUpgrade();
                }
                ServiceManager.startCheckServiceStatus();
            }
            catch (DataManagerException e) {
                CnfgLog.error(e);
                String sMessage = new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append("\n").append(e.getMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                DialogMessage.showDialog(sMessage, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
                this.exit(1);
            }
            catch (StartupFileException sfe) {
                CnfgLog.error(sfe);
                String sMessage = new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append("\n").append(sfe.getMessage()).append("\n").append(CnfgResource.getMessage("Message.startupfile.failed.exit.resolution")).toString();
                if (DialogMessage.showDialog(sMessage, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_EXITCONTINUE, 0) != 0) break block11;
                this.exit(1);
            }
        }
        DataManager.getInstance().newConfig();
    }

    public void createMenus() {
        this.m_menuBar = new JMenuBar();
        CnfgMenu menuFile = new CnfgMenu(CnfgResource.getMessage("Menu.file"), null);
        this.m_menuFileSave = menuFile.addMenuItem(CnfgResource.getMessage("Menu.file.save"), KeyStroke.getKeyStroke(83, 2), true, this.m_actionFileSave);
        this.m_menuFileSaveUTF8 = menuFile.addMenuItem(CnfgResource.getMessage("Menu.file.saveutf8"), null, true, this.m_actionFileSaveUTF8);
        menuFile.addSeparator();
        this.m_menuFileExport = menuFile.addMenuItem(CnfgResource.getMessage("Menu.file.export"), null, true, this.m_actionFileExport);
        menuFile.addSeparator();
        this.m_menuFileExit = menuFile.addMenuItem(CnfgResource.getMessage("Menu.file.exit"), KeyStroke.getKeyStroke(115, 8), true, this.m_actionFileExit);
        CnfgMenu menuEdit = new CnfgMenu(CnfgResource.getMessage("Menu.edit"), null);
        this.m_menuEditResetToDefault = menuEdit.addMenuItem(CnfgResource.getMessage("Menu.edit.resetToDefault"), null, true, this.m_actionEditResetToDefault);
        menuEdit.addSeparator();
        this.m_menuEditNew_main = new CnfgMenu(CnfgResource.getMessage("Menu.edit.new"), null, false);
        this.m_menuEditNew_main.addItemListener(this);
        menuEdit.add(this.m_menuEditNew_main);
        this.m_menuEditRename = menuEdit.addMenuItem(CnfgResource.getMessage("Menu.edit.rename"), KeyStroke.getKeyStroke(113, 0), false, this.m_actionEditRename);
        this.m_menuEditDelete = menuEdit.addMenuItem(CnfgResource.getMessage("Menu.edit.delete"), null, false, this.m_actionEditDelete);
        CnfgMenu menuView = new CnfgMenu(CnfgResource.getMessage("Menu.view"), null);
        this.m_menuViewToolbar = menuView.addCheckBoxMenuItem(CnfgResource.getMessage("Menu.view.toolbar"), null, true, this.m_actionViewToolbar);
        this.m_menuViewInstallPath = menuView.addCheckBoxMenuItem(CnfgResource.getMessage("Menu.view.installPath"), null, true, this.m_actionViewInstallPath);
        menuView.addSeparator();
        this.m_menuViewFont = menuView.addMenuItem(CnfgResource.getMessage("Menu.view.font"), null, !CnfgFontSetting.useSystemFontAndColor(), this.m_actionViewFont);
        CnfgMenu menuActions = new CnfgMenu(CnfgResource.getMessage("Menu.actions"), null);
        if (DataManager.getInstance().isBTSVInstalled() || DataManager.getInstance().isInstalled("CCD")) {
            this.m_menuActionsStart = menuActions.addMenuItem(CnfgResource.getMessage("Menu.actions.start"), null, false, this.m_actionActionsStart);
            this.m_menuActionsStop = menuActions.addMenuItem(CnfgResource.getMessage("Menu.actions.stop"), null, false, this.m_actionActionsStop);
            this.m_menuActionsRestart = menuActions.addMenuItem(CnfgResource.getMessage("Menu.actions.restart"), null, false, this.m_actionActionsRestart);
            menuActions.addSeparator();
        }
        if (DataManager.getInstance().isInstalled("CM")) {
            this.m_menuActionsGlobalConfig = menuActions.addMenuItem(CnfgResource.getMessage("Menu.actions.globalConfig"), null, true, this.m_actionActionsGlobalConfig);
        }
        this.m_menuActionsTest = menuActions.addMenuItem(CnfgResource.getMessage("Menu.actions.test"), null, true, this.m_actionActionsTest);
        this.m_menuActionsVerifyConfig = menuActions.addMenuItem(CnfgResource.getMessage("Menu.actions.verify"), null, true, this.m_actionActionsVerifyConfig);
        if (!DataManager.getInstance().retrieveCNFMCheckingDisabled().booleanValue()) {
            this.m_menuActionsVerifyConformance = menuActions.addMenuItem(CnfgResource.getMessage("Menu.actions.verifyConformance"), null, true, this.m_actionActionsVerifyConformance);
        }
        CnfgMenu menuHelp = new CnfgMenu(CnfgResource.getMessage("Menu.help"), null);
        this.m_menuHelpCognosOnTheWeb = menuHelp.addMenuItem(CnfgResource.getMessage("Menu.help.cognosOnTheWeb"), null, true, this.m_actionHelpCognosOnTheWeb);
        menuHelp.addSeparator();
        this.m_menuHelpAbout = menuHelp.addMenuItem(CnfgResource.getMessage("Menu.help.about"), null, true, this.m_actionHelpAbout);
        this.m_menuBar.add(menuFile);
        this.m_menuBar.add(menuEdit);
        this.m_menuBar.add(menuView);
        this.m_menuBar.add(menuActions);
        this.m_menuBar.add(menuHelp);
        EmptyBorder popupBorder = new EmptyBorder(2, 2, 3, 3){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(Color.white);
                g.drawLine(x + 1, y, x + width - 1, y);
                g.drawLine(x + 1, y, x + 1, y + height - 2);
                g.setColor(Color.gray);
                g.drawLine(x + width - 2, y + 2, x + width - 2, y + height - 2);
                g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
                g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
                g.drawLine(x + 2, y + height - 2, x + width - 3, y + height - 2);
            }
        };
        this.treePopupMenu = new JPopupMenu();
        if (CnfgUtils.isWindowsPlatform()) {
            this.treePopupMenu.setBorder(popupBorder);
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.m_menuEditNew_popup = new CnfgMenu(CnfgResource.getMessage("Menu.edit.new.no.mnemonic"), null, true);
        this.m_menuEditNew_popup.addItemListener(this);
        this.tablePopupMenu = new JPopupMenu();
        if (CnfgUtils.isWindowsPlatform()) {
            this.tablePopupMenu.setBorder(popupBorder);
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.m_tableResetToDefault = CnfgMenu.addMenuItem(this.tablePopupMenu, null, CnfgResource.getMessage("Menu.edit.resetToDefault.no.mnemonic"), false, this.m_actionEditResetToDefault);
    }

    public void updateRunningActions() {
        if (DataManager.getInstance().isBTSVInstalled() || ServiceManager.hasOtherServicesInstalled()) {
            List<ServiceFolder> lServices = DataManager.getInstance().getServiceFolders(true);
            int iRunningServices = 0;
            int iStoppedServices = 0;
            for (ServiceFolder serviceFolder : lServices) {
                if (serviceFolder.getDisabled() || !serviceFolder.getVisibility()) continue;
                if (serviceFolder.isRunning()) {
                    ++iRunningServices;
                    continue;
                }
                ++iStoppedServices;
            }
            if (DataManager.getInstance().getCBS() == null) {
                boolean bIsAvailable;
                boolean bIsRunning = ServiceManager.isRunning();
                boolean bl = bIsAvailable = ServiceManager.getCBSRegName() != null;
                if (bIsAvailable && bIsRunning) {
                    ++iRunningServices;
                } else if (bIsAvailable && !bIsRunning) {
                    ++iStoppedServices;
                }
            }
            this.m_actionActionsStart.setEnabled(iStoppedServices > 0);
            this.m_actionActionsStop.setEnabled(iRunningServices > 0);
            this.m_actionActionsRestart.setEnabled(iRunningServices > 0);
        }
    }

    @Override
    public void serviceStatusChecking(String msg) {
        if (msg != null && msg.length() != 0) {
            this.m_xcStatusLabel.setText(msg);
        } else {
            this.updateStatusLabel(this.m_bIsInstallPathVisible);
        }
    }

    public String formatInstallPath(String sPath) {
        if (this.m_sbInstallPath == null) {
            this.m_sbInstallPath = new StringBuffer();
            char[] seps = new char[]{File.separatorChar};
            StringTokenizer parser = new StringTokenizer(sPath, new String(seps));
            int count = parser.countTokens();
            String[] parts = new String[count];
            for (int i = 0; i < count; ++i) {
                parts[i] = parser.nextToken();
            }
            if (parts.length >= 5) {
                String sUNCPrefix = "\\\\";
                if (sPath.startsWith("\\\\")) {
                    this.m_sbInstallPath.append("\\\\");
                } else if (sPath.startsWith(File.separator)) {
                    this.m_sbInstallPath.append(File.separatorChar);
                }
                this.m_sbInstallPath.append(parts[0]).append(File.separatorChar).append(parts[1]).append(File.separatorChar).append("...").append(File.separatorChar).append(parts[parts.length - 2]).append(File.separatorChar).append(parts[parts.length - 1]);
            } else {
                this.m_sbInstallPath.append(sPath);
            }
        }
        return this.m_sbInstallPath.toString();
    }

    private void updateStatusLabel(boolean bInstallPathIsVisible) {
        if (this.m_xcStatusLabel != null) {
            if (!bInstallPathIsVisible) {
                this.m_xcStatusLabel.setText(null);
            } else {
                String sPath = DataManager.getPathToInstallDir();
                if (sPath == null) {
                    this.m_xcStatusLabel.setText(null);
                }
                Rectangle2D rec = this.m_xcStatusLabel.getFont().getStringBounds(sPath, new FontRenderContext(null, false, false));
                int availableWidth = this.m_xcStatusLabel.getWidth();
                int fudgeFactor = 10;
                if (rec.getWidth() + 10.0 < (double)availableWidth) {
                    this.m_xcStatusLabel.setText(sPath);
                } else {
                    String sFormattedPath = this.formatInstallPath(sPath);
                    rec = this.m_xcStatusLabel.getFont().getStringBounds(sFormattedPath, new FontRenderContext(null, false, false));
                    availableWidth = this.m_xcStatusLabel.getWidth();
                    if (rec.getWidth() + 10.0 < (double)availableWidth) {
                        this.m_xcStatusLabel.setText(sFormattedPath);
                    } else {
                        this.m_xcStatusLabel.setText(sPath);
                    }
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        block18: {
            class CreateNewAction
            extends CnfgSwingAction {
                public CreateNewAction(String string, Icon toolbarIcon, Object userObject1, Object userObject2) {
                    super(string, toolbarIcon, userObject1, userObject2);
                }

                @Override
                public void actionPerformed(ActionEvent event) {
                    TemplatedParameter tp = (TemplatedParameter)this.userObject1;
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.userObject2;
                    CRConfigFrame.this.displayCreateNewDialog(tp, treeNode);
                }
            }
            Folder sf;
            CnfgMenu source;
            block19: {
                if (!CnfgMenu.class.isInstance(e.getSource())) break block18;
                source = (CnfgMenu)e.getSource();
                if (!this.m_menuEditNew_main.equals(source)) {
                    source.removeAll();
                } else if (source.getMenuComponentCount() == 1 && source.getMenuComponent(0).getName().compareTo(CnfgResource.getMessage("Menu.actions.new.empty")) == 0) {
                    source.removeAll();
                }
                DefaultMutableTreeNode sn = (DefaultMutableTreeNode)this.cCnfgTree.getLastSelectedPathComponent();
                sf = null;
                if (sn != null) {
                    sf = (Folder)sn.getUserObject();
                }
                if (source == this.m_menuEditNew_main) break block19;
                if (sf != null) {
                    List<TemplatedParameter> al = sf.getAvailableTemplates();
                    StringBuffer listOfMnemonics = new StringBuffer();
                    for (int i = 0; i < al.size(); ++i) {
                        TemplatedParameter tp = al.get(i);
                        CreateNewAction newAction = new CreateNewAction("XXX", null, tp, sn);
                        String tpLabel = tp.getLabel();
                        int j = 0;
                        char mnemonicChar = tpLabel.charAt(j);
                        while (true) {
                            if (listOfMnemonics.toString().indexOf(mnemonicChar) < 0) {
                                if (mnemonicChar >= 'A' && mnemonicChar <= 'Z' || mnemonicChar >= 'a' && mnemonicChar <= 'z' || mnemonicChar >= '0' && mnemonicChar <= '9') {
                                    listOfMnemonics.append(mnemonicChar);
                                    break;
                                }
                                if (++j == tpLabel.length()) {
                                    mnemonicChar = '\u0000';
                                    break;
                                }
                                mnemonicChar = tpLabel.charAt(j);
                                continue;
                            }
                            if (++j == tpLabel.length()) {
                                mnemonicChar = tpLabel.charAt(0);
                                break;
                            }
                            mnemonicChar = tpLabel.charAt(j);
                        }
                        JMenuItem menu = source.addMenuItem(tpLabel + "...", mnemonicChar, null, true, newAction);
                        menu.updateUI();
                    }
                } else {
                    CreateNewAction newAction = new CreateNewAction("empty", null, null, null){
                        {
                            super(string, toolbarIcon, userObject1, userObject2);
                        }

                        @Override
                        public void actionPerformed(ActionEvent event) {
                        }
                    };
                    JMenuItem menu = source.addMenuItem(CnfgResource.getMessage("Menu.actions.new.empty"), null, false, newAction);
                    menu.setName(CnfgResource.getMessage("Menu.actions.new.empty"));
                }
                break block18;
            }
            if (source.getMenuComponentCount() == 0) {
                Folder f = this.cCnfgTree.getRootFolder();
                this.parseFolders(f, source);
                if (source.getMenuComponentCount() == 0) {
                    CreateNewAction newAction = new CreateNewAction("empty", null, null, null){
                        {
                            super(string, toolbarIcon, userObject1, userObject2);
                        }

                        @Override
                        public void actionPerformed(ActionEvent event) {
                        }
                    };
                    JMenuItem menu = source.addMenuItem(CnfgResource.getMessage("Menu.actions.new.empty"), null, false, newAction);
                    menu.setName(CnfgResource.getMessage("Menu.actions.new.empty"));
                }
            } else {
                for (int k = 0; k < source.getMenuComponentCount(); ++k) {
                    source.getMenuComponent(k).setEnabled(false);
                }
            }
            if (sf == null) break block18;
            List<TemplatedParameter> als = sf.getAvailableTemplates();
            for (int k = 0; k < source.getMenuComponentCount(); ++k) {
                for (int t = 0; t < als.size(); ++t) {
                    TemplatedParameter tps = als.get(t);
                    JMenuItem menu = (JMenuItem)source.getMenuComponent(k);
                    if (menu.getName().compareTo(tps.getLabel() + "...") != 0) continue;
                    menu.setEnabled(true);
                }
            }
        }
    }

    private void parseFolders(Folder f, CnfgMenu source) {
        if (null != f && !f.getDisabled() && f.getVisibility() && !f.isInstanceFolder()) {
            for (int i = 0; i < f.getTParameters().size(); ++i) {
                TemplatedParameter tp = f.getTParameters().get(i);
                if (null == tp || tp.getDisabled() || !tp.getVisibility()) continue;
                this.addTemplateToMenu(tp, source);
            }
            for (int j = 0; j < f.getFolders().size(); ++j) {
                Folder cf = f.getFolders().get(j);
                this.parseFolders(cf, source);
            }
        }
    }

    private void addTemplateToMenu(TemplatedParameter tp, CnfgMenu source) {
        boolean found = false;
        for (int j = 0; j < source.getMenuComponentCount(); ++j) {
            JMenuItem menu = (JMenuItem)source.getMenuComponent(j);
            if (!menu.getName().equals(tp.getLabel() + "...")) continue;
            found = true;
            break;
        }
        if (!found) {
            class CreateNewActionBar
            extends CnfgSwingAction {
                String name;

                public CreateNewActionBar(String string, Icon toolbarIcon, Object userObject1, Object userObject2) {
                    super(string, toolbarIcon, userObject1, userObject2);
                    this.name = "";
                    this.name = string;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode sn = (DefaultMutableTreeNode)CRConfigFrame.this.cCnfgTree.getLastSelectedPathComponent();
                    Folder sf = null;
                    if (sn != null) {
                        sf = (Folder)sn.getUserObject();
                        List<TemplatedParameter> al = sf.getAvailableTemplates();
                        for (int i = 0; i < al.size(); ++i) {
                            TemplatedParameter availableTP = al.get(i);
                            if (availableTP.getName().compareTo(this.name) != 0 && (availableTP.getName().indexOf("database") < 0 || this.name.indexOf("database") < 0)) continue;
                            CRConfigFrame.this.displayCreateNewDialog(availableTP, sn);
                        }
                    }
                }
            }
            CreateNewActionBar newAction = new CreateNewActionBar(tp.getName(), null, tp, null);
            String tpLabel = tp.getLabel();
            int j = 0;
            char mnemonicChar = Character.toLowerCase(tpLabel.charAt(j));
            while (true) {
                if (this.m_listOfMnemonics.toString().indexOf(mnemonicChar) < 0) {
                    if (this.m_listOfMnemonics.toString().indexOf(mnemonicChar) >= 0) break;
                    if (mnemonicChar >= 'A' && mnemonicChar <= 'Z' || mnemonicChar >= 'a' && mnemonicChar <= 'z' || mnemonicChar >= '0' && mnemonicChar <= '9') {
                        this.m_listOfMnemonics.append(mnemonicChar);
                        break;
                    }
                    if (++j == tpLabel.length()) {
                        mnemonicChar = '\u0000';
                        break;
                    }
                    mnemonicChar = tpLabel.charAt(j);
                    continue;
                }
                if (++j == tpLabel.length()) {
                    mnemonicChar = tpLabel.charAt(0);
                    break;
                }
                mnemonicChar = tpLabel.charAt(j);
            }
            JMenuItem menu = source.addMenuItem(tpLabel + "...", mnemonicChar, null, false, newAction);
            menu.setName(tp.getLabel() + "...");
        }
        List<Option> aOp = tp.getOptions();
        for (int w = 0; w < aOp.size(); ++w) {
            Option o = aOp.get(w);
            if (null == o || o.getDisabled() || !o.getVisibility()) continue;
            ArrayList<TemplatedParameter> param = o.getTParameters();
            for (int t = 0; t < param.size(); ++t) {
                TemplatedParameter p = param.get(t);
                if (null == p || p.getDisabled() || !p.getVisibility()) continue;
                this.addTemplateToMenu(p, source);
            }
        }
    }

    public void createToolbar() {
        this.m_toolBar = new JToolBar(){

            @Override
            public boolean isManagingFocus() {
                return false;
            }
        };
        this.m_toolBar.setFloatable(false);
        this.m_toolBar.setMargin(new Insets(0, 0, 0, 0));
        this.m_toolBar.setRollover(true);
        EmptyBorder lineBorder = new EmptyBorder(new Insets(0, 2, 2, 2)){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(Color.gray);
                g.drawLine(x, y + height - 2, x + width - 2, y + height - 2);
                g.drawLine(x, y, x, y + height - 2);
                g.drawLine(x + width - 2, y, x + width - 2, y + height - 2);
                g.setColor(Color.white);
                g.drawLine(x, y + height - 1, x + width - 2, y + height - 1);
                g.drawLine(x + 1, y, x + 1, y + height - 3);
            }
        };
        this.m_toolBar.setBorder(lineBorder);
        this.addToolbarButton(CnfgResource.getMessage("Tooltip.file.save"), this.m_actionFileSave);
        this.m_toolBar.addSeparator();
        if (DataManager.getInstance().isBTSVInstalled() || DataManager.getInstance().isInstalled("CCD") || DataManager.getInstance().isInstalled("BV")) {
            this.addToolbarButton(CnfgResource.getMessage("Tooltip.actions.start"), this.m_actionActionsStart);
            this.addToolbarButton(CnfgResource.getMessage("Tooltip.actions.stop"), this.m_actionActionsStop);
            this.addToolbarButton(CnfgResource.getMessage("Tooltip.actions.restart"), this.m_actionActionsRestart);
            this.m_toolBar.addSeparator();
        }
        this.addToolbarButton(CnfgResource.getMessage("Tooltip.actions.resetToDefault"), this.m_actionEditResetToDefault);
        this.addToolbarButton(CnfgResource.getMessage("Tooltip.actions.test"), this.m_actionActionsTest);
    }

    public JButton addToolbarButton(String szToolHelp, CnfgSwingAction action) {
        Insets insets = new Insets(4, 4, 4, 4);
        JButton b = this.m_toolBar.add(action);
        b.setText("");
        b.setAction(action);
        b.setRequestFocusEnabled(false);
        b.setIcon(action.toolbarIcon);
        if (szToolHelp != null && szToolHelp.length() != 0) {
            b.setToolTipText(szToolHelp);
        }
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setHorizontalAlignment(0);
        b.setVerticalAlignment(0);
        b.setBorder(new EmptyBorder(insets));
        return b;
    }

    public void createTable() {
        this.cCnfgTableModel = new CnfgTableModel();
        this.cCnfgTable = new CnfgTable(this, this.cCnfgTableModel);
        this.m_tableScrollPane = new JScrollPane(this.cCnfgTable);
        if (CnfgUtils.isWindowsPlatform()) {
            this.m_tableScrollPane.setBorder(new CnfgBorder());
        }
        this.m_tableScrollPane.setMinimumSize(new Dimension(150, 20));
        this.m_tableScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                CRConfigFrame.this.cCnfgTable.grabFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JViewport cExploreView = this.m_tableScrollPane.getViewport();
        this.cCnfgTable.setMinimumSize(new Dimension(150, 20));
        if (CnfgUtils.isWindowsPlatform()) {
            cExploreView.setBackground(SystemColor.window);
        } else {
            cExploreView.setBackground(Color.white);
        }
        cExploreView.setOpaque(true);
        this.cRightContentPanel = new JPanel();
        this.cRightContentPanel.setLayout(new BorderLayout());
        this.cNavPathPanel = new JPanel(){
            Dimension d = new Dimension(200, 200);

            @Override
            public Dimension getMinimumSize() {
                return this.d;
            }
        };
        this.cNavPathPanel.setLayout(new BorderLayout());
        this.cNavPathPanel.setBorder(new LineBorder(UIManager.getDefaults().getColor("Menu.background"), 2, false));
        this.cNavPathLabel = new NavigationLabel(" ", 2);
        this.cNavPathLabel.setBorder(new EmptyBorder(new Insets(1, 5, 1, 5)));
        this.cNavPathLabel.setFont(CnfgFontSetting.getNavPathLabelFont());
        if (CnfgUtils.isHighContrastWin()) {
            this.cNavPathLabel.setForeground(SystemColor.windowText);
            this.cNavPathPanel.setBackground(SystemColor.window);
        } else {
            this.cNavPathLabel.setForeground(new Color(130, 130, 130));
            this.cNavPathPanel.setBackground(new Color(204, 204, 255));
        }
        this.cNavPathPanel.add((Component)this.cNavPathLabel, "West");
        this.cNavPathPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                CRConfigFrame.this.cCnfgTable.grabFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.m_infoPanel = new InformationPanel(this.cCnfgTable, this.cCnfgTableModel, this);
        this.m_infoScrollPane = new JScrollPane();
        JViewport cInfoView = this.m_infoScrollPane.getViewport();
        this.m_infoScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.m_infoScrollPane.setOpaque(true);
        cInfoView.add(this.m_infoPanel);
        if (CnfgUtils.isWindowsPlatform()) {
            this.m_tableScrollPane.setBorder(new CnfgBorder());
            cInfoView.setBackground(SystemColor.window);
            this.m_infoScrollPane.setBackground(SystemColor.window);
        } else {
            cInfoView.setBackground(Color.white);
            this.m_infoScrollPane.setBackground(Color.white);
        }
        cInfoView.setOpaque(true);
        this.m_infoScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel cTopContentPanel = new JPanel();
        cTopContentPanel.setLayout(new BorderLayout());
        cTopContentPanel.add((Component)this.cNavPathPanel, "North");
        cTopContentPanel.add((Component)this.m_tableScrollPane, "Center");
        this.m_infoTableSplitPane = new JSplitPane(0, true, cTopContentPanel, this.m_infoScrollPane);
        this.m_infoTableSplitPane.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.m_infoTableSplitPane.setDividerSize(5);
        Integer dividerLocation = (Integer)CnfgPreferences.getInstance().getProperty("HorizontalDividerLocation", Integer.class);
        if (dividerLocation != null) {
            this.m_infoTableSplitPane.setDividerLocation(dividerLocation);
        } else {
            this.m_infoTableSplitPane.setDividerLocation(375);
        }
        this.m_infoScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Object obj = e.getSource();
                if (obj != null && JScrollPane.class.isInstance(obj)) {
                    CRConfigFrame.getInstance().resizeInfoPane(CRConfigFrame.this.m_infoTableSplitPane, CRConfigFrame.this.m_infoScrollPane, CRConfigFrame.this.m_infoPanel);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.setScrollPaneMinSize(this.m_infoPanel, this.m_infoScrollPane);
        this.cRightContentPanel.add((Component)this.m_infoTableSplitPane, "Center");
        DataManager.getInstance().addCnfgSelectionListener(this.cCnfgTable);
        DataManager.getInstance().addCnfgValueChangedListener(this.cCnfgTable);
        DataManager.getInstance().addCnfgValueChangedListener(this.m_infoPanel);
        DataManager.getInstance().addCnfgSelectionListener(this.cNavPathLabel);
        DataManager.getInstance().addCnfgNodeRenamedListener(this.cNavPathLabel);
    }

    protected void setScrollPaneMinSize(InformationPanel infoPanel, JScrollPane scrollPane) {
        m_maxCharWidth = CnfgFontSetting.getMaxHeight(infoPanel.getFont());
        Dimension d = new Dimension(200, (m_maxCharWidth + 3) * 5);
        scrollPane.setMinimumSize(d);
        infoPanel.setMinimumSize(d);
    }

    protected void resizeInfoPane(JSplitPane splitPane, JScrollPane scrollPane, InformationPanel infoPane) {
        if (splitPane == null) {
            return;
        }
        int marginWidth = 0;
        if (m_maxCharWidth + scrollPane.getVerticalScrollBar().getSize().width < splitPane.getSize().width) {
            marginWidth = m_maxCharWidth + scrollPane.getVerticalScrollBar().getSize().width;
        }
        infoPane.resizeWidth(splitPane.getSize().width - marginWidth);
        scrollPane.updateUI();
        if (splitPane.getDividerLocation() >= splitPane.getMaximumDividerLocation()) {
            splitPane.setDividerLocation(splitPane.getMaximumDividerLocation() - 1);
        }
    }

    private void createDualPane() {
        this.cTreeScrollPane = new JScrollPane();
        this.cCnfgTree = new CnfgTree(this);
        this.cTreeScrollPane.getViewport().add(this.cCnfgTree);
        this.cTreeScrollPane.setPreferredSize(new Dimension(200, 400));
        this.cTreeScrollPane.setMinimumSize(new Dimension(150, 20));
        this.cTreeScrollPane.setBorder(new CnfgBorder(new Insets(2, 5, 2, 2)));
        if (CnfgUtils.isWindowsPlatform()) {
            this.cTreeScrollPane.getViewport().setBackground(SystemColor.window);
            this.cTreeScrollPane.setBackground(SystemColor.window);
        } else {
            this.cTreeScrollPane.getViewport().setBackground(Color.white);
            this.cTreeScrollPane.setBackground(Color.white);
        }
        DataManager.getInstance().addCnfgDataLoadedListener(this.cCnfgTree);
        DataManager.getInstance().addCnfgNodeInsertedListener(this.cCnfgTree);
        DataManager.getInstance().addCnfgNodeDeletedListener(this.cCnfgTree);
        DataManager.getInstance().addCnfgNodeRenamedListener(this.cCnfgTree);
        DataManager.getInstance().addCnfgNodeSwitchListener(this.cCnfgTree);
        DataManager.getInstance().addServiceFolderListener(this);
        this.m_mtblL = new MenuToolbarLogicListener(this);
        this.m_rtdL = new ResetToDefaultListener(this);
        this.cCnfgTree.addTreeSelectionListener(this.m_mtblL);
        this.cCnfgTree.addTreeSelectionListener(this.m_rtdL);
        this.cCnfgTree.addTreeSelectionListener(this.m_infoPanel);
        this.cCnfgTree.addFocusListener(this.m_mtblL);
        this.cCnfgTree.addFocusListener(this.m_rtdL);
        this.cCnfgTree.addFocusListener(this.m_infoPanel);
        this.cCnfgTable.addFocusListener(this.m_mtblL);
        this.cCnfgTable.addFocusListener(this.m_rtdL);
        this.cCnfgTable.addFocusListener(this.m_infoPanel);
        DataManager.getInstance().addCnfgNodeDeletedListener(this.m_mtblL);
        DataManager.getInstance().addCnfgNodeInsertedListener(this.m_mtblL);
        this.cLeftContentPanel = new JPanel();
        this.cLeftContentPanel.setLayout(new BorderLayout());
        this.cExplorerPanel = new JPanel();
        this.cExplorerPanel.setLayout(new BorderLayout());
        this.cExplorerPanel.setBorder(new LineBorder(UIManager.getDefaults().getColor("Menu.background"), 2, false));
        this.cExplorerLabel = new JLabel(CnfgResource.getMessage("Label.treeHeader"));
        this.cExplorerLabel.setFont(CnfgFontSetting.getExplorerLabelFont());
        if (CnfgUtils.isHighContrastWin()) {
            this.cExplorerPanel.setBackground(SystemColor.window);
            this.cExplorerLabel.setForeground(SystemColor.windowText);
        } else {
            this.cExplorerPanel.setBackground(new Color(102, 102, 153));
            this.cExplorerLabel.setForeground(Color.white);
        }
        this.cExplorerLabel.setBorder(new EmptyBorder(new Insets(1, 5, 1, 5)));
        this.cExplorerPanel.add((Component)this.cExplorerLabel, "West");
        this.cLeftContentPanel.add((Component)this.cExplorerPanel, "North");
        this.cLeftContentPanel.add((Component)this.cTreeScrollPane, "Center");
        this.cLeftContentPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                CRConfigFrame.this.cCnfgTree.grabFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.cSplitPane = new JSplitPane(1, true, this.cLeftContentPanel, this.cRightContentPanel);
        this.cSplitPane.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.cSplitPane.setDividerSize(6);
        Integer dividerLocation = (Integer)CnfgPreferences.getInstance().getProperty("VerticalDividerLocation", Integer.class);
        if (dividerLocation != null) {
            this.cSplitPane.setDividerLocation(dividerLocation);
        }
        ListSelectionModel lsm = this.cCnfgTable.getSelectionModel();
        lsm.addListSelectionListener(this.m_mtblL);
        lsm.addListSelectionListener(this.m_rtdL);
        lsm.addListSelectionListener(this.m_infoPanel);
        this.getContentPane().add((Component)this.cSplitPane, "Center");
        ColorOnFocusListener currentPaneFocus = new ColorOnFocusListener();
        this.cCnfgTree.addFocusListener(currentPaneFocus);
        this.cCnfgTable.addFocusListener(currentPaneFocus);
    }

    @Override
    public void serviceFolderChanged(CnfgServiceFolderChangedEvent e) {
        DefaultMutableTreeNode sn = (DefaultMutableTreeNode)this.cCnfgTree.getLastSelectedPathComponent();
        if (sn != null) {
            Folder f = (Folder)sn.getUserObject();
            if (f instanceof ServiceFolder) {
                boolean bIsRunning = ((ServiceFolder)f).isRunning();
                this.m_actionActionsStart.setEnabled(!bIsRunning);
                this.m_actionActionsStop.setEnabled(bIsRunning);
                this.m_actionActionsRestart.setEnabled(bIsRunning);
            } else {
                this.updateRunningActions();
            }
        }
        this.cCnfgTree.fireRootChange();
    }

    public boolean action_Save() {
        return this.commonSave();
    }

    public boolean action_SaveAndAutoClose() {
        return this.commonSave(true);
    }

    private boolean commonSave() {
        this.stopCellEditing();
        int res = this.askToSaveForAAA();
        if (res != 0) {
            return false;
        }
        return this.commonSave(false);
    }

    private int askToSaveForAAA() {
        if (DataManager.getInstance().isAAADirty() && ServiceManager.isRunning() && DataManager.getInstance().isCMEnabled()) {
            Object[] message = new Object[]{CnfgResource.getMessage("Message.saveaaa.notification"), CnfgResource.getMessage("Message.saveaaa.confirmation")};
            return DialogMessage.showDialog(message, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 0);
        }
        return 0;
    }

    private boolean commonSave(boolean autoCloseOnNoErrors) {
        TestTaskManager.setTestPerformed(false);
        boolean ret = this.runAction(new CnfgAction(){

            @Override
            public ICnfgTask[] getTasks() {
                return DataManager.getInstance().getSaveTasks();
            }
        }, true, autoCloseOnNoErrors);
        return ret;
    }

    public boolean action_SaveUTF8() {
        DataManager dm = DataManager.getInstance();
        dm.useDefaultEncoding(false);
        return this.commonSave();
    }

    public boolean action_Export() {
        int returnVal;
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f != null) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = CnfgUtils.getFileExtension(f);
                    if (extension != null && extension.compareTo("xml") == 0) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Label.export.xml");
            }
        };
        this.stopCellEditing();
        CnfgFileChooser chooser = new CnfgFileChooser("../configuration");
        chooser.setFileFilter(filter);
        chooser.setDialogTitle(CnfgResource.getMessage("Title.DialogExport"));
        Object[] oMessage1 = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.export.notification")).append("\n").toString(), CnfgResource.getMessage("Message.export.resolution")};
        if (0 == DialogMessage.showDialog(oMessage1, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1) && (returnVal = chooser.showSaveDialog(this)) == 0) {
            Object[] args;
            Object[] oMessage2;
            File selectedFile = chooser.getSelectedFile();
            String sExt = CnfgUtils.getFileExtension(selectedFile);
            if (sExt == null || sExt.compareTo("xml") != 0) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".xml");
            }
            if (selectedFile.exists() && 1 == DialogMessage.showDialog(oMessage2 = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.export.duplicate.notification", args = new Object[]{selectedFile.getName()})).append("\n").toString(), CnfgResource.getMessage("Message.export.duplicate.resolution")}, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1)) {
                return false;
            }
            DataManager.getInstance().setDefaultEncoding(false);
            final File f = selectedFile;
            return this.runAction(new CnfgAction(){

                @Override
                public ICnfgTask[] getTasks() {
                    return DataManager.getInstance().getExportTasks(f);
                }
            });
        }
        return false;
    }

    public void action_GenWar() {
        CnfgWizard.getInstance().action_Wizard("genwarwizard");
    }

    private ArrayList mergeAndCloneServiceList(ArrayList srcList, ArrayList newList) {
        ArrayList resultList = new ArrayList();
        if (srcList != null) {
            resultList = (ArrayList)srcList.clone();
        }
        if (newList != null && newList.size() > 0) {
            for (int i = 0; i < newList.size(); ++i) {
                String sService = (String)newList.get(i);
                if (resultList.indexOf(sService) >= 0) continue;
                resultList.add(sService);
            }
        }
        return resultList;
    }

    private String getServiceNodeName(Folder srvFolder, Folder cbsFolder) {
        String serviceNodeName = "";
        if (srvFolder == cbsFolder) {
            serviceNodeName = "CBS";
        } else if (srvFolder instanceof BootstrapServiceFolder) {
            Folder parentF = srvFolder.getParent();
            if (parentF != null) {
                serviceNodeName = parentF.getName();
            }
        } else {
            serviceNodeName = srvFolder.getName();
        }
        return serviceNodeName;
    }

    public void action_Exit() {
        int option;
        boolean bIsCBSAvaliable;
        this.stopCellEditing();
        boolean bSave = false;
        boolean bNeedUnreg = false;
        if (DataManager.getInstance().isDirty()) {
            Object[] arrayOfObjects = this.getSaveWarningMessage();
            int option2 = DialogMessage.showDialog(arrayOfObjects, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNOCANCEL, 0);
            if (option2 == 0) {
                bSave = true;
            } else if (option2 == 2) {
                return;
            }
        }
        ArrayList lRestartServices = new ArrayList();
        if (bSave) {
            bIsCBSAvaliable = DataManager.getInstance().getCBS() != null;
            lRestartServices = this.mergeAndCloneServiceList(ServiceManager.getRestartServices(), DataManager.getInstance().getRestartServices());
        } else {
            String serviceName = DataManager.getInstance().getCRNServiceName();
            bIsCBSAvaliable = serviceName != null && serviceName.length() > 0;
            lRestartServices = this.mergeAndCloneServiceList(ServiceManager.getRestartServices(), null);
        }
        ArrayList lErrors = new ArrayList();
        ArrayList<ICnfgTask> serviceTasks = new ArrayList<ICnfgTask>();
        ArrayList lServiceFolders = (ArrayList)DataManager.getInstance().getServiceFolders(true);
        Folder cbsFolder = DataManager.getInstance().getCBS();
        String sExitActionName = "";
        for (int idx = 0; idx < lServiceFolders.size(); ++idx) {
            ServiceFolder srvFolder = (ServiceFolder)lServiceFolders.get(idx);
            String sAction = "";
            if (srvFolder == null || srvFolder.getDisabled() || !srvFolder.getVisibility()) continue;
            String serviceNodeName = this.getServiceNodeName(srvFolder, cbsFolder);
            if (srvFolder == cbsFolder && !bIsCBSAvaliable) {
                if (ServiceManager.isRegistered()) {
                    sAction = srvFolder.isRunning() ? "restart" : "start";
                    sExitActionName = sAction;
                    this.addExitErrorMessages(lErrors, "unregister", srvFolder.getLabel());
                    bNeedUnreg = true;
                }
            } else if (srvFolder.isRunning()) {
                if (lRestartServices.indexOf(serviceNodeName) >= 0) {
                    sExitActionName = sAction = "restart";
                    this.addExitErrorMessages(lErrors, sAction, srvFolder.getLabel());
                }
            } else {
                sExitActionName = sAction = "start";
                this.addExitErrorMessages(lErrors, sAction, srvFolder.getLabel());
            }
            ICnfgTask[] listTasks = null;
            if (sAction.equals("restart")) {
                if (srvFolder == cbsFolder) {
                    if (bSave) {
                        CnfgServiceUtils.createStopTask(serviceTasks, null);
                        CnfgServiceUtils.createStartTask(serviceTasks, true, null);
                    } else {
                        listTasks = CnfgServiceUtils.getServiceTasks(3);
                    }
                } else {
                    listTasks = srvFolder.createRestartTasks(bSave);
                }
            } else if (sAction.equals("start")) {
                if (srvFolder == cbsFolder) {
                    if (bSave) {
                        CnfgServiceUtils.createStartTask(serviceTasks, true, null);
                    } else {
                        listTasks = CnfgServiceUtils.getServiceTasks(1);
                    }
                } else {
                    listTasks = srvFolder.createStartTasks(srvFolder.findAction("start"), bSave);
                }
            }
            if (listTasks != null) {
                for (int j = 0; j < listTasks.length; ++j) {
                    serviceTasks.add(listTasks[j]);
                }
            }
            lRestartServices.remove(serviceNodeName);
        }
        if (cbsFolder == null) {
            String sAction = "";
            if (!bIsCBSAvaliable) {
                if (ServiceManager.isRegistered()) {
                    sAction = ServiceManager.isRunning() ? "restart" : "start";
                    sExitActionName = sAction;
                    this.addExitErrorMessages(lErrors, "unregister", ServiceManager.getCBSRegName());
                    bNeedUnreg = true;
                }
            } else if (ServiceManager.isRunning()) {
                if (lRestartServices.indexOf("CBS") >= 0) {
                    sAction = "restart";
                    this.addExitErrorMessages(lErrors, sAction, DataManager.getInstance().getCRNServiceName());
                    sExitActionName = "restart";
                }
            } else {
                sAction = "start";
                this.addExitErrorMessages(lErrors, sAction, DataManager.getInstance().getCRNServiceName());
                sExitActionName = sAction;
            }
            ICnfgTask[] listTasks = null;
            if (sAction.equals("restart")) {
                if (bSave) {
                    CnfgServiceUtils.createStopTask(serviceTasks, null);
                    CnfgServiceUtils.createStartTask(serviceTasks, true, null);
                } else {
                    listTasks = CnfgServiceUtils.getServiceTasks(3);
                }
            } else if (sAction.equals("start")) {
                if (bSave) {
                    CnfgServiceUtils.createStartTask(serviceTasks, true, null);
                } else {
                    listTasks = CnfgServiceUtils.getServiceTasks(1);
                }
            }
            if (listTasks != null) {
                for (int k = 0; k < listTasks.length; ++k) {
                    serviceTasks.add(listTasks[k]);
                }
            }
        }
        if (lErrors != null && lErrors.size() > 0) {
            ArrayList lErrorMessages = new ArrayList();
            this.populateExitErrorMessages(lErrors, lErrorMessages);
            if (bNeedUnreg) {
                option = DialogMessage.showDialog(lErrorMessages, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESCANCEL, 0);
                if (option == 1) {
                    option = 2;
                }
            } else {
                option = DialogMessage.showDialog(lErrorMessages, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNOCANCEL, 0);
            }
        } else {
            option = 1;
        }
        if (option == 0) {
            ICnfgTask[] tasks = null;
            int iSaveTasksNum = 0;
            if (bSave) {
                ICnfgTask[] listSaveTasks = DataManager.getInstance().getSaveTasks();
                if (listSaveTasks != null) {
                    iSaveTasksNum = listSaveTasks.length;
                    tasks = new ICnfgTask[iSaveTasksNum + serviceTasks.size()];
                    for (int i = 0; i < iSaveTasksNum; ++i) {
                        tasks[i] = listSaveTasks[i];
                    }
                }
            } else {
                tasks = new ICnfgTask[serviceTasks.size()];
            }
            for (int j = 0; j < serviceTasks.size(); ++j) {
                tasks[j + iSaveTasksNum] = serviceTasks.get(j);
            }
            final String sActionName = sExitActionName;
            final ICnfgTask[] exitTasks = tasks;
            this.runAction(new CnfgAction(){

                @Override
                public ICnfgTask[] getTasks() {
                    return exitTasks;
                }

                @Override
                public String getName() {
                    return sActionName;
                }
            });
        } else if (option == 1) {
            if (bSave) {
                this.action_Save();
            }
        } else if (option == 2) {
            return;
        }
        Dimension dim = this.getSize();
        CnfgPreferences.getInstance().setProperty("MainFrameSize.x", dim.getWidth());
        CnfgPreferences.getInstance().setProperty("MainFrameSize.y", dim.getHeight());
        CnfgPreferences.getInstance().setProperty("ToolbarIsVisible", this.m_bIsToolbarVisible);
        CnfgPreferences.getInstance().setProperty("InstallPathIsVisible", this.m_bIsInstallPathVisible);
        CnfgFontSetting.setFontPreference();
        CnfgPreferences.getInstance().setProperty("VerticalDividerLocation", this.cSplitPane.getDividerLocation());
        CnfgPreferences.getInstance().setProperty("HorizontalDividerLocation", this.m_infoTableSplitPane.getDividerLocation());
        CnfgPreferences.getInstance().setProperty("ConformanceCheckingIsDisabled", DataManager.getInstance().getIsCNFMCheckingDisabled());
        this.cCnfgTable.setPreferences();
        CnfgUtils.saveAdditionalInfo();
        CnfgPreferences.getInstance().saveSettings();
        this.dispose();
        ServiceManager.stopCheckServiceStatus();
        this.exit(0);
    }

    private void addExitErrorMessages(ArrayList lErrors, String sError, String sServiceName) {
        if (sError == null | sError.length() == 0) {
            return;
        }
        Object[] errObj = new Object[]{sError, sServiceName};
        lErrors.add(errObj);
    }

    private void populateExitErrorMessages(ArrayList lErrors, ArrayList lErrorMessages) {
        if (lErrors == null || lErrors.size() == 0) {
            return;
        }
        for (int i = 0; i < lErrors.size(); ++i) {
            Object[] errObj = (Object[])lErrors.get(i);
            String sError = (String)errObj[0];
            String sServiceName = (String)errObj[1];
            Object[] arg = new Object[]{sServiceName};
            if (sError.equalsIgnoreCase("unregister")) {
                if (lErrors.size() == 1) {
                    lErrorMessages.add(CnfgResource.getMessage("Message.exit.servicedeleted.notification1", arg) + "\n");
                    lErrorMessages.add(CnfgResource.getMessage("Message.exit.servicedeleted.resolution") + "\n");
                    return;
                }
                lErrorMessages.add(CnfgResource.getMessage("Message.exit.servicedeleted.notification", arg) + "\n");
                continue;
            }
            if (sError.equalsIgnoreCase("restart")) {
                if (lErrors.size() == 1) {
                    lErrorMessages.add(CnfgResource.getMessage("Message.exit.servicedirty.notification1", arg) + "\n");
                    lErrorMessages.add(CnfgResource.getMessage("Message.exit.servicedirty.resolution"));
                    return;
                }
                lErrorMessages.add(CnfgResource.getMessage("Message.exit.servicedirty.notification", arg) + "\n");
                continue;
            }
            if (!sError.equalsIgnoreCase("start")) continue;
            if (lErrors.size() == 1) {
                lErrorMessages.add(CnfgResource.getMessage("Message.exit.servicestopped.notification1", arg) + "\n");
                lErrorMessages.add(CnfgResource.getMessage("Message.exit.servicestopped.resolution"));
                return;
            }
            lErrorMessages.add(CnfgResource.getMessage("Message.exit.servicestopped.notification", arg) + "\n");
        }
        if (lErrorMessages != null && lErrorMessages.size() > 0) {
            lErrorMessages.add(CnfgResource.getMessage("Message.exit.serviceaction.apply.resolution"));
        }
    }

    public void action_ViewToolbar() {
        this.stopCellEditing();
        if (this.m_bIsToolbarVisible.booleanValue()) {
            this.m_toolBar.setVisible(false);
            this.m_menuViewToolbar.setSelected(false);
            this.m_bIsToolbarVisible = new Boolean(false);
        } else {
            this.m_toolBar.setVisible(true);
            this.m_menuViewToolbar.setSelected(true);
            this.m_bIsToolbarVisible = new Boolean(true);
        }
    }

    public void action_ViewInstallPath() {
        this.stopCellEditing();
        if (this.m_bIsInstallPathVisible.booleanValue()) {
            this.updateStatusLabel(false);
            this.m_menuViewInstallPath.setSelected(false);
            this.m_bIsInstallPathVisible = new Boolean(false);
        } else {
            this.updateStatusLabel(true);
            this.m_menuViewInstallPath.setSelected(true);
            this.m_bIsInstallPathVisible = new Boolean(true);
        }
    }

    public void action_Rename() {
        Folder f;
        DefaultMutableTreeNode sn = (DefaultMutableTreeNode)this.cCnfgTree.getLastSelectedPathComponent();
        if (sn != null && (f = (Folder)sn.getUserObject()).isInstanceFolder()) {
            this.displayRenameDialog(f, sn);
        }
    }

    public void action_retrieve(Object userObject1) {
        String sTitle = CnfgResource.getMessage("Label.DialogRetrieveConfiguration.title");
        String username = "";
        String password = "";
        String namespaceID = "";
        String remoteURL = new DialogConfigServersParameter().getPortalURIViaCMURI();
        DataManager dm = DataManager.getInstance();
        Parameter parm = dm.findParm("retrieveConfigUser");
        username = parm != null ? (String)parm.getValue() : "";
        parm = dm.findParm("retrieveConfigPassword");
        password = parm != null ? (String)parm.getValue() : "";
        DialogRetrieveConfiguration dlg = new DialogRetrieveConfiguration(new Dialog(this), sTitle, username, password, namespaceID = (parm = dm.findParm("retrieveConfigNamespaceID")) != null ? (String)parm.getValue() : "", remoteURL);
        if (dlg.isOk()) {
            Properties res = dlg.getConfigProps();
            this.setValuesOnCFS(res, userObject1);
            this.requestFocus();
        }
    }

    private void setValuesOnCFS(Properties res, Object userObject1) {
        ArrayList<String> flipperConfigList = this.getFlipperConfigList();
        DataManager dm = DataManager.getInstance();
        for (int i = 0; i < flipperConfigList.size(); ++i) {
            String parmName = flipperConfigList.get(i);
            Parameter parm = dm.findParm(parmName);
            if (parm == null) continue;
            parm.setValue(res.getProperty(parmName));
        }
    }

    private ArrayList<String> getFlipperConfigList() {
        ArrayList<String> flipperConfigList = new ArrayList<String>();
        flipperConfigList.add("configGroupName");
        flipperConfigList.add("configGroupPassword");
        flipperConfigList.add("configGroupContactPort");
        flipperConfigList.add("configGroupContactHost");
        return flipperConfigList;
    }

    public void action_About() {
        this.stopCellEditing();
        CnfgSplashScreen splash = new CnfgSplashScreen(this, "cogconfigspl", true);
    }

    private void action_Start(Folder folder) {
        this.action_Start(folder, "start");
    }

    private void action_Start(Folder folder, String sActionName) {
        this.stopCellEditing();
        this.startTaskCollecting();
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        int res = this.checkSave(tasklist);
        if (res == 2) {
            this.endTaskCollecting();
            return;
        }
        if (res == 1) {
            DataManager.getInstance().createValidationTask(tasklist);
        }
        Map<String, ICnfgTest> initializedClasses = null;
        BootstrapServiceFolder cbsFolder = null;
        if (folder != null && folder instanceof BootstrapServiceFolder) {
            cbsFolder = (BootstrapServiceFolder)folder;
        }
        if (sActionName.equals("start")) {
            if (res == 0) {
                initializedClasses = TestTaskManager.getTestTasks(this, folder, tasklist, true, res != 0, true, new CnfgTestInitializationFeedback());
                if (initializedClasses != null) {
                    tasklist.add(new TestTaskManager.TestActionPauseTask(this.getTaskDialog()));
                }
                CnfgServiceUtils.createStartTask(tasklist, true, cbsFolder);
            } else {
                initializedClasses = TestTaskManager.getTestTasks(this, folder, tasklist, true, res != 0, true, new CnfgTestInitializationFeedback());
                if (initializedClasses != null) {
                    tasklist.add(new TestTaskManager.TestActionPauseTask(this.getTaskDialog()));
                }
                CnfgServiceUtils.createStartUpgradeTask(tasklist);
            }
        } else if (sActionName.equals("restart")) {
            if (res == 0) {
                tasklist.clear();
                CnfgServiceUtils.createStopTask(tasklist, cbsFolder);
                DataManager.getInstance().getSaveTasks(tasklist);
                initializedClasses = TestTaskManager.getTestTasks(this, folder, tasklist, true, res != 0, true, new CnfgTestInitializationFeedback());
                if (initializedClasses != null) {
                    tasklist.add(new TestTaskManager.TestActionPauseTask(this.getTaskDialog()));
                }
                CnfgServiceUtils.createStartTask(tasklist, true, cbsFolder);
            } else {
                CnfgServiceUtils.createStopTask(tasklist, cbsFolder);
                initializedClasses = TestTaskManager.getTestTasks(this, folder, tasklist, true, res != 0, true, new CnfgTestInitializationFeedback());
                if (initializedClasses != null) {
                    tasklist.add(new TestTaskManager.TestActionPauseTask(this.getTaskDialog()));
                }
                CnfgServiceUtils.createStartUpgradeTask(tasklist);
            }
        }
        ICnfgTask[] actionTasks = null;
        if (tasklist.size() > 0) {
            actionTasks = CnfgTask.createTaskArray(tasklist);
        }
        this.endTaskCollecting();
        this.runServiceAction(sActionName, actionTasks);
        if (initializedClasses != null) {
            TestTaskManager.terminateTestProviders(initializedClasses, new CnfgTestInitializationFeedback());
        }
    }

    private int checkSave(List list) {
        if (DataManager.getInstance().isDirty()) {
            return this.askToSave(list);
        }
        return 1;
    }

    public int askToSave(List<ICnfgTask> list) {
        Object[] arrayOfObjects = this.getSaveWarningMessage();
        int option = DialogMessage.showDialog(arrayOfObjects, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNOCANCEL, 0);
        int result = 1;
        if (option == 0) {
            DataManager dm = DataManager.getInstance();
            dm.useDefaultEncoding(true);
            dm.getSaveTasks(list);
            result = 0;
        } else if (option == 2) {
            result = 2;
        }
        return result;
    }

    public int askToSaveOK(Object message) {
        return DialogMessage.showDialog(message, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 0);
    }

    private void runAllServicesAction(String sAction) {
        this.stopCellEditing();
        this.startTaskCollecting();
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        Map<String, ICnfgTest> initializedClasses = null;
        int res = 1;
        if (!sAction.equals("stop")) {
            res = this.checkSave(tasklist);
            if (res == 2) {
                return;
            }
            if (res == 1) {
                DataManager.getInstance().createValidationTask(tasklist);
            }
            boolean bStartAction = sAction.equalsIgnoreCase("start") || sAction.equalsIgnoreCase("restart");
            CnfgTestInitializationFeedback initFeedback = new CnfgTestInitializationFeedback();
            initializedClasses = TestTaskManager.getTestTasks(this, DataManager.getInstance().getRootFolder(), tasklist, true, res != 0, bStartAction, initFeedback);
            if (initializedClasses != null) {
                for (Folder f : DataManager.getInstance().getGlobalConfigFolders()) {
                    Map<String, ICnfgTest> globalClasses = TestTaskManager.getTestTasks(this, f, tasklist, true, false, bStartAction, initFeedback);
                    if (globalClasses == null) continue;
                    initializedClasses.putAll(globalClasses);
                }
                tasklist.add(new TestTaskManager.TestActionPauseTask(this.getTaskDialog()));
            }
        }
        DataManager dm = DataManager.getInstance();
        if (sAction.equals("stop")) {
            CnfgServiceUtils.getCBSServiceActionTasks(dm, sAction, res, tasklist);
            dm.getAllServiceFoldersActions(sAction, tasklist, res == 0);
        } else if (sAction.equals("start")) {
            dm.getAllServiceFoldersActions(sAction, tasklist, res == 0);
            CnfgServiceUtils.getCBSServiceActionTasks(dm, sAction, res, tasklist);
        } else if (sAction.equals("restart")) {
            boolean bIncludeCMUpgradeTask = res != 0;
            CnfgServiceUtils.getRestartActionTasks(tasklist, bIncludeCMUpgradeTask);
        }
        if (tasklist.size() == 0) {
            return;
        }
        ICnfgTask[] svtasks = CnfgTask.createTaskArray(tasklist);
        this.endTaskCollecting();
        ServiceManager.pauseCheckServiceStatus();
        this.runServiceAction(sAction, svtasks);
        if (initializedClasses != null) {
            TestTaskManager.terminateTestProviders(initializedClasses, new CnfgTestInitializationFeedback());
        }
        ServiceManager.resumeCheckServiceStatus();
        ServiceManager.checkAllServicesStatus();
    }

    private void runRemoveServiceFolderAction(ServiceFolder curServiceFolder, DefaultMutableTreeNode treeNode) {
        Object[] args = new Object[]{curServiceFolder.getName()};
        Object[] oMessage = null;
        oMessage = new Object[]{CnfgResource.getMessage("Message.delete.unregister.confirmation", args)};
        if (DialogMessage.showDialog(oMessage, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1) == 0) {
            this.startTaskCollecting();
            ICnfgTask[] actionTasks = this.prepareRemoveServiceActionTasks(curServiceFolder, treeNode);
            this.endTaskCollecting();
            ServiceManager.pauseCheckServiceStatus();
            boolean bSucceed = this.runServiceAction("Remove", actionTasks);
            ServiceManager.resumeCheckServiceStatus();
        }
    }

    private ICnfgTask[] prepareRemoveServiceActionTasks(ServiceFolder curServiceFolder, DefaultMutableTreeNode treeNode) {
        CnfgActionOld unregAction;
        CnfgActionOld svAction;
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        ICnfgTask[] saveTasks = null;
        ICnfgTask[] unregActionTasks = null;
        ICnfgTask[] stopActionTasks = null;
        if (curServiceFolder.isRunning() && (svAction = curServiceFolder.findAction("stop")) != null) {
            stopActionTasks = curServiceFolder.createStopTasks(svAction);
        }
        if ((unregAction = curServiceFolder.findAction("unregister")) != null) {
            unregActionTasks = curServiceFolder.createUnregisterTasks(unregAction);
        }
        ICnfgTask[] stopUnregTasks = DataManager.getInstance().mergeTaskList(stopActionTasks, unregActionTasks);
        tasklist.add(new TestTaskManager.TestActionPauseTask(this.getTaskDialog(), "Message.checkActionResults.label", "Message.checkActionResults.label", "Message.checkActionResults.prompt"));
        final ServiceFolder deletedFolder = curServiceFolder;
        final DefaultMutableTreeNode sn = treeNode;
        tasklist.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.actiondeleteservice.actionlabel");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.actiondeleteservice.actiondesc");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                deletedFolder.getParent().remove(deletedFolder);
                CnfgNodeDeletedEvent e = new CnfgNodeDeletedEvent(deletedFolder, sn);
                DataManager.getInstance().fireNodeDeleted(e);
                return true;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        });
        DataManager dm = DataManager.getInstance();
        dm.useDefaultEncoding(true);
        dm.getSaveTasks(tasklist);
        if (tasklist.size() > 0) {
            saveTasks = CnfgTask.createTaskArray(tasklist);
        }
        return DataManager.getInstance().mergeTaskList(stopUnregTasks, saveTasks);
    }

    private void runServiceFolderAction(ServiceFolder innerServiceFolder, String sAction) {
        CnfgActionOld action = innerServiceFolder.findAction(sAction);
        boolean bSave = false;
        if (action != null || sAction.equals("restart")) {
            boolean bSucceed;
            block15: {
                this.startTaskCollecting();
                ICnfgTask[] savetasks = null;
                Map<String, ICnfgTest> initializedClasses = null;
                if (!sAction.equals("stop")) {
                    boolean bStartAction;
                    ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
                    int res = this.checkSave(tasklist);
                    if (res == 2) {
                        return;
                    }
                    if (res == 0) {
                        bSave = true;
                    }
                    if ((initializedClasses = TestTaskManager.getTestTasks(this, innerServiceFolder, tasklist, true, res != 0, bStartAction = sAction.equalsIgnoreCase("start") || sAction.equalsIgnoreCase("restart"), new CnfgTestInitializationFeedback())) != null) {
                        tasklist.add(new TestTaskManager.TestActionPauseTask(this.getTaskDialog()));
                    }
                    if (tasklist.size() > 0) {
                        savetasks = CnfgTask.createTaskArray(tasklist);
                    }
                }
                ICnfgTask[] actionTasks = null;
                if (sAction.equals("start")) {
                    actionTasks = DataManager.getInstance().mergeTaskList(savetasks, innerServiceFolder.createStartTasks(action, bSave));
                } else if (sAction.equals("stop")) {
                    actionTasks = DataManager.getInstance().mergeTaskList(savetasks, innerServiceFolder.createStopTasks(action));
                } else if (sAction.equals("restart")) {
                    actionTasks = DataManager.getInstance().mergeTaskList(savetasks, innerServiceFolder.createRestartTasks(bSave));
                }
                this.endTaskCollecting();
                ServiceManager.pauseCheckServiceStatus();
                bSucceed = this.runServiceAction(sAction, actionTasks);
                if (initializedClasses != null) {
                    TestTaskManager.terminateTestProviders(initializedClasses, new CnfgTestInitializationFeedback());
                }
                ServiceManager.resumeCheckServiceStatus();
                try {
                    innerServiceFolder.checkServiceStatus();
                }
                catch (Exception ex) {
                    if (!CnfgLog.isDebugEnabled()) break block15;
                    CnfgLog.debug("Exception occurred while checking status for service '" + innerServiceFolder.getLabel() + "'." + ex.getLocalizedMessage());
                }
            }
            if (bSucceed && (sAction.equals("start") || sAction.equals("restart"))) {
                ServiceManager.removeFromRestartServicesList(innerServiceFolder.getName());
            }
        }
    }

    public void action_Stop() {
        this.stopCellEditing();
        ICnfgTask[] listStopTasks = CnfgServiceUtils.getServiceTasks(2);
        this.runServiceAction("stop", listStopTasks);
    }

    private void action_Restart(Folder folder) {
        this.action_Start(folder, "restart");
    }

    private boolean runServiceAction(final String sActionName, final ICnfgTask[] tasks) {
        boolean ret = this.runAction(new CnfgAction(){

            @Override
            public ICnfgTask[] getTasks() {
                return tasks;
            }

            @Override
            public String getName() {
                return sActionName;
            }
        });
        return ret;
    }

    private void action_GlobalConfig() {
        this.stopCellEditing();
        try {
            GlobalConfigModel dataModel = new GlobalConfigModel();
            DialogEditGlobalConfig dlg = new DialogEditGlobalConfig((Frame)this, dataModel);
            dlg.setVisible(true);
        }
        catch (DataManagerException e) {
            CnfgLog.error(e);
            DialogMessage.showDialog(e.getMessage(), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
        }
    }

    private void action_Test() {
        this.stopCellEditing();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.cCnfgTree.getLastSelectedPathComponent();
        if (null != node) {
            this.runTestAction(node.getUserObject());
        }
    }

    private void action_VerifyConfig() {
        this.stopCellEditing();
        this.runVerifyConfigAction();
    }

    private void action_checkFlipper() {
        this.stopCellEditing();
        this.runCheckFlipperAction();
    }

    private void runCheckFlipperAction() {
        int res;
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        if (DataManager.getInstance().isDirty() && (res = this.askToSave(tasklist)) != 0) {
            return;
        }
        DataManager.getInstance().getVerifyConfig().createCheckFlipperTask(tasklist);
        ICnfgTask[] actionTasks = null;
        if (tasklist.size() > 0) {
            actionTasks = CnfgTask.createTaskArray(tasklist);
        }
        this.runServiceAction("checkflipper", actionTasks);
    }

    private void runVerifyConfigAction() {
        int res;
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        if (DataManager.getInstance().isDirty() && (res = this.askToSave(tasklist)) != 0) {
            return;
        }
        if (DataManager.getInstance().isBTSVInstalled() && !ServiceManager.isRunning()) {
            DataManager.getInstance().getVerifyConfig().createVerifyPortsTask(tasklist);
        }
        DataManager.getInstance().getVerifyConfig().createVerifyFolderPathTask(tasklist);
        if (DataManager.getInstance().isBTSVInstalled()) {
            DataManager.getInstance().getVerifyConfig().createVerifyCMURLsTask(tasklist);
            DataManager.getInstance().getVerifyConfig().createCheckFlipperTask(tasklist);
        }
        ICnfgTask[] actionTasks = null;
        if (tasklist.size() > 0) {
            actionTasks = CnfgTask.createTaskArray(tasklist);
        }
        this.runServiceAction("verify", actionTasks);
    }

    private void action_VerifyConformance() {
        this.stopCellEditing();
        CnfgWizard.getInstance().action_Wizard("verifyConfWizard");
    }

    public void runTestAction(Object obj) {
        this.startTaskCollecting();
        ArrayList<ICnfgTask> listTasks = new ArrayList<ICnfgTask>();
        Map<String, ICnfgTest> initializedClasses = TestTaskManager.getTestTasks(this, obj, listTasks, false, true, false, new CnfgTestInitializationFeedback());
        if (listTasks.size() > 0) {
            ICnfgTask[] tasks = new ICnfgTask[listTasks.size()];
            tasks = listTasks.toArray(tasks);
            this.endTaskCollecting();
            List<Folder> folders = null;
            if (Folder.class.isAssignableFrom(obj.getClass())) {
                folders = ((Folder)obj).getFolders();
            }
            String actionName = "";
            actionName = folders != null && folders.size() == 0 ? "localTest" : "test";
            this.runServiceAction(actionName, tasks);
        } else {
            this.endTaskCollecting();
        }
        if (initializedClasses != null) {
            TestTaskManager.terminateTestProviders(initializedClasses, new CnfgTestInitializationFeedback());
        }
    }

    public String resolveHelpFilePath(String contentsFileName) {
        String sNormalizedLocale = null;
        try {
            ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
            sNormalizedLocale = cfg.normalizeLocale(CnfgResource.getLocale().toString());
        }
        catch (CCLConfigurationException e) {
            CnfgLog.error(e);
        }
        String sFileName = null;
        sFileName = this.m_sHelpPath.charAt(this.m_sHelpPath.length() - 1) == File.separatorChar ? this.m_sHelpPath + sNormalizedLocale + File.separatorChar + contentsFileName : this.m_sHelpPath + File.separatorChar + sNormalizedLocale + File.separatorChar + contentsFileName;
        File f = new File(sFileName);
        if (!f.exists()) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Could not find the localized documentation (" + sFileName + ") falling back to the English.");
            }
            sFileName = this.m_sHelpPath.charAt(this.m_sHelpPath.length() - 1) == File.separatorChar ? this.m_sHelpPath + "en" + File.separatorChar + contentsFileName : this.m_sHelpPath + File.separatorChar + "en" + File.separatorChar + contentsFileName;
        }
        return sFileName;
    }

    public void action_Help(JComponent component) {
        this.stopCellEditing();
        String szURL = null;
        if (component == this.m_menuHelpContents) {
            if (this.m_sHelpPath != null) {
                String sFileName = this.resolveHelpFilePath(this.m_sContentsFileName);
                szURL = "file://" + sFileName;
            }
        } else if (component == this.m_menuHelpCognosOnTheWeb) {
            szURL = "http://www-01.ibm.com/software/analytics/cognos/";
        }
        if (szURL != null) {
            WebBrowser.displayURL(szURL);
        }
    }

    public String getHelpPath() {
        return this.m_sHelpPath;
    }

    public void stopCellEditing() {
        TableCellEditor ed = this.cCnfgTable.getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
    }

    protected CnfgTaskDialog getTaskDialog() {
        if (null == this.m_taskDialog) {
            this.m_taskDialog = new CnfgTaskDialog(this);
        }
        return this.m_taskDialog;
    }

    public boolean runAction(ICnfgAction action, boolean cancellable) {
        return this.runAction(action, cancellable, false);
    }

    public boolean runAction(ICnfgAction action, boolean cancellable, boolean autoCloseOnNoErrors) {
        CnfgTaskDialog taskDialog = this.getTaskDialog();
        taskDialog.setEngine(this.m_actionEngine);
        taskDialog.setAutoCloseOnNoError(autoCloseOnNoErrors);
        boolean isSuccess = this.m_actionEngine.run(action, taskDialog, cancellable);
        return isSuccess;
    }

    public boolean runAction(ICnfgAction action) {
        return this.runAction(action, true);
    }

    ICnfgTask[] getActionTasks(CnfgActionOld action, ArrayList list) {
        return action.getTasks(list, new CnfgTestInitializationFeedback());
    }

    private Boolean getToolbarState() {
        Boolean bToolbar = (Boolean)CnfgPreferences.getInstance().getProperty("ToolbarIsVisible", "true", Boolean.class);
        if (bToolbar != null) {
            return bToolbar;
        }
        return this.m_bIsToolbarVisible;
    }

    private Boolean getInstallPathState() {
        Boolean bInstallPath = (Boolean)CnfgPreferences.getInstance().getProperty("InstallPathIsVisible", "false", Boolean.class);
        if (bInstallPath != null) {
            return bInstallPath;
        }
        return this.m_bIsInstallPathVisible;
    }

    public boolean isActionRenameEnabled() {
        return this.m_actionEditRename.isEnabled();
    }

    private void initActions() {
        this.m_actionFileSave = new CnfgSwingAction("FileSave", CnfgImageLoader.loadIcon("action_save.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_Save();
            }
        };
        this.m_actionFileSaveUTF8 = new CnfgSwingAction("FileSaveUTF8"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_SaveUTF8();
            }
        };
        this.m_actionFileExport = new CnfgSwingAction("FileExport"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_Export();
            }
        };
        this.m_actionFileExit = new CnfgSwingAction("FileExit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_Exit();
            }
        };
        this.m_actionViewToolbar = new CnfgSwingAction("ViewToolbar"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_ViewToolbar();
            }
        };
        this.m_actionViewInstallPath = new CnfgSwingAction("ViewInstallPath"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_ViewInstallPath();
            }
        };
        this.m_actionViewFont = new CnfgSwingAction("ActionsViewFont"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CRConfigFrame.this.m_fontChooser.showDialog() && null != CRConfigFrame.this.m_fontChooser.getSelectedFont()) {
                    CnfgFontSetting.updateFonts(CRConfigFrame.this.m_fontChooser.getSelectedFont());
                }
            }
        };
        this.m_actionEditRename = new CnfgSwingAction("ActionsRename"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_Rename();
            }
        };
        this.m_actionEditSwitch = new CnfgSwingAction("ActionsSwitch"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Folder sourcefolder;
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)CRConfigFrame.this.cCnfgTree.getLastSelectedPathComponent();
                if (treeNode != null && (sourcefolder = (Folder)treeNode.getUserObject()).isInstanceFolder()) {
                    Folder parentFolder = sourcefolder.getParent();
                    Folder newFolder = null;
                    TemplatedParameter tp = sourcefolder.getTemplatedParameter();
                    Option switchopt = null;
                    if (tp != null) {
                        List<Option> al = tp.getAvailableOptions(true);
                        Iterator<Option> it = al.iterator();
                        if (it.hasNext()) {
                            switchopt = it.next();
                        }
                        if (switchopt != null) {
                            newFolder = parentFolder.addInstanceFolder(tp, switchopt.getName(), sourcefolder.getName(), sourcefolder.getLabel());
                            parentFolder.remove(sourcefolder);
                            CnfgNodeSwitchEvent se = new CnfgNodeSwitchEvent(sourcefolder, treeNode, newFolder);
                            DataManager.getInstance().fireNodeSwitch(se);
                            return;
                        }
                    }
                }
                CnfgLog.error("ActionsSwitch - Unable to switch instance folder.");
            }
        };
        this.m_actionEditDelete = new CnfgSwingAction("ActionsDelete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Folder f;
                DefaultMutableTreeNode sn = (DefaultMutableTreeNode)CRConfigFrame.this.cCnfgTree.getLastSelectedPathComponent();
                if (sn != null && (f = (Folder)sn.getUserObject()).isInstanceFolder()) {
                    ServiceFolder sf;
                    boolean bUnreg = false;
                    if (f instanceof ServiceFolder && CnfgUtils.isWindowsPlatform() && (sf = (ServiceFolder)f).getUnregisterOnDelete()) {
                        bUnreg = true;
                        CRConfigFrame.this.runRemoveServiceFolderAction(sf, sn);
                    }
                    if (!bUnreg) {
                        CRConfigFrame.this.displayDeleteDialog(f, sn);
                    }
                }
            }
        };
        this.m_actionActionsStart = new CnfgSwingAction("ActionsStart", CnfgImageLoader.loadIcon("action_start.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode sn = (DefaultMutableTreeNode)CRConfigFrame.this.cCnfgTree.getLastSelectedPathComponent();
                if (sn != null) {
                    Folder f = (Folder)sn.getUserObject();
                    if (f instanceof ServiceFolder) {
                        if (f == DataManager.getInstance().getCBS()) {
                            CRConfigFrame.this.action_Start(f);
                        } else {
                            CRConfigFrame.this.runServiceFolderAction((ServiceFolder)f, "start");
                        }
                    } else {
                        CRConfigFrame.this.runAllServicesAction("start");
                    }
                }
            }
        };
        this.m_actionActionsStop = new CnfgSwingAction("ActionsStop", CnfgImageLoader.loadIcon("action_stop.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode sn = (DefaultMutableTreeNode)CRConfigFrame.this.cCnfgTree.getLastSelectedPathComponent();
                if (sn != null) {
                    Folder f = (Folder)sn.getUserObject();
                    if (f instanceof ServiceFolder) {
                        if (f == DataManager.getInstance().getCBS()) {
                            CRConfigFrame.this.action_Stop();
                        } else {
                            CRConfigFrame.this.runServiceFolderAction((ServiceFolder)f, "stop");
                        }
                    } else {
                        CRConfigFrame.this.runAllServicesAction("stop");
                    }
                }
            }
        };
        this.m_actionActionsRestart = new CnfgSwingAction("ActionsRestart", CnfgImageLoader.loadIcon("action_restart.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode sn = (DefaultMutableTreeNode)CRConfigFrame.this.cCnfgTree.getLastSelectedPathComponent();
                if (sn != null) {
                    Folder f = (Folder)sn.getUserObject();
                    if (f instanceof ServiceFolder) {
                        if (f == DataManager.getInstance().getCBS()) {
                            CRConfigFrame.this.action_Restart(f);
                        } else {
                            CRConfigFrame.this.runServiceFolderAction((ServiceFolder)f, "restart");
                        }
                    } else {
                        CRConfigFrame.this.runAllServicesAction("restart");
                    }
                }
            }
        };
        this.m_actionActionsGlobalConfig = new CnfgSwingAction("ActionsGlobalConfig"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_GlobalConfig();
            }
        };
        this.m_actionActionsTest = new CnfgSwingAction("ActionsTest", CnfgImageLoader.loadIcon("icon_test_connection.gif")){

            @Override
            public void actionPerformed(ActionEvent event) {
                CRConfigFrame.this.action_Test();
            }
        };
        this.m_actionActionsVerifyConfig = new CnfgSwingAction("ActionsVerifyConfig"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_VerifyConfig();
            }
        };
        this.m_actionActionsCheckFlipper = new CnfgSwingAction("ActionsCheckFlipper"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_checkFlipper();
            }
        };
        this.m_actionActionsVerifyConformance = new CnfgSwingAction("ActionsVerifyConformance", CnfgImageLoader.loadIcon("icon_test_connection.gif")){

            @Override
            public void actionPerformed(ActionEvent event) {
                CRConfigFrame.this.action_VerifyConformance();
            }
        };
        this.m_actionActionsGenWar = new CnfgSwingAction("ActionsGenWar"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_GenWar();
            }
        };
        this.m_actionEditResetToDefault = new CnfgSwingAction("ActionsResetToDefault", CnfgImageLoader.loadIcon("action_reset_default.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.userObject1 != null) {
                    if (Folder.class.isInstance(this.userObject1)) {
                        Folder f = (Folder)this.userObject1;
                        f.setToDefault();
                    } else if (Parameter.class.isInstance(this.userObject1)) {
                        Parameter p = (Parameter)this.userObject1;
                        p.setToDefault();
                    }
                }
            }
        };
        this.m_actionRetrieve = new CnfgSwingAction("Retrieve"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_retrieve(this.userObject1);
            }
        };
        this.m_actionHelpCognosOnTheWeb = new CnfgSwingAction("HelpCognosOnTheWeb"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_Help(CRConfigFrame.this.m_menuHelpCognosOnTheWeb);
            }
        };
        this.m_actionHelpAbout = new CnfgSwingAction("HelpAbout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CRConfigFrame.this.action_About();
            }
        };
    }

    private void displayCreateNewDialog(TemplatedParameter tp, DefaultMutableTreeNode treeNode) {
        Object[] args = new Object[]{tp.getLabel()};
        DialogCreateNew dlg = new DialogCreateNew(this, "", tp, treeNode, CnfgResource.getMessage("Title.DialogCreateNew", args));
        dlg.show();
    }

    private void displayDeleteDialog(Folder deletedFolder, DefaultMutableTreeNode treeNode) {
        Folder fp = deletedFolder.getParent();
        Object[] args = new Object[]{deletedFolder.getName()};
        Object[] oMessage = null;
        oMessage = fp.getName().compareTo("AAA") == 0 ? new Object[]{new StringBuffer(CnfgResource.getMessage("Message.delete.aaa.confirmation", args)).append("\n").toString(), CnfgResource.getMessage("Message.delete.confirmation", args)} : (fp.getName().compareTo("CRYPTO") == 0 ? new Object[]{new StringBuffer(CnfgResource.getMessage("Message.delete.crypto.confirmation", args)).append("\n").toString(), CnfgResource.getMessage("Message.delete.confirmation", args)} : new Object[]{CnfgResource.getMessage("Message.delete.confirmation", args)});
        if (DialogMessage.showDialog(oMessage, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1) == 0) {
            deletedFolder.getParent().remove(deletedFolder);
            CnfgNodeDeletedEvent e = new CnfgNodeDeletedEvent(deletedFolder, treeNode);
            DataManager.getInstance().fireNodeDeleted(e);
        }
    }

    private void displayRenameDialog(Folder renamedFolder, DefaultMutableTreeNode treeNode) {
        String sLabel = renamedFolder.getLabel();
        DialogRename dlg = new DialogRename(this, sLabel, renamedFolder, treeNode, 300);
        dlg.show();
    }

    public boolean saveConfiguration() {
        Object[] arrayOfObjects;
        int option;
        return !DataManager.getInstance().isDirty() || !((option = DialogMessage.showDialog(arrayOfObjects = this.getSaveWarningMessage(), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNOCANCEL, 0)) == 0 ? !this.action_Save() : option == 2);
    }

    public Object[] getSaveWarningMessage() {
        if (DataManager.getInstance().isAAADirty() && ServiceManager.isRunning() && DataManager.getInstance().isCMEnabled()) {
            CnfgLog.debug("getSaveWarningMessage - isAAADirty");
            Object[] arrayOfObjects = new Object[]{CnfgResource.getMessage("Message.exit.dirty.notification"), CnfgResource.getMessage("Message.saveaaa.notification"), CnfgResource.getMessage("Message.saveaaa.confirmation")};
            return arrayOfObjects;
        }
        CnfgLog.debug("getSaveWarningMessage - NOT isAAADirty");
        Object[] arrayOfObjects = new Object[]{CnfgResource.getMessage("Message.exit.dirty.notification"), CnfgResource.getMessage("Message.exit.dirty.resolution")};
        return arrayOfObjects;
    }

    public void closePopups() {
        this.treePopupMenu.setVisible(false);
        this.tablePopupMenu.setVisible(false);
        this.getRootPane().update(this.getRootPane().getGraphics());
    }

    public JPopupMenu getTablePopupMenu() {
        return this.tablePopupMenu;
    }

    public JPopupMenu getTreePopupMenu() {
        return this.treePopupMenu;
    }

    public DialogFontChooser getFontChooser() {
        return this.m_fontChooser;
    }

    public void setFontChooser(DialogFontChooser diagFont) {
        this.m_fontChooser = diagFont;
    }

    public CnfgTable getCnfgTable() {
        return this.cCnfgTable;
    }

    public CnfgTableModel getCnfgTableModel() {
        return this.cCnfgTableModel;
    }

    public JMenuBar getCnfgMenuBar() {
        return this.m_menuBar;
    }

    public JLabel getExploreLabel() {
        return this.cExplorerLabel;
    }

    public JLabel getNavPathLabel() {
        return this.cNavPathLabel;
    }

    public JPanel getNavPathPanel() {
        return this.cNavPathPanel;
    }

    public InformationPanel getInfoPanel() {
        return this.m_infoPanel;
    }

    public JMenu getMenuEditNewPopup() {
        return this.m_menuEditNew_popup;
    }

    public JMenuItem getTableResetToDefault() {
        return this.m_tableResetToDefault;
    }

    public CnfgTree getCnfgTree() {
        return this.cCnfgTree;
    }

    public JLabel getStatusLabel() {
        return this.m_xcStatusLabel;
    }

    public JPanel getStatusPanel() {
        return this.m_xcStatusPanel;
    }

    @Override
    public void startTaskCollecting() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void endTaskCollecting() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void error(TaskCollectorException e) {
        Throwable t = e.getCause();
        String msg = null;
        msg = t == null ? e.getMessage() : t.getMessage();
        DialogMessage.showDialog(msg, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_OK, 0);
    }

    class ColorOnFocusListener
    implements FocusListener {
        Color[] m_backColor = new Color[]{new Color(204, 204, 255), new Color(102, 102, 153)};
        Color[] m_foreColor = new Color[]{new Color(130, 130, 130), new Color(255, 255, 255)};

        ColorOnFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object obj = e.getSource();
            if (obj != null) {
                int navigation;
                int explorer;
                if (CnfgTree.class.isInstance(obj)) {
                    explorer = 1;
                    navigation = 0;
                } else if (CnfgTable.class.isInstance(obj)) {
                    explorer = 0;
                    navigation = 1;
                } else {
                    explorer = 0;
                    navigation = 0;
                }
                if (CnfgUtils.isHighContrastWin()) {
                    Color[] highContrastBackColor = new Color[]{SystemColor.text, SystemColor.textHighlight};
                    Color[] highContrastForeColor = new Color[]{SystemColor.textText, SystemColor.textHighlightText};
                    CRConfigFrame.this.cExplorerLabel.setForeground(highContrastForeColor[explorer]);
                    CRConfigFrame.this.cExplorerPanel.setBackground(highContrastBackColor[explorer]);
                    CRConfigFrame.this.cNavPathLabel.setForeground(highContrastForeColor[navigation]);
                    CRConfigFrame.this.cNavPathPanel.setBackground(highContrastBackColor[navigation]);
                } else {
                    CRConfigFrame.this.cExplorerLabel.setForeground(this.m_foreColor[explorer]);
                    CRConfigFrame.this.cExplorerPanel.setBackground(this.m_backColor[explorer]);
                    CRConfigFrame.this.cNavPathLabel.setForeground(this.m_foreColor[navigation]);
                    CRConfigFrame.this.cNavPathPanel.setBackground(this.m_backColor[navigation]);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class DevInfoListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ee) {
            DialogProperties dlg = new DialogProperties(CRConfigFrame.getInstance());
            dlg.show();
        }
    }

    private class BusyIndicationThread
    extends Thread {
        int m_return = 0;
        ArrayList<String> m_lErrors = new ArrayList();
        int m_status = 0;
        DialogMessage m_dlg = null;

        public BusyIndicationThread(int status, DialogMessage dlg) {
            this.m_status = status;
            this.m_dlg = dlg;
        }

        @Override
        public void run() {
            try {
                BusyIndicationThread.yield();
                this.m_return = DataManager.getInstance().heavyCurrentJavaValidation(this.m_status, this.m_lErrors);
                Runnable disposeDialog = new Runnable(){

                    @Override
                    public void run() {
                        BusyIndicationThread.this.m_dlg.setVisible(false);
                        BusyIndicationThread.this.m_dlg.Terminate();
                    }
                };
                SwingUtilities.invokeLater(disposeDialog);
            }
            catch (Exception e) {
                this.m_dlg.Terminate();
                CnfgLog.error(e);
            }
        }

        public int getReturnedStatus() {
            return this.m_return;
        }

        public ArrayList<String> getReturnedErrors() {
            return this.m_lErrors;
        }
    }
}

