/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.Parameter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;

public class CnfgButton
extends JButton {
    private static final long serialVersionUID = 7450459372659537873L;
    public static final int DEFAULT_BUTTON_WIDTH = 80;
    public static final int UNIX_DEFAULT_BUTTON_HEIGHT = 30;
    public static final int WIN_DEFAULT_BUTTON_HEIGHT = 24;
    private static boolean m_fixedWidth = false;
    private static boolean m_fixedHeight = false;
    private Dimension m_dim;
    public static final Icon m_imageEdit = CnfgImageLoader.loadIcon("action_edit_10.gif");

    public CnfgButton() {
        this.m_dim = CnfgUtils.isWindowsPlatform() ? new Dimension(80, 24) : new Dimension(80, 30);
    }

    public CnfgButton(String szText) {
        super(szText);
        this.Initialize('*');
    }

    public CnfgButton(Icon icon, Parameter parm) {
        super(icon);
        String szToolTipText = "";
        if (parm != null) {
            szToolTipText = parm.getLabel();
        }
        this.Initialize(szToolTipText);
    }

    public CnfgButton(Icon icon, String szToolTipText) {
        super(icon);
        this.Initialize(szToolTipText);
    }

    public CnfgButton(String szText, Icon icon) {
        super(szText, icon);
        this.Initialize(szText);
    }

    public CnfgButton(String szText, char mnemonic) {
        super(szText);
        this.Initialize(mnemonic);
    }

    public CnfgButton(String szText, char mnemonic, int mnemonicIndex) {
        super(szText);
        this.Initialize(mnemonic, mnemonicIndex);
    }

    public CnfgButton(String szText, int fixedWidth, int fixedHeight) {
        super(szText);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.m_dim = new Dimension(fixedWidth, fixedHeight);
        m_fixedHeight = true;
        m_fixedWidth = true;
    }

    public static CnfgButton createEditButton(Parameter parm) {
        CnfgButton button = new CnfgButton(m_imageEdit, parm);
        return button;
    }

    private void Initialize(String szToolTipText) {
        this.m_dim = CnfgUtils.isWindowsPlatform() ? new Dimension(80, 24) : new Dimension(80, 30);
        this.setToolTipText(szToolTipText);
    }

    public void Initialize(char mnemonic) {
        this.Initialize(mnemonic, -1, 80);
    }

    public void Initialize(char mnemonic, int mnemonicIndex) {
        this.Initialize(mnemonic, mnemonicIndex, 80);
    }

    public void Initialize(char mnemonic, int mnemonicIndex, int iWidth) {
        this.setMargin(new Insets(1, 1, 1, 1));
        this.m_dim = CnfgUtils.isWindowsPlatform() ? new Dimension(iWidth, 24) : new Dimension(iWidth, 30);
        this.setPreferredSize(this.m_dim);
        if (mnemonic != '*') {
            this.setMnemonic(mnemonic);
            this.setDisplayedMnemonicIndex(mnemonicIndex);
        }
        this.setButtonSize();
    }

    public void setDefaultStyle() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createRaisedBevelBorder()));
    }

    public void setDim(Dimension dim) {
        this.m_dim = dim;
    }

    public void setButtonSize() {
        int height = CnfgFontSetting.getMaxHeight(this.getFont());
        int defaultHeight = CnfgUtils.isWindowsPlatform() ? 24 : 30;
        if (this.m_dim != null) {
            if (!m_fixedHeight) {
                this.m_dim.height = defaultHeight < height ? height : defaultHeight;
            }
            int stringWidth = this.getStringWidth();
            if (!m_fixedWidth) {
                this.m_dim.width = 80 < stringWidth ? stringWidth : 80;
            }
            if (!m_fixedWidth || !m_fixedHeight) {
                this.setPreferredSize(this.m_dim);
            }
        }
    }

    public int getStringWidth() {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        Rectangle2D rect2D = this.getFont().getStringBounds(this.getText(), frc);
        int stringWidth = (int)rect2D.getWidth() + 10;
        return stringWidth;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.setButtonSize();
    }

    public int getDimWidth() {
        return this.m_dim.width;
    }

    public void setDimWidth(int dimWidth) {
        this.m_dim.width = dimWidth;
    }

    public int getDimHeight() {
        return this.m_dim.height;
    }

    public void setDimHeight(int dimHeight) {
        this.m_dim.height = dimHeight;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_dim;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.m_dim;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.m_dim;
    }
}

