/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class CnfgCheckLogsFromTomcat
extends Thread {
    private boolean m_bKeepRunning = true;
    private ICnfgFeedback m_fb;
    private BufferedReader m_bf = null;
    private Date m_date;

    public CnfgCheckLogsFromTomcat(ICnfgFeedback fb, String sActionName) {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CnfgCheckLogsFromTomcat()");
        }
        this.m_fb = fb;
        this.m_date = new Date();
    }

    @Override
    public void interrupt() {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CheckLogsThread.interrupt()");
        }
        this.m_bKeepRunning = false;
        super.interrupt();
    }

    @Override
    public void run() {
        block19: {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgCheckLogsFromTomcat.run()");
            }
            ICCLConfiguration cf = CCLConfigurationFactory.createConfiguration();
            String filePath = cf.resolveEffectivePath("../logs/tomcat.log");
            Object[] arg = new Object[]{filePath};
            String message = CnfgResource.getMessage("Message.application.Tomcat.error", arg);
            String[] shortMonths = new DateFormatSymbols().getShortMonths();
            Object ois = null;
            while (this.m_bKeepRunning) {
                CnfgCheckLogsFromTomcat.yield();
                if (this.isInterrupted()) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("CnfgCheckLogsFromTomcat.isInterrupted()");
                    }
                    return;
                }
                try {
                    if (this.m_bf == null) {
                        this.m_bf = new BufferedReader(new FileReader(filePath));
                    }
                    if (this.m_bf != null) {
                        String str = this.m_bf.readLine();
                        if (str != null && str.startsWith("ERROR")) {
                            Date logDate;
                            block18: {
                                int ind = str.indexOf(":");
                                if (ind <= 0) continue;
                                String sub = str.substring(ind + 1);
                                logDate = null;
                                try {
                                    Calendar cal = Calendar.getInstance();
                                    cal.clear();
                                    String jour = "";
                                    String mois = "";
                                    String year = "";
                                    String heur = "";
                                    String min = "";
                                    String sec = "";
                                    String milli = "";
                                    StringTokenizer st = new StringTokenizer(sub);
                                    if (st.countTokens() == 4) {
                                        jour = st.nextToken();
                                        int d = Integer.valueOf(jour);
                                        cal.set(5, d);
                                        mois = st.nextToken();
                                        for (int i = 0; i < shortMonths.length; ++i) {
                                            if (!shortMonths[i].equals(mois)) continue;
                                            cal.set(2, i);
                                            break;
                                        }
                                        year = st.nextToken();
                                        int y = Integer.valueOf(year);
                                        cal.set(1, y);
                                        StringTokenizer st2 = new StringTokenizer(st.nextToken(), ":");
                                        heur = st2.nextToken();
                                        int h = Integer.valueOf(heur);
                                        min = st2.nextToken();
                                        int m = Integer.valueOf(min);
                                        String ss = st2.nextToken();
                                        StringTokenizer st3 = new StringTokenizer(ss, ",");
                                        sec = st3.nextToken();
                                        int s = Integer.valueOf(sec);
                                        milli = st3.nextToken();
                                        int mm = Integer.valueOf(milli);
                                        cal.set(10, h);
                                        cal.set(12, m);
                                        cal.set(13, s);
                                        cal.set(14, mm);
                                        logDate = cal.getTime();
                                    }
                                }
                                catch (Exception e) {
                                    if (!CnfgLog.isDebugEnabled()) break block18;
                                    CnfgLog.error("CnfgCheckLogsFromTomcat. ParseException: Could not parse the date from Tomcat.log: " + e.getMessage());
                                }
                            }
                            if (logDate == null || !this.m_date.before(logDate)) continue;
                            this.m_fb.showError(message);
                            this.m_bKeepRunning = false;
                            continue;
                        }
                        if (str != null) continue;
                        CnfgCheckLogsFromTomcat.sleep(200L);
                        continue;
                    }
                    CnfgCheckLogsFromTomcat.sleep(100L);
                }
                catch (Exception e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("CnfgCheckLogsFromTomcat.Exception, e is " + e.getMessage());
                    }
                    this.m_bKeepRunning = false;
                }
                catch (Error e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("CnfgCheckLogsFromTomcat.Error, e is " + e.getMessage());
                    }
                    this.m_bKeepRunning = false;
                }
            }
            try {
                this.m_bf.close();
            }
            catch (Exception a) {
                if (!CnfgLog.isDebugEnabled()) break block19;
                CnfgLog.debug("CnfgCheckLogsFromTomcat Exception: " + a.getMessage());
            }
        }
    }
}

