/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CnfgCheckLogsThread
extends Thread {
    private boolean m_bKeepRunning = true;
    protected final int TIMEOUT = 2000;
    private ICnfgFeedback m_fb;
    private DatagramSocket m_ds;

    public CnfgCheckLogsThread(ICnfgFeedback fb, String sActionName, DatagramSocket ds) {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CheckLogsThread.ctor()");
        }
        this.m_fb = fb;
        this.m_ds = ds;
    }

    @Override
    public void interrupt() {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CheckLogsThread.interrupt()");
        }
        this.m_bKeepRunning = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CheckLogsThread.run()");
        }
        if (this.m_ds == null) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CheckLogsThread.run() - Feedback UDP Socket is null.");
            }
            return;
        }
        buffer = new byte[65536];
        dp = null;
        try {
            this.m_ds.setSoTimeout(2000);
            this.m_ds.setReceiveBufferSize(65536);
            this.m_ds.setSendBufferSize(65536);
        }
        catch (SocketException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CheckLogsThread.SocketException, e " + e.getMessage());
            }
            this.m_bKeepRunning = false;
        }
        ois = null;
        while (this.m_bKeepRunning) {
            CnfgCheckLogsThread.yield();
            if (this.isInterrupted()) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CheckLogsThread.isInterrupted()");
                }
                return;
            }
            try {
                dp = new DatagramPacket(buffer, buffer.length);
                this.m_ds.receive(dp);
                indication = new byte[dp.getLength()];
                System.arraycopy(buffer, 0, indication, 0, dp.getLength());
                bis = new ByteArrayInputStream(indication, 0, indication.length);
                ois = new ObjectInputStream(bis);
                sLoggerName = ois.readUTF();
                ind = (LogAuditIndication)ois.readObject();
                if (ind instanceof LogAuditAccessIndication && !ind.getOperation().equalsIgnoreCase("ThresholdViolation")) {
                    doNotOutput = false;
                    sb = new StringBuffer();
                    newInd = (LogAuditAccessIndication)ind;
                    iRawOutput = (Integer)CnfgPreferences.getInstance().getProperty("LeaveFeedbackUnformatted", Integer.class);
                    if (iRawOutput != null) {
                        sb.append("\nLOGGER\t" + sLoggerName);
                        sb.append("\nCMP ID\t" + ind.getComponentID());
                        sb.append("\nTIME\t" + ind.getTime());
                        sb.append("\nTZOFF\t" + ind.getTimeZoneOffset());
                        sb.append("\n").append("OBJTYPE\t" + newInd.getObjectType());
                        sb.append("\n").append("OPERATION\t" + ind.getOperation());
                        sb.append("\n").append("STATUS\t" + newInd.getStatus());
                        sb.append("\nOBJPATH\t" + newInd.getObjectPath());
                        sb.append("\nERROR\t").append(newInd.getErrorMessage());
                        sb.append("\nLOGDATA\t").append(ind.getLogData());
                        this.m_fb.showInformational(sb.toString());
                    } else {
                        timeStamp = new SimpleDateFormat("kk:mm:ss").format(new Date(ind.getTime()));
                        sb.append(timeStamp).append(", ");
                        sStatus = newInd.getStatus();
                        sOp = ind.getOperation();
                        sObjType = newInd.getObjectType().trim();
                        if (sStatus.equalsIgnoreCase("info") || sStatus.equalsIgnoreCase("warning")) {
                            if (!ind.getLogData().trim().isEmpty()) {
                                sb.append(ind.getLogData());
                            } else {
                                doNotOutput = true;
                            }
                        } else if (sStatus.equalsIgnoreCase("success")) {
                            if (sObjType.isEmpty()) {
                                doNotOutput = true;
                            } else {
                                sb.append("'").append(sObjType).append("', '").append(sOp).append("', '").append(sStatus).append("'.");
                            }
                        } else if (sStatus.equalsIgnoreCase("failure")) {
                            sb.append("'").append(newInd.getObjectType()).append("', '").append(sOp).append("', '").append(sStatus).append("'.");
                            messageString = newInd.getErrorMessage().trim();
                            if (messageString.startsWith("<messages")) {
                                try {
                                    stringInput = new StringReader(messageString);
                                    reader = new SAXReader();
                                    doc = reader.read((Reader)stringInput);
                                    elem = doc.getRootElement();
                                    eList = elem.elements();
                                    for (i = 0; i < eList.size(); ++i) {
                                        eMessage = (Element)eList.get(i);
                                        eStringMessage = eMessage.element("messageString");
                                        sb.append("\n").append(eStringMessage.getTextTrim());
                                    }
                                }
                                catch (Exception e) {
                                    if (!CnfgLog.isDebugEnabled()) ** GOTO lbl112
                                    CnfgLog.debug(e);
                                }
                            } else {
                                sb.append("\n").append(messageString);
                            }
                        } else if (newInd.getObjectType().isEmpty()) {
                            doNotOutput = true;
                        } else {
                            sb.append("'").append(sObjType).append("', '").append(sOp).append("', '").append(sStatus).append("'.");
                        }
lbl112:
                        // 10 sources

                        if (!doNotOutput) {
                            this.m_fb.showInformational(sb.toString());
                        }
                    }
                }
                ois.close();
            }
            catch (ClassCastException e) {
                if (!CnfgLog.isDebugEnabled()) continue;
                CnfgLog.debug("CheckLogsThread.ClassCastException, e is " + e.getMessage());
                CnfgLog.debug("The sender's port is " + dp.getPort());
            }
            catch (InterruptedIOException e) {
                if (!CnfgLog.isDebugEnabled()) continue;
                CnfgLog.debug("CnfgCheckLogsThread.InterruptedIOException, e is " + e.getMessage());
            }
            catch (Exception e) {
                if (!CnfgLog.isDebugEnabled()) continue;
                CnfgLog.debug("CheckLogsThread.Exception, exception is " + e.getMessage());
                e.printStackTrace();
            }
            catch (Error e) {
                if (!CnfgLog.isDebugEnabled()) continue;
                CnfgLog.debug("CheckLogsThread.Error, error is " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                try {
                    if (ois == null) continue;
                    ois.close();
                }
                catch (IOException e) {
                    if (!CnfgLog.isDebugEnabled()) continue;
                    CnfgLog.debug("CheckLogsThread - IOException when ois.close()");
                    e.printStackTrace();
                }
            }
        }
        if (this.m_ds != null) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CheckLogsThread.m_ds.close() - freeing up the socket.");
            }
            this.m_ds.close();
        }
    }
}

