/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgActionClient;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionEngine;
import com.cognos.crconfig.data.Constants;
import com.cognos.crconfig.data.ICnfgAction;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CnfgConsoleClient
implements CnfgActionClient {
    private ICnfgTask m_currentTask;
    private OutputStreamWriter m_sw;
    private static final String sSep1 = ", \"";
    private static final String sSep2 = "\"\n";
    private CnfgConsoleFeedback m_feedback = new CnfgConsoleFeedback();
    private int m_numFailedTasks = 0;

    public CnfgConsoleClient(OutputStreamWriter sw) {
        this.m_sw = sw;
    }

    @Override
    public void begin() {
        this.m_numFailedTasks = 0;
    }

    @Override
    public void end() {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void updateTaskStatus(ICnfgTask task, int status) {
        if (null != task) {
            StringBuffer s = new StringBuffer();
            String sMsg = "";
            try {
                switch (status) {
                    case 1: {
                        s.append("EXEC");
                        sMsg = task.getDescription();
                        this.m_currentTask = task;
                        break;
                    }
                    case 2: {
                        s.append("SUCCESS");
                        sMsg = CnfgResource.getMessage("Message.silent.status.success");
                        if (this.m_currentTask != task) break;
                        this.m_currentTask = null;
                        break;
                    }
                    case 3: {
                        ++this.m_numFailedTasks;
                        s.append("FAILURE");
                        sMsg = CnfgResource.getMessage("Message.silent.status.failure");
                        if (this.m_currentTask != task) break;
                        this.m_currentTask = null;
                    }
                }
                s.append(", \"[").append(task.getLabel()).append("]\"").append(sSep1).append(sMsg).append(sSep2);
                this.m_sw.write(s.toString());
            }
            catch (IOException ioe) {
                CnfgLog.error("Exception encountered while writing status update message to response file. Status update message: " + s.toString());
            }
        }
    }

    @Override
    public void setEngine(CnfgActionEngine engine) {
    }

    @Override
    public boolean initialize(ICnfgAction action, ICnfgTask[] tasks) {
        return true;
    }

    @Override
    public ICnfgFeedback getFeedback() {
        return this.m_feedback;
    }

    @Override
    public void setCancellable(boolean cancellable) {
    }

    @Override
    public void lastTaskDisabled() {
    }

    @Override
    public int getNumberOfFailedTasks() {
        return this.m_numFailedTasks;
    }

    @Override
    public void setTasksLeft(int tasksLeftInList) {
    }

    @Override
    public void setEnginePaused(boolean value) {
    }

    private class CnfgConsoleFeedback
    extends Constants
    implements ICnfgFeedback {
        private CnfgConsoleFeedback() {
        }

        public void showError(String message) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ERROR, ");
            if (null != CnfgConsoleClient.this.m_currentTask) {
                buffer.append("\"[");
                buffer.append(CnfgConsoleClient.this.m_currentTask.getLabel());
                buffer.append("]\"");
            }
            buffer.append(CnfgConsoleClient.sSep1).append(message).append(CnfgConsoleClient.sSep2);
            try {
                CnfgConsoleClient.this.m_sw.write(buffer.toString());
            }
            catch (IOException e) {
                CnfgLog.error("Exception encountered while writing error message to response file. Error message: " + buffer.toString());
            }
        }

        public void showInformational(String message) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("INFO, ");
            if (null != CnfgConsoleClient.this.m_currentTask) {
                buffer.append("\"[");
                buffer.append(CnfgConsoleClient.this.m_currentTask.getLabel());
                buffer.append("]\"");
            }
            buffer.append(CnfgConsoleClient.sSep1).append(message).append(CnfgConsoleClient.sSep2);
            try {
                CnfgConsoleClient.this.m_sw.write(buffer.toString());
            }
            catch (IOException e) {
                CnfgLog.error("Exception encountered while writing informational message to response file. Informational message: " + buffer.toString());
            }
        }

        public void showWarning(String message) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("WARNING, ");
            if (null != CnfgConsoleClient.this.m_currentTask) {
                buffer.append("\"[");
                buffer.append(CnfgConsoleClient.this.m_currentTask.getLabel());
                buffer.append("]\"");
            }
            buffer.append(CnfgConsoleClient.sSep1).append(message).append(CnfgConsoleClient.sSep2);
            try {
                CnfgConsoleClient.this.m_sw.write(buffer.toString());
            }
            catch (IOException e) {
                CnfgLog.error("Exception encountered while writing warning message to response file. Warning message: " + buffer.toString());
            }
        }

        public void invalidateParameter(String arg0) {
        }

        public boolean promptForConfirmation(String arg0) {
            return false;
        }

        public String prompt(String promptSpec) {
            StringBuffer sb;
            block22: {
                sb = new StringBuffer("");
                String sPromptName = "";
                boolean bPromptNameExists = false;
                try {
                    Document doc = DocumentHelper.parseText((String)promptSpec);
                    Element root = doc.getRootElement();
                    sPromptName = root.attributeValue("name");
                    if (sPromptName == null || sPromptName == "") {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("No prompt name specified.");
                        }
                    } else {
                        bPromptNameExists = true;
                    }
                    if (bPromptNameExists && (sPromptName.equalsIgnoreCase("com.cognos.crconfig.DialogCMUpgrade") || sPromptName.equalsIgnoreCase("com.cognos.crconfig.DialogIPFUpgrade"))) {
                        Element parameters;
                        sb.append("<success><parameters>");
                        if (root != null && (parameters = root.element("parameters")) != null) {
                            List list = parameters.elements("parameter");
                            for (Element parameter : list) {
                                String sName = parameter.attributeValue("name");
                                Element value = parameter.element("value");
                                if (value == null) continue;
                                String sValue = value.getText();
                                if (sName == null || sValue == null) continue;
                                sb.append("<parameter name=\"").append(sName).append("\"><value>").append(sValue).append("</value></parameter>");
                            }
                        }
                        sb.append("</parameters></success>");
                    } else {
                        String defaultNodeValue;
                        Element defaultNode;
                        int defaultAction = 0;
                        int numberOfButtons = 2;
                        Element dialogTypeNode = root.element("dialogType");
                        if (dialogTypeNode != null) {
                            String dialogTypeNodeValue = dialogTypeNode.getStringValue();
                            if (dialogTypeNodeValue.equalsIgnoreCase("yesnocancel")) {
                                numberOfButtons = 3;
                            } else if (!dialogTypeNodeValue.equalsIgnoreCase("okcancel")) {
                                if (dialogTypeNodeValue.equalsIgnoreCase("ok")) {
                                    numberOfButtons = 1;
                                } else if (dialogTypeNodeValue.equalsIgnoreCase("exitcontinue")) {
                                    // empty if block
                                }
                            }
                        }
                        if ((defaultNode = root.element("default")) != null && (defaultNodeValue = defaultNode.getStringValue()) != "") {
                            if (defaultNodeValue.equalsIgnoreCase("1") && numberOfButtons > 1) {
                                defaultAction = 1;
                            } else if (defaultNodeValue.equalsIgnoreCase("2") && numberOfButtons > 2) {
                                defaultAction = 2;
                            }
                        }
                        sb.append(defaultAction);
                    }
                }
                catch (DocumentException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("CnfgConsoleClient::prompt() - DocumentException e is " + e.getMessage());
                    }
                    sb.setLength(0);
                    if (!bPromptNameExists || !sPromptName.equalsIgnoreCase("com.cognos.crconfig.DialogCMUpgrade") && !sPromptName.equalsIgnoreCase("com.cognos.crconfig.DialogIPFUpgrade")) break block22;
                    sb.append("<fail/>");
                }
            }
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgConsoleClient::prompt() - return value is " + sb.toString());
            }
            return sb.toString();
        }
    }
}

