/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class CnfgField
extends JTextField
implements FocusListener {
    private Dimension minSize;
    private Dimension maxSize;
    private Dimension preferredSize;
    private int maxLength = 0;

    public CnfgField(int iX, int iY, int iWidth, String szString) {
        this(iX, iY, iWidth, szString, true);
    }

    public CnfgField(int iX, int iY, int iWidth, String szString, boolean selection) {
        super(szString);
        this.minSize = new Dimension(iWidth - 200, CnfgFontSetting.controlHeight);
        this.maxSize = new Dimension(iWidth + 200, CnfgFontSetting.controlHeight);
        this.preferredSize = new Dimension(iWidth, CnfgFontSetting.controlHeight);
        this.setScrollOffset(0);
        if (CnfgUtils.isWindowsPlatform()) {
            this.setBackground(SystemColor.window);
        } else {
            this.setBackground(Color.white);
        }
        if (CnfgUtils.isWindowsPlatform()) {
            this.setMargin(CRConfigFrame.ins);
        }
        this.addFocusListener(this);
    }

    public CnfgField(int iWidth) {
        this(0, 0, iWidth, "");
    }

    public CnfgField(int iWidth, String szString, int maxLength) {
        this(0, 0, iWidth, szString);
        this.maxLength = maxLength;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.maxSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (this.maxLength == 0 || !this.isEditable()) {
            super.processKeyEvent(e);
            return;
        }
        int keyCode = e.getKeyCode();
        int keyID = e.getID();
        if ((keyID == 401 || keyID == 400) && keyCode != 8 && keyCode != 10 && this.getText().length() > this.maxLength - 1) {
            return;
        }
        super.processKeyEvent(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        CnfgField field;
        Object o = e.getSource();
        if (CnfgField.class.isInstance(o) && (field = (CnfgField)o).getText().length() > 0) {
            field.setSelectionStart(0);
            field.setSelectionEnd(field.getText().length());
        }
    }
}

