/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgTree;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.DialogFontChooser;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.data.DataManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class CnfgFontSetting {
    private static boolean m_bUseSystemFontAndColor;
    private static ArrayList<String> menuFontAttrs;
    private static Font adminFont;
    private static Font adminBoldFont;
    private static Font adminButtonFont;
    private static Font explorerLabelFont;
    private static Font navPathLabelFont;
    public static int controlHeight;

    public static boolean useSystemFontAndColor() {
        return m_bUseSystemFontAndColor;
    }

    public static void setUseSystemFontAndColor(boolean useSys) {
        m_bUseSystemFontAndColor = useSys;
    }

    public static Font getAdminFont() {
        return adminFont;
    }

    public static Font getAdminBoldFont() {
        return adminBoldFont;
    }

    public static Font getAdminButtonFont() {
        return adminButtonFont;
    }

    public static Font getNavPathLabelFont() {
        return navPathLabelFont;
    }

    public static Font getExplorerLabelFont() {
        return explorerLabelFont;
    }

    public static void setAdminButtonFont(Font f) {
        adminButtonFont = f;
    }

    public static void setAdminBoldFont(Font f) {
        adminBoldFont = new Font(f.getName(), 1, f.getSize());
    }

    public static void initializeGUIFont() {
        String useSysSetting = (String)CnfgPreferences.getInstance().getProperty("UseSystemDisplaySetting", String.class);
        if (useSysSetting != null && useSysSetting.equalsIgnoreCase("true") && CnfgUtils.isWindowsPlatform()) {
            CnfgFontSetting.initSystemSettings();
            CnfgFontSetting.setupSystemFonts();
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Use System settings for font and color.");
            }
        } else {
            CnfgFontSetting.setupCustomizedFonts();
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Use Customized settings for font and color.");
            }
        }
        CnfgFontSetting.updateUIDefaults();
    }

    protected static void initSystemSettings() {
        CnfgFontSetting.setUseSystemFontAndColor(true);
        menuFontAttrs.add("menuitem.font");
        menuFontAttrs.add("radiobuttonmenuitem.font");
        menuFontAttrs.add("menuitem.acceleratorfont");
        menuFontAttrs.add("popupmenu.font");
        menuFontAttrs.add("menu.font");
        menuFontAttrs.add("checkboxmenuitem.font");
        menuFontAttrs.add("menubar.font");
    }

    protected static void setupSystemFonts() {
        adminFont = CnfgFontSetting.getSystemFont();
        if (adminFont == null) {
            CnfgFontSetting.setupCustomizedFonts();
            CnfgLog.debug("Couldn't find system font setting, use customized font settings instead.");
            return;
        }
        adminBoldFont = adminFont.deriveFont(1, adminFont.getSize());
        adminButtonFont = adminFont;
        navPathLabelFont = explorerLabelFont = adminFont.deriveFont(1, adminFont.getSize() + 2);
        if (CRConfigFrame.getInstance().getGraphics() == null) {
            CRConfigFrame.getInstance().pack();
        }
        CnfgFontSetting.setControlHeight(adminFont);
    }

    public static Font getSystemFont() {
        UIDefaults ui_defaults = UIManager.getDefaults();
        Enumeration k_oKey = ui_defaults.keys();
        while (k_oKey.hasMoreElements()) {
            String s_oStringKey = k_oKey.nextElement().toString();
            if (s_oStringKey.compareToIgnoreCase("OptionPane.messageFont") != 0) continue;
            Font aFont = UIManager.getFont(s_oStringKey);
            return aFont;
        }
        return null;
    }

    public static void refreshWithSystemFont() {
        UIDefaults ui_defaults = UIManager.getDefaults();
        Enumeration k_oKey = ui_defaults.keys();
        while (k_oKey.hasMoreElements()) {
            String s_oStringKey = k_oKey.nextElement().toString();
            if (s_oStringKey.compareToIgnoreCase("OptionPane.messageFont") != 0) continue;
            Font aFont = UIManager.getFont(s_oStringKey);
            if (aFont == CnfgFontSetting.getAdminFont()) break;
            CnfgFontSetting.updateFonts(aFont);
            break;
        }
    }

    public static int getCurrentFontSize() {
        if (CnfgFontSetting.useSystemFontAndColor()) {
            return CnfgFontSetting.getAdminFont().getSize();
        }
        DialogFontChooser fontChooser = CRConfigFrame.getInstance().getFontChooser();
        if (fontChooser != null && fontChooser.getFontSize() != null) {
            String str = fontChooser.getFontSize();
            Integer iInt = new Integer(str);
            return iInt;
        }
        return CnfgFontSetting.getDefaultFontSize();
    }

    public static void setControlHeight(Font font) {
        int height = CnfgFontSetting.getMaxHeight(font);
        controlHeight = height > 20 ? height : 20;
    }

    public static int getControlHeight() {
        return controlHeight;
    }

    public static int getMaxHeight(Font f) {
        FontMetrics fm = CRConfigFrame.getInstance().getFontMetrics(f);
        Rectangle2D recBounds = fm.getMaxCharBounds(CRConfigFrame.getInstance().getGraphics());
        return (int)recBounds.getHeight() + 4;
    }

    public static int getMaxWidth(Font f) {
        FontMetrics fm = CRConfigFrame.getInstance().getFontMetrics(f);
        Rectangle2D recBounds = fm.getMaxCharBounds(CRConfigFrame.getInstance().getGraphics());
        return (int)recBounds.getWidth();
    }

    public static int getTextHeight() {
        FontMetrics fm = CRConfigFrame.getInstance().getGraphics().getFontMetrics(CnfgFontSetting.getAdminFont());
        Rectangle2D recBounds = fm.getMaxCharBounds(CRConfigFrame.getInstance().getGraphics());
        int textHeight = (int)recBounds.getHeight();
        if (textHeight < CnfgFontSetting.getAdminFont().getSize()) {
            textHeight = CnfgFontSetting.getAdminFont().getSize();
        }
        return textHeight;
    }

    public static void setFontPreference() {
        if (!CnfgFontSetting.useSystemFontAndColor() && CnfgFontSetting.getAdminFont() != null && CRConfigFrame.getInstance().getFontChooser() != null) {
            CnfgPreferences.getInstance().setProperty("FontName", CnfgFontSetting.getAdminFont().getName());
            CnfgPreferences.getInstance().setProperty("FontStyle", CnfgFontSetting.getAdminFont().getStyle());
            CnfgPreferences.getInstance().setProperty("FontSize", CRConfigFrame.getInstance().getFontChooser().getFontSize());
        }
    }

    public static void updateUIDefaults() {
        CnfgFontSetting.updateUIDefaults(CnfgFontSetting.useSystemFontAndColor());
    }

    protected static boolean isMenuFont(String fontStr, boolean useSys) {
        return useSys && menuFontAttrs.contains(fontStr.toLowerCase());
    }

    private static void updateUIDefaults(boolean useSys) {
        UIDefaults ui_defaults = UIManager.getDefaults();
        Enumeration k_oKey = ui_defaults.keys();
        while (k_oKey.hasMoreElements()) {
            String s_oStringKey = k_oKey.nextElement().toString();
            if (s_oStringKey.compareToIgnoreCase("Button.font") == 0) {
                UIManager.put(s_oStringKey, adminButtonFont);
                continue;
            }
            if (!s_oStringKey.endsWith(".font") && !s_oStringKey.endsWith(".acceleratorFont") || CnfgFontSetting.isMenuFont(s_oStringKey, useSys)) continue;
            UIManager.put(s_oStringKey, adminFont);
        }
    }

    public static void setFont(JComponent comp, Font font) {
        if (comp != null) {
            comp.setFont(font);
        }
    }

    public static void updateFonts(Font font) {
        adminFont = font;
        adminBoldFont = new Font(adminFont.getName(), 1, adminFont.getSize());
        adminButtonFont = adminFont;
        navPathLabelFont = explorerLabelFont = new Font(adminFont.getName(), 1, adminFont.getSize() + 2);
        CRConfigFrame cnfgFrame = CRConfigFrame.getInstance();
        DialogFontChooser fontDialog = cnfgFrame.getFontChooser();
        if (fontDialog != null) {
            fontDialog.setFont(adminFont);
        }
        CnfgFontSetting.setFont(cnfgFrame.getExploreLabel(), explorerLabelFont);
        CnfgFontSetting.setFont(cnfgFrame.getNavPathLabel(), navPathLabelFont);
        CnfgFontSetting.setFont(cnfgFrame.getNavPathPanel(), navPathLabelFont);
        CnfgFontSetting.updateUIDefaults();
        cnfgFrame.setFont(adminFont);
        CnfgFontSetting.setFont(cnfgFrame.getCnfgTable(), adminFont);
        cnfgFrame.getCnfgTable().setCnfgTableHeight();
        CnfgFontSetting.setFont(cnfgFrame.getInfoPanel(), adminFont);
        JMenuBar menuBar = cnfgFrame.getCnfgMenuBar();
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            for (int j = 0; j < menu.getMenuComponentCount(); ++j) {
                if (!JMenuItem.class.isInstance(menu.getMenuComponent(j))) continue;
                JMenuItem menuItem = (JMenuItem)menu.getMenuComponent(j);
                menuItem.setFont(adminFont);
                if (menuItem.getAccelerator() != null) {
                    menuItem.updateUI();
                }
                if (!JMenu.class.isInstance(menu.getMenuComponent(j))) continue;
                JMenu subMenu = (JMenu)menu.getMenuComponent(j);
                for (int t = 0; t < subMenu.getMenuComponentCount(); ++t) {
                    subMenu.getMenuComponent(t).setFont(adminFont);
                }
            }
            menu.setFont(adminFont);
        }
        CnfgFontSetting.setFont(cnfgFrame.getMenuEditNewPopup(), adminFont);
        CnfgFontSetting.setFont(cnfgFrame.getTableResetToDefault(), adminFont);
        CnfgFontSetting.setFont(cnfgFrame.getTablePopupMenu(), adminFont);
        CnfgTree cTree = cnfgFrame.getCnfgTree();
        JLabel label = (JLabel)((Object)cTree.getCellRenderer());
        label.setFont(adminFont);
        cTree.setFont(adminFont);
        cTree.setCnfgTreeHeight();
        DialogMessage.updateFont(adminButtonFont);
        cnfgFrame.getTaskDialog().updateFonts();
        CnfgFontSetting.setControlHeight(font);
        CnfgFontSetting.setFont(cnfgFrame.getStatusLabel(), adminFont);
        cnfgFrame.getStatusPanel().setPreferredSize(new Dimension(750, CnfgFontSetting.getControlHeight()));
        JPopupMenu treePopup = cnfgFrame.getTreePopupMenu();
        CnfgFontSetting.setFont(cnfgFrame.getTreePopupMenu(), adminFont);
        for (int i = 0; i < treePopup.getComponentCount(); ++i) {
            Component comp = treePopup.getComponent(i);
            comp.setFont(adminFont);
        }
    }

    protected static void setupCustomizedFonts() {
        CRConfigFrame cnfgFrame = CRConfigFrame.getInstance();
        String sFontDir = DataManager.getPathToBinDir() + "fonts";
        int fontSize = CnfgFontSetting.getDefaultFontSize();
        int trueFontSize = CnfgFontSetting.getTrueFontSize(fontSize);
        int fStyle = CnfgFontSetting.getDefaultFontStyle();
        DialogFontChooser fontChooser = new DialogFontChooser(cnfgFrame, sFontDir, "Dialog", CnfgResource.getMessage("Label.DialogFontChooser.FontPlain"), fontSize);
        cnfgFrame.setFontChooser(fontChooser);
        String fontName = (String)CnfgPreferences.getInstance().getProperty("FontName", String.class);
        String currentLang = CnfgResource.getLocale().getLanguage();
        String oldLang = (String)CnfgPreferences.getInstance().getProperty("Language", String.class);
        CnfgPreferences.getInstance().setProperty("Language", currentLang);
        if (fontName == null || !currentLang.equals(oldLang)) {
            CnfgFontSetting.setDefaultFont(false);
        } else {
            Font savedFont = new Font(fontName, 0, 1);
            String savedFontName = savedFont.getFontName();
            Font font = DialogFontChooser.getFont(savedFontName);
            if (font != null) {
                adminFont = font.deriveFont(fStyle, trueFontSize);
            } else {
                CnfgFontSetting.setDefaultFont(false);
            }
        }
        adminBoldFont = adminFont.deriveFont(1, trueFontSize);
        adminButtonFont = adminFont;
        navPathLabelFont = explorerLabelFont = adminFont.deriveFont(1, trueFontSize + 2);
        String style = CnfgFontSetting.getAdminFont().getStyle() == 0 ? CnfgResource.getMessage("Label.DialogFontChooser.FontPlain") : (CnfgFontSetting.getAdminFont().getStyle() == 1 ? CnfgResource.getMessage("Label.DialogFontChooser.FontBold") : CnfgResource.getMessage("Label.DialogFontChooser.FontItalic"));
        fontChooser.setFontStyle(style);
        fontChooser.setFontName(adminFont.getFontName());
        fontChooser.setFont(adminFont);
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("setupFonts() - using " + adminFont.getName());
        }
        CnfgFontSetting.setControlHeight(adminFont);
    }

    private static int getDefaultFontSize() {
        int iFontSize;
        boolean isWinPlatform = CnfgUtils.isWindowsPlatform();
        Integer savedFontSize = (Integer)CnfgPreferences.getInstance().getProperty("FontSize", Integer.class);
        if (savedFontSize != null) {
            iFontSize = savedFontSize;
            String sVersion = (String)CnfgPreferences.getInstance().getProperty("Version", String.class);
            if (sVersion == null && isWinPlatform) {
                iFontSize = CnfgFontSetting.upgradeFontSize(iFontSize);
            }
        } else {
            iFontSize = CnfgFontSetting.getInitialFontSize(isWinPlatform);
        }
        return iFontSize;
    }

    private static int getInitialFontSize(boolean isWinPlatform) {
        if (!isWinPlatform) {
            return 11;
        }
        return 8;
    }

    private static int getScreenRes() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    private static int upgradeFontSize(int fontSize) {
        int screenRes = CnfgFontSetting.getScreenRes();
        int convertedSize = Math.round(72.0f * (float)fontSize / (float)screenRes);
        if (convertedSize < 8) {
            return 8;
        }
        if (convertedSize > 12 && convertedSize % 2 == 1) {
            return convertedSize + 1;
        }
        return convertedSize;
    }

    public static void setDefaultFont(boolean isWizardMode) {
        boolean bHindi;
        int fStyle;
        int fSize;
        if (CRConfigFrame.getInstance().getFontChooser() == null) {
            return;
        }
        if (isWizardMode) {
            boolean isWinPlatform = CnfgUtils.isWindowsPlatform();
            fSize = CnfgFontSetting.getTrueFontSize(CnfgFontSetting.getInitialFontSize(isWinPlatform));
            fStyle = CnfgFontSetting.getInitialFontStyle();
        } else {
            fSize = CnfgFontSetting.getTrueFontSize(CnfgFontSetting.getDefaultFontSize());
            fStyle = CnfgFontSetting.getDefaultFontStyle();
        }
        Font fAndale = DialogFontChooser.getFont("Andale WT");
        boolean bJa = CnfgResource.getLocale().getLanguage().compareToIgnoreCase("ja") == 0;
        boolean bChina = CnfgResource.getLocale().toString().compareToIgnoreCase("zh_cn") == 0;
        boolean bSingapore = CnfgResource.getLocale().toString().compareToIgnoreCase("zh_sg") == 0;
        boolean bTaiwan = CnfgResource.getLocale().toString().compareToIgnoreCase("zh_tw") == 0;
        boolean bMacao = CnfgResource.getLocale().toString().compareToIgnoreCase("zh_mo") == 0;
        boolean bHongKong = CnfgResource.getLocale().toString().compareToIgnoreCase("zh_hk") == 0;
        boolean bKorean = CnfgResource.getLocale().getLanguage().compareToIgnoreCase("ko") == 0;
        boolean bl = bHindi = CnfgResource.getLocale().getLanguage().compareToIgnoreCase("hi") == 0;
        if (!CnfgUtils.isWindowsPlatform()) {
            adminFont = (bJa || bChina || bSingapore || bTaiwan || bMacao || bHongKong || bKorean || bHindi) && fAndale != null ? fAndale.deriveFont(fStyle, fSize) : new Font("Dialog", fStyle, fSize);
        } else {
            Font fTahoma = DialogFontChooser.getFont("Tahoma");
            Font fMSUIGothic = DialogFontChooser.getFont("MS UI Gothic");
            Font fSimSun = null;
            Font fPMingLiU = null;
            Font fGulim = null;
            Font fRaghu8 = null;
            Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            for (int idx = 0; idx < fonts.length; ++idx) {
                String name = fonts[idx].getName();
                if (name.equalsIgnoreCase("SimSun")) {
                    fSimSun = DialogFontChooser.getFont(fonts[idx].getFontName());
                    continue;
                }
                if (name.equalsIgnoreCase("Raghu8")) {
                    fRaghu8 = DialogFontChooser.getFont(fonts[idx].getFontName());
                    continue;
                }
                if (name.equalsIgnoreCase("Gulim")) {
                    fGulim = DialogFontChooser.getFont(fonts[idx].getFontName());
                    continue;
                }
                if (!name.equalsIgnoreCase("PMingLiU")) continue;
                fPMingLiU = DialogFontChooser.getFont(fonts[idx].getFontName());
            }
            adminFont = bJa && fMSUIGothic != null ? fMSUIGothic.deriveFont(fStyle, fSize) : ((bChina || bSingapore) && fSimSun != null ? fSimSun.deriveFont(fStyle, fSize) : ((bHongKong || bMacao || bTaiwan) && fPMingLiU != null ? fPMingLiU.deriveFont(fStyle, fSize) : (bKorean && fGulim != null ? fGulim.deriveFont(fStyle, fSize) : (bHindi && fRaghu8 != null ? fRaghu8.deriveFont(fStyle, fSize) : (fTahoma != null ? fTahoma.deriveFont(fStyle, fSize) : (fAndale != null ? fAndale.deriveFont(fStyle, fSize) : new Font("Dialog", fStyle, fSize)))))));
        }
    }

    protected static int getTrueFontSize(int fontSize) {
        int screenRes = CnfgFontSetting.getScreenRes();
        return Math.round((float)(fontSize * screenRes) / 72.0f);
    }

    private static int getDefaultFontStyle() {
        int iFontStyle = CnfgFontSetting.getInitialFontStyle();
        Integer savedFontStyle = (Integer)CnfgPreferences.getInstance().getProperty("FontStyle", Integer.class);
        if (savedFontStyle != null) {
            return savedFontStyle;
        }
        return iFontStyle;
    }

    private static int getInitialFontStyle() {
        return 0;
    }

    static {
        menuFontAttrs = new ArrayList();
    }
}

