/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgField;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.CnfgWizardDialog;
import com.cognos.crconfig.CnfgWizardFrame;
import com.cognos.crconfig.CnfgWizardPage;
import com.cognos.crconfig.CnfgWizardPanel;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.data.PathParameter;
import com.cognos.crconfig.data.WizardPageData;
import com.cognos.crconfig.data.WizardParameterData;
import com.cognos.crconfig.editors.EditorPathParameter;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;

public class CnfgGenWarWizardPanel
extends CnfgWizardPanel
implements ItemListener {
    public static final String WELCOME_PAGE_NAME = "welcome";
    public static final String DISP_PAGE_NAME = "dispatcher";
    public static final String GATEWAY_PAGE_NAME = "gateway";
    public static final String DMNET_PAGE_NAME = "dmnet";
    public static final String PMPSVC_PAGE_NAME = "pmpsvc";
    public static final String DISP_PARAM_NAME = "disp";
    public static final String GATEWAY_PARAM_NAME = "gateway";
    public static final String DMNET_PARAM_NAME = "dmnet";
    public static final String PMPSVC_PARAM_NAME = "pmpsvc";
    public static final String PMHUB_PARAM_NAME = "pmhub";
    public static final String TM1WEB_PARAM_NAME = "tm1web";
    public static final String INCLUDEWEB_PARAM_NAME = "webcontent";
    public static final String INCLUDEDOCSAMPLES_PARAM_NAME = "docsamples";
    public static final String INCLUDEGATDOCSAMPLES_PARAM_NAME = "gatdocsamples";
    public static final String FILETYPE_PARAM_NAME = "filetype";
    public static final String LOCATION_PARAM_NAME = "location";
    public static final String CONTEXTROOT_PARAM_NAME = "contextroot";
    public static final String EAR_OPTION_NAME = "1_ear";
    public static final String WAR_OPTION_NAME = "2_war";
    public static final String EXPAND_OPTION_NAME = "3_expand";
    public static final String APPSERVER_PARAM_NAME = "appservertype";
    JCheckBox m_dispFileCB;
    JCheckBox m_servletGatewayFileCB;
    JCheckBox m_includeWebcontentCB;
    JCheckBox m_includeDOCSamplesCB;
    JCheckBox m_includeGATDOCSamplesCB;
    JCheckBox m_dmnetFileCB;
    JCheckBox m_pmpsvcFileCB;
    AbstractButton m_tomcatButton;
    AbstractButton m_defaultButton;
    ButtonGroup m_appServerTypeBG;
    ButtonGroup m_dispFileTypeBG;
    EditorPathParameter m_dispLocationPathEditor;
    CnfgField m_dispContextRootField;
    ButtonGroup m_servletFileTypeBG;
    EditorPathParameter m_servletLocationPathEditor;
    CnfgField m_servletContextRootField;
    ButtonGroup m_dmnetFileTypeBG;
    EditorPathParameter m_dmnetLocationPathEditor;
    ButtonGroup m_pmpsvcFileTypeBG;
    EditorPathParameter m_pmpsvcLocationPathEditor;
    ButtonGroup m_pmhubFileTypeBG;
    EditorPathParameter m_pmhubLocationPathEditor;
    ButtonGroup m_tm1webFileTypeBG;
    EditorPathParameter m_tm1webLocationPathEditor;
    WizardParameterData m_locationParam;

    public CnfgGenWarWizardPanel(CnfgWizardFrame parent, CnfgWizard cw) {
        super(parent, cw);
    }

    public CnfgGenWarWizardPanel(CnfgWizardDialog parent, CnfgWizard cw) {
        super(parent, cw);
    }

    @Override
    public void refresh(CnfgWizardPage wp) {
        super.refresh(wp);
        String tomcatResText = null;
        ArrayList paramList = wp.getWizardPageData().getWizardParamList();
        for (int i = 0; i < paramList.size(); ++i) {
            WizardParameterData wParam = (WizardParameterData)paramList.get(i);
            String paramName = wParam.getParam().getName();
            if (paramName.equals(DISP_PARAM_NAME)) {
                this.m_dispFileCB = (JCheckBox)wParam.getComponent();
                if (!wParam.getParam().getDisabled() || this.m_dispFileCB == null) continue;
                this.m_dispFileCB.setEnabled(false);
                this.m_dispFileCB.setSelected(false);
                continue;
            }
            if (paramName.equals("gateway")) {
                this.m_servletGatewayFileCB = (JCheckBox)wParam.getComponent();
                if (!wParam.getParam().getDisabled() || this.m_servletGatewayFileCB == null) continue;
                this.m_servletGatewayFileCB.setEnabled(false);
                this.m_servletGatewayFileCB.setSelected(false);
                continue;
            }
            if (paramName.equals("dmnet")) {
                this.m_dmnetFileCB = (JCheckBox)wParam.getComponent();
                if (!wParam.getParam().getDisabled() || this.m_dmnetFileCB == null) continue;
                this.m_dmnetFileCB.setEnabled(false);
                this.m_dmnetFileCB.setSelected(false);
                continue;
            }
            if (paramName.equals("pmpsvc")) {
                this.m_pmpsvcFileCB = (JCheckBox)wParam.getComponent();
                if (!wParam.getParam().getDisabled() || this.m_pmpsvcFileCB == null) continue;
                this.m_pmpsvcFileCB.setEnabled(false);
                this.m_pmpsvcFileCB.setSelected(false);
                continue;
            }
            if (paramName.equals(INCLUDEWEB_PARAM_NAME)) {
                this.m_includeWebcontentCB = (JCheckBox)wParam.getComponent();
                if (!wParam.getParam().getDisabled() || this.m_includeWebcontentCB == null) continue;
                this.m_includeWebcontentCB.setEnabled(false);
                this.m_includeWebcontentCB.setSelected(false);
                continue;
            }
            if (paramName.equals(INCLUDEDOCSAMPLES_PARAM_NAME)) {
                this.m_includeDOCSamplesCB = (JCheckBox)wParam.getComponent();
                if (!wParam.getParam().getDisabled() || this.m_includeDOCSamplesCB == null) continue;
                this.m_includeDOCSamplesCB.setEnabled(false);
                this.m_includeDOCSamplesCB.setSelected(false);
                continue;
            }
            if (paramName.equals(INCLUDEGATDOCSAMPLES_PARAM_NAME)) {
                this.m_includeGATDOCSamplesCB = (JCheckBox)wParam.getComponent();
                if (!wParam.getParam().getDisabled() || this.m_includeGATDOCSamplesCB == null) continue;
                this.m_includeGATDOCSamplesCB.setEnabled(false);
                this.m_includeGATDOCSamplesCB.setSelected(false);
                continue;
            }
            if (paramName.equals("disp_filetype")) {
                this.m_dispFileTypeBG = (ButtonGroup)wParam.getComponent();
                continue;
            }
            if (paramName.equals("disp_location")) {
                this.m_dispLocationPathEditor = (EditorPathParameter)wParam.getComponent();
                this.m_locationParam = wParam;
                if (this.m_dispFileTypeBG != null) {
                    this.setFileFilters(this.m_dispFileTypeBG, (PathParameter)wParam.getParam());
                    continue;
                }
                this.setEARFileFilter((PathParameter)wParam.getParam());
                continue;
            }
            if (paramName.equals("disp_contextroot")) {
                this.m_dispContextRootField = (CnfgField)wParam.getComponent();
                if (this.m_dispFileTypeBG == null || this.m_dispFileTypeBG.getSelection().getActionCommand().startsWith(EAR_OPTION_NAME)) continue;
                this.m_dispContextRootField.getParent().setVisible(false);
                continue;
            }
            if (paramName.equals("gateway_filetype")) {
                this.m_servletFileTypeBG = (ButtonGroup)wParam.getComponent();
                continue;
            }
            if (paramName.equals("gateway_location")) {
                this.m_servletLocationPathEditor = (EditorPathParameter)wParam.getComponent();
                this.m_locationParam = wParam;
                this.setFileFilters(this.m_servletFileTypeBG, (PathParameter)wParam.getParam());
                continue;
            }
            if (paramName.equals("gateway_contextroot")) {
                this.m_servletContextRootField = (CnfgField)wParam.getComponent();
                if (this.m_servletFileTypeBG == null || this.m_servletFileTypeBG.getSelection().getActionCommand().startsWith(EAR_OPTION_NAME)) continue;
                this.m_servletContextRootField.getParent().setVisible(false);
                continue;
            }
            if (paramName.equals("dmnet_filetype")) {
                this.m_dmnetFileTypeBG = (ButtonGroup)wParam.getComponent();
                continue;
            }
            if (wParam.getParam().getName().equals("dmnet_location")) {
                this.m_dmnetLocationPathEditor = (EditorPathParameter)wParam.getComponent();
                this.m_locationParam = wParam;
                this.setFileFilters(this.m_dmnetFileTypeBG, (PathParameter)wParam.getParam());
                continue;
            }
            if (paramName.equals("pmpsvc_filetype")) {
                this.m_pmpsvcFileTypeBG = (ButtonGroup)wParam.getComponent();
                continue;
            }
            if (paramName.equals("pmpsvc_location")) {
                this.m_pmpsvcLocationPathEditor = (EditorPathParameter)wParam.getComponent();
                this.m_locationParam = wParam;
                this.setFileFilters(this.m_pmpsvcFileTypeBG, (PathParameter)wParam.getParam());
                continue;
            }
            if (paramName.equals("pmhub_filetype")) {
                this.m_pmhubFileTypeBG = (ButtonGroup)wParam.getComponent();
                continue;
            }
            if (paramName.equals("pmhub_location")) {
                this.m_pmhubLocationPathEditor = (EditorPathParameter)wParam.getComponent();
                this.m_locationParam = wParam;
                this.setFileFilters(this.m_pmhubFileTypeBG, (PathParameter)wParam.getParam());
                continue;
            }
            if (paramName.equals("tm1web_filetype")) {
                this.m_tm1webFileTypeBG = (ButtonGroup)wParam.getComponent();
                continue;
            }
            if (paramName.equals("tm1web_location")) {
                this.m_tm1webLocationPathEditor = (EditorPathParameter)wParam.getComponent();
                this.m_locationParam = wParam;
                this.setFileFilters(this.m_tm1webFileTypeBG, (PathParameter)wParam.getParam());
                continue;
            }
            if (!paramName.equals(APPSERVER_PARAM_NAME)) continue;
            this.m_appServerTypeBG = (ButtonGroup)wParam.getComponent();
            Map valueMap = wParam.getParam().getValues();
            String tomcatResId = (String)valueMap.get("7_tomcat");
            if (tomcatResId != null) {
                tomcatResText = CnfgUIDocResource.getMessage(tomcatResId, "config_wizard");
            }
            Enumeration<AbstractButton> radioButtons = this.m_appServerTypeBG.getElements();
            while (radioButtons.hasMoreElements()) {
                String buttonText;
                AbstractButton button = radioButtons.nextElement();
                if (button.getSelectedObjects() != null) {
                    this.m_defaultButton = button;
                }
                if (!(buttonText = button.getText()).equals(tomcatResText)) continue;
                this.m_tomcatButton = button;
                if (this.m_pmpsvcFileCB != null && this.m_pmpsvcFileCB.getSelectedObjects() != null) {
                    this.m_tomcatButton.setEnabled(true);
                    continue;
                }
                this.m_tomcatButton.setEnabled(false);
            }
        }
        if (wp.getWizardPageData().getName().equals(WELCOME_PAGE_NAME)) {
            boolean bPMPSVCDisabled;
            if (this.m_dispFileCB == null || !this.m_dispFileCB.isEnabled()) {
                if (this.m_servletGatewayFileCB != null && this.m_servletGatewayFileCB.isEnabled()) {
                    this.m_servletGatewayFileCB.setSelected(true);
                } else if (this.m_dmnetFileCB != null && this.m_dmnetFileCB.isEnabled()) {
                    this.m_dmnetFileCB.setSelected(true);
                } else if (this.m_pmpsvcFileCB != null && this.m_pmpsvcFileCB.isEnabled()) {
                    this.m_pmpsvcFileCB.setSelected(true);
                }
            }
            boolean bDispDisabled = this.m_dispFileCB == null || this.m_dispFileCB != null && (!this.m_dispFileCB.isEnabled() || this.m_dispFileCB.getSelectedObjects() == null);
            boolean bGatewayDisabled = this.m_servletGatewayFileCB == null || this.m_servletGatewayFileCB != null && (!this.m_servletGatewayFileCB.isEnabled() || this.m_servletGatewayFileCB.getSelectedObjects() == null);
            boolean bDMNETDisabled = this.m_dmnetFileCB == null || this.m_dmnetFileCB != null && (!this.m_dmnetFileCB.isEnabled() || this.m_dmnetFileCB.getSelectedObjects() == null);
            boolean bl = bPMPSVCDisabled = this.m_pmpsvcFileCB == null || this.m_pmpsvcFileCB != null && (!this.m_pmpsvcFileCB.isEnabled() || this.m_pmpsvcFileCB.getSelectedObjects() == null);
            if (bDispDisabled && bGatewayDisabled && bDMNETDisabled && bPMPSVCDisabled) {
                this.m_buttonNext.setEnabled(false);
            }
            this.m_dispFileTypeBG = null;
            this.m_dispLocationPathEditor = null;
            this.m_dispContextRootField = null;
            this.m_servletFileTypeBG = null;
            this.m_servletLocationPathEditor = null;
            this.m_servletContextRootField = null;
            this.m_dmnetFileTypeBG = null;
            this.m_dmnetLocationPathEditor = null;
            this.m_pmpsvcFileTypeBG = null;
            this.m_pmpsvcLocationPathEditor = null;
            this.m_pmhubFileTypeBG = null;
            this.m_pmhubLocationPathEditor = null;
            this.m_tm1webFileTypeBG = null;
            this.m_tm1webLocationPathEditor = null;
        }
    }

    private void setEARFileFilter(PathParameter param) {
        ArrayList<String> fileExtensionList = new ArrayList<String>();
        fileExtensionList.add("ear");
        param.setFileFilterExt(fileExtensionList, CnfgResource.getMessage("Label.DialogGenWarWizard.EAR"));
    }

    private void setFileFilters(ButtonGroup fileTypeBG, PathParameter param) {
        ArrayList<String> lExt = new ArrayList<String>();
        if (fileTypeBG != null && fileTypeBG.getSelection().getActionCommand().startsWith(EAR_OPTION_NAME)) {
            lExt.add("ear");
            param.setFileFilterExt(lExt, CnfgResource.getMessage("Label.DialogGenWarWizard.EAR"));
        } else if (this.m_dispFileTypeBG != null && this.m_dispFileTypeBG.getSelection().getActionCommand().startsWith(WAR_OPTION_NAME)) {
            lExt.add("war");
            param.setFileFilterExt(lExt, CnfgResource.getMessage("Label.DialogGenWarWizard.WAR"));
        } else {
            param.setFileFilterExt(null, null);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        WizardPageData wpd = this.getWizard().getCurrentWizardPage().getWizardPageData();
        if (wpd.getName().equals(WELCOME_PAGE_NAME)) {
            boolean bPMPSVCDisabled;
            boolean isPmpsvSelected;
            boolean isGatewaySelected;
            boolean isDmnetsSelected;
            boolean isDispSelected;
            if (e.getStateChange() == 1) {
                this.m_buttonNext.setEnabled(true);
            }
            if (e.getStateChange() == 1 && source == this.m_includeWebcontentCB) {
                this.m_dispFileCB.setSelected(true);
                if (this.m_includeDOCSamplesCB != null) {
                    this.m_includeDOCSamplesCB.setSelected(true);
                }
            } else if (e.getStateChange() == 2 && source == this.m_pmpsvcFileCB) {
                if (this.m_tomcatButton != null) {
                    this.m_tomcatButton.setEnabled(false);
                    if (this.m_tomcatButton.getSelectedObjects() != null) {
                        this.m_defaultButton.setSelected(true);
                    }
                }
            } else if (e.getStateChange() == 1 && source == this.m_pmpsvcFileCB) {
                isDispSelected = this.m_dispFileCB != null && this.m_dispFileCB.isEnabled() && this.m_dispFileCB.getSelectedObjects() != null;
                boolean isGatewaySelected2 = this.m_servletGatewayFileCB != null && this.m_servletGatewayFileCB.isEnabled() && this.m_servletGatewayFileCB.getSelectedObjects() != null;
                boolean bl = isDmnetsSelected = this.m_dmnetFileCB != null && this.m_dmnetFileCB.isEnabled() && this.m_dmnetFileCB.getSelectedObjects() != null;
                if (!(isDispSelected || isGatewaySelected2 || isDmnetsSelected || this.m_tomcatButton == null)) {
                    this.m_tomcatButton.setEnabled(true);
                }
            } else if (e.getStateChange() == 1 && source == this.m_includeDOCSamplesCB) {
                this.m_dispFileCB.setSelected(true);
                if (this.m_includeWebcontentCB != null) {
                    this.m_includeWebcontentCB.setSelected(true);
                }
            } else if (e.getStateChange() == 1 && source == this.m_servletGatewayFileCB) {
                if (this.m_includeGATDOCSamplesCB != null) {
                    this.m_includeGATDOCSamplesCB.setSelected(true);
                }
                if (this.m_tomcatButton != null) {
                    this.m_tomcatButton.setEnabled(false);
                    if (this.m_tomcatButton.getSelectedObjects() != null) {
                        this.m_defaultButton.setSelected(true);
                    }
                }
            } else if (e.getStateChange() == 1 && source == this.m_dmnetFileCB) {
                if (this.m_tomcatButton != null) {
                    this.m_tomcatButton.setEnabled(false);
                    if (this.m_tomcatButton.getSelectedObjects() != null) {
                        this.m_defaultButton.setSelected(true);
                    }
                }
            } else if (e.getStateChange() == 2 && source == this.m_dmnetFileCB) {
                isGatewaySelected = this.m_servletGatewayFileCB != null && this.m_servletGatewayFileCB.isEnabled() && this.m_servletGatewayFileCB.getSelectedObjects() != null;
                isPmpsvSelected = this.m_pmpsvcFileCB != null && this.m_pmpsvcFileCB.isEnabled() && this.m_pmpsvcFileCB.getSelectedObjects() != null;
                boolean bl = isDmnetsSelected = this.m_dmnetFileCB != null && this.m_dmnetFileCB.isEnabled() && this.m_dmnetFileCB.getSelectedObjects() != null;
                if (!isGatewaySelected && !isDmnetsSelected && isPmpsvSelected && this.m_tomcatButton != null) {
                    this.m_tomcatButton.setEnabled(true);
                }
            } else if (e.getStateChange() == 1 && source == this.m_includeGATDOCSamplesCB) {
                if (this.m_servletGatewayFileCB != null) {
                    this.m_servletGatewayFileCB.setSelected(true);
                }
            } else if (e.getStateChange() == 1 && source == this.m_dispFileCB) {
                if (this.m_tomcatButton != null) {
                    this.m_tomcatButton.setEnabled(false);
                    if (this.m_tomcatButton.getSelectedObjects() != null) {
                        this.m_defaultButton.setSelected(true);
                    }
                }
            } else if (e.getStateChange() == 2 && source == this.m_dispFileCB) {
                if (this.m_includeWebcontentCB != null) {
                    this.m_includeWebcontentCB.setSelected(false);
                }
                if (this.m_includeDOCSamplesCB != null) {
                    this.m_includeDOCSamplesCB.setSelected(false);
                }
                isGatewaySelected = this.m_servletGatewayFileCB != null && this.m_servletGatewayFileCB.isEnabled() && this.m_servletGatewayFileCB.getSelectedObjects() != null;
                isPmpsvSelected = this.m_pmpsvcFileCB != null && this.m_pmpsvcFileCB.isEnabled() && this.m_pmpsvcFileCB.getSelectedObjects() != null;
                boolean bl = isDmnetsSelected = this.m_dmnetFileCB != null && this.m_dmnetFileCB.isEnabled() && this.m_dmnetFileCB.getSelectedObjects() != null;
                if (!isGatewaySelected && !isDmnetsSelected && isPmpsvSelected && this.m_tomcatButton != null) {
                    this.m_tomcatButton.setEnabled(true);
                }
            } else if (e.getStateChange() == 2 && source == this.m_includeWebcontentCB) {
                if (this.m_includeDOCSamplesCB != null) {
                    this.m_includeDOCSamplesCB.setSelected(false);
                }
            } else if (e.getStateChange() == 2 && source == this.m_servletGatewayFileCB) {
                if (this.m_includeGATDOCSamplesCB != null) {
                    this.m_includeGATDOCSamplesCB.setSelected(false);
                }
                isDispSelected = this.m_dispFileCB != null && this.m_dispFileCB.isEnabled() && this.m_dispFileCB.getSelectedObjects() != null;
                isPmpsvSelected = this.m_pmpsvcFileCB != null && this.m_pmpsvcFileCB.isEnabled() && this.m_pmpsvcFileCB.getSelectedObjects() != null;
                boolean bl = isDmnetsSelected = this.m_dmnetFileCB != null && this.m_dmnetFileCB.isEnabled() && this.m_dmnetFileCB.getSelectedObjects() != null;
                if (!isDispSelected && !isDmnetsSelected && isPmpsvSelected && this.m_tomcatButton != null) {
                    this.m_tomcatButton.setEnabled(true);
                }
            }
            boolean bDispDisabled = this.m_dispFileCB == null || this.m_dispFileCB != null && (!this.m_dispFileCB.isEnabled() || this.m_dispFileCB.getSelectedObjects() == null);
            boolean bGatewayDisabled = this.m_servletGatewayFileCB == null || this.m_servletGatewayFileCB != null && (!this.m_servletGatewayFileCB.isEnabled() || this.m_servletGatewayFileCB.getSelectedObjects() == null);
            boolean bDMNETDisabled = this.m_dmnetFileCB == null || this.m_dmnetFileCB != null && (!this.m_dmnetFileCB.isEnabled() || this.m_dmnetFileCB.getSelectedObjects() == null);
            boolean bl = bPMPSVCDisabled = this.m_pmpsvcFileCB == null || this.m_pmpsvcFileCB != null && (!this.m_pmpsvcFileCB.isEnabled() || this.m_pmpsvcFileCB.getSelectedObjects() == null);
            if (bDispDisabled && bGatewayDisabled && bDMNETDisabled && bPMPSVCDisabled) {
                this.m_buttonNext.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().getClass() == JRadioButton.class) {
            String name = e.getActionCommand();
            ArrayList<String> lExt = new ArrayList<String>();
            if (name.startsWith(EAR_OPTION_NAME)) {
                if (name.endsWith(DISP_PARAM_NAME)) {
                    this.m_dispContextRootField.getParent().setVisible(true);
                    this.m_dispLocationPathEditor.setPathEditorValue("../p2pd.ear");
                }
                if (name.endsWith("gateway")) {
                    this.m_servletContextRootField.getParent().setVisible(true);
                    this.m_servletLocationPathEditor.setPathEditorValue("../ServletGateway.ear");
                }
                if (name.endsWith("dmnet")) {
                    this.m_dmnetLocationPathEditor.setPathEditorValue("../dmnet.ear");
                }
                if (name.endsWith("pmpsvc") && null != this.m_pmpsvcLocationPathEditor) {
                    this.m_pmpsvcLocationPathEditor.setPathEditorValue("../pmpsvc.ear");
                }
                if (name.endsWith(PMHUB_PARAM_NAME) && null != this.m_pmhubLocationPathEditor) {
                    this.m_pmhubLocationPathEditor.setPathEditorValue("../pmhub.ear");
                }
                if (name.endsWith(TM1WEB_PARAM_NAME) && null != this.m_tm1webLocationPathEditor) {
                    this.m_tm1webLocationPathEditor.setPathEditorValue("../tm1web.ear");
                }
                ((PathParameter)this.m_locationParam.getParam()).setFilePath(true);
                lExt.add("ear");
                ((PathParameter)this.m_locationParam.getParam()).setFileFilterExt(lExt, CnfgResource.getMessage("Label.DialogGenWarWizard.EAR"));
            } else if (name.startsWith(WAR_OPTION_NAME)) {
                if (name.endsWith(DISP_PARAM_NAME)) {
                    this.m_dispContextRootField.getParent().setVisible(false);
                    this.m_dispLocationPathEditor.setPathEditorValue("../p2pd.war");
                    if (this.m_dispContextRootField.getText().length() == 0) {
                        this.m_dispContextRootField.setText("p2pd");
                    }
                }
                if (name.endsWith("gateway")) {
                    this.m_servletContextRootField.getParent().setVisible(false);
                    this.m_servletLocationPathEditor.setPathEditorValue("../ServletGateway.war");
                    if (this.m_servletContextRootField.getText().length() == 0) {
                        this.m_servletContextRootField.setText("ServletGateway");
                    }
                }
                if (name.endsWith("dmnet")) {
                    this.m_dmnetLocationPathEditor.setPathEditorValue("../dmnet.war");
                }
                if (name.endsWith("pmpsvc") && null != this.m_pmpsvcLocationPathEditor) {
                    this.m_pmpsvcLocationPathEditor.setPathEditorValue("../pmpsvc.war");
                }
                if (name.endsWith(PMHUB_PARAM_NAME) && null != this.m_pmhubLocationPathEditor) {
                    this.m_pmhubLocationPathEditor.setPathEditorValue("../pmhub.war");
                }
                if (name.endsWith(TM1WEB_PARAM_NAME) && null != this.m_tm1webLocationPathEditor) {
                    this.m_tm1webLocationPathEditor.setPathEditorValue("../tm1web.war");
                }
                ((PathParameter)this.m_locationParam.getParam()).setFilePath(true);
                lExt.add("war");
                ((PathParameter)this.m_locationParam.getParam()).setFileFilterExt(lExt, CnfgResource.getMessage("Label.DialogGenWarWizard.WAR"));
            } else if (name.startsWith(EXPAND_OPTION_NAME)) {
                if (name.endsWith(DISP_PARAM_NAME)) {
                    this.m_dispContextRootField.getParent().setVisible(false);
                    this.m_dispLocationPathEditor.setPathEditorValue("");
                    if (this.m_dispContextRootField.getText().length() == 0) {
                        this.m_dispContextRootField.setText("p2pd");
                    }
                }
                if (name.endsWith("gateway")) {
                    this.m_servletContextRootField.getParent().setVisible(false);
                    this.m_servletLocationPathEditor.setPathEditorValue("");
                    if (this.m_servletContextRootField.getText().length() == 0) {
                        this.m_servletContextRootField.setText("ServletGateway");
                    }
                }
                if (name.endsWith("dmnet")) {
                    this.m_dmnetLocationPathEditor.setPathEditorValue("");
                }
                if (name.endsWith("pmpsvc") && null != this.m_pmpsvcLocationPathEditor) {
                    this.m_pmpsvcLocationPathEditor.setPathEditorValue("");
                }
                if (name.endsWith(PMHUB_PARAM_NAME) && null != this.m_pmhubLocationPathEditor) {
                    this.m_pmhubLocationPathEditor.setPathEditorValue("");
                }
                if (name.endsWith(TM1WEB_PARAM_NAME) && null != this.m_tm1webLocationPathEditor) {
                    this.m_tm1webLocationPathEditor.setPathEditorValue("");
                }
                ((PathParameter)this.m_locationParam.getParam()).setFilePath(false);
                ((PathParameter)this.m_locationParam.getParam()).setFileFilterExt(null, null);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private String updateFileExtension(String destExtension, String sLocation) {
        String filepath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sLocation);
        if (destExtension == null || destExtension.length() == 0) {
            return filepath;
        }
        String newLocation = filepath;
        File f = new File(filepath);
        String sExt = CnfgUtils.getFileExtension(f);
        if (sExt == null || !sExt.equalsIgnoreCase(destExtension)) {
            newLocation = f.getAbsolutePath() + "." + destExtension.toLowerCase();
        }
        return newLocation;
    }

    @Override
    public void actionNext() {
        if (this.m_locationParam != null) {
            PathParameter pParam = (PathParameter)this.m_locationParam.getParam();
            HashSet<String> sTargets = new HashSet<String>(0);
            String sPath = "";
            String sDispPath = "";
            String sGatewayPath = "";
            WizardPageData wpd = this.getWizard().getCurrentWizardPage().getWizardPageData();
            if (wpd.getName().equals(DISP_PAGE_NAME) && this.m_dispLocationPathEditor != null) {
                sPath = this.m_dispLocationPathEditor.getCellEditorValue().toString();
                if (sPath != null && sPath.length() > 0 && pParam.getFileFilterExtList() != null) {
                    sTargets.add(this.updateFileExtension(pParam.getFileFilterExtList().get(0), sPath));
                    this.m_dispLocationPathEditor.setPathEditorValue(sPath);
                } else {
                    sTargets.add(sPath);
                }
            } else if (wpd.getName().equals("gateway") && this.m_servletLocationPathEditor != null) {
                sPath = this.m_servletLocationPathEditor.getCellEditorValue().toString();
                if (sPath != null && sPath.length() > 0 && pParam.getFileFilterExtList() != null) {
                    sTargets.add(this.updateFileExtension(pParam.getFileFilterExtList().get(0), sPath));
                    this.m_servletLocationPathEditor.setPathEditorValue(sPath);
                } else {
                    sTargets.add(sPath);
                }
                if (this.m_dispLocationPathEditor != null) {
                    sDispPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(this.m_dispLocationPathEditor.getCellEditorValue().toString());
                }
            } else if (wpd.getName().equals("dmnet") && this.m_dmnetLocationPathEditor != null) {
                sPath = this.m_dmnetLocationPathEditor.getCellEditorValue().toString();
                if (sPath != null && sPath.length() > 0 && pParam.getFileFilterExtList() != null) {
                    sTargets.add(this.updateFileExtension(pParam.getFileFilterExtList().get(0), sPath));
                    this.m_dmnetLocationPathEditor.setPathEditorValue(sPath);
                } else {
                    sTargets.add(sPath);
                }
                if (this.m_dispLocationPathEditor != null) {
                    sDispPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(this.m_dispLocationPathEditor.getCellEditorValue().toString());
                }
                if (this.m_servletLocationPathEditor != null) {
                    sGatewayPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(this.m_servletLocationPathEditor.getCellEditorValue().toString());
                }
            } else if (wpd.getName().equals("pmpsvc")) {
                if (this.m_pmpsvcLocationPathEditor != null) {
                    sPath = this.m_pmpsvcLocationPathEditor.getCellEditorValue().toString();
                    if (sPath != null && sPath.length() > 0 && pParam.getFileFilterExtList() != null) {
                        sTargets.add(this.updateFileExtension(pParam.getFileFilterExtList().get(0), sPath));
                        this.m_pmpsvcLocationPathEditor.setPathEditorValue(sPath);
                    } else {
                        sTargets.add(sPath);
                    }
                    if (this.m_dispLocationPathEditor != null) {
                        sDispPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(this.m_dispLocationPathEditor.getCellEditorValue().toString());
                    }
                    if (this.m_servletLocationPathEditor != null) {
                        sGatewayPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(this.m_servletLocationPathEditor.getCellEditorValue().toString());
                    }
                }
                if (this.m_pmhubLocationPathEditor != null) {
                    sPath = this.m_pmhubLocationPathEditor.getCellEditorValue().toString();
                    if (sPath != null && sPath.length() > 0 && pParam.getFileFilterExtList() != null) {
                        sTargets.add(this.updateFileExtension(pParam.getFileFilterExtList().get(0), sPath));
                        this.m_pmhubLocationPathEditor.setPathEditorValue(sPath);
                    } else {
                        sTargets.add(sPath);
                    }
                }
                if (this.m_tm1webLocationPathEditor != null) {
                    sPath = this.m_tm1webLocationPathEditor.getCellEditorValue().toString();
                    if (sPath != null && sPath.length() > 0 && pParam.getFileFilterExtList() != null) {
                        sTargets.add(this.updateFileExtension(pParam.getFileFilterExtList().get(0), sPath));
                        this.m_tm1webLocationPathEditor.setPathEditorValue(sPath);
                    } else {
                        sTargets.add(sPath);
                    }
                }
            }
            for (String sTarget : sTargets) {
                Object[] oMsg;
                if (sTarget == null || sTarget.length() <= 0) continue;
                String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sTarget);
                File curFile = new File(sResolvedPath);
                Object[] args = new Object[]{sResolvedPath};
                if (sResolvedPath.equalsIgnoreCase(sDispPath) || sResolvedPath.equalsIgnoreCase(sGatewayPath)) {
                    oMsg = new Object[2];
                    if (pParam.isFilePath()) {
                        oMsg[0] = new StringBuffer(CnfgResource.getMessage("Message.errorOnGenWarWizard.filenamedup.notification", args)).append("\n").toString();
                        oMsg[1] = CnfgResource.getMessage("Message.errorOnGenWarWizard.filenamedup.resolution");
                    } else if (pParam.isFolderPath()) {
                        oMsg[0] = new StringBuffer(CnfgResource.getMessage("Message.errorOnGenWarWizard.pathnamedup.notification", args)).append("\n").toString();
                        oMsg[1] = CnfgResource.getMessage("Message.errorOnGenWarWizard.pathnamedup.resolution");
                    }
                    DialogMessage.showDialog(oMsg, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                    return;
                }
                if (!curFile.exists()) continue;
                oMsg = new Object[2];
                if (pParam.isFilePath()) {
                    oMsg[0] = new StringBuffer(CnfgResource.getMessage("Message.errorOnGenWarWizard.fileduplicate.notification", args)).append("\n").toString();
                    oMsg[1] = CnfgResource.getMessage("Message.errorOnGenWarWizard.fileduplicate.resolution");
                } else if (pParam.isFolderPath()) {
                    oMsg[0] = new StringBuffer(CnfgResource.getMessage("Message.errorOnGenWarWizard.pathduplicate.notification", args)).append("\n").toString();
                    oMsg[1] = CnfgResource.getMessage("Message.errorOnGenWarWizard.pathduplicate.resolution");
                }
                if (1 != DialogMessage.showDialog(oMsg, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1)) continue;
                return;
            }
        }
        super.actionNext();
    }
}

