/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import java.io.File;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CnfgInfo {
    private static final String CNFG_VERSION = "${ProductMajorNo}.${ProductMinorNo}.${BuildMajorNo}.${BuildMinorNo}";
    private static final String VERSION_FILE = "./version.xml";
    private static final String PRODUCT_MAJOR = "productMajor";
    private static final String PRODUCT_MINOR = "productMinor";
    private static final String IS_RELEASE = "isRelease";
    private static final String VERSION_SEPARATOR = ".";
    private static String m_sVersion;

    public static String getVersion() {
        return m_sVersion;
    }

    static {
        StringBuffer sb = new StringBuffer();
        boolean bContinue = true;
        Document versionDoc = null;
        try {
            SAXReader saxReader = new SAXReader();
            versionDoc = saxReader.read(new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(VERSION_FILE)));
        }
        catch (DocumentException e) {
            CnfgLog.debug(e);
            bContinue = false;
        }
        if (bContinue) {
            Element rootElem = versionDoc.getRootElement();
            if (rootElem == null) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("Root element is null.");
                }
                bContinue = false;
            }
            if (bContinue) {
                Attribute attribute = rootElem.attribute(PRODUCT_MAJOR);
                if (attribute == null) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("Unable to find attribute : productMajor");
                    }
                    bContinue = false;
                }
                if (bContinue) {
                    sb.append(attribute.getValue()).append(VERSION_SEPARATOR);
                    attribute = rootElem.attribute(PRODUCT_MINOR);
                    if (attribute == null) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("Unable to find attribute : productMinor");
                        }
                        bContinue = false;
                    }
                    if (bContinue) {
                        sb.append(attribute.getValue());
                        String sIsRelease = rootElem.attributeValue(IS_RELEASE);
                        if (sIsRelease != null && sIsRelease.equalsIgnoreCase("false")) {
                            sb.append(" " + CnfgResource.getMessage("Label.DialogAbout.notforresale"));
                        }
                    }
                }
            }
        }
        if (!bContinue) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Was unsuccessful in reading from version.xml -- falling back to CNFG's build number");
            }
            sb.delete(0, sb.length());
            sb.append(CNFG_VERSION);
        }
        m_sVersion = sb.toString();
    }
}

