/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.ConfigServersArrayParameter;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Parameter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;

public class CnfgInstallDataProcessor {
    private static final String INSTALLDATA_PROPFILE = "../configuration/installData.properties";
    private static final String ZOOKEEPER_MYID = "../configuration/data/myid";
    private static final CnfgInstallDataProcessor INSTANCE = new CnfgInstallDataProcessor();
    public static final String LOCAL_CONFIG_SERVER = "localConfigurationServer";
    public static final String LOCAL_ZOOKEEPER = "localZookeeper";
    public static final String LOCAL_ZOOKEEPER_CLIENTPORT = "localZookeeper.clientPort";
    public static final String LOCAL_ZOOKEEPER_SERVERPORTS = "localZookeeper.serverPorts";
    public static final String REMOTE_ZOOKEEPER_SERVER = "zkserver";
    public static final String ZOOKEEPER_SERVERS_COUNT = "zkservers.count";
    private ConfigServersArrayParameter m_configServerParm = null;
    private Properties m_installDataProp = this.loadInstallDataFile();

    public static CnfgInstallDataProcessor getInstance() {
        return INSTANCE;
    }

    private CnfgInstallDataProcessor() {
    }

    public void processConfigServersParamForTest(Parameter configServersP) {
        if (null != configServersP && configServersP instanceof ConfigServersArrayParameter) {
            ConfigServersArrayParameter arrayParam;
            this.m_configServerParm = arrayParam = (ConfigServersArrayParameter)configServersP;
            ArrayList<Parameter> alist = new ArrayList<Parameter>();
            this.addServerParam(arrayParam, alist, "localConfigurationServer:2888:3888;2181");
            arrayParam.setValue(alist);
        }
    }

    public void processConfigServersParam(Parameter configServersP, boolean isSmoketest) {
        if (isSmoketest) {
            this.processConfigServersParamForTest(configServersP);
        } else {
            this.processConfigServersParam(configServersP);
        }
    }

    public void processConfigServersParam(Parameter configServersP) {
        if (null != configServersP && !configServersP.getDisabled() && configServersP instanceof ConfigServersArrayParameter) {
            ConfigServersArrayParameter arrayParam;
            this.m_configServerParm = arrayParam = (ConfigServersArrayParameter)configServersP;
            Set<Parameter> values = arrayParam.getCurrentValues();
            String zkClientPort = null;
            String zkServerPorts = null;
            if (this.m_installDataProp != null && this.m_installDataProp.size() > 0) {
                for (String name : this.m_installDataProp.stringPropertyNames()) {
                    String value = this.m_installDataProp.getProperty(name);
                    if (name.equalsIgnoreCase(LOCAL_ZOOKEEPER_CLIENTPORT)) {
                        zkClientPort = value;
                        continue;
                    }
                    if (!name.equalsIgnoreCase(LOCAL_ZOOKEEPER_SERVERPORTS)) continue;
                    zkServerPorts = value;
                }
                String zklocalSetting = "";
                if (zkClientPort != null && zkServerPorts != null) {
                    zklocalSetting = "localConfigurationServer:" + (zkServerPorts.length() > 0 ? zkServerPorts : "0") + ";" + (zkClientPort.length() > 0 ? zkClientPort : "0");
                    arrayParam.setDefault(zklocalSetting);
                }
                if (values == null || values.size() == 0) {
                    ArrayList<Parameter> alist = this.getRemoteServerList(arrayParam);
                    if (alist.size() > 0) {
                        arrayParam.setValue(alist);
                    } else if (zklocalSetting.length() > 0 && this.myIDFileExist()) {
                        this.addServerParam(arrayParam, alist, zklocalSetting);
                        arrayParam.setValue(alist);
                    }
                }
            }
        }
    }

    private ArrayList<Parameter> getRemoteServerList(ConfigServersArrayParameter arrayParam) {
        ArrayList<Parameter> alist = new ArrayList<Parameter>();
        for (String name : this.m_installDataProp.stringPropertyNames()) {
            String value = this.m_installDataProp.getProperty(name);
            if (!name.startsWith("zkserver.") || value == null || value.length() <= 0) continue;
            this.addServerParam(arrayParam, alist, value);
        }
        return alist;
    }

    private boolean myIDFileExist() {
        try {
            ICCLConfiguration CCLCFGAPI = CCLConfigurationFactory.getInstance();
            File orgfile = new File(CCLCFGAPI.resolveEffectivePath(ZOOKEEPER_MYID));
            if (orgfile.exists()) {
                return true;
            }
        }
        catch (Exception e) {
            CnfgLog.error("Unable to locate the file '../configuration/data/myid'. " + e.toString());
        }
        return false;
    }

    private void addServerParam(ConfigServersArrayParameter arrayParam, ArrayList<Parameter> alist, String value) {
        Parameter param = arrayParam.createParamElement(arrayParam.getElemType());
        param.load(null, arrayParam.getMetaData());
        param.setValue(value);
        alist.add(param);
    }

    public Properties loadInstallDataFile() {
        Properties properties = new Properties();
        ICCLConfiguration CCLCFGAPI = CCLConfigurationFactory.getInstance();
        File pFile = new File(CCLCFGAPI.resolveEffectivePath(INSTALLDATA_PROPFILE));
        if (pFile.exists()) {
            try {
                FileInputStream fileInput = new FileInputStream(pFile);
                properties.load(fileInput);
                fileInput.close();
            }
            catch (Exception e) {
                CnfgLog.error("Exception when try to load installdata.properties file." + e.toString());
            }
        }
        return properties;
    }

    public void saveConfigServerInfo() throws DataManagerException {
        if (this.m_installDataProp == null) {
            this.m_installDataProp = this.loadInstallDataFile();
        }
        if (this.m_configServerParm != null) {
            int res = this.refreshInstallDataProps();
            this.backUpFile(INSTALLDATA_PROPFILE);
            this.updateInstallDataFile(this.m_installDataProp);
            if (res == 1) {
                this.backUpFile(ZOOKEEPER_MYID);
            }
        }
    }

    protected int refreshInstallDataProps() throws DataManagerException {
        this.cleanEntries("zkserver.");
        Set<Parameter> values = this.m_configServerParm.getCurrentValues();
        int idx = 0;
        for (Parameter p : values) {
            if (p == null) continue;
            String pvalue = (String)p.getValue();
            if (pvalue != null && pvalue.startsWith(LOCAL_CONFIG_SERVER)) {
                int res = this.handleLocalServer(pvalue);
                return res;
            }
            this.m_installDataProp.put("zkserver." + ++idx, pvalue);
        }
        if (idx > 0) {
            this.m_installDataProp.put(ZOOKEEPER_SERVERS_COUNT, String.valueOf(idx));
            if (this.cleanEntries("localZookeeper.")) {
                return 1;
            }
        }
        return 0;
    }

    protected int handleLocalServer(String value) throws DataManagerException {
        boolean raiseerror = false;
        if (value.equals(LOCAL_CONFIG_SERVER)) {
            if (this.isLocalServerConfigured()) {
                return 0;
            }
            raiseerror = true;
        } else {
            String[] newsettings = this.parseConfigServerSetting(value);
            if (newsettings == null) {
                raiseerror = true;
            } else if (this.updateLocalServerSettings(newsettings)) {
                return 1;
            }
        }
        if (raiseerror) {
            String sMessage = new StringBuffer(CnfgResource.getMessage("Message.localConfigServer.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
            throw new DataManagerException(sMessage);
        }
        return 0;
    }

    private boolean isLocalServerConfigured() {
        if (this.m_installDataProp == null) {
            return false;
        }
        String localclient = this.m_installDataProp.getProperty(LOCAL_ZOOKEEPER_CLIENTPORT);
        String localserver = this.m_installDataProp.getProperty(LOCAL_ZOOKEEPER_SERVERPORTS);
        return localclient != null && localclient.length() > 0 && localserver != null && localserver.length() > 0;
    }

    public String[] parseConfigServerSetting(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        String clientport = "";
        String serverport = "";
        String[] parts = value.split(";");
        if (parts.length != 2) {
            return null;
        }
        String part1 = parts[0];
        String part2 = parts[1];
        try {
            int i = Integer.parseInt(part2);
            clientport = String.valueOf(i);
        }
        catch (NumberFormatException n) {
            return null;
        }
        String[] hostports = part1.split(":");
        if (hostports.length != 3) {
            return null;
        }
        serverport = hostports[1] + ":" + hostports[2];
        return new String[]{clientport, serverport};
    }

    protected boolean updateLocalServerSettings(String[] newsettings) {
        String clientport = newsettings[0];
        String serverport = newsettings[1];
        String origClientPort = this.m_installDataProp.getProperty(LOCAL_ZOOKEEPER_CLIENTPORT);
        String origServerPorts = this.m_installDataProp.getProperty(LOCAL_ZOOKEEPER_SERVERPORTS);
        if (!(clientport.length() <= 0 || serverport.length() <= 0 || clientport.equals(origClientPort) && serverport.equals(origServerPorts))) {
            this.m_installDataProp.put(LOCAL_ZOOKEEPER_CLIENTPORT, clientport);
            this.m_installDataProp.put(LOCAL_ZOOKEEPER_SERVERPORTS, serverport);
            this.m_installDataProp.put(ZOOKEEPER_SERVERS_COUNT, "0");
            return true;
        }
        return false;
    }

    protected boolean cleanEntries(String namePrefix) {
        boolean bExist = false;
        Enumeration<Object> e = this.m_installDataProp.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(namePrefix)) continue;
            this.m_installDataProp.remove(key);
            bExist = true;
        }
        return bExist;
    }

    private boolean backUpFile(String fileName) {
        boolean success;
        block5: {
            success = false;
            try {
                ICCLConfiguration CCLCFGAPI = CCLConfigurationFactory.getInstance();
                File orgfile = new File(CCLCFGAPI.resolveEffectivePath(fileName));
                if (!orgfile.exists()) break block5;
                String timeStamp = new SimpleDateFormat("yyyyMMdd_kkmmss").format(new Date());
                try {
                    File bakfile = new File(orgfile.getCanonicalPath() + "_" + timeStamp);
                    if (!orgfile.renameTo(bakfile)) {
                        CnfgLog.error("Unable to rename file '" + orgfile.getName() + "' to '" + bakfile.getName() + "'.");
                        success = false;
                        break block5;
                    }
                    success = true;
                }
                catch (IOException e) {
                    CnfgLog.error("Unable to backup file '" + orgfile.getName() + "'. " + e.getMessage());
                    success = false;
                }
            }
            catch (Exception e) {
                CnfgLog.error("Unable to backup file '" + fileName + "'.");
                success = false;
            }
        }
        return success;
    }

    public void updateInstallDataFile(Properties properties) throws DataManagerException {
        try {
            ICCLConfiguration CCLCFGAPI = CCLConfigurationFactory.getInstance();
            File pFile = new File(CCLCFGAPI.resolveEffectivePath(INSTALLDATA_PROPFILE));
            FileOutputStream out = new FileOutputStream(pFile);
            this.storeProperties(properties, out, "Generated");
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            CnfgLog.error("Exception when try to save installData.properties file. " + e.toString());
            String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
            throw new DataManagerException(sMessage);
        }
    }

    public void storeProperties(Properties props, OutputStream out, String comments) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (comments != null) {
            bw.write("#");
            bw.write(comments);
            bw.newLine();
        }
        bw.write("#" + new Date().toString());
        bw.newLine();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)props.get(key);
            bw.write(key + "=" + val);
            bw.newLine();
        }
        bw.flush();
    }

    public void setInstallDataProp(Properties props) {
        this.m_installDataProp = props;
    }

    public Properties getInstallDataProp() {
        return this.m_installDataProp;
    }

    public void setCconfigServerParm(ConfigServersArrayParameter p) {
        this.m_configServerParm = p;
    }
}

