/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CnfgLog {
    private static boolean m_bDebugEnabled;
    static final String DEBUG_TAG = "Dbg";
    static final String ERROR_TAG = "Err";
    static final String INFO_TAG = "Info";

    public static void debug(String msg) {
        CnfgLog.output(System.out, DEBUG_TAG, msg);
    }

    public static void debug(Throwable t) {
        CnfgLog.output(System.out, DEBUG_TAG, t);
    }

    public static void error(String msg) {
        CnfgLog.output(System.err, ERROR_TAG, msg);
    }

    public static void error(Throwable t) {
        CnfgLog.output(System.err, ERROR_TAG, t);
    }

    public static void info(String msg) {
        CnfgLog.output(System.err, INFO_TAG, msg);
    }

    public static void info(Throwable t) {
        CnfgLog.output(System.err, INFO_TAG, t);
    }

    public static boolean isDebugEnabled() {
        return m_bDebugEnabled;
    }

    public static void enableDebug() {
        m_bDebugEnabled = true;
    }

    public static void redirectOutput(String dir, String filePrefix) {
        String sDebugFile = dir + "/" + filePrefix + ".log";
        try {
            File file = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(sDebugFile));
            File parent = new File(file.getParent());
            if (!parent.isDirectory() && !parent.mkdirs()) {
                return;
            }
            System.setErr(new PrintStream(new FileOutputStream(file, true)));
            System.setOut(System.err);
        }
        catch (FileNotFoundException e) {
            System.err.println(e.toString());
        }
    }

    private static void output(PrintStream ps, String msgType, String msg) {
        StringBuffer sb = new StringBuffer(CnfgLog.getTimeStamp()).append(",").append(msgType).append(",").append(msg);
        ps.println(sb.toString());
    }

    private static void output(PrintStream ps, String msgType, Throwable t) {
        final StringBuffer sb = new StringBuffer();
        PrintStream stream = new PrintStream(new OutputStream(){
            private int m_scan;

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (this.m_scan == 0) {
                    String s = new String(b, off, len);
                    sb.append(s).append(", ");
                    ++this.m_scan;
                } else {
                    String s = new String(b, off, len);
                    int pos = s.indexOf("com.cognos.crconfig");
                    if (CnfgLog.isDebugEnabled()) {
                        pos = 0;
                    }
                    if (pos != -1) {
                        sb.append(s.substring(pos));
                        ++this.m_scan;
                    }
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
            }

            @Override
            public void write(int b) throws IOException {
            }
        });
        sb.append(CnfgLog.getTimeStamp()).append(",").append(msgType).append(",");
        t.printStackTrace(stream);
        ps.println(sb.toString());
    }

    private static String getTimeStamp() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy','kk:mm:ss");
        return formatter.format(new Date());
    }
}

