/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgSwingAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class CnfgMenu
extends JMenu {
    private boolean m_bRetainDefaultBehaviour;
    EmptyBorder upBorder = new EmptyBorder(2, 2, 4, 2){

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.white);
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y, x, y + height - 2);
            g.setColor(Color.gray);
            g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 2);
            g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
        }
    };
    EmptyBorder downBorder = new EmptyBorder(2, 2, 4, 2){

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.gray);
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y, x, y + height - 2);
            g.setColor(Color.white);
            g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 2);
            g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
        }
    };
    EmptyBorder emptyBorder = new EmptyBorder(2, 2, 4, 2){

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }
    };
    EmptyBorder popupBorder = new EmptyBorder(2, 2, 3, 3){

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.white);
            g.drawLine(x + 1, y, x + width - 1, y);
            g.drawLine(x + 1, y, x + 1, y + height - 2);
            g.setColor(Color.gray);
            g.drawLine(x + width - 2, y + 2, x + width - 2, y + height - 2);
            g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
            g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
            g.drawLine(x + 2, y + height - 2, x + width - 3, y + height - 2);
        }
    };

    public CnfgMenu(String szLabel, KeyStroke acceleratorKey) {
        this(szLabel, acceleratorKey, false);
    }

    public CnfgMenu(String szLabel, KeyStroke acceleratorKey, boolean retainDefaultBehaviour) {
        super(szLabel);
        char accelerator;
        this.m_bRetainDefaultBehaviour = retainDefaultBehaviour;
        if (acceleratorKey != null) {
            this.setAccelerator(acceleratorKey);
        }
        if ((accelerator = CnfgResource.getLastAccelerator()) != '\u0000') {
            this.setMnemonic(CnfgResource.getLastAccelerator());
            this.setDisplayedMnemonicIndex(CnfgResource.getLastAcceleratorIndex());
        }
        this.initPopupMenuListener();
    }

    public JMenuItem addMenuItem(String szLabel, KeyStroke acceleratorKey, boolean bEnabled, CnfgSwingAction action) {
        char lastAccelerator = CnfgResource.getLastAccelerator();
        JMenuItem mi = this.addMenuItem(szLabel, lastAccelerator, acceleratorKey, bEnabled, action);
        mi.setDisplayedMnemonicIndex(CnfgResource.getLastAcceleratorIndex());
        return mi;
    }

    public JMenuItem addMenuItem(String szLabel, char lastAccelerator, KeyStroke acceleratorKey, boolean bEnabled, CnfgSwingAction action) {
        JMenuItem mi = this.add(action);
        mi.setText(szLabel);
        action.setEnabled(bEnabled);
        if (lastAccelerator != '\u0000') {
            mi.setMnemonic(lastAccelerator);
        }
        if (acceleratorKey != null) {
            mi.setAccelerator(acceleratorKey);
        }
        return mi;
    }

    public JCheckBoxMenuItem addCheckBoxMenuItem(String szLabel, KeyStroke acceleratorKey, boolean bEnabled, CnfgSwingAction action) {
        action.setEnabled(bEnabled);
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(action);
        mi.setText(szLabel);
        char accelerator = CnfgResource.getLastAccelerator();
        if (accelerator != '\u0000') {
            mi.setMnemonic(CnfgResource.getLastAccelerator());
            mi.setDisplayedMnemonicIndex(CnfgResource.getLastAcceleratorIndex());
        }
        if (acceleratorKey != null) {
            mi.setAccelerator(acceleratorKey);
        }
        this.add(mi);
        return mi;
    }

    public static JMenuItem addMenuItem(JPopupMenu popup, KeyStroke acceleratorKey, String szLabel, boolean bEnabled, CnfgSwingAction action) {
        JMenuItem mi = popup.add(action);
        String s = szLabel;
        if (s != null && s.length() != 0) {
            mi.setText(s);
        } else {
            mi.setText(szLabel);
        }
        mi.setIcon(null);
        if (acceleratorKey != null) {
            mi.setAccelerator(acceleratorKey);
        }
        action.setEnabled(bEnabled);
        return mi;
    }

    public void initPopupMenuListener() {
        this.setBorder(this.emptyBorder);
        this.getPopupMenu().setBorder(this.popupBorder);
        if (this.m_bRetainDefaultBehaviour) {
            return;
        }
        this.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                CnfgMenu.this.setBorder(CnfgMenu.this.emptyBorder);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                CnfgMenu.this.setBorder(CnfgMenu.this.emptyBorder);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                CnfgMenu.this.setBorder(CnfgMenu.this.downBorder);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (CnfgMenu.this.getBorder() == CnfgMenu.this.emptyBorder) {
                    CnfgMenu.this.setBorder(CnfgMenu.this.upBorder);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!CnfgMenu.this.getPopupMenu().isShowing()) {
                    CnfgMenu.this.setBorder(CnfgMenu.this.emptyBorder);
                }
            }
        });
    }
}

