/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

public class CnfgPreferences {
    private static final CnfgPreferences INSTANCE = new CnfgPreferences();
    File m_PrefsFile = null;
    private static final String CRCONFIG_PREFS_FILE = "../configuration/cogconfig.prefs";
    private static final String GS_PROPERTIES = "gs.properties";
    private Map<String, String> m_map = new Hashtable<String, String>();
    private Map<String, String> m_gsmap = new Hashtable<String, String>();

    public static CnfgPreferences getInstance() {
        return INSTANCE;
    }

    private CnfgPreferences() {
        String sLine;
        BufferedReader reader;
        InputStreamReader isr;
        FileInputStream fis;
        try {
            String sCRConfigPrefs = "../configuration/crconfig.prefs";
            File CRConfigPrefs = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(sCRConfigPrefs));
            if (CRConfigPrefs.exists()) {
                String sCogConfigPrefs = CRCONFIG_PREFS_FILE;
                File cogPrefsFile = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(sCogConfigPrefs));
                if (cogPrefsFile.exists()) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddkkmmss");
                    String timeStamp = formatter.format(new Date());
                    String sCogPrefsBak = "../configuration/cogconfig_" + timeStamp + "_backup.prefs";
                    if (!cogPrefsFile.renameTo(new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(sCogPrefsBak)))) {
                        Object[] arg = new Object[]{sCogConfigPrefs, sCogPrefsBak};
                        CnfgLog.error(CnfgResource.getMessage("Message.error.copy.file", arg));
                    }
                }
                if (!CRConfigPrefs.renameTo(new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(CRCONFIG_PREFS_FILE)))) {
                    Object[] arg = new Object[]{sCRConfigPrefs, CRCONFIG_PREFS_FILE};
                    CnfgLog.error(CnfgResource.getMessage("Message.error.copy.file", arg));
                }
            } else if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("crconfig.prefs was not found...");
            }
            this.m_PrefsFile = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(CRCONFIG_PREFS_FILE));
            fis = new FileInputStream(this.m_PrefsFile);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            reader = new BufferedReader(isr);
            sLine = reader.readLine();
            while (sLine != null) {
                int index;
                if (!sLine.trim().startsWith("#") && (index = sLine.indexOf("=")) != -1) {
                    this.m_map.put(sLine.substring(0, index), sLine.substring(index + 1));
                }
                sLine = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(e);
            }
            this.m_map.put("DebugExcludeInstalledCmpLst", "DM DMNETC DMNETS EPCONTRIBUTORSERVERPAS EPCONTRIBUTORSERVERPJS EPCONTRIBUTORSERVERPWS PLANSRVR PLANNINGANALYST8 PLANNINGANALYSTMANAGER8 PLANNINGCONTRIBADMIN8 CCD BV BVCLIENT TM1SERVER TM1ADMINSERVER PMPSVC TM1XLSRV");
        }
        catch (IOException e) {
            CnfgLog.error(e);
        }
        try {
            String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(GS_PROPERTIES);
            File gs = new File(sResolvedPath);
            if (gs.exists()) {
                fis = new FileInputStream(gs);
                isr = new InputStreamReader((InputStream)fis, "UTF-8");
                reader = new BufferedReader(isr);
                sLine = reader.readLine();
                while (sLine != null) {
                    int index;
                    if (!sLine.trim().startsWith(";") && (index = sLine.indexOf("=")) != -1) {
                        this.m_gsmap.put(sLine.substring(0, index), sLine.substring(index + 1));
                    }
                    sLine = reader.readLine();
                }
                reader.close();
            }
        }
        catch (FileNotFoundException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(e);
            }
        }
        catch (IOException e) {
            CnfgLog.error(e);
        }
    }

    public void setProperty(String sProperty, String sValue) {
        this.m_map.put(sProperty, sValue);
    }

    public void setProperty(String sProperty, double value) {
        StringBuffer sb = new StringBuffer().append(new Double(value).intValue());
        this.m_map.put(sProperty, sb.toString());
    }

    public void setProperty(String sProperty, Boolean value) {
        this.m_map.put(sProperty, value.toString());
    }

    public void setProperty(String sProperty, boolean value) {
        this.m_map.put(sProperty, Boolean.toString(value));
    }

    public String getProperty(String sProperty, String sDefault) {
        return (String)this.getProperty(sProperty, sDefault, String.class);
    }

    public String getProperty(String sProperty) {
        return (String)this.getProperty(sProperty, String.class);
    }

    public Object getProperty(String sProperty, Class convertTo) {
        return this.getProperty(sProperty, null, convertTo);
    }

    public boolean getProperty(String sProperty, boolean bDefault) {
        boolean bRetValue = bDefault;
        String sValue = this.m_map.get(sProperty);
        bRetValue = sValue == null ? bRetValue : Boolean.valueOf(sValue);
        return bRetValue;
    }

    public Object getProperty(String sProperty, String sDefault, Class convertTo) {
        String sValue = this.m_map.get(sProperty);
        if (sValue == null) {
            sValue = this.m_gsmap.get(sProperty);
        }
        String string = sValue = sValue == null ? sDefault : sValue;
        if (convertTo == Integer.class) {
            try {
                return new Integer(sValue);
            }
            catch (NumberFormatException e1) {
                try {
                    return new Integer(sDefault);
                }
                catch (NumberFormatException e2) {
                    return null;
                }
            }
        }
        if (convertTo == Boolean.class) {
            return new Boolean(sValue);
        }
        return sValue;
    }

    public void saveSettings() {
        if (this.m_PrefsFile == null) {
            try {
                this.m_PrefsFile = DataManager.getInstance().resolveEffectiveFilePath(CRCONFIG_PREFS_FILE);
            }
            catch (DataManagerException e) {
                CnfgLog.error(e);
                return;
            }
        }
        try {
            FileOutputStream fou = new FileOutputStream(this.m_PrefsFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fou, "UTF-8");
            BufferedWriter writer = new BufferedWriter(osw);
            for (String sKey : this.m_map.keySet()) {
                String sValue = this.m_map.get(sKey);
                writer.write(sKey + "=" + sValue + "\n");
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(e);
            }
        }
        catch (IOException e) {
            CnfgLog.error(e);
        }
    }
}

