/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.DataManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;

public class CnfgSplashScreen
extends Window {
    private int m_imgWidth;
    private int m_imgHeight;
    private Image m_splashImage;
    private String m_imgName;
    private static final int BORDERSIZE = 0;
    private static final Color BORDERCOLOR = Color.white;
    private Toolkit m_tk;

    public CnfgSplashScreen(Frame frame, String imgName, boolean closeOnKeyOrMouse) {
        super(frame);
        this.m_imgName = imgName;
        this.m_tk = Toolkit.getDefaultToolkit();
        this.setBackground(BORDERCOLOR);
        this.loadSplashImage();
        this.setFocusable(true);
        this.requestFocus();
        this.toFront();
        this.showSplashScreen();
        if (closeOnKeyOrMouse) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    CnfgSplashScreen.this.getOwner().setEnabled(true);
                }
            });
            frame.setEnabled(false);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    CnfgSplashScreen.this.setVisible(false);
                    CnfgSplashScreen.this.dispose();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    CnfgSplashScreen.this.setVisible(false);
                    CnfgSplashScreen.this.dispose();
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    CnfgSplashScreen.this.requestFocus();
                }
            });
        }
    }

    public void loadSplashImage() {
        MediaTracker tracker = new MediaTracker(this);
        ClassLoader cl = this.getClass().getClassLoader();
        Locale defLocale = CnfgResource.getLocale();
        String localeSpecificName = this.m_imgName + "_" + defLocale.getLanguage() + "-" + defLocale.getCountry() + ".png";
        File f = new File(DataManager.getInstance().getCfgApi().resolveEffectivePath(localeSpecificName));
        String absName = DataManager.getInstance().getCfgApi().resolveEffectivePath(this.m_imgName + "_en.png");
        if (f.exists()) {
            absName = localeSpecificName;
        } else {
            localeSpecificName = this.m_imgName + "_" + defLocale.getLanguage() + ".png";
            f = new File(DataManager.getInstance().getCfgApi().resolveEffectivePath(localeSpecificName));
            if (f.exists()) {
                absName = localeSpecificName;
            }
        }
        this.m_splashImage = this.m_tk.getImage(absName);
        tracker.addImage(this.m_splashImage, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            CnfgLog.error(e);
        }
        this.m_imgWidth = this.m_splashImage.getWidth(this);
        this.m_imgHeight = this.m_splashImage.getHeight(this);
    }

    public void showSplashScreen() {
        Dimension screenSize = this.m_tk.getScreenSize();
        int w = this.m_imgWidth + 0;
        int h = this.m_imgHeight + 0;
        int x = (screenSize.width - w) / 2;
        int y = (screenSize.height - h) / 2;
        this.setBounds(x, y, w, h);
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.m_splashImage, 0, 0, this.m_imgWidth, this.m_imgHeight, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void toFront() {
        super.toFront();
    }
}

