/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgComboBox;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgTableModel;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.DialogEditGlobalConfig;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.RenderHeader;
import com.cognos.crconfig.RendererParameterCustomize;
import com.cognos.crconfig.RendererParameterLabel;
import com.cognos.crconfig.RendererParameterValue;
import com.cognos.crconfig.TablePopupListener;
import com.cognos.crconfig.data.AliasRootsParameter;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.CnfgSelectionEvent;
import com.cognos.crconfig.data.CnfgSelectionListener;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.CnfgValueChangedListener;
import com.cognos.crconfig.data.ComplexFileURIParameter;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.FontsEmbedParameter;
import com.cognos.crconfig.data.FontsMapParameter;
import com.cognos.crconfig.data.Group;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.PathParameter;
import com.cognos.crconfig.data.SystemPasswordParameter;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.tenancy.TenancyInfoProviderParameter;
import com.cognos.crconfig.editors.EditorAliasRootURI;
import com.cognos.crconfig.editors.EditorAliasRoots;
import com.cognos.crconfig.editors.EditorArrayParameter;
import com.cognos.crconfig.editors.EditorBase;
import com.cognos.crconfig.editors.EditorCredential;
import com.cognos.crconfig.editors.EditorEncrypted;
import com.cognos.crconfig.editors.EditorFontEmbedBrowser;
import com.cognos.crconfig.editors.EditorFontsMap;
import com.cognos.crconfig.editors.EditorPathParameter;
import com.cognos.crconfig.editors.EditorSystemPassword;
import com.cognos.crconfig.editors.EditorTenancyInfo;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CnfgTable
extends JTable
implements CnfgSelectionListener,
CnfgValueChangedListener,
KeyListener {
    private static final long serialVersionUID = -2185432541465824483L;
    private Container m_parent;
    private final CnfgTableModel m_dataModel;
    private RenderHeader m_leftHeaderRender;
    private JTableHeader m_tableHeader;
    protected int m_rowIndex;
    protected int m_columnIndex;
    protected static Map<String, Font> m_lFonts = new HashMap<String, Font>();
    public static final int COL_GROUP = 0;
    public static final int COL_NAME = 1;
    public static final int COL_CUSTOM = 2;
    public static final int COL_VALUE = 3;
    public static final int COL_TOTAL_COUNT = 4;

    public CnfgTable(Dialog parent, CnfgTableModel dataModel) {
        super(dataModel);
        this.m_parent = parent;
        this.m_dataModel = dataModel;
        this.initUI();
    }

    public CnfgTable(CRConfigFrame parent, CnfgTableModel dataModel) {
        super(dataModel);
        this.m_parent = parent;
        this.m_dataModel = dataModel;
        this.initUI();
        if (parent.tablePopupMenu != null) {
            this.addMouseListener(new TablePopupListener(parent.tablePopupMenu, parent, this));
        }
    }

    private void initUI() {
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setAutoCreateColumnsFromModel(false);
        this.addKeyListener(this);
        this.m_tableHeader = this.getTableHeader();
        this.m_tableHeader.setReorderingAllowed(false);
        this.m_tableHeader.setResizingAllowed(true);
        this.initKeyActionMap();
        this.m_leftHeaderRender = new RenderHeader(2);
        this.m_tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int columnId;
                if (e.getClickCount() != 2) {
                    return;
                }
                TableColumn column = this.getResizingColumn(e.getPoint());
                if (column != null && ((columnId = column.getModelIndex()) == 3 || columnId == 1)) {
                    int maxStringWidth = 0;
                    String str = null;
                    str = columnId == 3 ? CnfgResource.getMessage("Label.value") : CnfgResource.getMessage("Label.property");
                    if (str != null) {
                        FontMetrics fm = CnfgTable.this.m_tableHeader.getFontMetrics(CnfgTable.this.getElementFont("PropertySheet.Header"));
                        maxStringWidth = SwingUtilities.computeStringWidth(fm, str);
                    }
                    for (int i = 0; i < CnfgTable.this.m_dataModel.getRowCount(); ++i) {
                        FontMetrics fm;
                        int wd;
                        Object value = CnfgTable.this.m_dataModel.getValueAt(i, columnId);
                        Parameter p = (Parameter)value;
                        String string = "";
                        if (columnId == 3) {
                            string = p.isEncrypted() || p.getClass() == CredentialParameter.class || p.getClass() == SystemPasswordParameter.class ? "***************" : p.getDisplayValue();
                        } else if (columnId == 1) {
                            string = value.getClass() == TemplatedParameter.class ? ((TemplatedParameter)value).getFormattedLabel() : p.getLabel();
                        } else {
                            return;
                        }
                        if (string == null) continue;
                        Font f = CnfgTable.this.getElementFont(p.getClass().getName());
                        if (f == null && (f = CnfgTable.this.getElementFont(Parameter.class.getName())) == null) {
                            f = CnfgTable.this.getFont();
                        }
                        if (maxStringWidth >= (wd = SwingUtilities.computeStringWidth(fm = CnfgTable.this.m_tableHeader.getFontMetrics(f), string))) continue;
                        maxStringWidth = wd;
                    }
                    if (maxStringWidth > 0) {
                        column.setPreferredWidth(maxStringWidth + 6);
                    }
                }
            }

            private TableColumn getResizingColumn(Point p) {
                return this.getResizingColumn(p, CnfgTable.this.m_tableHeader.getColumnModel().getColumnIndexAtX(p.x));
            }

            private TableColumn getResizingColumn(Point p, int column) {
                int columnIndex;
                if (column == -1) {
                    return null;
                }
                Rectangle r = CnfgTable.this.m_tableHeader.getHeaderRect(column);
                r.grow(-3, 0);
                if (r.contains(p)) {
                    return null;
                }
                int midPoint = r.x + r.width / 2;
                int n = columnIndex = p.x < midPoint ? column - 1 : column;
                if (columnIndex == -1) {
                    return null;
                }
                return CnfgTable.this.m_tableHeader.getColumnModel().getColumn(columnIndex);
            }
        });
        Enumeration<TableColumn> e = this.m_tableHeader.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            TableColumn tc = e.nextElement();
            int idx = tc.getModelIndex();
            if (idx == 0) {
                Integer iGroupWidthTableCell = (Integer)CnfgPreferences.getInstance().getProperty("GroupWidthTableCell", Integer.class);
                if (iGroupWidthTableCell != null) {
                    tc.setPreferredWidth(iGroupWidthTableCell);
                }
                tc.setMaxWidth(16);
                tc.setResizable(true);
                tc.setHeaderRenderer(this.m_leftHeaderRender);
                continue;
            }
            if (idx == 1) {
                tc.setMinWidth(80);
                Integer iNameWidthTableCell = (Integer)CnfgPreferences.getInstance().getProperty("NameWidthTableCell", Integer.class);
                if (iNameWidthTableCell != null) {
                    tc.setPreferredWidth(iNameWidthTableCell);
                } else {
                    tc.setPreferredWidth(200);
                }
                tc.setResizable(true);
                tc.setHeaderRenderer(this.m_leftHeaderRender);
                continue;
            }
            if (idx == 2) {
                tc.setMaxWidth(23);
                tc.setResizable(false);
                tc.setHeaderRenderer(this.m_leftHeaderRender);
                continue;
            }
            if (idx != 3) continue;
            tc.setMinWidth(80);
            tc.setResizable(true);
            Integer iValueWidthTableCell = (Integer)CnfgPreferences.getInstance().getProperty("ValueWidthTableCell", Integer.class);
            if (iValueWidthTableCell != null) {
                tc.setPreferredWidth(iValueWidthTableCell);
            } else {
                tc.setPreferredWidth(250);
            }
            tc.setHeaderRenderer(this.m_leftHeaderRender);
        }
        this.setAutoResizeMode(0);
        this.setCnfgTableHeight();
    }

    private void initKeyActionMap() {
        InputMap im = this.getInputMap(1);
        ActionMap am = this.getActionMap();
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
        im.put(tab, "selectNextRow");
        im.put(shiftTab, "selectPreviousRow");
        am.put("selectNextRow", new SelectNextRow(this));
        am.put("selectPreviousRow", new SelectPreviousRow(this));
    }

    public void setPreferences() {
        if (this.m_tableHeader != null) {
            Enumeration<TableColumn> e = this.m_tableHeader.getColumnModel().getColumns();
            while (e.hasMoreElements()) {
                TableColumn tc = e.nextElement();
                int idx = tc.getModelIndex();
                if (idx == 0) {
                    CnfgPreferences.getInstance().setProperty("GroupWidthTableCell", tc.getPreferredWidth());
                    continue;
                }
                if (idx == 1) {
                    CnfgPreferences.getInstance().setProperty("NameWidthTableCell", tc.getPreferredWidth());
                    continue;
                }
                if (idx != 3) continue;
                CnfgPreferences.getInstance().setProperty("ValueWidthTableCell", tc.getPreferredWidth());
            }
        }
    }

    @Override
    public void selectionChanged(CnfgSelectionEvent e) {
        TableCellEditor tceTable = this.getCellEditor();
        if (tceTable != null) {
            tceTable.stopCellEditing();
        }
        this.removeEditor();
        Object o = e.getSource();
        if (Folder.class.isInstance(o)) {
            Folder currentFolder = (Folder)e.getSource();
            this.m_dataModel.buildDisplayData(currentFolder);
        }
    }

    @Override
    public void valueChanged(CnfgValueChangedEvent e) {
        this.removeEditor();
        Object o = e.getSource();
        if (Folder.class.isInstance(o)) {
            this.m_dataModel.fireTableRowsUpdated(0, this.m_dataModel.getRowCount() - 1);
        } else if (Parameter.class.isInstance(o)) {
            this.m_dataModel.fireTableRowsUpdated(this.getSelectedRow(), this.getSelectedRow());
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Color tableLineColor = CnfgUtils.isWindowsPlatform() ? SystemColor.control : Color.lightGray;
        if (column == 1 || column == 0) {
            return new RendererParameterLabel(2, tableLineColor, 1);
        }
        if (column == 2) {
            return new RendererParameterCustomize(tableLineColor);
        }
        if (column == 3) {
            return new RendererParameterValue(2, tableLineColor);
        }
        return new DefaultTableCellRenderer();
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        Parameter parm = this.m_dataModel.getItem(row);
        if (column == 3) {
            if (parm.getClass() == CredentialParameter.class) {
                CnfgButton button = CnfgButton.createEditButton(parm);
                JPasswordField pwdField = new JPasswordField();
                pwdField.setEchoChar('*');
                return new EditorCredential(this.m_parent, pwdField, false, button);
            }
            if (parm.getClass() == SystemPasswordParameter.class) {
                CnfgButton button = CnfgButton.createEditButton(parm);
                JPasswordField pwdField = new JPasswordField();
                pwdField.setEchoChar('*');
                return new EditorSystemPassword(this.m_parent, pwdField, false, button);
            }
            if (parm.getClass() == FontsMapParameter.class) {
                CnfgButton button = CnfgButton.createEditButton(parm);
                Object[] args = new Object[]{parm.getLabel()};
                String title = CnfgResource.getMessage("Title.DialogEditValue.Parameter", args);
                return new EditorFontsMap(this.m_parent, new JTextField(), false, button, title);
            }
            if (parm.getClass() == AliasRootsParameter.class) {
                CnfgButton button = CnfgButton.createEditButton(parm);
                Object[] args = new Object[]{parm.getLabel()};
                String title = CnfgResource.getMessage("Title.DialogEditValue.Parameter", args);
                return new EditorAliasRoots(this.m_parent, new JTextField(), false, button, title);
            }
            if (parm.getClass() == ComplexFileURIParameter.class) {
                CnfgButton button = CnfgButton.createEditButton(parm);
                return new EditorAliasRootURI(this.m_parent, new JTextField(), button, (ComplexFileURIParameter)parm);
            }
            if (parm.getClass() == TenancyInfoProviderParameter.class) {
                CnfgButton button = CnfgButton.createEditButton(parm);
                return new EditorTenancyInfo(this.m_parent, new JTextField(), button, (TenancyInfoProviderParameter)parm);
            }
            if (parm.getClass() == FontsEmbedParameter.class) {
                CnfgButton button = CnfgButton.createEditButton(parm);
                Object[] args = new Object[]{parm.getLabel()};
                DataManager dm = DataManager.getInstance();
                Parameter parm2 = parm.getName().compareToIgnoreCase("brsPDFEmbeddableFonts") == 0 ? dm.findParm("brsPDFNonEmbeddableFonts") : dm.findParm("rsPDFNonEmbeddableFonts");
                String title = CnfgResource.getMessage("Title.DialogEditValue.Parameter", args);
                return new EditorFontEmbedBrowser(this.m_parent, new JTextField(), false, button, title, parm, parm2);
            }
            if (parm instanceof ArrayParameter) {
                CnfgButton button = CnfgButton.createEditButton(parm);
                return new EditorArrayParameter(this.m_parent, new JTextField(), false, button, (ArrayParameter)parm);
            }
            if (parm.getClass() == PathParameter.class) {
                CnfgButton button = CnfgButton.createEditButton(parm);
                return new EditorPathParameter(this.m_parent, new JTextField(), true, button, (PathParameter)parm);
            }
            if (parm.getValues() != null) {
                CnfgComboBox cbox = new CnfgComboBox();
                cbox.setBackground(this.getBackground());
                return new EditorBase(this.m_parent, cbox);
            }
            if (parm.isEncrypted()) {
                CnfgButton button = CnfgButton.createEditButton(parm);
                JPasswordField pwdField = new JPasswordField();
                pwdField.setEchoChar('*');
                return new EditorEncrypted(this.m_parent, pwdField, false, button);
            }
            return new EditorBase(this.m_parent, new JTextField());
        }
        return null;
    }

    @Override
    public void editingStopped(ChangeEvent ce) {
        TableCellEditor editor;
        int iRow = this.getEditingRow();
        if (iRow != -1 && (editor = this.getCellEditor()) != null) {
            Object value = editor.getCellEditorValue();
            if (value != null) {
                Parameter parm = this.m_dataModel.getItem(iRow);
                boolean bRetVal = true;
                if (!parm.isEqual(value)) {
                    bRetVal = parm.setValue(value);
                    if (DialogEditGlobalConfig.class.isInstance(this.m_parent)) {
                        ((DialogEditGlobalConfig)this.m_parent).setDirtyFlag(true);
                        CnfgValueChangedEvent vce = new CnfgValueChangedEvent(parm);
                        this.valueChanged(vce);
                    }
                }
                this.removeEditor();
                this.getSelectionModel().setSelectionInterval(iRow, iRow);
                if (!bRetVal) {
                    ArrayList<String> lMsg = new ArrayList<String>(parm.getErrorMsg());
                    lMsg.add(0, CnfgResource.getMessage("Message.errorOnValidation.info"));
                    DialogMessage.showDialog(lMsg, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_NOARGS, 0);
                }
            } else {
                this.removeEditor();
                this.getSelectionModel().setSelectionInterval(iRow, iRow);
            }
        }
        this.repaint();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.m_leftHeaderRender != null) {
            this.m_leftHeaderRender.setFont(f);
        }
        Font fb = f.deriveFont(1);
        m_lFonts.put(Group.class.getName(), fb);
        m_lFonts.put(Parameter.class.getName(), f);
        m_lFonts.put("PropertySheet.Header", f);
    }

    public Font getElementFont(String name) {
        Font obj = name == null ? null : m_lFonts.get(name);
        return obj;
    }

    public void setCnfgTableHeight() {
        int height = CnfgFontSetting.getMaxHeight(this.getFont());
        if (height < CnfgButton.m_imageEdit.getIconHeight()) {
            this.setRowHeight(CnfgButton.m_imageEdit.getIconHeight());
        } else {
            this.setRowHeight(height);
        }
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (columnIndex != 0) {
            this.m_columnIndex = 0;
        }
        this.m_rowIndex = rowIndex;
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object obj = e.getSource();
        int key = e.getKeyCode();
        if (CnfgTable.class.isInstance(obj)) {
            if (key == 113 || key >= 65 && key <= 90 || key >= 48 && key <= 57 || key >= 96 && key <= 105) {
                this.m_columnIndex = 3;
                super.changeSelection(this.m_rowIndex, this.m_columnIndex, false, false);
            } else if (key == 121 && (e.getModifiers() & 1) != 0 && CRConfigFrame.class.isInstance(this.m_parent)) {
                CRConfigFrame frame = (CRConfigFrame)this.m_parent;
                e.consume();
                this.requestFocus();
                int row = this.getSelectedRow();
                if (row != -1) {
                    Point p1 = this.m_parent.getLocationOnScreen();
                    Point p2 = this.getLocationOnScreen();
                    int x = p2.x - p1.x + this.getWidth() / 2;
                    int y = p2.y - p1.y + this.getRowHeight(row) * this.m_rowIndex;
                    frame.tablePopupMenu.show(this.m_parent, x, y);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    class SelectPreviousRow
    extends AbstractAction {
        private static final long serialVersionUID = 1767360941724503210L;
        JTable table;

        public SelectPreviousRow(JTable aTable) {
            this.table = aTable;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.table.isEditing() && !this.table.getCellEditor().stopCellEditing()) {
                return;
            }
            int row = this.table.getSelectedRow();
            row = row == 0 ? this.table.getModel().getRowCount() - 1 : --row;
            this.table.changeSelection(row, 0, false, false);
        }
    }

    class SelectNextRow
    extends AbstractAction {
        private static final long serialVersionUID = -4334823552487496577L;
        JTable table;

        public SelectNextRow(JTable aTable) {
            this.table = aTable;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.table.isEditing() && !this.table.getCellEditor().stopCellEditing()) {
                return;
            }
            int row = this.table.getSelectedRow();
            row = row == this.table.getModel().getRowCount() - 1 ? 0 : ++row;
            this.table.changeSelection(row, 0, false, false);
        }
    }
}

