/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.dom4j.Element;

public class CnfgTableModel
extends AbstractTableModel {
    private int[] m_iIndexes;
    private ArrayList m_displayData = new ArrayList();

    public void buildDisplayData(Folder f) {
        Parameter p;
        int i;
        this.m_displayData.clear();
        if (f == null) {
            return;
        }
        if (f.isGlobal()) {
            for (i = 0; i < f.getParameters().size(); ++i) {
                p = f.getParameters().get(i);
                if (p.getDisabled()) continue;
                this.m_displayData.add(p);
            }
        } else {
            for (i = 0; i < f.getParameters().size(); ++i) {
                p = f.getParameters().get(i);
                if (p.getDisabled() || !p.getVisibility()) continue;
                this.m_displayData.add(p);
            }
        }
        this.m_iIndexes = new int[this.m_displayData.size()];
        for (int iIndex = 0; iIndex < this.m_displayData.size(); ++iIndex) {
            this.m_iIndexes[iIndex] = iIndex;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.m_displayData.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int iRow, int iCol) {
        this.getIndexes();
        if (this.m_displayData.size() > 0 && this.m_displayData.size() > this.m_iIndexes[iRow]) {
            Parameter p = (Parameter)this.m_displayData.get(this.m_iIndexes[iRow]);
            return p;
        }
        return null;
    }

    public Parameter getItem(int iIndex) {
        if (iIndex < 0) {
            return null;
        }
        this.getIndexes();
        if (this.m_displayData.size() > 0 && this.m_displayData.size() > this.m_iIndexes[iIndex]) {
            return (Parameter)this.m_displayData.get(this.m_iIndexes[iIndex]);
        }
        return null;
    }

    public int[] getIndexes() {
        int iRowCount = this.getRowCount();
        if (this.m_iIndexes != null && this.m_iIndexes.length == iRowCount) {
            return this.m_iIndexes;
        }
        this.m_iIndexes = new int[iRowCount];
        for (int i = 0; i < iRowCount; ++i) {
            this.m_iIndexes[i] = i;
        }
        return this.m_iIndexes;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 3) {
            Parameter p = this.getItem(row);
            return !p.isReadOnly();
        }
        return false;
    }

    protected String getCaption() {
        return "";
    }

    protected void load(Element parentElement) {
    }

    protected void cancelParamChanges() {
    }

    protected void save(Element parentElement) throws DataManagerException {
    }

    protected boolean isValid() {
        return true;
    }

    protected int getLastErrorRow() {
        return 0;
    }

    protected int getLastErrorCol() {
        return 0;
    }

    protected List<String> getLastErrorMessage() {
        return new ArrayList<String>();
    }
}

