/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgActionClient;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgCheckLogsFromTomcat;
import com.cognos.crconfig.CnfgCheckLogsThread;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPlatform;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgTaskFeedback;
import com.cognos.crconfig.CnfgTaskLabel;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionEngine;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.ICnfgAction;
import com.cognos.crconfig.data.Parameter;
import com.cognos.i18n.ui.I18NTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CnfgTaskDialog
extends JDialog
implements CnfgActionClient {
    private static final long serialVersionUID = 1L;
    private static String[] m_detailsCaption = new String[2];
    private static char[] m_detailsAccel = new char[2];
    private static int[] m_detailsAccelIndex = new int[2];
    private static final int PREFERRED_WIDTH = 290;
    private static final int PREFERRED_HEIGHT = 144;
    private CnfgActionEngine m_engine;
    private CnfgTaskFeedback m_feedback;
    private ICnfgAction m_currentAction;
    private CnfgTaskLabel m_currentTask;
    private List<CnfgTaskLabel> m_taskList = new ArrayList<CnfgTaskLabel>();
    private JLabel m_icon;
    private JPanel m_detailsPanel;
    private I18NTextArea m_detailsView;
    private JPanel m_taskPanel;
    private JScrollPane m_scrollTaskPane;
    private CnfgButton m_closeButton;
    private CnfgButton m_continueButton;
    private CnfgButton m_detailsButton;
    private CnfgCheckLogsThread m_viewThread;
    private CnfgCheckLogsFromTomcat m_viewTomcat;
    private JLabel m_messageLabel;
    private Font m_normalFont = CnfgFontSetting.getAdminFont();
    private Font m_boldFont = CnfgFontSetting.getAdminBoldFont();
    private boolean m_cancellable;
    private boolean m_bIsCancelled;
    private boolean m_isLastTaskRunning;
    private JPanel upperPanel;
    private int DEFAULT_FEEDBACK_PORT = 9363;
    private DatagramSocket m_ds;
    private boolean m_bFoundFeedBackPort = false;
    protected int m_port = this.DEFAULT_FEEDBACK_PORT;
    private int m_numFailedTasks = 0;
    private int m_tasksLeft = 0;
    private boolean m_engineIsPaused = false;
    private boolean m_scrollDetailsNeeded = false;
    private boolean m_updatedCurrentTask = false;
    private boolean autoCloseOnNoError;

    public boolean isAutoCloseOnNoError() {
        return this.autoCloseOnNoError;
    }

    public void setAutoCloseOnNoError(boolean autoCloseOnNoError) {
        this.autoCloseOnNoError = autoCloseOnNoError;
    }

    @Override
    public void setEnginePaused(boolean value) {
        boolean old = this.m_engineIsPaused;
        this.m_engineIsPaused = value;
        this.firePropertyChange("enginePaused", old, value);
    }

    public void setScrollDetailsNeeded(boolean value) {
        boolean old = this.m_scrollDetailsNeeded;
        this.m_scrollDetailsNeeded = value;
        this.firePropertyChange("scrollDetailsNeeded", old, value);
    }

    public void setUpdatedCurrentTask(boolean value) {
        boolean old = this.m_updatedCurrentTask;
        this.m_updatedCurrentTask = value;
        this.firePropertyChange("updatedCurrentTask", old, value);
    }

    public CnfgTaskDialog(Frame parent) {
        super(parent, CnfgResource.getMessage("Application.title"), true);
    }

    @Override
    public void setEngine(CnfgActionEngine engine) {
        this.m_engine = engine;
    }

    @Override
    protected void dialogInit() {
        super.dialogInit();
        this.setResizable(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.addPropertyChangeListener("enginePaused", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Boolean newValue = (Boolean)e.getNewValue();
                if (newValue.booleanValue()) {
                    CnfgTaskDialog.this.pauseToCloseOrContinue();
                    CnfgTaskDialog.this.m_engine.pause();
                } else {
                    CnfgTaskDialog.this.continueRunning();
                    CnfgTaskDialog.this.m_engineIsPaused = false;
                }
            }
        });
        this.addPropertyChangeListener("scrollDetailsNeeded", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Boolean newValue = (Boolean)e.getNewValue();
                if (newValue.booleanValue() && CnfgTaskDialog.this.m_detailsView.isVisible()) {
                    CnfgTaskDialog.this.m_detailsView.updateUI();
                    Container c = CnfgTaskDialog.this.m_detailsView.getParent();
                    JScrollPane scrollPane = (JScrollPane)c.getParent();
                    JScrollBar sb = scrollPane.getVerticalScrollBar();
                    int sbMax = sb.getMaximum();
                    if (sbMax > 0) {
                        sb.setValue(sbMax);
                    }
                    scrollPane.repaint();
                }
                CnfgTaskDialog.this.m_scrollDetailsNeeded = false;
            }
        });
        this.addPropertyChangeListener("updatedCurrentTask", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int listSize = CnfgTaskDialog.this.m_taskList.size();
                int index = listSize - CnfgTaskDialog.this.m_tasksLeft;
                if (index >= 5) {
                    JScrollBar js = CnfgTaskDialog.this.m_scrollTaskPane.getVerticalScrollBar();
                    js.setValue(js.getMaximum() / listSize * index);
                    CnfgTaskDialog.this.m_scrollTaskPane.getParent().repaint();
                }
                CnfgTaskDialog.this.m_updatedCurrentTask = false;
            }
        });
        this.upperPanel = new JPanel();
        this.upperPanel.setLayout(new GridBagLayout());
        this.upperPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_icon = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(68, 68);
            }
        };
        this.m_icon.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.upperPanel.add((Component)this.m_icon, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.m_messageLabel = new JLabel(CnfgResource.getMessage("Label.DialogSave.message"));
        this.m_messageLabel.setBorder(new EmptyBorder(10, 0, 10, 10));
        this.m_messageLabel.setFocusable(true);
        this.upperPanel.add((Component)this.m_messageLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(10, 0, 0, 10), 0, 0));
        this.m_taskPanel = new JPanel(new GridBagLayout());
        this.m_taskPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_scrollTaskPane = new JScrollPane(this.m_taskPanel);
        this.m_scrollTaskPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_scrollTaskPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_scrollTaskPane.setHorizontalScrollBarPolicy(30);
        this.m_scrollTaskPane.setVerticalScrollBarPolicy(20);
        this.m_scrollTaskPane.setPreferredSize(new Dimension(290, 144));
        this.upperPanel.add((Component)this.m_scrollTaskPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.m_closeButton = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
        this.m_closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CnfgTaskDialog.this.Terminate();
            }
        });
        this.m_continueButton = new CnfgButton(CnfgResource.getMessage("Label.ButtonContinue"));
        this.m_continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CnfgTaskDialog.this.m_continueButton.setEnabled(false);
                CnfgTaskDialog.this.m_engine.continueRunning();
            }
        });
        this.m_continueButton.setVisible(false);
        this.m_detailsButton = new CnfgButton(m_detailsCaption[0], m_detailsAccel[0]);
        this.m_detailsButton.setDisplayedMnemonicIndex(m_detailsAccelIndex[0]);
        this.m_detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CnfgTaskDialog.this.m_detailsPanel.isVisible()) {
                    CnfgTaskDialog.this.m_detailsPanel.setVisible(false);
                    CnfgTaskDialog.this.m_detailsButton.setText(m_detailsCaption[0]);
                    CnfgTaskDialog.this.m_detailsButton.setMnemonic(m_detailsAccel[0]);
                    CnfgTaskDialog.this.m_detailsButton.setDisplayedMnemonicIndex(m_detailsAccelIndex[0]);
                    CnfgTaskDialog.this.packIt();
                    CnfgTaskDialog.this.nudgeDialog(-1);
                } else {
                    CnfgTaskDialog.this.m_detailsPanel.setVisible(true);
                    CnfgTaskDialog.this.m_detailsButton.setText(m_detailsCaption[1]);
                    CnfgTaskDialog.this.m_detailsButton.setMnemonic(m_detailsAccel[1]);
                    CnfgTaskDialog.this.m_detailsButton.setDisplayedMnemonicIndex(m_detailsAccelIndex[1]);
                    CnfgTaskDialog.this.packIt();
                    CnfgTaskDialog.this.nudgeDialog(1);
                }
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 0));
        buttonPanel.add(this.m_continueButton);
        buttonPanel.add(this.m_closeButton);
        buttonPanel.add(this.m_detailsButton);
        buttonPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.upperPanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 14, 2, new Insets(0, 5, 10, 5), 0, 0));
        this.m_detailsPanel = new JPanel(new BorderLayout());
        this.m_detailsPanel.setVisible(false);
        this.m_detailsView = new I18NTextArea(8, 0, CnfgResource.getLocale());
        this.m_detailsView.setLineWrap(true);
        this.m_detailsView.setWrapStyleWord(true);
        this.m_detailsView.setEditable(false);
        JScrollPane detailsScrollPane = new JScrollPane((Component)this.m_detailsView);
        this.m_detailsPanel.add((Component)detailsScrollPane, "Center");
        this.m_detailsPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        this.getContentPane().add((Component)this.upperPanel, "North");
        this.getContentPane().add((Component)this.m_detailsPanel, "Center");
        ((JComponent)this.getContentPane()).registerKeyboardAction(new CancelListener(), KeyStroke.getKeyStroke(27, 0), 2);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CnfgTaskDialog.this.Terminate();
            }
        });
        this.packIt();
    }

    private void reset() {
        this.m_detailsButton.setEnabled(false);
        this.m_detailsPanel.setVisible(false);
        this.m_detailsButton.setText(m_detailsCaption[0]);
        this.m_detailsButton.setMnemonic(m_detailsAccel[0]);
        this.m_detailsButton.setDisplayedMnemonicIndex(m_detailsAccelIndex[0]);
        this.packIt();
        this.nudgeDialog(-1);
        this.m_detailsView.getDocument().addDocumentListener(new DetailsViewListener());
    }

    private void packIt() {
        CnfgUtils.pack(this);
    }

    public void Terminate() {
        this.m_continueButton.setVisible(false);
        if (!this.m_cancellable && this.m_currentAction != null && this.m_currentAction.getStatus() != 2) {
            if (this.m_currentAction.getStatus() <= 1) {
                return;
            }
            if (this.m_currentAction.getStatus() == 3) {
                System.exit(1);
            }
        } else {
            if (this.m_currentAction != null && this.m_currentAction.getStatus() == 1) {
                if (this.m_bIsCancelled || this.m_isLastTaskRunning) {
                    return;
                }
                this.m_closeButton.setEnabled(false);
                this.m_engine.cancel();
                if (!this.m_detailsPanel.isVisible()) {
                    this.m_detailsPanel.setVisible(true);
                    this.m_detailsButton.setText(m_detailsCaption[1]);
                    this.m_detailsButton.setMnemonic(m_detailsAccel[1]);
                    this.m_detailsButton.setDisplayedMnemonicIndex(m_detailsAccelIndex[1]);
                    this.packIt();
                    this.nudgeDialog(1);
                }
                return;
            }
            this.stopViewLogs();
            this.m_engine.cancel();
            this.setVisible(false);
        }
    }

    @Override
    public void show() {
        if (this.m_taskList.size() > 0) {
            CnfgUtils.pack(this);
            this.setLocationRelativeTo(this.getParent());
            this.reset();
            super.show();
        }
    }

    private void nudgeDialog(int value) {
        if (CnfgPlatform.isJava13VM() && (CnfgPlatform.isHPUXPlatform() || CnfgPlatform.isSolarisPlatform())) {
            Point p = this.getLocation();
            p.translate(0, value);
            this.setLocation(p);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = d.width < 450 ? 450 : d.width;
        return d;
    }

    @Override
    public void begin() {
        String sActionName;
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CnfgTaskDialog::begin()");
        }
        this.m_closeButton.setText(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
        this.m_closeButton.setMnemonic(0);
        this.m_closeButton.setEnabled(this.m_cancellable);
        this.setDefaultCloseOperation(0);
        this.m_icon.setIcon(CnfgTaskLabel.getIconMap().get("progress.gif"));
        String string = sActionName = this.m_currentAction != null ? this.m_currentAction.getName() : "";
        if (sActionName.equalsIgnoreCase("start") || sActionName.equalsIgnoreCase("restart")) {
            this.m_viewTomcat = new CnfgCheckLogsFromTomcat(this.getFeedback(), sActionName);
            this.m_viewTomcat.start();
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Calling m_viewTomcat start..");
            }
        }
        if (this.m_bFoundFeedBackPort && sActionName.equalsIgnoreCase("start") || sActionName.equalsIgnoreCase("stop") || sActionName.equalsIgnoreCase("restart")) {
            this.m_viewThread = new CnfgCheckLogsThread(this.getFeedback(), sActionName, this.m_ds);
            this.m_viewThread.start();
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Calling m_viewThread start..");
            }
        }
        this.m_bIsCancelled = false;
        this.m_numFailedTasks = 0;
        this.show();
    }

    public void stopViewLogs() {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CnfgTaskDialog::stopViewLogs()");
        }
        if (this.m_viewTomcat != null) {
            block7: {
                this.m_viewTomcat.interrupt();
                try {
                    this.m_viewTomcat.join();
                }
                catch (InterruptedException e) {
                    if (!CnfgLog.isDebugEnabled()) break block7;
                    CnfgLog.debug(e);
                }
            }
            this.m_viewTomcat = null;
        }
        if (this.m_viewThread != null) {
            block8: {
                this.m_viewThread.interrupt();
                try {
                    this.m_viewThread.join();
                }
                catch (InterruptedException e) {
                    if (!CnfgLog.isDebugEnabled()) break block8;
                    CnfgLog.debug(e);
                }
            }
            this.m_viewThread = null;
        }
    }

    @Override
    public void end() {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CnfgTaskDialog::end()");
        }
        this.m_isLastTaskRunning = false;
        if (this.m_bIsCancelled) {
            this.m_bIsCancelled = false;
            this.setVisible(false);
            this.stopViewLogs();
            return;
        }
        int actionStatus = this.m_currentAction.getStatus();
        if (3 == actionStatus) {
            this.m_icon.setIcon(CnfgTaskLabel.getIconMap().get("dialog.failed"));
        } else {
            this.m_icon.setIcon(CnfgTaskLabel.getIconMap().get("dialog.information"));
        }
        if (this.isAutoCloseOnNoError() && 3 != actionStatus) {
            this.setAutoCloseOnNoError(false);
            this.Terminate();
        }
        if (!this.m_cancellable) {
            if (3 == actionStatus) {
                this.m_closeButton.setText(CnfgResource.getMessage("Label.ButtonExit"));
                this.m_closeButton.setMnemonic(CnfgResource.getLastAccelerator());
                this.m_closeButton.setDisplayedMnemonicIndex(CnfgResource.getLastAcceleratorIndex());
            } else {
                this.m_closeButton.setText(CnfgResource.getMessage("Label.ButtonContinue"));
                this.m_closeButton.setMnemonic(CnfgResource.getLastAccelerator());
                this.m_closeButton.setDisplayedMnemonicIndex(CnfgResource.getLastAcceleratorIndex());
            }
        } else {
            this.m_closeButton.setText(CnfgResource.getMessage("Label.ButtonClose"));
            this.m_closeButton.setMnemonic(CnfgResource.getLastAccelerator());
            this.m_closeButton.setDisplayedMnemonicIndex(CnfgResource.getLastAcceleratorIndex());
        }
        this.m_closeButton.setEnabled(true);
        this.setDefaultCloseOperation(1);
    }

    private CnfgTaskLabel findTaskLabel(ICnfgTask task) {
        if (null != task) {
            for (int i = 0; i < this.m_taskList.size(); ++i) {
                CnfgTaskLabel tl = this.m_taskList.get(i);
                if (!task.equals(tl.m_task)) continue;
                return tl;
            }
        }
        return null;
    }

    @Override
    public void updateTaskStatus(ICnfgTask task, int status) {
        CnfgTaskLabel tl;
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CnfgTaskDialog::updateTaskStatus(), status is " + status);
        }
        if (null != (tl = this.findTaskLabel(task))) {
            if (3 == status) {
                ++this.m_numFailedTasks;
                tl.setFont(this.m_normalFont);
                if (this.m_currentTask.m_task.isMandatory()) {
                    tl.setIcon(CnfgTaskLabel.getIconMap().get("symbol_error.gif"));
                } else {
                    tl.setIcon(CnfgTaskLabel.getIconMap().get("symbol_warning.gif"));
                }
                if (this.m_currentTask == tl) {
                    this.m_currentTask = null;
                }
            } else if (2 == status) {
                tl.setIcon(CnfgTaskLabel.getIconMap().get("symbol_success.gif"));
                tl.setFont(this.m_normalFont);
                if (this.m_currentTask == tl) {
                    this.m_currentTask = null;
                }
            } else if (1 == status) {
                tl.setIcon(CnfgTaskLabel.getIconMap().get("current.gif"));
                tl.setFont(this.m_boldFont);
                this.setUpdatedCurrentTask(true);
                this.m_currentTask = tl;
            } else if (4 == status) {
                tl.setIcon(CnfgTaskLabel.getIconMap().get("cancelled.gif"));
                tl.setFont(this.m_boldFont);
                this.m_currentTask = tl;
            } else {
                tl.setIcon(CnfgTaskLabel.getIconMap().get("none.gif"));
                tl.setFont(this.m_normalFont);
                if (this.m_currentTask == tl) {
                    this.m_currentTask = null;
                }
            }
        }
    }

    void updateFonts() {
        this.m_normalFont = CnfgFontSetting.getAdminFont();
        this.m_boldFont = CnfgFontSetting.getAdminBoldFont();
        this.setFont(this.m_normalFont);
        this.m_messageLabel.setFont(this.m_normalFont);
        this.m_detailsView.setFont(this.m_normalFont);
        this.m_closeButton.setFont(this.m_normalFont);
        this.m_detailsButton.setFont(this.m_normalFont);
    }

    @Override
    public boolean initialize(ICnfgAction action, ICnfgTask[] tasks) {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CnfgTaskDialog::initialize()");
        }
        this.m_taskList.clear();
        this.m_taskPanel.removeAll();
        this.m_detailsView.setText(null);
        this.m_detailsPanel.setPreferredSize(new Dimension(290, 144));
        if (null != action) {
            String sActionName;
            this.m_currentAction = action;
            if (null != tasks) {
                if (tasks.length < 5) {
                    this.m_scrollTaskPane.setPreferredSize(new Dimension(290, 94));
                } else {
                    this.m_scrollTaskPane.setPreferredSize(new Dimension(290, 144));
                }
                for (int i = 0; i < tasks.length; ++i) {
                    CnfgTaskLabel tl = new CnfgTaskLabel(tasks[i]);
                    this.m_taskList.add(tl);
                    ++this.m_tasksLeft;
                    this.m_taskPanel.add((Component)tl, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
                    tl.setFocusable(true);
                }
                this.validate();
            }
            if ((sActionName = this.m_currentAction.getName()).equalsIgnoreCase("start") || sActionName.equalsIgnoreCase("stop") || sActionName.equalsIgnoreCase("restart")) {
                this.grabUDPPort(sActionName);
            }
        }
        return true;
    }

    @Override
    public ICnfgFeedback getFeedback() {
        if (null == this.m_feedback) {
            this.m_feedback = new CnfgTaskFeedback();
        }
        this.m_feedback.setValues(this.m_currentTask, (ArrayList)this.m_taskList, this.m_detailsView, this);
        return this.m_feedback;
    }

    @Override
    public void setCancellable(boolean cancellable) {
        this.m_cancellable = cancellable;
    }

    @Override
    public void lastTaskDisabled() {
        this.m_closeButton.setEnabled(false);
        this.m_isLastTaskRunning = true;
    }

    public void pauseToCloseOrContinue() {
        this.m_icon.setIcon(CnfgTaskLabel.getIconMap().get("none64.gif"));
        this.m_continueButton.setVisible(true);
        this.m_continueButton.setEnabled(true);
        if (!this.m_detailsPanel.isVisible()) {
            this.m_detailsPanel.setVisible(true);
            this.m_detailsButton.setText(m_detailsCaption[1]);
            this.m_detailsButton.setMnemonic(m_detailsAccel[1]);
            this.m_detailsButton.setDisplayedMnemonicIndex(m_detailsAccelIndex[1]);
            this.packIt();
            this.nudgeDialog(1);
            this.setScrollDetailsNeeded(true);
        }
    }

    @Override
    public void setTasksLeft(int tasksLeftInList) {
        this.m_tasksLeft = tasksLeftInList;
    }

    public void continueRunning() {
        this.m_icon.setIcon(CnfgTaskLabel.getIconMap().get("progress.gif"));
    }

    @Override
    public void cancel() {
        this.m_bIsCancelled = true;
    }

    private void grabUDPPort(String sOperation) {
        block26: {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CheckLogsThread::grabUDPPort(" + sOperation + ")");
            }
            this.m_bFoundFeedBackPort = false;
            Parameter feedbackPortParm = DataManager.getInstance().findParm("feedbackPort");
            if (feedbackPortParm == null) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CheckLogsThread::grabUDPPort() - couldn't find feedbackPortParm. Quit looking for a port.");
                }
                return;
            }
            int iOriginalPort = ((BigInteger)feedbackPortParm.getValue()).intValue();
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CheckLogsThread::grabUDPPort() - Data model's feebackPort is " + iOriginalPort);
            }
            if (sOperation.equalsIgnoreCase("stop") || sOperation.equalsIgnoreCase("restart")) {
                try {
                    this.m_ds = new DatagramSocket(iOriginalPort);
                    this.m_port = iOriginalPort;
                    this.m_bFoundFeedBackPort = true;
                }
                catch (SocketException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("CheckLogsThread::grabUDPPort() - Port " + iOriginalPort + " not available, e is " + e.getMessage());
                    }
                    break block26;
                }
            }
            if (sOperation.equalsIgnoreCase("start")) {
                int iNewPort;
                Parameter logServerPortParm = DataManager.getInstance().findParm("logServerPort");
                if (logServerPortParm == null) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("CheckLogsThread::grabUDPPort() - couldn't find logServerPortParm. Quit looking for a port.");
                    }
                    return;
                }
                int ilogServerPort = ((BigInteger)logServerPortParm.getValue()).intValue();
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CheckLogsThread::grabUDPPort() - Data model's logServerPort is " + ilogServerPort);
                }
                int iTicks = 0;
                int n = iNewPort = ilogServerPort == 65535 ? 0 : ilogServerPort;
                while (!this.m_bFoundFeedBackPort && iTicks != 20) {
                    ++iNewPort;
                    ++iTicks;
                    try {
                        this.m_ds = new DatagramSocket(iNewPort);
                        this.m_port = iNewPort;
                        this.m_bFoundFeedBackPort = true;
                    }
                    catch (SocketException e) {
                        if (!CnfgLog.isDebugEnabled()) continue;
                        CnfgLog.debug("CheckLogsThread::grapUDPPort() - Attempt # " + iTicks + ", Port " + iNewPort + " not available, e is " + e.getMessage());
                    }
                }
                if (this.m_bFoundFeedBackPort && iOriginalPort != iNewPort) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("CheckLogsThread::grabUDPPort() - new port (" + iNewPort + ") is different than the original port (" + iOriginalPort + "). Need to serialize to disk.");
                    }
                    try {
                        boolean b = DataManager.getInstance().isConfigDirty();
                        DataManager.getInstance().saveFeedBackPort(iNewPort);
                        Element e = DocumentHelper.createElement((String)"value");
                        e.setText(Integer.toString(iNewPort));
                        feedbackPortParm.setValue(e);
                        DataManager.getInstance().setConfigDirtyFlag(b);
                    }
                    catch (DataManagerException dme) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("DataManager::createCMUpgradeTask() - Unable to serialize the feedback port, e is " + dme.getMessage());
                        }
                        if (this.m_ds != null) {
                            if (CnfgLog.isDebugEnabled()) {
                                CnfgLog.debug("CheckLogsThread.m_ds.close() - freeing up the socket.");
                            }
                            this.m_ds.close();
                            this.m_ds = null;
                        }
                        this.m_port = this.DEFAULT_FEEDBACK_PORT;
                        this.m_bFoundFeedBackPort = false;
                    }
                }
            }
        }
        if (!this.m_bFoundFeedBackPort) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CheckLogsThread::grabUDPPort() - Was unable to find a free port.");
            }
        } else if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CheckLogsThread::grabUDPPort() - Found a free port : " + this.m_port);
        }
    }

    @Override
    public int getNumberOfFailedTasks() {
        return this.m_numFailedTasks;
    }

    static {
        CnfgTaskDialog.m_detailsCaption[0] = CnfgResource.getMessage("Label.ButtonDetails");
        CnfgTaskDialog.m_detailsAccel[0] = CnfgResource.getLastAccelerator();
        CnfgTaskDialog.m_detailsAccelIndex[0] = CnfgResource.getLastAcceleratorIndex();
        CnfgTaskDialog.m_detailsCaption[1] = CnfgResource.getMessage("Label.ButtonDetailsHide");
        CnfgTaskDialog.m_detailsAccel[1] = CnfgResource.getLastAccelerator();
        CnfgTaskDialog.m_detailsAccelIndex[1] = CnfgResource.getLastAcceleratorIndex();
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == (JComponent)CnfgTaskDialog.this.getContentPane() && CnfgTaskDialog.this.m_currentAction != null && CnfgTaskDialog.this.m_currentAction.getStatus() == 1 && CnfgTaskDialog.this.m_closeButton.isEnabled()) {
                CnfgTaskDialog.this.Terminate();
            }
        }
    }

    private class DetailsViewListener
    implements DocumentListener {
        private DetailsViewListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (!CnfgTaskDialog.this.m_detailsButton.isEnabled()) {
                CnfgTaskDialog.this.m_detailsButton.setEnabled(true);
            }
            CnfgTaskDialog.this.m_detailsView.getDocument().removeDocumentListener(this);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

