/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgTaskLabel;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.data.Constants;
import com.cognos.i18n.ui.I18NTextArea;
import java.awt.Dialog;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CnfgTaskFeedback
extends Constants
implements ICnfgFeedback {
    private JDialog m_taskDialog;
    private CnfgTaskLabel m_currentTask;
    private List m_taskList = new ArrayList();
    private I18NTextArea m_detailsView;
    private boolean m_firstMessage = true;

    public void setValues(CnfgTaskLabel curTask, ArrayList tasklist, I18NTextArea detailsView, JDialog taskdialog) {
        this.m_currentTask = curTask;
        this.m_taskList = tasklist;
        this.m_detailsView = detailsView;
        this.m_taskDialog = taskdialog;
        this.m_firstMessage = true;
    }

    private void addDetailsMessage(String message) {
        if (message.length() > 0) {
            if (null != this.m_currentTask) {
                this.m_currentTask.addDetailsMessage(message);
                if (this.m_firstMessage) {
                    if (this.m_detailsView.getLineCount() > 1) {
                        this.m_detailsView.append("\n");
                    }
                    String taskLabel = "[" + this.m_currentTask.getLabel() + "]\n";
                    this.m_detailsView.append(taskLabel);
                }
            }
            this.m_detailsView.append(message + "\n");
            this.m_firstMessage = false;
        }
    }

    public void showError(String message) {
        this.addDetailsMessage(CnfgResource.getMessage("Message.task.error", new Object[]{message}));
    }

    public void showInformational(String message) {
        this.addDetailsMessage(message);
    }

    public void showWarning(String message) {
        this.addDetailsMessage(CnfgResource.getMessage("Message.task.warning", new Object[]{message}));
    }

    public void invalidateParameter(String parameterPath) {
    }

    public boolean promptForConfirmation(final String message) {
        class PromptRunnable
        implements Runnable {
            private int m_result;

            PromptRunnable() {
            }

            @Override
            public void run() {
                this.m_result = CnfgTaskFeedback.this.m_taskDialog != null ? DialogMessage.showDialog(CnfgTaskFeedback.this.m_taskDialog, message, CnfgResource.getMessage("Application.title"), DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 0) : DialogMessage.showDialog(message, CnfgResource.getMessage("Application.title"), DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 0);
            }
        }
        PromptRunnable pr;
        block4: {
            pr = new PromptRunnable();
            try {
                SwingUtilities.invokeAndWait(pr);
            }
            catch (InvocationTargetException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("InvocationException occured while trying to display message dialog in Swing thread. " + e.getMessage());
                }
            }
            catch (InterruptedException e) {
                if (!CnfgLog.isDebugEnabled()) break block4;
                CnfgLog.debug("InterruptedException occured while trying to display message dialog in Swing thread. " + e.getMessage());
            }
        }
        return pr.m_result == 0;
    }

    public String prompt(final String promptSpec) {
        class PromptRunnable
        implements Runnable {
            private String m_sResult;
            private String m_sPromptName;

            PromptRunnable(String sPromptName) {
                this.m_sPromptName = sPromptName;
            }

            @Override
            public void run() {
                boolean bUsingPromptClass = false;
                if (bPromptName) {
                    Class<?> promptClass;
                    block8: {
                        promptClass = null;
                        try {
                            promptClass = Class.forName(this.m_sPromptName);
                            bUsingPromptClass = true;
                        }
                        catch (ClassNotFoundException e) {
                            if (!CnfgLog.isDebugEnabled()) break block8;
                            CnfgLog.debug(e);
                        }
                    }
                    if (bUsingPromptClass) {
                        try {
                            Class[] ctorTypes = new Class[]{CnfgTaskFeedback.this.m_taskDialog != null ? Dialog.class : Frame.class, String.class};
                            Constructor<?> ctor = promptClass.getConstructor(ctorTypes);
                            Object[] ctorArgList = new Object[]{CnfgTaskFeedback.this.m_taskDialog != null ? CnfgTaskFeedback.this.m_taskDialog : CRConfigFrame.getInstance(), promptSpec};
                            Object promptInstance = ctor.newInstance(ctorArgList);
                            Class[] methodTypes = new Class[]{};
                            Method theMethod = promptClass.getMethod("getRetValue", methodTypes);
                            Object[] methodArgList = new Object[]{};
                            this.m_sResult = (String)theMethod.invoke(promptInstance, methodArgList);
                        }
                        catch (Exception e) {
                            if (CnfgLog.isDebugEnabled()) {
                                CnfgLog.debug(e);
                            }
                            bUsingPromptClass = false;
                        }
                    }
                }
                if (!bUsingPromptClass) {
                    int iResult = 0;
                    iResult = CnfgTaskFeedback.this.m_taskDialog != null ? DialogMessage.showDialog(CnfgTaskFeedback.this.m_taskDialog, alParagraphs, szCaption, iconType, oButtons, iDefault) : DialogMessage.showDialog(alParagraphs, szCaption, iconType, oButtons, iDefault);
                    this.m_sResult = Integer.toString(iResult);
                }
            }
        }
        PromptRunnable pr;
        block31: {
            String sPromptName = "";
            boolean bPromptNameExists = false;
            ArrayList<String> paragraphs = new ArrayList<String>();
            int defaultAction = 0;
            Icon icon = DialogMessage.ICON_INFORMATION;
            String caption = CnfgResource.getMessage("Application.title");
            Object[] buttons = DialogMessage.OPTS_YESNO;
            int numberOfButtons = 2;
            try {
                String captionNodeValue;
                Element captionNode;
                Element typeNode;
                String defaultNodeValue;
                Element defaultNode;
                Element dialogTypeNode;
                Document doc = null;
                doc = DocumentHelper.parseText((String)promptSpec);
                Element rootElement = doc.getRootElement();
                sPromptName = rootElement.attributeValue("name");
                if (sPromptName == null || sPromptName == "") {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("No prompt name specified.");
                    }
                } else {
                    bPromptNameExists = true;
                }
                List paragraphNodes = rootElement.elements("paragraph");
                for (int i = 0; i < paragraphNodes.size(); ++i) {
                    Element paragraphElement = (Element)paragraphNodes.get(i);
                    String addBlankLine = paragraphElement.attributeValue("addBlankLine");
                    String newline = "";
                    if (addBlankLine == null || addBlankLine != "false") {
                        newline = "\n";
                    }
                    paragraphs.add(paragraphElement.getStringValue() + newline);
                }
                Element confirmationNode = rootElement.element("confirmation");
                if (confirmationNode != null) {
                    paragraphs.add(confirmationNode.getStringValue());
                }
                if ((dialogTypeNode = rootElement.element("dialogType")) != null) {
                    String dialogTypeNodeValue = dialogTypeNode.getStringValue();
                    if (dialogTypeNodeValue.equalsIgnoreCase("yesnocancel")) {
                        buttons = DialogMessage.OPTS_YESNOCANCEL;
                        numberOfButtons = 3;
                    } else if (dialogTypeNodeValue.equalsIgnoreCase("okcancel")) {
                        buttons = DialogMessage.OPTS_OKCANCEL;
                    } else if (dialogTypeNodeValue.equalsIgnoreCase("ok")) {
                        buttons = DialogMessage.OPTS_OK;
                        numberOfButtons = 1;
                    } else if (dialogTypeNodeValue.equalsIgnoreCase("exitcontinue")) {
                        buttons = DialogMessage.OPTS_EXITCONTINUE;
                    }
                }
                if ((defaultNode = rootElement.element("default")) != null && (defaultNodeValue = defaultNode.getStringValue()) != "") {
                    if (defaultNodeValue.equalsIgnoreCase("1") && numberOfButtons > 1) {
                        defaultAction = 1;
                    } else if (defaultNodeValue.equalsIgnoreCase("2") && numberOfButtons > 2) {
                        defaultAction = 2;
                    }
                }
                if ((typeNode = rootElement.element("type")) != null) {
                    String iconType = typeNode.getStringValue();
                    if (iconType.equalsIgnoreCase("error")) {
                        icon = DialogMessage.ICON_ERROR;
                    } else if (iconType.equalsIgnoreCase("warning")) {
                        icon = DialogMessage.ICON_WARNING;
                    } else if (iconType.equalsIgnoreCase("progress")) {
                        icon = DialogMessage.ICON_ACTION_RUNNING;
                    }
                }
                if ((captionNode = rootElement.element("caption")) != null && (captionNodeValue = captionNode.getStringValue()) != "") {
                    caption = captionNodeValue;
                }
            }
            catch (DocumentException e) {
                CnfgLog.error(e);
                return "";
            }
            final ArrayList<String> alParagraphs = paragraphs;
            final int iDefault = defaultAction;
            final Icon iconType = icon;
            final String szCaption = caption;
            final Object[] oButtons = buttons;
            final boolean bPromptName = bPromptNameExists;
            pr = new PromptRunnable(sPromptName);
            try {
                SwingUtilities.invokeAndWait(pr);
            }
            catch (InvocationTargetException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("InvocationException occured while trying to display message dialog in Swing thread. " + e.getMessage());
                }
            }
            catch (InterruptedException e) {
                if (!CnfgLog.isDebugEnabled()) break block31;
                CnfgLog.debug("InterruptedException occured while trying to display message dialog in Swing thread. " + e.getMessage());
            }
        }
        return pr.m_sResult;
    }
}

