/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.ICnfgTask;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;

public class CnfgTaskLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    public static final String ICON_TASK_CURRENT = "current.gif";
    public static final String ICON_TASK_COMPLETE = "symbol_success.gif";
    public static final String ICON_TASK_FAILED = "symbol_error.gif";
    public static final String ICON_TASK_WARNING = "symbol_warning.gif";
    public static final String ICON_TASK_CANCELLED = "cancelled.gif";
    public static final String ICON_TASK_NONE = "none.gif";
    public static final String ICON_ACTION_RUNNING = "progress.gif";
    public static final String ICON_ACTION_COMPLETE = "dialog.information";
    public static final String ICON_ACTION_FAILED = "dialog.failed";
    public static final String ICON_ACTION_NONE = "none64.gif";
    public static Map<String, Icon> m_iconMap = new HashMap<String, Icon>();
    public ICnfgTask m_task;
    public LinkedList<String> m_detailsList;
    private StringBuffer m_buffer;

    public CnfgTaskLabel(ICnfgTask task) {
        super(task.getDescription(), CnfgImageLoader.loadIcon(ICON_TASK_NONE), 10);
        m_iconMap.put(ICON_TASK_CURRENT, CnfgImageLoader.loadIcon(ICON_TASK_CURRENT));
        m_iconMap.put(ICON_TASK_COMPLETE, CnfgImageLoader.loadIcon(ICON_TASK_COMPLETE));
        m_iconMap.put(ICON_TASK_FAILED, CnfgImageLoader.loadIcon(ICON_TASK_FAILED));
        m_iconMap.put(ICON_TASK_WARNING, CnfgImageLoader.loadIcon(ICON_TASK_WARNING));
        m_iconMap.put(ICON_TASK_CANCELLED, CnfgImageLoader.loadIcon(ICON_TASK_CANCELLED));
        m_iconMap.put(ICON_TASK_NONE, CnfgImageLoader.loadIcon(ICON_TASK_NONE));
        m_iconMap.put(ICON_ACTION_RUNNING, CnfgImageLoader.loadIcon(ICON_ACTION_RUNNING));
        m_iconMap.put(ICON_ACTION_COMPLETE, DialogMessage.ICON_INFORMATION);
        m_iconMap.put(ICON_ACTION_FAILED, DialogMessage.ICON_ERROR);
        this.m_detailsList = new LinkedList();
        this.m_buffer = new StringBuffer();
        this.m_task = task;
        this.setIconAccessibleName("");
    }

    public String getLabel() {
        return this.m_task.getLabel();
    }

    public void addDetailsMessage(String message) {
        this.m_detailsList.add(message);
        this.m_buffer.delete(0, this.m_buffer.length());
    }

    public static Map<String, Icon> getIconMap() {
        return m_iconMap;
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        String iconText = " ";
        if (icon == m_iconMap.get(ICON_TASK_COMPLETE) || icon == m_iconMap.get(ICON_ACTION_COMPLETE)) {
            iconText = CnfgResource.getMessage("Status.taskdialog.success");
            if (iconText == null || iconText == "???") {
                iconText = "Success";
            }
        } else if (icon == m_iconMap.get(ICON_TASK_FAILED) || icon == m_iconMap.get(ICON_ACTION_FAILED)) {
            iconText = CnfgResource.getMessage("Status.taskdialog.fail");
            if (iconText == null || iconText == "???") {
                iconText = "Failed";
            }
        } else if (icon == m_iconMap.get(ICON_TASK_CURRENT)) {
            iconText = CnfgResource.getMessage("Status.taskdialog.running");
            if (iconText == null || iconText == "???") {
                iconText = "Running";
            }
        } else if (icon == m_iconMap.get(ICON_TASK_WARNING)) {
            iconText = CnfgResource.getMessage("Status.taskdialog.warning");
            if (iconText == null || iconText == "???") {
                iconText = "Warning";
            }
        } else if (icon == m_iconMap.get(ICON_TASK_CANCELLED) && ((iconText = CnfgResource.getMessage("Status.taskdialog.cancelled")) == null || iconText == "???")) {
            iconText = "Cancelled";
        }
        this.setIconAccessibleName(iconText);
    }

    public void setIconAccessibleName(String iconName) {
        AccessibleContext ac = this.getAccessibleContext();
        if (ac != null) {
            ac.setAccessibleName(this.getText() + " " + iconName);
        }
    }
}

