/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.RenderTreeNode;
import com.cognos.crconfig.TreePopupListener;
import com.cognos.crconfig.data.CnfgDataEvent;
import com.cognos.crconfig.data.CnfgDataListener;
import com.cognos.crconfig.data.CnfgNodeDeletedEvent;
import com.cognos.crconfig.data.CnfgNodeDeletedListener;
import com.cognos.crconfig.data.CnfgNodeInsertedEvent;
import com.cognos.crconfig.data.CnfgNodeInsertedListener;
import com.cognos.crconfig.data.CnfgNodeRenamedEvent;
import com.cognos.crconfig.data.CnfgNodeRenamedListener;
import com.cognos.crconfig.data.CnfgNodeSwitchEvent;
import com.cognos.crconfig.data.CnfgNodeSwitchListener;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CnfgTree
extends JTree
implements CnfgDataListener,
CnfgNodeInsertedListener,
CnfgNodeDeletedListener,
CnfgNodeSwitchListener,
CnfgNodeRenamedListener,
TreeSelectionListener,
TreeWillExpandListener {
    private static final long serialVersionUID = -3199430212976381938L;
    private CRConfigFrame m_frame;
    private Folder m_rootFolder;
    private DefaultTreeModel m_treeModel;
    private DefaultMutableTreeNode m_treeRoot;
    protected static Folder m_hoverFolder;
    protected TreePath m_selectedTreePath;
    protected DefaultMutableTreeNode m_selectedNode;

    public void expandJTree(int depth) {
        this.expandJTreeNode(this.m_treeModel.getRoot(), 0, depth);
    }

    Folder getRootFolder() {
        return this.m_rootFolder;
    }

    public int expandJTreeNode(Object node, int row, int depth) {
        if (node != null && !this.m_treeModel.isLeaf(node)) {
            this.expandRow(row);
            if (depth != 0) {
                for (int index = 0; row + 1 < this.getRowCount() && index < this.m_treeModel.getChildCount(node); ++index) {
                    TreePath path;
                    ++row;
                    Object child = this.m_treeModel.getChild(node, index);
                    if (child == null) break;
                    while ((path = this.getPathForRow(row)) != null && path.getLastPathComponent() != child) {
                        ++row;
                    }
                    if (path == null) break;
                    row = this.expandJTreeNode(child, row, depth - 1);
                }
            }
        }
        return row;
    }

    public void buildTree(DefaultMutableTreeNode parentNode, Folder currentFolder) {
        for (int i = 0; i < currentFolder.getFolders().size(); ++i) {
            Folder f = currentFolder.getFolders().get(i);
            if (f.getDisabled() || !f.getVisibility()) continue;
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(f);
            this.m_treeModel.insertNodeInto(n, parentNode, parentNode.getChildCount());
            if (0 >= f.countFolders(true)) continue;
            this.buildTree(n, f);
        }
    }

    public void fireRootChange() {
        this.m_treeModel.nodeChanged(this.m_treeRoot);
    }

    @Override
    public void dataLoaded(CnfgDataEvent e) {
        Folder rootFolder;
        this.m_rootFolder = rootFolder = (Folder)e.getSource();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
        rootNode.setUserObject(rootFolder);
        if (rootNode.getChildCount() > 0) {
            rootNode.removeAllChildren();
            this.m_treeModel.reload();
        }
        this.buildTree(this.m_treeRoot, rootFolder);
        this.expandJTree(-1);
        this.setSelectionRow(0);
    }

    @Override
    public void nodeInserted(CnfgNodeInsertedEvent e) {
        Folder changedFolder = (Folder)e.getSource();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getArg();
        DefaultMutableTreeNode n = new DefaultMutableTreeNode(changedFolder);
        this.m_treeModel.insertNodeInto(n, node, node.getChildCount());
        if (0 < changedFolder.countFolders(true)) {
            this.buildTree(n, changedFolder);
        }
        this.setSelectionPath(new TreePath(n.getPath()));
    }

    @Override
    public void nodeDeleted(CnfgNodeDeletedEvent e) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)e.getArg();
        if (treeNode == null) {
            return;
        }
        TreeNode parentNode = treeNode.getParent();
        if (parentNode != null) {
            this.setSelectionPath(new TreePath(((DefaultMutableTreeNode)parentNode).getPath()));
        } else {
            this.setSelectionPath(new TreePath(this.m_treeRoot));
        }
        this.m_treeModel.removeNodeFromParent(treeNode);
    }

    @Override
    public void nodeSwitch(CnfgNodeSwitchEvent e) {
        Folder sourceFolder = (Folder)e.getSource();
        Folder targetFolder = (Folder)e.getTarget();
        DefaultMutableTreeNode sourceTreeNode = (DefaultMutableTreeNode)e.getArg();
        if (sourceTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)sourceTreeNode.getParent();
        DefaultMutableTreeNode targetnode = new DefaultMutableTreeNode(targetFolder);
        int sourceIdx = parentNode.getIndex(sourceTreeNode);
        this.m_treeModel.removeNodeFromParent(sourceTreeNode);
        this.m_treeModel.insertNodeInto(targetnode, parentNode, sourceIdx);
        this.setSelectionPath(new TreePath(targetnode.getPath()));
    }

    @Override
    public void nodeRenamed(CnfgNodeRenamedEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getArg();
        this.m_treeModel.nodeChanged(node);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath tp = event.getPath();
        DefaultMutableTreeNode nodeToCollapse = (DefaultMutableTreeNode)tp.getLastPathComponent();
        if (nodeToCollapse.isRoot()) {
            throw new ExpandVetoException(event);
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
    }

    public CnfgTree(CRConfigFrame frame) {
        this.m_frame = frame;
        Folder tempRoot = new Folder(CnfgResource.getMessage("Label.cnfgTreeRoot"));
        this.m_treeRoot = new DefaultMutableTreeNode(tempRoot);
        this.m_treeModel = new DefaultTreeModel(this.m_treeRoot);
        this.getSelectionModel().setSelectionMode(1);
        this.setModel(this.m_treeModel);
        this.setCnfgTreeHeight();
        this.expandRow(0);
        this.addTreeSelectionListener(this);
        this.addTreeWillExpandListener(this);
        this.setCellRenderer(new RenderTreeNode());
        this.putClientProperty("JTree.lineStyle", "Angled");
        if (this.m_frame.treePopupMenu != null) {
            TreePopupListener tempListener = new TreePopupListener(this.m_frame.treePopupMenu, this.m_frame);
            this.addMouseListener(tempListener);
            this.addMouseMotionListener(tempListener);
            this.addKeyListener(tempListener);
        }
        final CRConfigFrame cParent_final = this.m_frame;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113 && cParent_final.isActionRenameEnabled()) {
                    cParent_final.action_Rename();
                }
            }
        });
    }

    public void setCnfgTreeHeight() {
        int textHeight = CnfgFontSetting.getTextHeight();
        Icon treeIcon = CnfgImageLoader.loadIcon("icon_computer.gif");
        int iconHeight = treeIcon.getIconHeight();
        if (iconHeight < (treeIcon = CnfgImageLoader.loadIcon("icon_group.gif")).getIconHeight()) {
            iconHeight = treeIcon.getIconHeight();
        }
        if (iconHeight < (treeIcon = CnfgImageLoader.loadIcon("icon_component.gif")).getIconHeight()) {
            iconHeight = treeIcon.getIconHeight();
        }
        if (iconHeight < (treeIcon = CnfgImageLoader.loadIcon("icon_resource.gif")).getIconHeight()) {
            iconHeight = treeIcon.getIconHeight();
        }
        if (textHeight >= iconHeight) {
            this.setRowHeight(textHeight + 1);
        } else {
            this.setRowHeight(iconHeight + 1);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        this.m_selectedTreePath = event.getNewLeadSelectionPath();
        if (this.m_selectedTreePath == null) {
            return;
        }
        DefaultMutableTreeNode m_selectedNode = (DefaultMutableTreeNode)this.m_selectedTreePath.getLastPathComponent();
        Folder f = (Folder)m_selectedNode.getUserObject();
        DataManager.getInstance().setCurrentSelection(f);
    }
}

