/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CnfgUIDocResource {
    private static Hashtable s_resourceMap = new Hashtable();
    private static char s_acceleratorChar;

    public static void setResourceBundle(ResourceBundle bundle) {
        CnfgUIDocResource.setResourceBundle(bundle, "config");
    }

    public static void setResourceBundle(String msgBaseName) {
        if (msgBaseName != null && msgBaseName.length() != 0) {
            if (s_resourceMap.containsKey(msgBaseName)) {
                return;
            }
            Locale locale = CnfgResource.getLocale();
            try {
                ResourceBundle rb = ResourceBundle.getBundle(msgBaseName, locale);
                CnfgUIDocResource.setResourceBundle(rb, msgBaseName);
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgUIDocResource::setResourceBundle() - Found '" + msgBaseName + "' property for locale '" + rb.getLocale() + "'");
                }
            }
            catch (MissingResourceException mre) {
                CnfgLog.error(mre);
                CnfgLog.error("CnfgUIDocResource::setResourceBundle() - Property file '" + msgBaseName + "' for locale '" + locale.getDisplayName(Locale.ENGLISH) + "' not found. As well, unable to find the default property file.");
            }
        }
    }

    public static void setResourceBundle(ResourceBundle bundle, String msgBaseName) {
        s_resourceMap.put(msgBaseName, bundle);
    }

    public static char getLastAccelerator() {
        return s_acceleratorChar;
    }

    public static String getMessage(String szResource) {
        return CnfgUIDocResource.getMessage(szResource, "config");
    }

    public static String getMessage(String szResource, String msgBaseName) {
        if (msgBaseName == null || msgBaseName.length() == 0) {
            msgBaseName = "config";
        }
        String szString = null;
        s_acceleratorChar = '\u0000';
        try {
            ResourceBundle resource = (ResourceBundle)s_resourceMap.get(msgBaseName);
            String resourceString = resource.getString(szResource);
            int aPos = resourceString.indexOf("&&");
            if (aPos >= 0) {
                szString = aPos == 0 ? resourceString.substring(aPos + 1) : resourceString.substring(0, aPos) + resourceString.substring(aPos + 1);
            } else {
                int iPos = resourceString.indexOf("&");
                if (iPos >= 0) {
                    szString = iPos == 0 ? resourceString.substring(iPos + 1) : resourceString.substring(0, iPos) + resourceString.substring(iPos + 1);
                    s_acceleratorChar = resourceString.charAt(iPos + 1);
                } else {
                    szString = resourceString;
                }
            }
        }
        catch (NullPointerException e) {
            szString = "???";
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgUIDocResource::getMessage() - " + e.getMessage() + ", string is now " + szString);
            }
        }
        catch (MissingResourceException e) {
            if (CnfgLog.isDebugEnabled()) {
                // empty if block
            }
        }
        return szString;
    }
}

