/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgInfo;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPlatform;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ConfigurationException;
import com.cognos.crconfig.ConfigurationImpl;
import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.LocalURLParameter;
import com.cognos.crconfig.data.crypto.Creator;
import com.cognos.crconfig.data.service.BootstrapServiceFolder;
import com.cognos.crconfig.data.service.ServiceManager;
import com.cognos.crconfig.data.wlpconfig.WLPConfigCognosserverSettings;
import com.cognos.crconfig.data.wlpconfig.WLPConfiguration;
import com.cognos.i18n.ToolkitResources;
import com.ibm.cognos.i18n.util.Bidi;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class CnfgUtils {
    private static final char[] winInvalidCharacters = new char[]{'\\', '/', '*', '?', '\"', '<', '>', '|', ':'};
    private static final char[] unixInvalidCharacters = new char[]{'\\', '/', '*', '?', '\"', '<', '>', '|'};
    private static String os = null;
    private static boolean m_bInternalSetup = false;
    private static boolean m_bSmoketestSetup = false;
    private static final String sMain = "\"[main]\"";
    private static final String sSep1 = ", \"";
    private static final String sSep2 = "\"\n";
    private static OutputStreamWriter m_sw;
    private static String hostName;
    public static final double MIN_JAVA_VERSION = 1.8;
    private static Pattern PATTERN_IPV4;
    private static Pattern PATTERN_IPV6_STD;
    private static Pattern PATTERN_IPV6_HEX_COMPRESSED;
    private static final String strIpv4Pattern = "^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$";
    private static final String strIpv6PatternStd = "^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$";
    private static final String strIpv6PatternHexComp = "^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$";
    static final String parm_gateway = "gateway";
    static final String parm_launch = "launchURL";

    public static void setInternalSetup(boolean bInternal) {
        m_bInternalSetup = bInternal;
    }

    public static void setSmoketestSetup(boolean bsmoketest) {
        m_bSmoketestSetup = bsmoketest;
    }

    public static boolean isInternalSetup() {
        return m_bInternalSetup;
    }

    public static boolean isSmoketestSetup() {
        return m_bSmoketestSetup;
    }

    public static String getInvalidChars() {
        char[] invalidChars = CnfgUtils.isWindowsPlatform() ? winInvalidCharacters : unixInvalidCharacters;
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 0; i < invalidChars.length; ++i) {
            sBuffer.append(invalidChars[i]).append(" ");
        }
        return sBuffer.toString();
    }

    public static boolean isValidName(String name) {
        char[] invalidChars = CnfgUtils.isWindowsPlatform() ? winInvalidCharacters : unixInvalidCharacters;
        for (int i = 0; i < invalidChars.length; ++i) {
            if (name.indexOf(invalidChars[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPath(String sPath) {
        if (sPath.equals(null)) {
            return true;
        }
        if ((sPath = sPath.trim()).length() == 0) {
            return true;
        }
        if (sPath.length() > 1 && CnfgUtils.isWindowsPlatform()) {
            char[] charTokens = new char[2];
            sPath.getChars(0, 2, charTokens, 0);
            if (Character.isLetter(charTokens[0]) && charTokens[1] == ':') {
                sPath = sPath.substring(2);
            }
        }
        StringTokenizer sTokenizer = new StringTokenizer(sPath, "\\/");
        boolean bIsValid = true;
        while (bIsValid && sTokenizer.hasMoreTokens()) {
            bIsValid = CnfgUtils.isValidName(sTokenizer.nextToken());
        }
        return bIsValid;
    }

    public static boolean isWindowsPlatform() {
        return CnfgUtils.getPlatform().equalsIgnoreCase("win");
    }

    public static boolean isUnixPlatform() {
        return !CnfgUtils.isWindowsPlatform();
    }

    public static String getPlatform() {
        if (os == null) {
            os = System.getProperty("os.name");
            os = os != null ? (os.toLowerCase().indexOf("win") != -1 ? "win" : "unix") : "win";
        }
        return os;
    }

    public static String getWindowsDirectory() {
        String oshome = "";
        if (CnfgUtils.isWindowsPlatform()) {
            oshome = System.getenv("windir");
        }
        return oshome;
    }

    public static String getFileExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public static boolean validateLocaleID(String sLocale) {
        if (sLocale == null || sLocale.length() < 2 || sLocale.length() > 5) {
            return false;
        }
        int i = sLocale.indexOf("-");
        if (i < 0) {
            if (sLocale.length() != 2) {
                return false;
            }
            String[] aLanguages = Locale.getISOLanguages();
            for (int k = 0; k < aLanguages.length; ++k) {
                if (sLocale.compareToIgnoreCase(aLanguages[k]) != 0) continue;
                return true;
            }
            return false;
        }
        String sCountry = null;
        String sLanguage = null;
        sLanguage = sLocale.substring(0, i);
        if (sLanguage == null || sLanguage.length() != 2) {
            return false;
        }
        if (i + 1 < sLocale.length()) {
            sCountry = sLocale.substring(i + 1, sLocale.length());
        }
        if (sCountry == null || sCountry.length() != 2) {
            return false;
        }
        String[] aLanguages = Locale.getISOLanguages();
        boolean bLang = false;
        for (int k = 0; k < aLanguages.length; ++k) {
            if (aLanguages[k].compareToIgnoreCase(sLanguage) != 0) continue;
            bLang = true;
            break;
        }
        if (!bLang) {
            return false;
        }
        boolean bCount = false;
        String[] aCountries = Locale.getISOCountries();
        for (int k = 0; k < aCountries.length; ++k) {
            if (aCountries[k].compareToIgnoreCase(sCountry) != 0) continue;
            bCount = true;
            break;
        }
        return bCount;
    }

    public static boolean escapeXMLComment(StringBuffer sb) {
        String DOUBLE_HYPHEN_REPLACEMENT = "-";
        boolean bRetValue = false;
        int sbLength = sb.length();
        for (int index = 0; index < sbLength; ++index) {
            char c2;
            char c1 = sb.charAt(index);
            if (c1 != '-' || index + 1 >= sbLength || (c2 = sb.charAt(index + 1)) != '-') continue;
            sb.replace(index, index + 2, "-");
            index += "-".length() - 1;
            sbLength = sb.length();
            bRetValue = true;
        }
        return bRetValue;
    }

    public static Map sort(Locale locale, Map map) {
        Collator collator = Collator.getInstance(locale);
        TreeMap sortedMap = new TreeMap();
        for (Map.Entry pair : map.entrySet()) {
            String name = (String)pair.getValue() + ":" + pair.getKey();
            CollationKey key = collator.getCollationKey(name);
            sortedMap.put(key, pair);
        }
        return sortedMap;
    }

    public static String delete(File f) {
        if (!f.exists()) {
            return null;
        }
        String sMsg = null;
        if (f.isFile()) {
            if (!f.delete()) {
                Object[] args = new Object[]{f.getAbsolutePath()};
                sMsg = CnfgResource.getMessage("Message.utils.deleteerrordetail", args);
            }
        } else {
            boolean bDoh = false;
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File childFile = files[i];
                sMsg = CnfgUtils.delete(childFile);
                if (sMsg == null) continue;
                bDoh = true;
                break;
            }
            if (!bDoh && !f.delete()) {
                Object[] args = new Object[]{f.getAbsolutePath()};
                sMsg = CnfgResource.getMessage("Message.utils.deleteerrordetail", args);
            }
        }
        return sMsg;
    }

    public static void pack(Dialog dlg) {
        if (CnfgPlatform.isJava13VM() && CnfgPlatform.isLinuxPlatform()) {
            boolean bResizable = dlg.isResizable();
            dlg.setResizable(true);
            dlg.pack();
            dlg.setResizable(bResizable);
        } else {
            dlg.pack();
        }
    }

    public static JTextPane addHyperlinkText(JTextPane hyperlinkTextPane, String normalText, String linkedText, int width, ArrayList pos) {
        Font adminFont = CnfgFontSetting.getAdminFont();
        int controlHeight = CnfgFontSetting.getMaxHeight(adminFont);
        hyperlinkTextPane.setEditable(false);
        hyperlinkTextPane.setRequestFocusEnabled(false);
        hyperlinkTextPane.setPreferredSize(new Dimension(width, controlHeight));
        Color hyperlinkColor = CnfgUtils.getHyperLinkColor();
        if (normalText.length() > 0) {
            normalText = normalText + " ";
        }
        try {
            DefaultStyledDocument dsd = new DefaultStyledDocument();
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setFontFamily(attrs, adminFont.getFontName());
            StyleConstants.setFontSize(attrs, adminFont.getSize());
            dsd.insertString(0, normalText, attrs);
            pos.add(0, new Integer(normalText.length()));
            SimpleAttributeSet attrs_h = new SimpleAttributeSet();
            StyleConstants.setFontFamily(attrs_h, adminFont.getFontName());
            StyleConstants.setFontSize(attrs_h, adminFont.getSize());
            StyleConstants.setForeground(attrs_h, hyperlinkColor);
            StyleConstants.setAlignment(attrs_h, 2);
            StyleConstants.setUnderline(attrs_h, true);
            dsd.insertString(normalText.length(), linkedText, attrs_h);
            hyperlinkTextPane.setDocument(dsd);
            pos.add(1, new Integer(normalText.length() + linkedText.length()));
        }
        catch (Exception e) {
            CnfgLog.error(e);
            hyperlinkTextPane.setFont(adminFont);
            hyperlinkTextPane.setText(normalText + linkedText);
            hyperlinkTextPane.setForeground(hyperlinkColor);
            pos.add(0, new Integer(normalText.length() + linkedText.length()));
            pos.add(1, new Integer(normalText.length() + linkedText.length()));
        }
        return hyperlinkTextPane;
    }

    private static Color getHyperLinkColor() {
        if (CnfgUtils.isHighContrastWin()) {
            return SystemColor.textText;
        }
        return Color.blue;
    }

    public static void saveJavaInfo() {
        CnfgUtils.saveJavaAndMachineInfo();
        CnfgUtils.updateJavaPropFile();
    }

    public static void saveJavaAndMachineInfo() {
        CnfgPreferences.getInstance().setProperty("JavaVersion", CnfgUtils.getCurrentJavaVersion());
        CnfgPreferences.getInstance().setProperty("JavaVendor", CnfgUtils.getCurrentJavaVendor());
        CnfgPreferences.getInstance().setProperty("JavaHome", DataManager.getCurrentJavaHome());
        String sOsName = System.getProperty("os.name");
        CnfgPreferences.getInstance().setProperty("OSName", sOsName != null ? sOsName : "NA");
        String sOsVersion = System.getProperty("os.version");
        CnfgPreferences.getInstance().setProperty("OSVersion", sOsVersion != null ? sOsVersion : "NA");
        String sOsArch = System.getProperty("os.arch");
        CnfgPreferences.getInstance().setProperty("OSArchitecture", sOsArch != null ? sOsArch : "NA");
        String sUsername = System.getProperty("user.name");
        CnfgPreferences.getInstance().setProperty("UserName", sUsername != null ? sUsername : "NA");
        try {
            String sHostName = InetAddress.getLocalHost().getHostName();
            CnfgPreferences.getInstance().setProperty("HostName", sHostName != null ? sHostName : "NA");
        }
        catch (UnknownHostException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Couldn't resolve the host name. Not able to save it to the preferences file.");
            }
            CnfgPreferences.getInstance().setProperty("HostName", "NA");
        }
    }

    private static void updateJavaPropFile() {
        if (DataManager.getInstance().getCBS() != null) {
            try {
                ICCLConfiguration icclconfig = CCLConfigurationFactory.createConfiguration();
                icclconfig.init();
                CnfgUtils.updateJavaPropFileToTempFolder(icclconfig);
            }
            catch (CCLConfigurationException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgUtils::updateJavaPropFile() - Unable to init ICCLConfiguration, e is " + e.getMessage());
                }
            }
        } else if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CnfgUtils::updateJavaPropFile() - No CBS is installed, no need to update cbs.prefs file.");
        }
    }

    public static boolean updateJavaPropFileToTempFolder(ICCLConfiguration icclconfig) {
        block12: {
            if (icclconfig == null) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgUtils::updateJavaPropFileToTempFolder() - icclconfig is null. The file cbs.prefs was not updated.");
                }
                return false;
            }
            String sJavaPropFile = CnfgUtils.getJavaPropFilePath(icclconfig);
            if (sJavaPropFile == null) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgUtils::updateJavaPropFileToTempFolder() - Unable to get cbs.prefs file path.");
                }
                return false;
            }
            try {
                File fPropFile = DataManager.getInstance().resolveEffectiveFilePath(sJavaPropFile);
                FileOutputStream fou = new FileOutputStream(fPropFile);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fou, "UTF-8");
                BufferedWriter writer = new BufferedWriter(osw);
                writer.write("java_home=" + DataManager.getCurrentJavaHome() + "\n");
                writer.write("java_vendor=" + CnfgUtils.getCurrentJavaVendor() + "\n");
                writer.write("java_version=" + CnfgUtils.getCurrentJavaVersion() + "\n");
                writer.close();
                if (CnfgLog.isDebugEnabled() && fPropFile != null) {
                    CnfgLog.debug("CnfgUtils::updateJavaPropFileToTempFolder() - The file '" + fPropFile.getCanonicalPath() + "' was updated successfully.");
                }
                return true;
            }
            catch (FileNotFoundException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgUtils::updateJavaPropFileToTempFolder() - " + e.getMessage());
                }
            }
            catch (IOException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgUtils::updateJavaPropFileToTempFolder() - " + e.getMessage());
                }
            }
            catch (DataManagerException e) {
                if (!CnfgLog.isDebugEnabled()) break block12;
                CnfgLog.debug("CnfgUtils::updateJavaPropFileToTempFolder() - " + e.getMessage());
            }
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CnfgUtils::updateJavaPropFileToTempFolder() - The file cbs.prefs was failed to be updated.");
        }
        return false;
    }

    public static String getJavaPropFilePath(ICCLConfiguration icclconfig) {
        String sJavaPropFile;
        block5: {
            sJavaPropFile = null;
            try {
                String sTempDir = icclconfig.getValue("temp", false);
                if (sTempDir != null && sTempDir.length() != 0) {
                    sJavaPropFile = sTempDir.charAt(sTempDir.length() - 1) == File.separatorChar ? sTempDir + "cbs.prefs" : sTempDir + File.separatorChar + "cbs.prefs";
                } else if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgUtils::getJavaPropFilePath() - The temp parameter is null or empty. The file cbs.prefs will not be updated.");
                }
            }
            catch (CCLConfigurationException e) {
                if (!CnfgLog.isDebugEnabled()) break block5;
                CnfgLog.debug("CnfgUtils::getJavaPropFilePath() - Unable to get the temp parameter, e is " + e.getMessage() + ". The file cbs.prefs will not be updated.");
            }
        }
        return sJavaPropFile;
    }

    public static void saveAdditionalInfo() {
        String sVersion = CnfgInfo.getVersion();
        CnfgPreferences.getInstance().setProperty("Version", sVersion);
    }

    public static String[] getEnv() {
        return CnfgUtils.getEnvWithPath(DataManager.getPathToInstallDir());
    }

    public static String[] getEnvWithPath(String path) {
        Map<String, String> envMap = System.getenv();
        Iterator<Map.Entry<String, String>> it = envMap.entrySet().iterator();
        String[] envp = new String[envMap.size() + 1];
        int index = 0;
        envp[index++] = "COG_ROOT=" + path;
        Map.Entry<String, String> entry = null;
        while (it.hasNext()) {
            entry = it.next();
            String origKey = entry.getKey();
            String newKey = origKey.equals("SYSTEMROOT") ? "SystemRoot" : origKey;
            envp[index++] = newKey + "=" + entry.getValue();
        }
        return envp;
    }

    public static String[] getEnvForWLP() {
        return CnfgUtils.getEnvForWLPWithPath(DataManager.getPathToInstallDir());
    }

    public static String[] getEnvForWLPWithPath(String path) {
        String[] env = CnfgUtils.getEnvWithPath(path);
        String[] envWLP = new String[env.length + 1];
        System.arraycopy(env, 0, envWLP, 0, env.length);
        envWLP[env.length] = "WLP_INSTALL_DIR=" + path + "/wlp";
        return envWLP;
    }

    public static boolean isHighContrastWin() {
        Toolkit toolkit;
        Boolean highContrast;
        if (CnfgUtils.isWindowsPlatform() && (highContrast = (Boolean)(toolkit = Toolkit.getDefaultToolkit()).getDesktopProperty("win.highContrast.on")) != null) {
            return highContrast;
        }
        return false;
    }

    public static String checkJava() {
        if (DataManager.getInstance().useJCAM()) {
            int status = 0;
            try {
                CAMFactory.checkFIPSSupport();
            }
            catch (CAMCryptoException e) {
                CnfgLog.error(e.getMessage());
                return null;
            }
            status = DataManager.getInstance().lightCurrentJavaValidation();
            if (status == 0) {
                CnfgUtils.saveJavaInfo();
                return null;
            }
            ArrayList lErrors = new ArrayList();
            int ret = DataManager.getInstance().heavyCurrentJavaValidation(status, lErrors);
            if (ret == 0) {
                CnfgUtils.saveJavaInfo();
                return null;
            }
            String str = DataManager.getJavaErrorMessage(ret);
            StringBuffer buf = new StringBuffer(str);
            buf.append("\n");
            for (int i = 0; i < lErrors.size(); ++i) {
                buf.append("[" + CnfgResource.getMessage("Message.task.validate") + "] " + ((String)lErrors.get(i)).concat("\n"));
            }
            return buf.toString();
        }
        return null;
    }

    public static String validateJavaVersion() {
        boolean unsupported;
        String javaVersion = CnfgUtils.getCurrentJavaVersion();
        String major = javaVersion.substring(0, 3);
        double majorVersion = Double.parseDouble(major);
        boolean bl = unsupported = majorVersion < 1.8;
        if (unsupported) {
            return "Current system Java version, " + javaVersion + ", is unsupported." + "We require " + 1.8 + " and up";
        }
        return null;
    }

    public static String getCurrentJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getCurrentJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public static void setOutputStream(OutputStreamWriter output_sw) {
        m_sw = output_sw;
    }

    public static void writeToOutput(String msgLevel, String msgStr) {
        if (m_sw == null) {
            CnfgLog.error(msgStr);
            return;
        }
        try {
            m_sw.write(new StringBuffer(msgLevel + ", ").append(sMain).append(sSep1).append(msgStr).append(sSep2).toString());
            if (msgLevel != null && msgLevel.equalsIgnoreCase("ERROR")) {
                CnfgLog.error(msgStr);
            }
        }
        catch (IOException e) {
            CnfgLog.error(e);
        }
    }

    public static void flushOutput() {
        try {
            if (m_sw != null) {
                m_sw.flush();
            }
        }
        catch (IOException e) {
            CnfgLog.error(e);
        }
    }

    private static String[] parseINIFile(String fileName, String dbClass) {
        String[] dbParams;
        block7: {
            CnfgUtils.writeToOutput("INFO", "parseINIFile() - start parsing INI file '" + fileName + "'.");
            dbParams = null;
            try {
                FileInputStream is = new FileInputStream(fileName);
                if (is == null) break block7;
                Properties props = new Properties();
                try {
                    props.load(is);
                    if (dbClass.equals("DB2")) {
                        String db2User = props.getProperty("DB2_USERNAME");
                        String db2Password = props.getProperty("DB2_PASSWORD");
                        String db2Port = props.getProperty("DB2_PORT");
                        String db2Name = props.getProperty("DB2_NAME");
                        if (db2User == null || db2User.length() < 0 || db2Password == null || db2Password.length() < 0 || db2Port == null || db2Port.length() < 0) {
                            CnfgUtils.writeToOutput("ERROR", "parseINIFile() - The db info in '" + fileName + "' is not valid, return null.");
                            return null;
                        }
                        if (db2Name == null || db2Name.length() < 0) {
                            db2Name = "CognosCM";
                        }
                        dbParams = new String[]{"class=DB2", "instanceName=Content Store", "server=localhost:" + db2Port, "user=" + db2User, "password=" + db2Password, "name=" + db2Name, "SSLencryptionEnabled=false"};
                    }
                }
                catch (IOException ex) {
                    CnfgUtils.writeToOutput("ERROR", "parseINIFile() - IOException when parsing '" + fileName + "', return null.");
                    CnfgLog.error(ex);
                    return null;
                }
            }
            catch (FileNotFoundException e) {
                CnfgUtils.writeToOutput("ERROR", "parseINIFile() - FileNotFoundException when parsing '" + fileName + "', return null.");
                CnfgLog.error(e);
                return null;
            }
        }
        CnfgUtils.writeToOutput("INFO", "parseINIFile() - The db info in '" + fileName + "' has been parsed properly.");
        return dbParams;
    }

    private static void prepareOutputStream() {
        DataManager dm = DataManager.getInstance();
        OutputStreamWriter wg_sw = null;
        String outputFileName = "../logs/workgroup_output.csv";
        try {
            File resp_dir = dm.resolveEffectiveFilePath(outputFileName);
            String encoding = ToolkitResources.getDefaultEncoding();
            wg_sw = new OutputStreamWriter((OutputStream)new FileOutputStream(resp_dir), encoding);
        }
        catch (Exception e) {
            CnfgLog.error("Could not create the output file '" + outputFileName + "'.");
            CnfgLog.error(e);
        }
        CnfgUtils.setOutputStream(wg_sw);
    }

    private static void closeOutputStream() {
        if (m_sw != null) {
            try {
                m_sw.flush();
                m_sw.close();
            }
            catch (IOException e) {
                CnfgLog.error(e);
            }
        }
    }

    public static boolean ConfigureAndLaunch(String sConfigINIFileName, boolean bStartServer) {
        boolean succeed = false;
        CnfgUtils.prepareOutputStream();
        ConfigurationImpl config = CnfgUtils.ConfigureServers(sConfigINIFileName);
        if (config != null) {
            if (!bStartServer) {
                CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureAndLaunch() - Configuration is done. Return true.");
                return true;
            }
            succeed = CnfgUtils.LaunchServers(config);
        }
        if (succeed) {
            CnfgUtils.updateConfigINI(config, sConfigINIFileName);
        }
        CnfgUtils.closeOutputStream();
        return succeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateConfigINI(ConfigurationImpl config, String sConfigINIFileName) {
        String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sConfigINIFileName);
        File iniFile = new File(sResolvedPath);
        if (!iniFile.exists()) {
            CnfgUtils.writeToOutput("ERROR", "CnfgUtils.updateConfigINI() - INI file '" + sResolvedPath + "' doesn't exist, return false.");
            return;
        }
        ArrayList<String> listProps = CnfgUtils.getPropertiesToWrite(config);
        FileOutputStream fileOS = null;
        try {
            fileOS = new FileOutputStream(iniFile, true);
            for (String prop : listProps) {
                fileOS.write(prop.getBytes());
            }
            fileOS.close();
        }
        catch (FileNotFoundException fnf) {
            CnfgUtils.writeToOutput("ERROR", fnf.getMessage());
        }
        catch (IOException ioe) {
            CnfgUtils.writeToOutput("ERROR", ioe.getMessage());
        }
        finally {
            if (fileOS != null) {
                try {
                    fileOS.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static ArrayList<String> getPropertiesToWrite(ConfigurationImpl config) {
        ArrayList<String> props = new ArrayList<String>();
        props.add(CnfgUtils.getLaunchURL(config));
        props.add(CnfgUtils.getLine("internalDispatcher", config.getParameterValue("internalDispatcher").toString()));
        return props;
    }

    private static String getLaunchURL(ConfigurationImpl config) {
        String gwValue = config.getParameterValue(parm_gateway).toString();
        String launchValue = gwValue.substring(0, gwValue.indexOf("/servlet/Gateway"));
        String sRet = CnfgUtils.getLine(parm_launch, launchValue);
        return sRet;
    }

    private static String getLine(String name, String value) {
        StringBuffer buf = new StringBuffer("");
        buf.append(name);
        buf.append('=');
        buf.append(value);
        buf.append("\r\n");
        return buf.toString();
    }

    private static ConfigurationImpl ConfigureServers(String sConfigINIFileName) {
        CnfgUtils.writeToOutput("INFO", "Start configuration for IBM Cognos servers... ...");
        if (sConfigINIFileName == null || sConfigINIFileName.length() == 0) {
            CnfgUtils.writeToOutput("ERROR", "CnfgUtils.ConfigureServers() - INI file name '" + sConfigINIFileName + "' is empty, return false.");
            return null;
        }
        String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sConfigINIFileName);
        File iniFile = new File(sResolvedPath);
        if (!iniFile.exists()) {
            CnfgUtils.writeToOutput("ERROR", "CnfgUtils.ConfigureServers() - INI file '" + sResolvedPath + "' doesn't exist, return false.");
            return null;
        }
        try {
            ConfigurationImpl config = new ConfigurationImpl(false);
            CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureServers() - Initialize configuration succeed.");
            CnfgUtils.flushOutput();
            try {
                hostName = LocalURLParameter.getFullyQualifiedHostName();
                CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureServers() - get fully qualified host name: " + hostName);
            }
            catch (UnknownHostException ex) {
                CnfgUtils.writeToOutput("Error", "CnfgUtils.ConfigureServers() - localhost will be used because resolving fully qualified host name failed with exception: \r\n" + ex.getMessage());
            }
            CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureServers() - Update gateway URL... ...");
            CnfgUtils.updateGateway(config);
            CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureServers() - Update gateway URL... ...Succeed.");
            CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureServers() - Update Content Store DB information... ...");
            String[] dbParams = CnfgUtils.parseINIFile(sResolvedPath, "DB2");
            if (dbParams == null) {
                CnfgUtils.writeToOutput("ERROR", "CnfgUtils.ConfigureServers() - Could not parse the INI file properly, return false.");
                return null;
            }
            boolean bSucc = config.setDBInstance(false, "CM", dbParams);
            if (!bSucc) {
                CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureServers() - Could not update Content Store DB information properly, return false.");
                return null;
            }
            CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureServers() - Update Content Store DB information... ...Succeed.");
            CnfgUtils.updateDispatcherPorts(config);
            CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureServers() - Update dispatcher ports succeed.");
            CnfgUtils.updateLogServer(config);
            CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureServers() - Update log server port succeed.");
            CnfgUtils.saveConfig(config);
            CnfgUtils.writeToOutput("INFO", "CnfgUtils.ConfigureServers() - Configuration is saved.");
            CnfgUtils.flushOutput();
            return config;
        }
        catch (ConfigurationException e) {
            CnfgUtils.writeToOutput("ERROR", "CnfgUtils.ConfigureServers() - ConfigurationException during ConfigurationServers. Return false.");
            CnfgLog.error(e);
            return null;
        }
    }

    private static boolean LaunchServers(ConfigurationImpl config) {
        try {
            CnfgUtils.checkAndUpdateServices(config);
            CnfgUtils.writeToOutput("INFO", "CnfgUtils.LaunchServers() - Check and update services succeed.");
            CnfgUtils.writeToOutput("INFO", "Starting IBM Cognos services... ...");
            CnfgUtils.flushOutput();
            CnfgUtils.startServices(config);
            CnfgUtils.writeToOutput("INFO", "Starting IBM Cognos services... ... Succeed.");
        }
        catch (ConfigurationException ex) {
            CnfgUtils.writeToOutput("ERROR", "CnfgUtils.LaunchServers() - ConfigurationException when starting the service. Return false.");
            CnfgLog.error(ex);
            return false;
        }
        return true;
    }

    private static void updateLogServer(ConfigurationImpl config) {
        String parmName = "logServerPort";
        BigInteger logServerPort = (BigInteger)config.getParameterValue(parmName);
        int origPort = logServerPort.intValue();
        String newPort = CnfgUtils.getAvailablePort(origPort, 50, 5);
        if (!newPort.equals(Integer.toString(origPort))) {
            CnfgUtils.writeToOutput("INFO", "updateLogServer() - A new port for log server is picked: '" + newPort + "'.");
            config.setParameterValue(parmName, newPort);
        }
    }

    private static void updateGateway(ConfigurationImpl config) {
        String sgPort = CnfgUtils.getAvailableGWPort();
        String sGatewayURL = CnfgUtils.getAvailableGWURL(sgPort);
        config.setParameterValue("sg_startupPort", sgPort);
        config.setParameterValue(parm_gateway, sGatewayURL);
        CnfgUtils.writeToOutput("INFO", "updateGateway() - available port to use: '" + sgPort + "', gateway URL: '" + sGatewayURL + "'.");
    }

    private static void updateDispatcherPorts(ConfigurationImpl config) {
        int port = CnfgDataUtils.getBasePortNumber("internalDispatcher");
        String disPort = CnfgUtils.getAvailablePort(port, 50, 10);
        if (disPort != null && !disPort.equals(Integer.toString(port))) {
            CnfgUtils.writeToOutput("INFO", "updateDispatcherPorts() - A new port for dispatcher is picked: '" + disPort + "'.");
            String origInternalDisp = config.getParameterValue("internalDispatcher").toString();
            String newDispURI = origInternalDisp.replaceFirst(Integer.toString(port), disPort);
            config.setParameterValue("internalDispatcher", newDispURI);
            config.setParameterValue("externalDispatcher", newDispURI);
            String newCMURI = newDispURI.replaceFirst("/dispatch", "");
            config.setComplexParameterValue("contentManagers", newCMURI);
            String newLocalGWURI = newDispURI + "/ext";
            config.setComplexParameterValue("gatewayDispatcherURIList", newLocalGWURI);
        }
    }

    private static String getAvailableGWPort() {
        int defaultPort = 8080;
        String port = CnfgUtils.getAvailablePort(defaultPort, 100, 5);
        if (port == null) {
            CnfgLog.error("After 10 times try from port 8080, incremented by 100, did not find unused port. Default back to 8080");
            port = Integer.toString(defaultPort);
        }
        return port;
    }

    private static void saveConfig(ConfigurationImpl config) throws ConfigurationException {
        config.save(true, m_sw);
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("saveConfig() - Configuration is saved. ");
        }
    }

    private static void startServices(ConfigurationImpl config) throws ConfigurationException {
        config.startServices(m_sw);
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("startServices() - Services are started. ");
        }
    }

    private static void checkAndUpdateServices(ConfigurationImpl config) throws ConfigurationException {
        boolean cbsUpdated = CnfgUtils.checkAndUpdateCBS();
        boolean sgUpdated = CnfgUtils.checkAndUpdateSG();
        if (cbsUpdated || sgUpdated) {
            DataManager.getInstance().setConfigDirtyFlag(true);
            CnfgUtils.saveConfig(config);
        }
    }

    private static boolean checkAndUpdateSG() {
        BootstrapServiceFolder curFolder = (BootstrapServiceFolder)DataManager.getInstance().getSGFolder();
        boolean updated = CnfgUtils.checkAndUpdateServiceName(curFolder);
        return updated;
    }

    private static boolean checkAndUpdateCBS() {
        BootstrapServiceFolder curFolder = (BootstrapServiceFolder)DataManager.getInstance().getCBS();
        boolean updated = CnfgUtils.checkAndUpdateServiceName(curFolder);
        return updated;
    }

    private static boolean checkAndUpdateServiceName(BootstrapServiceFolder curFolder) {
        boolean updated = false;
        String sNewName = null;
        String curRegName = curFolder.getNewServiceName();
        boolean bInUse = ServiceManager.isRegistered(curRegName, curFolder);
        if (!bInUse) {
            return false;
        }
        for (int reTryTime = 10; reTryTime > 0 && bInUse; --reTryTime) {
            sNewName = curFolder.getName() + " - " + Integer.toString(10 - reTryTime + 1);
            curFolder.setName(sNewName);
            curRegName = curFolder.getNewServiceName();
            bInUse = ServiceManager.isRegistered(curRegName, curFolder);
        }
        if (!bInUse) {
            updated = true;
        }
        return updated;
    }

    private static String getAvailableGWURL(String port) {
        return new String("http://" + hostName + ":" + port + "/ibmcognos/servlet/Gateway");
    }

    public static String getAvailablePort(int defaultPort, int incr, int iTicks) {
        int maxTicks = iTicks;
        boolean bFoundPort = false;
        int iNewPort = defaultPort;
        String port = null;
        while (!bFoundPort && iTicks != 0) {
            --iTicks;
            if (CnfgUtils.isAvailable(iNewPort)) {
                bFoundPort = true;
                continue;
            }
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgUtils:getAvailablePort() - Attempt # " + (maxTicks - iTicks) + ", Port " + iNewPort + " not available");
            }
            iNewPort += incr;
        }
        if (bFoundPort) {
            port = Integer.toString(iNewPort);
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAvailable(int iNewPort) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(iNewPort);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(iNewPort);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (ss != null) {
                    ss.close();
                }
                if (ds != null) {
                    ds.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public static boolean isBidiChar(char c) {
        if (c >= '\u05d0' && c <= '\u05ff') {
            return true;
        }
        if (c >= '\u0600' && c <= '\u065f') {
            return true;
        }
        if (c >= '\u066a' && c <= '\u06ef') {
            return true;
        }
        if (c >= '\u06fa' && c <= '\u07ff') {
            return true;
        }
        if (c >= '\ufb1d' && c <= '\ufdff') {
            return true;
        }
        return c >= '\ufe70' && c <= '\ufefc';
    }

    public static boolean hasRTLText(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!CnfgUtils.isBidiChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getAccessibleBidiString(String inputStr) {
        StringBuffer resultStr = new StringBuffer("");
        if (!CnfgUtils.hasRTLText(inputStr)) {
            return inputStr;
        }
        for (int i = 0; i < inputStr.length(); ++i) {
            char chrCode = inputStr.charAt(i);
            if (chrCode == '\u200f' || chrCode == '\u200e') continue;
            resultStr.append(chrCode);
        }
        return resultStr.toString();
    }

    public static String handleBidiString(String inputStr) {
        String sLocale;
        StringBuffer resultStr = new StringBuffer("");
        String DIR_RTL = "rtl";
        String DIR_LTR = "ltr";
        String RLM = "\u200f";
        if (inputStr == null) {
            return "";
        }
        if (!CnfgUtils.hasRTLText(inputStr)) {
            return inputStr;
        }
        ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
        try {
            sLocale = cfg.normalizeLocale(CnfgResource.getLocale().toString());
        }
        catch (CCLConfigurationException e) {
            sLocale = CnfgPreferences.getInstance().getProperty("language", "en");
        }
        int rlm = inputStr.indexOf(RLM);
        if (rlm != -1) {
            String rtlTxt = inputStr.substring(0, rlm);
            String ltrTxt = inputStr.substring(rlm + 1);
            resultStr.append(Bidi.enforceSegmentBTD((String)rtlTxt, (String)DIR_RTL, (String)sLocale)).append(ltrTxt);
            return resultStr.toString();
        }
        String rtlStr = "";
        String ltrStr = "";
        String lastDir = "";
        for (int i = 0; i < inputStr.length(); ++i) {
            char chrCode = inputStr.charAt(i);
            if (CnfgUtils.isBidiChar(chrCode)) {
                if (lastDir.equals(DIR_LTR)) {
                    resultStr.append(Bidi.enforceSegmentBTD((String)ltrStr, (String)DIR_LTR, (String)sLocale));
                    resultStr.append(ltrStr);
                    ltrStr = "";
                }
                rtlStr = rtlStr + chrCode;
                lastDir = DIR_RTL;
                continue;
            }
            if (lastDir.equals(DIR_RTL)) {
                resultStr.append(Bidi.enforceSegmentBTD((String)rtlStr, (String)DIR_RTL, (String)sLocale));
                rtlStr = "";
            }
            ltrStr = ltrStr + chrCode;
            lastDir = DIR_LTR;
        }
        if (lastDir.equals(DIR_LTR)) {
            resultStr.append(Bidi.enforceSegmentBTD((String)ltrStr, (String)DIR_LTR, (String)sLocale));
        }
        if (lastDir.equals(DIR_RTL)) {
            resultStr.append(Bidi.enforceSegmentBTD((String)rtlStr, (String)DIR_RTL, (String)sLocale));
        }
        return resultStr.toString();
    }

    public static void printBytes(String res) {
        for (int k = 0; k < res.length(); ++k) {
            char c = res.charAt(k);
            System.out.print("\\u" + Integer.toHexString(c | 0x10000).substring(1));
            System.out.print(" ");
        }
        System.out.println();
    }

    public static boolean matchPlatform(String osArch) {
        boolean bRet = false;
        if (System.getProperty("os.arch").equalsIgnoreCase(osArch)) {
            bRet = true;
        }
        return bRet;
    }

    private static void initIPPatterns() {
        if (PATTERN_IPV4 == null) {
            try {
                PATTERN_IPV4 = Pattern.compile(strIpv4Pattern, 2);
                PATTERN_IPV6_STD = Pattern.compile(strIpv6PatternStd, 2);
                PATTERN_IPV6_HEX_COMPRESSED = Pattern.compile(strIpv6PatternHexComp, 2);
            }
            catch (PatternSyntaxException e) {
                CnfgLog.error("PatternSyntaxException when try to compile pattern - " + e.toString());
            }
        }
    }

    public static String[] parseHostName(String hostName) {
        String[] hostValues = new String[]{"", "", ""};
        if (hostName != null && !hostName.isEmpty()) {
            if (CnfgUtils.isValidIpAddress(hostName)) {
                hostValues[0] = hostName;
            } else {
                hostValues[1] = hostName;
            }
        }
        return hostValues;
    }

    public static boolean isValidIpAddress(String hostname) {
        Matcher mIpv6comp;
        Matcher mIpv6std;
        Matcher mIpv4;
        CnfgUtils.initIPPatterns();
        if (PATTERN_IPV4 != null && (mIpv4 = PATTERN_IPV4.matcher(hostname)).matches()) {
            return true;
        }
        if (PATTERN_IPV6_STD != null && (mIpv6std = PATTERN_IPV6_STD.matcher(hostname)).matches()) {
            return true;
        }
        return PATTERN_IPV6_HEX_COMPRESSED != null && (mIpv6comp = PATTERN_IPV6_HEX_COMPRESSED.matcher(hostname)).matches();
    }

    public static void storeProperties(Properties props, OutputStream out, String comments) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (comments != null) {
            bw.write("#");
            bw.write(comments);
            bw.newLine();
        }
        bw.write("#" + new Date().toString());
        bw.newLine();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)props.get(key);
            bw.write(key + "=" + val);
            bw.newLine();
        }
        bw.flush();
    }

    public static boolean saveWLPServerXML(String fileName) {
        DataManager dm = DataManager.getInstance();
        try {
            dm.getConfig();
            WLPConfigCognosserverSettings cognosserverWLP = dm.getWLPInst().getCognosserver();
            cognosserverWLP.setServerXmlFileName(fileName);
            cognosserverWLP.saveServerSettings();
            return true;
        }
        catch (Exception e) {
            CnfgLog.error("Failed to load and save WLP server xml file '" + fileName + "' - " + e.toString());
            return false;
        }
    }

    public static boolean testWLPConfFiles(String[] testcommand) {
        if (testcommand == null || testcommand.length < 3) {
            CnfgLog.error("Failed. The command is not valid - " + Arrays.toString(testcommand));
            return false;
        }
        try {
            DataManager dm = DataManager.getInstance();
            Creator.useJCAM(true);
            dm.initializeCAMFactoryFromDisk();
            dm.getConfig();
            WLPConfiguration wlpInst = dm.getWLPInst();
            if (testcommand[0].equals("-testwlpcognosserver")) {
                wlpInst.getCognosserver().saveWLPConfFiles(testcommand[1], testcommand[2]);
            } else if (testcommand[0].equals("-testwlpdatasetservice")) {
                wlpInst.getDatasetservice().saveWLPConfFiles(testcommand[1], testcommand[2]);
            }
            return true;
        }
        catch (Exception e) {
            CnfgLog.error("Failed to test WLP cpmf file '" + Arrays.toString(testcommand) + "' - " + e.toString());
            return false;
        }
    }

    public static int compareVersions(String version1, String version2) {
        String versionElementDelimiter = ".";
        StringTokenizer tokenizer1 = new StringTokenizer(version1, versionElementDelimiter);
        StringTokenizer tokenizer2 = new StringTokenizer(version2, versionElementDelimiter);
        String verElem1 = null;
        String verElem2 = null;
        long ver1 = 0L;
        long ver2 = 0L;
        while (tokenizer1.hasMoreElements() && tokenizer2.hasMoreElements()) {
            verElem1 = tokenizer1.nextToken();
            verElem2 = tokenizer2.nextToken();
            ver1 = Long.valueOf(verElem1);
            if (ver1 > (ver2 = Long.valueOf(verElem2).longValue())) {
                return 1;
            }
            if (ver1 >= ver2) continue;
            return -1;
        }
        while (tokenizer2.hasMoreElements()) {
            verElem2 = tokenizer2.nextToken();
            ver2 = Long.valueOf(verElem2);
            if (ver2 == 0L) continue;
            return -1;
        }
        while (tokenizer1.hasMoreElements()) {
            verElem1 = tokenizer1.nextToken();
            ver1 = Long.valueOf(verElem1);
            if (ver1 == 0L) continue;
            return 1;
        }
        return 0;
    }

    static {
        hostName = "localhost";
        PATTERN_IPV4 = null;
        PATTERN_IPV6_STD = null;
        PATTERN_IPV6_HEX_COMPRESSED = null;
    }
}

