/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgMenu;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgSwingAction;
import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.CnfgWizardDialog;
import com.cognos.crconfig.CnfgWizardFrame;
import com.cognos.crconfig.CnfgWizardPage;
import com.cognos.crconfig.CnfgWizardPanel;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.data.CnfgDataEvent;
import com.cognos.crconfig.data.CnfgDataListener;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.WizardComplexPageData;
import com.cognos.crconfig.data.WizardData;
import com.cognos.crconfig.data.WizardOption;
import com.cognos.crconfig.data.WizardPageData;
import com.cognos.crconfig.data.WizardParameterData;
import com.cognos.crconfig.data.WizardTemplatedParameterData;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import javax.swing.Icon;

public class CnfgWizard
implements CnfgDataListener {
    private static final CnfgWizard INSTANCE = new CnfgWizard();
    private ArrayList m_lWizardPages = new ArrayList();
    private int m_iCurrentPageIndex;
    private ArrayList m_lChainedWizardPages = new ArrayList();
    private Stack m_lEntryPagesIndex = new Stack();
    public static final int MAX_PARAM_PER_PAGE = 5;
    public static final String WIZARD_CUSTOM_RADIOBUTTON_USEEDITOR = "cogcnfg_wizard_usseditor";
    public static final String WIZARD_JAVA_PROP = "java_prop";
    public static final String WIZARD_WIZARD_PROP = "wizard_prop";
    public static final String WIZARD_THIS_PROP = "this";
    public static final String WIZARD_GENWAR = "genwarwizard";
    public static final String WIZARD_INSTALLCOGNOSAPP = "InstallCognosAppWizard";
    public static final String WIZARD_VERIFYCONFORMANCE = "verifyConfWizard";
    private boolean m_bWizardMenuLoaded = false;
    private String m_sWizardHelpFileName = null;
    private String m_sWizardLabel = null;
    private String m_sWizardName = null;
    private boolean m_bWizardMode = false;
    private String m_sPanelClassName = null;

    public static CnfgWizard getInstance() {
        return INSTANCE;
    }

    private CnfgWizard() {
        this.initWizard();
    }

    public void initWizard() {
        for (int i = 0; i < this.m_lWizardPages.size(); ++i) {
            CnfgWizardPage cwp = (CnfgWizardPage)this.m_lWizardPages.get(i);
            if (!cwp.isEntryPage()) continue;
            WizardPageData wp = cwp.getWizardTPageData();
            wp.resetParameterValues();
        }
        this.m_lWizardPages.clear();
        this.m_iCurrentPageIndex = 0;
        this.m_lEntryPagesIndex.clear();
    }

    public String getWizardModeName() {
        return this.m_sWizardName;
    }

    public String getWizardLabel() {
        return this.m_sWizardLabel;
    }

    public String getWizardHelpFileName() {
        if (this.m_sWizardHelpFileName != null) {
            return this.m_sWizardHelpFileName;
        }
        return "";
    }

    public boolean isWizardMode() {
        return this.m_bWizardMode;
    }

    public ArrayList getWizardPages() {
        return this.m_lWizardPages;
    }

    public int getCurrentPageIndex() {
        return this.m_iCurrentPageIndex;
    }

    public void addToChainedWizardPageList() {
        this.m_lChainedWizardPages.addAll(this.m_lWizardPages);
    }

    public void reloadData(boolean bReloadParamRef) {
        List<WizardData> lWizardData = DataManager.getInstance().getWizardContent();
        if (lWizardData == null) {
            return;
        }
        for (int i = 0; i < lWizardData.size(); ++i) {
            WizardData oWizardPage = lWizardData.get(i);
            if (WizardPageData.class.isInstance(oWizardPage)) {
                WizardPageData wp = (WizardPageData)oWizardPage;
                wp.reloadData(bReloadParamRef);
            }
            if (!WizardComplexPageData.class.isInstance(oWizardPage)) continue;
            WizardComplexPageData cwp = (WizardComplexPageData)oWizardPage;
            cwp.reloadData(bReloadParamRef);
        }
    }

    public boolean isCurrentPageLast() {
        if ((CnfgWizardPage)this.m_lWizardPages.get(this.m_iCurrentPageIndex) != null) {
            return ((CnfgWizardPage)this.m_lWizardPages.get(this.m_iCurrentPageIndex)).isLastPage();
        }
        return false;
    }

    public void cleanWizardPages(CnfgWizardPage fromPage) {
        Object[] entryObj;
        int entryIdx;
        int startIdx = this.m_lWizardPages.indexOf(fromPage);
        if (startIdx >= 0) {
            while (this.m_lWizardPages.size() > startIdx) {
                this.m_lWizardPages.remove(startIdx);
            }
            int n = this.m_iCurrentPageIndex = this.m_lWizardPages.size() > 0 ? this.m_lWizardPages.size() - 1 : 0;
        }
        while (!this.m_lEntryPagesIndex.empty() && (entryIdx = ((Integer)(entryObj = (Object[])this.m_lEntryPagesIndex.peek())[0]).intValue()) >= startIdx) {
            this.m_lEntryPagesIndex.pop();
        }
    }

    public CnfgWizardPage getCurrentWizardPage() {
        if (this.m_lWizardPages.size() > 0) {
            return (CnfgWizardPage)this.m_lWizardPages.get(this.m_iCurrentPageIndex);
        }
        if (DataManager.getInstance().getWizardContent() == null || DataManager.getInstance().getWizardContent().size() <= 0) {
            return null;
        }
        this.m_iCurrentPageIndex = 0;
        WizardData page = DataManager.getInstance().getWizardContent().get(this.m_iCurrentPageIndex);
        if (WizardPageData.class.isInstance(page)) {
            WizardPageData wPageData = (WizardPageData)page;
            CnfgWizardPage wPage = new CnfgWizardPage(null, null, DataManager.getInstance().getWizardContent(), wPageData, this, true);
            this.m_lWizardPages.add(wPage);
            return wPage;
        }
        return null;
    }

    public CnfgWizardPage getPreviousWizardPage() {
        boolean bFound = false;
        if (this.m_iCurrentPageIndex > 0) {
            WizardTemplatedParameterData wtp;
            while (this.m_lWizardPages.size() > this.m_iCurrentPageIndex) {
                this.m_lWizardPages.remove(this.m_iCurrentPageIndex);
            }
            --this.m_iCurrentPageIndex;
            CnfgWizardPage cwp = (CnfgWizardPage)this.m_lWizardPages.get(this.m_iCurrentPageIndex);
            cwp.resetActionState();
            if (cwp.isEntryPage() && (wtp = cwp.getWizardTParam()) != null) {
                wtp.revalidateInstancesList();
            }
            while (!this.m_lEntryPagesIndex.empty()) {
                Object[] entryObj = (Object[])this.m_lEntryPagesIndex.peek();
                int entryIdx = (Integer)entryObj[0];
                if (this.m_iCurrentPageIndex < entryIdx) {
                    this.m_lEntryPagesIndex.pop();
                    continue;
                }
                if (this.m_iCurrentPageIndex != entryIdx) break;
                bFound = true;
                break;
            }
            if (cwp.isEntryPage() && !bFound) {
                WizardTemplatedParameterData wtp2 = cwp.getWizardTParam();
                Object[] entryIdx = new Object[]{new Integer(this.m_iCurrentPageIndex), wtp2 != null ? new Boolean(wtp2.isTopLevel()) : new Boolean(false)};
                this.m_lEntryPagesIndex.push(entryIdx);
            }
            return cwp;
        }
        return null;
    }

    public CnfgWizardPage generateNextWizardPage(CnfgWizardPanel dw) {
        List<WizardData> wpList;
        int index;
        CnfgWizardPage curPage = this.getCurrentWizardPage();
        CnfgWizardPage continuePage = this.generateContinueWizardPage(curPage);
        if (continuePage != null) {
            return continuePage;
        }
        CnfgWizardPage tPage = this.generateNextTemplatedPage(curPage, dw);
        if (tPage != null) {
            return tPage;
        }
        if (curPage != null && (index = (wpList = curPage.getWizardPageDataList()).indexOf(curPage.getWizardPageData())) >= 0) {
            if (index < wpList.size() - 1) {
                return this.generatePage(curPage.getComlexWizardPageData(), curPage.getWizardCase(), wpList, index + 1);
            }
            if (curPage.getComlexWizardPageData() != null) {
                if (curPage.getWizardCase() != null) {
                    WizardOption wc;
                    ArrayList caseList = curPage.getComlexWizardPageData().getCasesList();
                    int caseIdx = caseList.indexOf(curPage.getWizardCase());
                    WizardPageData dependPage = this.getDependencyPage(curPage.getComlexWizardPageData());
                    if (dependPage != null && (wc = curPage.getComlexWizardPageData().getValidWizardCase(dependPage, caseIdx + 1)) != null) {
                        return this.generatePage(curPage.getComlexWizardPageData(), wc, wc.getWizardPageList(), 0);
                    }
                }
                if ((index = (wpList = DataManager.getInstance().getWizardContent()).indexOf(curPage.getComlexWizardPageData())) >= 0 && index < wpList.size() - 1) {
                    return this.generatePage(null, null, wpList, index + 1);
                }
            }
            return null;
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CnfgWizard::generateNextWizardPage() - Could not generate the next wizard page. ");
        }
        return null;
    }

    public void setConfigValues() {
        for (int i = 0; i < this.m_lWizardPages.size(); ++i) {
            CnfgWizardPage cwp = (CnfgWizardPage)this.m_lWizardPages.get(i);
            if (cwp.isTemplatedPage() && (!cwp.isTemplatedPage() || !cwp.isEntryPage())) continue;
            cwp.getWizardPageData().setConfigValues();
        }
    }

    private WizardPageData getDependencyPage(WizardComplexPageData cwPageData) {
        for (int i = this.m_lWizardPages.size() - 1; i >= 0; --i) {
            CnfgWizardPage dwPage = (CnfgWizardPage)this.m_lWizardPages.get(i);
            if (dwPage.getWizardPageData() == null || !dwPage.getWizardPageData().checkWizardPage(cwPageData.getDependencyComplexPage(), cwPageData.getDependencyGroup(), cwPageData.getDependencyPage())) continue;
            return dwPage.getWizardPageData();
        }
        return null;
    }

    private CnfgWizardPage generatePage(WizardComplexPageData cwpData, WizardOption wCase, List<WizardData> wpList, int index) {
        WizardData pageData = wpList.get(index);
        WizardPageData curWP = null;
        WizardComplexPageData curCWP = null;
        ArrayList curWPList = null;
        WizardOption curCase = null;
        if (WizardPageData.class.isInstance(pageData)) {
            curWP = (WizardPageData)pageData;
            curCWP = cwpData;
            curWPList = wpList;
            curCase = wCase;
        } else if (WizardComplexPageData.class.isInstance(pageData)) {
            WizardComplexPageData cwPageData = (WizardComplexPageData)pageData;
            WizardPageData dependPage = this.getDependencyPage(cwPageData);
            if (dependPage == null) {
                if (index < wpList.size() - 1) {
                    return this.generatePage(null, null, wpList, index + 1);
                }
                return null;
            }
            ArrayList lWizardPages = null;
            if (cwPageData.hasCases()) {
                curCase = cwPageData.getValidWizardCase(dependPage, 0);
                if (curCase != null) {
                    lWizardPages = curCase.getWizardPageList();
                }
            } else {
                lWizardPages = cwPageData.getValidWizardPages(dependPage);
            }
            if (lWizardPages == null) {
                if (index < wpList.size() - 1) {
                    return this.generatePage(null, null, wpList, index + 1);
                }
                return null;
            }
            curWP = (WizardPageData)lWizardPages.get(0);
            curCWP = cwPageData;
            curWPList = lWizardPages;
        } else {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgWizard::generatePage() - The current page data object is invalid.");
            }
            return null;
        }
        CnfgWizardPage curPage = new CnfgWizardPage(curCWP, curCase, curWPList, curWP, this, false);
        if (curWP.getNumOfParamsToDisplay() == 0 && curWP.getWizardTParamList().size() != 0) {
            ArrayList tparamlist = curWP.getWizardTParamList();
            for (int i = 0; i < tparamlist.size(); ++i) {
                WizardTemplatedParameterData wtp = (WizardTemplatedParameterData)tparamlist.get(i);
                if (!wtp.isTopLevel()) continue;
                return this.generateEntryPage(curPage, tparamlist, i, true);
            }
        }
        this.reloadParamValue(curPage.getWizardPageData());
        this.m_lWizardPages.add(curPage);
        ++this.m_iCurrentPageIndex;
        return curPage;
    }

    private void reloadParamValue(WizardPageData pageData) {
        ArrayList paramList = pageData.getWizardParamList();
        if (paramList == null) {
            return;
        }
        for (int i = 0; i < paramList.size(); ++i) {
            boolean bDone;
            WizardParameterData wParam = (WizardParameterData)paramList.get(i);
            Parameter curParam = wParam.getParam();
            if (curParam == null || (bDone = this.searchAndLoadParamValue(this.m_lWizardPages, curParam)) || !wParam.isWizardParam()) continue;
            bDone = this.searchAndLoadParamValue(this.m_lChainedWizardPages, curParam);
        }
    }

    private boolean searchAndLoadParamValue(ArrayList lWizPages, Parameter curParam) {
        String paramName = curParam.getName();
        for (int j = lWizPages.size() - 1; j >= 0; --j) {
            CnfgWizardPage cwp = (CnfgWizardPage)lWizPages.get(j);
            if (cwp == null || cwp.getWizardPageData() == null) continue;
            ArrayList prevParamList = cwp.getWizardPageData().getWizardParamList();
            for (int k = 0; k < prevParamList.size(); ++k) {
                WizardParameterData prevwParam = (WizardParameterData)prevParamList.get(k);
                Parameter prevParam = prevwParam.getParam();
                if (prevParam == null || !prevParam.getName().equalsIgnoreCase(paramName)) continue;
                curParam.setValue(prevParam.getValue());
                return true;
            }
        }
        return false;
    }

    public void resetParamValue(WizardParameterData wParam, CnfgWizardPage curWPage) {
        if (wParam == null) {
            return;
        }
        Parameter curParam = wParam.getParam();
        if (curParam != null) {
            String paramName = curParam.getName();
            int idx = this.m_lWizardPages.indexOf(curWPage);
            for (int j = idx - 1; j >= 0; --j) {
                CnfgWizardPage cwp = (CnfgWizardPage)this.m_lWizardPages.get(j);
                if (cwp == null || cwp.getWizardPageData() == null) continue;
                ArrayList prevParamList = cwp.getWizardPageData().getWizardParamList();
                for (int k = 0; k < prevParamList.size(); ++k) {
                    WizardParameterData prevwParam = (WizardParameterData)prevParamList.get(k);
                    Parameter prevParam = prevwParam.getParam();
                    if (prevParam == null || !prevParam.getName().equalsIgnoreCase(paramName)) continue;
                    prevParam.setValue(curParam.getValue());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CnfgWizardPage generateNextTemplatedPage(CnfgWizardPage curPage, CnfgWizardPanel dw) {
        if (curPage.isTemplatedPage()) {
            WizardPageData wPageData;
            if (curPage.isEntryPage()) {
                wPageData = curPage.getWizardTPageData();
                ArrayList paramList = wPageData.getWizardParamList();
                String opValue = null;
                String sOpLabel = "";
                for (int i = 0; i < paramList.size(); ++i) {
                    WizardParameterData wParam = (WizardParameterData)paramList.get(i);
                    Parameter curParam = wParam.getParam();
                    if (curParam == null || !curParam.getName().equals("operation")) continue;
                    Object paramValue = curParam.getValue();
                    if (paramValue == null) break;
                    opValue = paramValue.toString();
                    sOpLabel = CnfgUIDocResource.getMessage(curParam.getValues().get(opValue).toString(), "config_wizard");
                    break;
                }
                if (opValue != null && dw != null) {
                    WizardPageData wp = null;
                    WizardTemplatedParameterData tParam = curPage.getWizardTParam();
                    tParam.setPropertyPageTitle(sOpLabel);
                    if (opValue.equals("create")) {
                        wp = tParam.addNewInstance(dw.getNewName(), dw.getNewType());
                    } else if (opValue.equals("edit")) {
                        wp = dw.getEditPage();
                    } else {
                        if (opValue.equals("delete")) {
                            tParam.deleteInstance(dw.getDeletedPage(), false);
                            return curPage;
                        }
                        if (opValue.equals("switch")) {
                            wp = tParam.addNewInstance(dw.getNewName(), dw.getNewType());
                            WizardPageData sp = dw.getSwitchFromPage();
                            if (sp != null) {
                                tParam.deleteInstance(sp, true);
                            }
                        } else if (opValue.equals("exit")) {
                            Object[] entryObj;
                            int entryIdx;
                            while (!this.m_lEntryPagesIndex.empty() && this.m_iCurrentPageIndex != (entryIdx = ((Integer)(entryObj = (Object[])this.m_lEntryPagesIndex.pop())[0]).intValue())) {
                            }
                            int idx = curPage.getWizardTParamList().indexOf(curPage.getWizardTParam());
                            if (idx < curPage.getWizardTParamList().size() - 1) {
                                return this.generateEntryPage(curPage, curPage.getWizardTParamList(), idx + 1, false);
                            }
                            if (this.m_lEntryPagesIndex.empty()) return null;
                            Object[] entryObj2 = (Object[])this.m_lEntryPagesIndex.peek();
                            int entryPageIdx = (Integer)entryObj2[0];
                            while (this.m_lWizardPages.size() > entryPageIdx + 1) {
                                this.m_lWizardPages.remove(entryPageIdx + 1);
                            }
                            this.m_iCurrentPageIndex = entryPageIdx;
                            return (CnfgWizardPage)this.m_lWizardPages.get(entryPageIdx);
                        }
                    }
                    if (wp == null) return null;
                    CnfgWizardPage wPage = new CnfgWizardPage(wp, curPage.getWizardTParam(), curPage.getWizardTParamList(), curPage.getComlexWizardPageData(), curPage.getWizardCase(), curPage.getWizardPageDataList(), curPage.getWizardPageData(), this, false, false);
                    this.m_lWizardPages.add(wPage);
                    ++this.m_iCurrentPageIndex;
                    return wPage;
                }
            } else {
                if (curPage.isActionPage()) {
                    return this.generateSummaryPage(curPage);
                }
                if (curPage.isSummaryPage()) {
                    String wizStyle;
                    wPageData = curPage.getWizardTPageData();
                    WizardPageData propPage = this.getInstancePropertyPageData(curPage);
                    if (propPage != null && wPageData != null) {
                        propPage.setActionState(wPageData.getActionState());
                    }
                    if ((wizStyle = DataManager.getInstance().getWizardStyle(this.m_sWizardName)) == null || !wizStyle.equals("loop")) return null;
                    if (!this.m_lEntryPagesIndex.empty()) {
                        Object[] entryObj = (Object[])this.m_lEntryPagesIndex.peek();
                        int entryPageIdx = (Integer)entryObj[0];
                        while (this.m_lWizardPages.size() > entryPageIdx + 1) {
                            this.m_lWizardPages.remove(entryPageIdx + 1);
                        }
                        this.m_iCurrentPageIndex = entryPageIdx;
                        return (CnfgWizardPage)this.m_lWizardPages.get(entryPageIdx);
                    }
                } else {
                    CnfgWizardPage actionPage = this.generateActionPage(curPage);
                    if (actionPage != null) return actionPage;
                    return this.generateSummaryPage(curPage);
                }
            }
        }
        if (curPage.getWizardPageData() == null) return null;
        ArrayList tparamlist = curPage.getWizardPageData().getWizardTParamList();
        for (int i = 0; i < tparamlist.size(); ++i) {
            WizardTemplatedParameterData wtp = (WizardTemplatedParameterData)tparamlist.get(i);
            if (!wtp.isTopLevel()) continue;
            return this.generateEntryPage(curPage, tparamlist, i, true);
        }
        return null;
    }

    private CnfgWizardPage generateEntryPage(CnfgWizardPage curPage, ArrayList tParamList, int tParamIndex, boolean bIsTopLevel) {
        if (tParamIndex < 0) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgWizard::generateEntryPage() - The page index is invalid.");
            }
            return null;
        }
        WizardTemplatedParameterData wtp = (WizardTemplatedParameterData)tParamList.get(tParamIndex);
        wtp.revalidateInstancesList();
        CnfgWizardPage wPage = new CnfgWizardPage(wtp.getEntryPage(), wtp, tParamList, curPage.getComlexWizardPageData(), curPage.getWizardCase(), curPage.getWizardPageDataList(), curPage.getWizardPageData(), this, false, true);
        this.m_lWizardPages.add(wPage);
        ++this.m_iCurrentPageIndex;
        Object[] entryIdx = new Object[]{new Integer(this.m_iCurrentPageIndex), new Boolean(bIsTopLevel)};
        this.m_lEntryPagesIndex.push(entryIdx);
        return wPage;
    }

    public CnfgWizardPage generateEntryPage(WizardTemplatedParameterData wtp) {
        CnfgWizardPage curPage = this.getCurrentWizardPage();
        if (curPage == null) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgWizard::generateEntryPage() - The current page is null.");
            }
            return null;
        }
        ArrayList tParamList = new ArrayList();
        if (curPage.isTemplatedPage()) {
            if (curPage.getWizardTPageData() != null) {
                tParamList = curPage.getWizardTPageData().getWizardTParamList();
            }
        } else if (curPage.getWizardPageData() != null) {
            tParamList = curPage.getWizardPageData().getWizardTParamList();
        }
        return this.generateEntryPage(curPage, tParamList, tParamList.indexOf(wtp), false);
    }

    private CnfgWizardPage generateActionPage(CnfgWizardPage curPage) {
        WizardTemplatedParameterData wtp = curPage.getWizardTParam();
        WizardPageData wp = curPage.getWizardTPageData();
        if (wp.hasActionParam()) {
            WizardPageData actionPage = new WizardPageData(wp);
            if (wtp.getActionPage() != null) {
                actionPage.setOverViewList(wtp.getActionPage().getOverViewList());
                actionPage.setMaxNumOfParam(wtp.getActionPage().getMaxNumOfParam());
            }
            actionPage.setActionParams(wp);
            CnfgWizardPage wPage = new CnfgWizardPage(actionPage, wtp, curPage.getWizardTParamList(), curPage.getComlexWizardPageData(), curPage.getWizardCase(), curPage.getWizardPageDataList(), curPage.getWizardPageData(), this, false, false);
            wPage.setActionPage();
            this.m_lWizardPages.add(wPage);
            ++this.m_iCurrentPageIndex;
            return wPage;
        }
        return null;
    }

    private WizardPageData getInstancePropertyPageData(CnfgWizardPage curPage) {
        if (curPage.isActionPage() || curPage.isSummaryPage()) {
            int idx = this.m_lWizardPages.indexOf(curPage);
            for (int i = idx - 1; i >= 0; --i) {
                CnfgWizardPage cwp = (CnfgWizardPage)this.m_lWizardPages.get(i);
                if (cwp.isTemplatedPage()) {
                    if (cwp.isEntryPage()) {
                        return null;
                    }
                    if (cwp.isActionPage()) continue;
                    return cwp.getWizardTPageData();
                }
                return null;
            }
        } else {
            return curPage.getWizardTPageData();
        }
        return null;
    }

    private CnfgWizardPage generateSummaryPage(CnfgWizardPage curPage) {
        WizardTemplatedParameterData wtp = curPage.getWizardTParam();
        WizardPageData wp = this.getInstancePropertyPageData(curPage);
        WizardPageData summaryPage = new WizardPageData(wp);
        if (wtp.getSummaryPage() != null) {
            summaryPage.setOverViewList(wtp.getSummaryPage().getOverViewList());
        }
        summaryPage.setWizardParamList(wp.getWizardParamList());
        summaryPage.setInstLabel(wp.getInstLabel());
        summaryPage.setInstType(wp.getInstType());
        CnfgWizardPage wPage = new CnfgWizardPage(summaryPage, wtp, curPage.getWizardTParamList(), curPage.getComlexWizardPageData(), curPage.getWizardCase(), curPage.getWizardPageDataList(), curPage.getWizardPageData(), this, false, false);
        wPage.setSummaryPage();
        this.m_lWizardPages.add(wPage);
        ++this.m_iCurrentPageIndex;
        return wPage;
    }

    private CnfgWizardPage generateContinueWizardPage(CnfgWizardPage curPage) {
        if (curPage.isEntryPage() || curPage.isSummaryPage()) {
            return null;
        }
        WizardPageData wp = null;
        wp = curPage.isTemplatedPage() ? curPage.getWizardTPageData() : curPage.getWizardPageData();
        if (wp.hasMoreParams(curPage.getParamBeginIndex())) {
            CnfgWizardPage newPage = (CnfgWizardPage)curPage.clone();
            newPage.setNextDisplayParams();
            this.m_lWizardPages.add(newPage);
            ++this.m_iCurrentPageIndex;
            return newPage;
        }
        return null;
    }

    public void getUpdatedParamList(ArrayList paramList) {
        for (int i = 0; i < this.m_lWizardPages.size(); ++i) {
            ArrayList pl;
            CnfgWizardPage cwp = (CnfgWizardPage)this.m_lWizardPages.get(i);
            if (cwp == null || cwp.isTemplatedPage() || (pl = cwp.getWizardPageData().getConfigParamList()) == null) continue;
            paramList.addAll(pl);
        }
    }

    protected void launchWizard(String wizardName) {
        CRConfigFrame.getInstance().stopCellEditing();
        this.setCurrentWizard(false, wizardName);
        this.setWizardContent(wizardName);
        if (DataManager.getInstance().getWizardContent() == null) {
            Object[] oMsg = new Object[]{CnfgResource.getMessage("Message.wizard.load.failed.notification"), CnfgResource.getMessage("Message.loadConfig.failed.resolution")};
            DialogMessage.showDialog(oMsg, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
            return;
        }
        this.initWizard();
        this.reloadData(true);
        CnfgWizardDialog dlg = new CnfgWizardDialog(CRConfigFrame.getInstance(), this, false);
        CnfgWizardPage cwp = this.getCurrentWizardPage();
        if (cwp != null && dlg != null) {
            dlg.refresh(cwp);
            dlg.show();
        } else {
            Object[] oMsg = new Object[]{CnfgResource.getMessage("Message.wizard.load.failed.notification"), CnfgResource.getMessage("Message.loadConfig.failed.resolution")};
            DialogMessage.showDialog(oMsg, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
        }
    }

    public void action_Wizard(String wizardName) {
        this.cleanupChainedWizards();
        this.launchWizard(wizardName);
    }

    protected void cleanupChainedWizards() {
        this.m_lChainedWizardPages.clear();
    }

    @Override
    public void dataLoaded(CnfgDataEvent e) {
        if (this.m_bWizardMenuLoaded) {
            return;
        }
        if (!DataManager.getInstance().globalWizardsAvailable()) {
            return;
        }
        CnfgMenu menuWizard = new CnfgMenu(CnfgResource.getMessage("Menu.wizard"), null);
        Hashtable wizardMap = DataManager.getInstance().getWizardMap();
        boolean bFoundMoreWizards = false;
        Enumeration enumeration = wizardMap.keys();
        while (enumeration.hasMoreElements()) {
            String sKey = (String)enumeration.nextElement();
            if (sKey.equalsIgnoreCase(WIZARD_GENWAR) || DataManager.getInstance().isContextualWizard(sKey)) continue;
            String sLabel = DataManager.getInstance().getWizardLabel(sKey);
            String sMenuItemTitle = CnfgUIDocResource.getMessage(sLabel, "config_wizard");
            char lastAccelerator = CnfgUIDocResource.getLastAccelerator();
            class AbstractAction_ActionsWizard
            extends CnfgSwingAction {
                public AbstractAction_ActionsWizard(String wizName, Icon toolbarIcon) {
                    super(wizName, toolbarIcon);
                }

                public AbstractAction_ActionsWizard(String wizName) {
                    super(wizName);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    CnfgWizard.this.action_Wizard(this.getValue("Name").toString());
                }
            }
            AbstractAction_ActionsWizard actionActionsWizard = new AbstractAction_ActionsWizard(sKey);
            menuWizard.addMenuItem(sMenuItemTitle, lastAccelerator, null, true, actionActionsWizard);
            bFoundMoreWizards = true;
        }
        if (bFoundMoreWizards) {
            CRConfigFrame.getInstance().getCnfgMenuBar().add(menuWizard);
            CRConfigFrame.getInstance().validate();
        }
        this.m_bWizardMenuLoaded = true;
    }

    public void setWizardContent(String wizardName) {
        DataManager.getInstance().setWizardContent(wizardName);
        this.m_sWizardLabel = CnfgUIDocResource.getMessage(DataManager.getInstance().getWizardLabel(this.m_sWizardName), "config_wizard");
        this.m_sWizardHelpFileName = DataManager.getInstance().getWizardHelpFileName(this.m_sWizardName);
        this.m_sPanelClassName = DataManager.getInstance().getWizardPanelClassName(this.m_sWizardName);
    }

    public void setCurrentWizard(boolean isWizardMode, String wizardName) {
        this.m_bWizardMode = isWizardMode;
        this.m_sWizardName = wizardName;
    }

    protected CnfgWizardPanel getWizardPanel(Class parentCls, Object parentObj) {
        String className = this.m_sPanelClassName == "" || this.m_sPanelClassName == null ? CnfgWizardPanel.class.getName() : this.m_sPanelClassName;
        CnfgWizardPanel wizPanel = null;
        try {
            Class<?> panelClass = Class.forName(className);
            Class[] ctorTypes = new Class[]{parentCls, CnfgWizard.class};
            Constructor<?> ctor = panelClass.getConstructor(ctorTypes);
            Object[] ctorArgList = new Object[]{parentObj, this};
            wizPanel = (CnfgWizardPanel)ctor.newInstance(ctorArgList);
        }
        catch (Exception e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgWizard.getWizardPanel - Could not get wizard panel, class is " + className + e);
                CnfgLog.debug("Falling back and creating a " + CnfgWizardPanel.class.getName());
            }
            wizPanel = parentObj.getClass().equals(CnfgWizardFrame.class) ? new CnfgWizardPanel((CnfgWizardFrame)parentObj, this) : new CnfgWizardPanel((CnfgWizardDialog)parentObj, this);
        }
        return wizPanel;
    }

    protected void setPanelClassName(String panelClass) {
        this.m_sPanelClassName = panelClass;
    }
}

