/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgField;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.CnfgWizardDialog;
import com.cognos.crconfig.CnfgWizardFrame;
import com.cognos.crconfig.CnfgWizardPage;
import com.cognos.crconfig.CnfgWizardPanel;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.Constants;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.ExternalProcess;
import com.cognos.crconfig.data.LocalURLParameter;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.WizardPageData;
import com.cognos.crconfig.data.WizardParameterData;
import com.cognos.crconfig.editors.EditorArrayParameter;
import com.cognos.crconfig.websphere.WebSphereAdmin;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class CnfgWizardConfigureWASPanel
extends CnfgWizardPanel {
    private static final String ENV_CONFIG_WIZ_PAGE_NAME = "EnvConfig";
    private String m_sHttpPort = null;
    private String m_sHttpsPort = null;
    private String m_sContextRoot = null;

    public CnfgWizardConfigureWASPanel(CnfgWizardFrame parent, CnfgWizard cw) {
        super(parent, cw);
        this.setDialogSize();
    }

    public CnfgWizardConfigureWASPanel(CnfgWizardDialog parent, CnfgWizard cw) {
        super(parent, cw);
        this.setDialogSize();
    }

    private void setDialogSize() {
        int minHeight = CnfgUtils.isWindowsPlatform() ? 600 : 720;
        this.setMinimumSize(new Dimension(500, minHeight));
        this.setPreferredSize(new Dimension(500, minHeight));
    }

    @Override
    public void actionNext() {
        block7: {
            CnfgWizardPage wp = this.getWizard().getCurrentWizardPage();
            WizardPageData wpd = wp.getWizardPageData();
            if (!wp.setWizardValues()) {
                return;
            }
            if (!wpd.getName().equals(ENV_CONFIG_WIZ_PAGE_NAME)) break block7;
            ArrayList paramList = wpd.getWizardParamList();
            for (WizardParameterData wParam : paramList) {
                ArrayList<String> lMsg;
                Parameter parmRef;
                block9: {
                    Serializable field;
                    Object component;
                    String paramName;
                    block8: {
                        Object[] args;
                        String targetPort;
                        parmRef = wParam.getParamRef();
                        paramName = parmRef.getName();
                        component = wParam.getComponent();
                        if (component == null) continue;
                        lMsg = new ArrayList<String>();
                        if (!paramName.equals("internalDispatcher") && !paramName.equals("externalDispatcher") && !paramName.equals("sdk")) break block8;
                        field = (CnfgField)component;
                        String value = ((JTextComponent)field).getText();
                        String string = targetPort = value.startsWith("https://") ? this.m_sHttpsPort : this.m_sHttpPort;
                        if (targetPort.length() > 0 && value.indexOf(targetPort) == -1) {
                            ((JComponent)field).requestFocus();
                            args = new String[]{targetPort};
                            lMsg.add(CnfgResource.getMessage("Message.was.configure.validation.disp.port", args));
                        }
                        if (this.m_sContextRoot.length() <= 0 || value.indexOf(this.m_sContextRoot) != -1) break block9;
                        ((JComponent)field).requestFocus();
                        args = new String[]{this.m_sContextRoot};
                        lMsg.add(CnfgResource.getMessage("Message.was.configure.validation.disp.contextroot", args));
                        break block9;
                    }
                    if (paramName.equals("contentManagers") && DataManager.getInstance().isInstalled("CM") || paramName.equals(Constants.CRN_DISP_FOR_GW)) {
                        field = (EditorArrayParameter)component;
                        ArrayParameter p = ((EditorArrayParameter)field).getParam();
                        Set<Parameter> values = p.getCurrentValues();
                        for (Parameter parm : values) {
                            Object[] args;
                            String value = (String)parm.getValue();
                            if (this.m_sHttpPort.length() == 0 && this.m_sContextRoot.length() == 0 || !LocalURLParameter.isLocalURL(value)) continue;
                            if (paramName.equals("contentManagers") && !value.startsWith("http://")) {
                                lMsg.add(CnfgResource.getMessage("Message.was.configure.validation.cm.protocol"));
                            }
                            if (this.m_sHttpPort.length() > 0 && value.indexOf(this.m_sHttpPort) == -1) {
                                args = new String[]{this.m_sHttpPort};
                                lMsg.add(CnfgResource.getMessage("Message.was.configure.validation.cm.port", args));
                            }
                            if (this.m_sContextRoot.length() <= 0 || value.indexOf(this.m_sContextRoot) != -1) break;
                            args = new String[]{this.m_sContextRoot};
                            lMsg.add(CnfgResource.getMessage("Message.was.configure.validation.cm.contextroot", args));
                            break;
                        }
                    }
                }
                if (lMsg.size() <= 0) continue;
                Object[] args = new Object[]{parmRef.getLabel()};
                lMsg.add(0, CnfgResource.getMessage("Message.errorOnWizard.badvalue.resolution", args));
                DialogMessage.showDialog(lMsg, this.getWizard().getWizardLabel(), DialogMessage.ICON_WARNING, DialogMessage.OPTS_NOARGS, 0);
                return;
            }
        }
        super.actionNext();
    }

    @Override
    protected void discoverParamValues(WizardParameterData wparam) {
        String paramName;
        Parameter param = wparam.getParam();
        if (param != null && param.getName() != null && ((paramName = param.getName()).equalsIgnoreCase("WAS_http_port") || paramName.equalsIgnoreCase("WAS_https_port") || paramName.equalsIgnoreCase("WAS_context_root"))) {
            DialogMessage dlgProgress = DialogMessage.getWaitDialog(CnfgResource.getMessage("Message.request.user.to.wait"), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ACTION_RUNNING);
            BusyIndicationThread prg = new BusyIndicationThread(dlgProgress);
            prg.start();
            dlgProgress.setVisible(true);
            if (paramName.equalsIgnoreCase("WAS_http_port")) {
                param.setValue(this.m_sHttpPort == null ? "" : this.m_sHttpPort);
            } else if (paramName.equalsIgnoreCase("WAS_https_port")) {
                param.setValue(this.m_sHttpsPort == null ? "" : this.m_sHttpsPort);
            } else if (paramName.equalsIgnoreCase("WAS_context_root")) {
                param.setValue(this.m_sContextRoot == null ? "" : this.m_sContextRoot);
            }
        }
    }

    private void discoverWASContextRoot() {
        int retValue;
        if (this.m_sContextRoot != null) {
            return;
        }
        this.m_sContextRoot = "";
        Parameter param = DataManager.getInstance().findParm("WAS_serverProfile");
        if (param == null) {
            return;
        }
        String sWASProfile = (String)param.getValue();
        WebSphereAdmin wasAdmin = this.getWebSphereAdmin();
        if (wasAdmin == null) {
            return;
        }
        String[] pArgs = wasAdmin.getContextRoot(sWASProfile, "IBM Cognos");
        ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
        try {
            retValue = p.executeExternalProcess();
        }
        catch (Exception e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Could not get the context root. Profile name = " + sWASProfile + ". " + e.getMessage());
            }
            return;
        }
        if (retValue == 0) {
            String sRetValue = p.getErrorMsg();
            Pattern pattern = Pattern.compile("Context[\\s]*Root[\\s]*:");
            Matcher m = pattern.matcher(sRetValue);
            if (m.find()) {
                String contextRoot = sRetValue.substring(m.end() + 1);
                String[] splitsVille = contextRoot.split("\n", 2);
                this.m_sContextRoot = splitsVille[0].trim();
            }
        }
    }

    private WebSphereAdmin getWebSphereAdmin() {
        Parameter param = DataManager.getInstance().findParm("WAS_path");
        if (param == null) {
            return null;
        }
        String sWASPath = (String)param.getValue();
        if (sWASPath == null || sWASPath.length() == 0) {
            return null;
        }
        WebSphereAdmin wasAdmin = new WebSphereAdmin(sWASPath);
        if (!wasAdmin.isValid()) {
            return null;
        }
        return wasAdmin;
    }

    private void discoverWASHTTPPorts() {
        block16: {
            int retValue;
            if (this.m_sHttpPort != null && this.m_sHttpsPort != null) {
                return;
            }
            this.m_sHttpPort = "";
            this.m_sHttpsPort = "";
            Parameter param = DataManager.getInstance().findParm("WAS_serverProfile");
            if (param == null) {
                return;
            }
            String sWASProfile = (String)param.getValue();
            if (sWASProfile == null || sWASProfile.length() == 0) {
                return;
            }
            WebSphereAdmin wasAdmin = this.getWebSphereAdmin();
            if (wasAdmin == null) {
                return;
            }
            String[] pArgs = wasAdmin.getProfilePath(sWASProfile);
            ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
            try {
                retValue = p.executeExternalProcess();
            }
            catch (Exception e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("Could not find the profile path. Profile name = " + sWASProfile + ". " + e.getMessage());
                }
                return;
            }
            if (retValue == 0) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(p.getErrorMsg().trim() + "/logs/AboutThisProfile.txt")));
                    String sLine = reader.readLine();
                    while (sLine != null) {
                        if (sLine.startsWith("HTTP transport port: ")) {
                            this.m_sHttpPort = sLine.substring("HTTP transport port: ".length()).trim();
                        } else if (sLine.startsWith("HTTPS transport port: ")) {
                            this.m_sHttpsPort = sLine.substring("HTTP transport port: ".length()).trim();
                        }
                        sLine = reader.readLine();
                    }
                    reader.close();
                }
                catch (FileNotFoundException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                }
                catch (IOException e) {
                    if (!CnfgLog.isDebugEnabled()) break block16;
                    CnfgLog.debug(e);
                }
            }
        }
    }

    private class BusyIndicationThread
    extends Thread {
        DialogMessage m_dlg = null;

        public BusyIndicationThread(DialogMessage dlg) {
            this.m_dlg = dlg;
        }

        @Override
        public void run() {
            BusyIndicationThread.yield();
            CnfgWizardConfigureWASPanel.this.discoverWASHTTPPorts();
            CnfgWizardConfigureWASPanel.this.discoverWASContextRoot();
            this.m_dlg.Terminate();
        }
    }
}

