/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.CnfgWizardFrame;
import com.cognos.crconfig.CnfgWizardPage;
import com.cognos.crconfig.CnfgWizardPanel;
import com.cognos.crconfig.DialogMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

public class CnfgWizardDialog
extends JDialog {
    private CnfgWizardPanel m_panel;
    private boolean m_bIsSubDialog = false;
    private boolean m_bOK = false;
    private String m_sSubDialogAction;
    private boolean m_bIsTaskDialog = false;
    private CnfgWizardPanel m_generalPanel;

    public CnfgWizardDialog(CRConfigFrame parent, CnfgWizard cw, boolean bIsTaskDialog) {
        super((Frame)parent, true);
        this.m_bIsSubDialog = false;
        this.m_bIsTaskDialog = bIsTaskDialog;
        this.initUI(cw);
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
    }

    public CnfgWizardDialog(JDialog parent, CnfgWizard cw, boolean bIsTaskDialog) {
        super((Dialog)parent, true);
        this.m_bIsSubDialog = true;
        this.m_bIsTaskDialog = bIsTaskDialog;
        this.initUI(cw);
        if (parent != null) {
            Point loc = parent.getLocationOnScreen();
            this.setLocation(new Point((int)loc.getX() + 30, (int)loc.getY() + 30));
        }
    }

    public CnfgWizardDialog(CnfgWizardFrame parent, CnfgWizard cw) {
        super((Frame)parent, true);
        this.m_bIsSubDialog = true;
        this.initUI(cw);
        if (parent != null) {
            Point loc = parent.getLocationOnScreen();
            this.setLocation(new Point((int)loc.getX() + 30, (int)loc.getY() + 30));
        }
    }

    public void updatePanel(CnfgWizardPanel panel) {
        this.m_panel = panel;
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.m_panel, "Center");
    }

    public void resetPanel() {
        this.m_panel = this.m_generalPanel;
    }

    private void initUI(CnfgWizard cw) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(true);
        this.m_generalPanel = this.m_panel = cw.getWizardPanel(CnfgWizardDialog.class, this);
        this.getContentPane().add((Component)this.m_panel, "Center");
        CnfgUtils.pack(this);
        if (!this.m_bIsTaskDialog) {
            final String sWizardLabel = cw.getWizardLabel();
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    if (CnfgWizardDialog.this.m_panel.isFinishPage()) {
                        CnfgWizardDialog.this.m_panel.finish();
                    } else {
                        Object[] objMsgs = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.wizard.exit.notification")).append("\n").toString(), CnfgResource.getMessage("Message.wizard.exit.resolution")};
                        if (DialogMessage.showDialog(objMsgs, sWizardLabel, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1) == 0) {
                            CnfgWizardDialog.this.m_panel.terminate(false);
                        }
                    }
                }
            });
        }
    }

    public boolean isSubDialog() {
        return this.m_bIsSubDialog;
    }

    public boolean isOK() {
        return this.m_bOK;
    }

    public void refresh(CnfgWizardPage wp) {
        if (wp.isTemplatedPage()) {
            this.setTitle(wp.getWizardTPageData().getLabel());
        } else {
            this.setTitle(wp.getWizardPageData().getLabel());
        }
        this.m_panel.refresh(wp);
    }

    public void terminate(boolean bFinish) {
        this.m_bOK = bFinish;
        this.dispose();
    }

    public void setSubDialogAction(String action) {
        this.m_sSubDialogAction = action;
    }

    public String getSubDialogAction() {
        return this.m_sSubDialogAction;
    }
}

