/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.CnfgWizardPage;
import com.cognos.crconfig.CnfgWizardPanel;
import com.cognos.crconfig.DialogMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class CnfgWizardFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String m_sWizardLabel = "";
    private CnfgWizardPanel m_panel;
    private static final int MIN_WIDTH = 500;
    private static final int MIN_HEIGHT = 510;
    private String m_sSubDialogAction;

    public CnfgWizardFrame() {
        this.setupFonts();
    }

    public void loadData(CnfgWizard cw) {
        cw.reloadData(false);
        this.generateUI(cw);
        this.m_panel.setButtonFont(CnfgFontSetting.getAdminFont());
        this.m_sWizardLabel = cw.getWizardLabel();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (CnfgWizardFrame.this.m_panel.isFinishPage()) {
                    CnfgWizardFrame.this.m_panel.finish();
                } else {
                    Object[] objMsgs = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.wizard.exit.notification")).append("\n").toString(), CnfgResource.getMessage("Message.wizard.exit.resolution")};
                    if (DialogMessage.showDialog(objMsgs, CnfgWizardFrame.this.m_sWizardLabel, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1) == 0) {
                        CnfgWizardFrame.this.m_panel.terminate(false);
                    }
                }
            }
        });
    }

    private void setupFonts() {
        if (!CnfgFontSetting.useSystemFontAndColor()) {
            CnfgFontSetting.setDefaultFont(true);
        }
        Font defaultFont = CnfgFontSetting.getAdminFont();
        CnfgFontSetting.setAdminButtonFont(defaultFont);
        CnfgFontSetting.setAdminBoldFont(defaultFont);
        CnfgFontSetting.updateUIDefaults();
        DialogMessage.updateFont(defaultFont);
        CnfgFontSetting.setControlHeight(defaultFont);
    }

    private void generateUI(CnfgWizard cw) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(true);
        this.setIconImage(CnfgImageLoader.loadImage(CnfgUtils.isWindowsPlatform() ? "appl_server_cnfg_wizard.gif" : "appl_server_cnfg_wizard_32.gif"));
        this.m_panel = cw.getWizardPanel(CnfgWizardFrame.class, this);
        this.getContentPane().add((Component)this.m_panel, "Center");
        this.setSize(new Dimension(500, 510));
        Dimension dim = this.getSize();
        Dimension bounds = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(new Point((bounds.width - dim.width) / 2, (bounds.height - dim.height) / 2));
        this.validate();
    }

    public void refresh(CnfgWizardPage wp) {
        if (wp.isTemplatedPage()) {
            this.setTitle(wp.getWizardTPageData().getLabel());
        } else {
            this.setTitle(wp.getWizardPageData().getLabel());
        }
        this.m_panel.refresh(wp);
    }

    public void terminate() {
        this.dispose();
        CRConfigFrame.getInstance().exit(0);
    }

    public void setSubDialogAction(String action) {
        this.m_sSubDialogAction = action;
    }

    public String getSubDialogAction() {
        return this.m_sSubDialogAction;
    }
}

