/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.CnfgWizardDialog;
import com.cognos.crconfig.CnfgWizardFrame;
import com.cognos.crconfig.CnfgWizardPage;
import com.cognos.crconfig.CnfgWizardPanel;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.data.ExternalProcess;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.WizardPageData;
import com.cognos.crconfig.data.WizardParameterData;
import com.cognos.crconfig.editors.EditorCustomizedPathParameter;
import com.cognos.crconfig.editors.EditorCustomizedStringParameter;
import com.cognos.crconfig.websphere.WebSphereAdmin;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class CnfgWizardInstallAppPanel
extends CnfgWizardPanel
implements ItemListener {
    public static final String VPD_PROPERTIES_FILENAME = "vpd.properties";
    public static final String WASINSTALL_INDICATOR = "WSB";
    public static final String WASPATH_PAGE_NAME = "configSvrLocation";
    public static final String WASPROFILE_PAGE_NAME = "configSvrProfile";
    public static final String WASSVRINSTANCE_PAGE_NAME = "configSvrServerInstance";
    WizardParameterData m_sWASPathParam = null;
    WizardParameterData m_sWASProfileParam = null;
    EditorCustomizedPathParameter m_WASPathEditor = null;
    EditorCustomizedStringParameter m_WASProfileEditor = null;
    WizardParameterData m_WASProfileWizParam = null;
    EditorCustomizedStringParameter m_WASServerEditor = null;
    boolean m_bDiscoverParamValues = true;

    public CnfgWizardInstallAppPanel(CnfgWizardFrame parent, CnfgWizard cw) {
        super(parent, cw);
    }

    public CnfgWizardInstallAppPanel(CnfgWizardDialog parent, CnfgWizard cw) {
        super(parent, cw);
    }

    @Override
    public void refresh(CnfgWizardPage wp) {
        super.refresh(wp);
        ArrayList paramList = wp.getWizardPageData().getWizardParamList();
        String wizPageName = wp.getWizardPageData().getName();
        for (int i = 0; i < paramList.size(); ++i) {
            WizardParameterData wParam = (WizardParameterData)paramList.get(i);
            if (wParam.getParam().getName().equals("WAS_path") && wizPageName.equals(WASPATH_PAGE_NAME)) {
                this.m_WASPathEditor = (EditorCustomizedPathParameter)wParam.getComponent();
                break;
            }
            if (wParam.getParam().getName().equals("WAS_serverProfile") && wizPageName.equals(WASPROFILE_PAGE_NAME)) {
                this.m_WASProfileEditor = (EditorCustomizedStringParameter)wParam.getComponent();
                this.m_WASProfileWizParam = wParam;
                break;
            }
            if (!wParam.getParam().getName().equals("WAS_serverInstance") || !wizPageName.equals(WASSVRINSTANCE_PAGE_NAME)) continue;
            this.m_WASServerEditor = (EditorCustomizedStringParameter)wParam.getComponent();
            break;
        }
    }

    @Override
    protected void discoverParamValues(WizardParameterData wparam) {
        if (!this.m_bDiscoverParamValues) {
            return;
        }
        Parameter param = wparam.getParam();
        if (param != null && param.getName() != null) {
            String paramName = param.getName();
            HashMap<String, String> values = null;
            if (paramName.equalsIgnoreCase("WAS_path")) {
                values = this.discoverWASInstallLocations();
                this.m_sWASPathParam = wparam;
            } else if (paramName.equalsIgnoreCase("WAS_serverProfile")) {
                values = this.discoverWASProfiles();
                this.m_sWASProfileParam = wparam;
            } else if (paramName.equalsIgnoreCase("WAS_serverInstance")) {
                values = this.discoverWASServerInstances();
            }
            wparam.setParamValues(values);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HashMap<String, String> discoverWASInstallLocations() {
        HashMap<String, String> results = new HashMap<String, String>();
        File vpdPropfile = null;
        String sRootPath = "";
        if (CnfgUtils.isWindowsPlatform()) {
            sRootPath = CnfgUtils.getWindowsDirectory();
            if (sRootPath == null) return results;
            vpdPropfile = new File((sRootPath = sRootPath.replace('\\', '/')) + File.separator + VPD_PROPERTIES_FILENAME);
            if (!vpdPropfile.exists()) {
                return results;
            }
        } else {
            sRootPath = "/";
            vpdPropfile = new File(sRootPath + File.separator + VPD_PROPERTIES_FILENAME);
            if (!(vpdPropfile.exists() || (vpdPropfile = new File((sRootPath = "/root") + File.separator + VPD_PROPERTIES_FILENAME)).exists() || (sRootPath = System.getenv("HOME")) == null || (vpdPropfile = new File(sRootPath + File.separator + VPD_PROPERTIES_FILENAME)).exists() || (vpdPropfile = new File((sRootPath = "/usr/lib/objrepos") + File.separator + VPD_PROPERTIES_FILENAME)).exists())) {
                return results;
            }
        }
        try {
            FileInputStream fis = new FileInputStream(vpdPropfile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            String sLine = reader.readLine();
            while (sLine != null) {
                StringTokenizer tokens = new StringTokenizer(sLine, "|");
                int idx = 0;
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    if (idx == 0) {
                        if (token == null || !token.startsWith(WASINSTALL_INDICATOR)) {
                            break;
                        }
                    } else if (idx == 12) {
                        String wasPath = token.replace('\\', '/');
                        results.put(wasPath, wasPath);
                        break;
                    }
                    ++idx;
                }
                sLine = reader.readLine();
            }
            reader.close();
            return results;
        }
        catch (IOException e) {
            CnfgLog.error(e);
            return new HashMap<String, String>();
        }
    }

    private HashMap<String, String> discoverWASProfiles() {
        HashMap<String, String> results = new HashMap<String, String>();
        if (this.m_sWASPathParam != null) {
            String sWASPath;
            Object obj = this.m_sWASPathParam.getParam().getValue();
            String string = sWASPath = obj != null ? obj.toString() : "";
            if (sWASPath.length() > 0) {
                WebSphereAdmin wasAdmin = new WebSphereAdmin(sWASPath);
                String[] pArgs = wasAdmin.listProfiles();
                ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                try {
                    p.executeExternalProcess();
                }
                catch (Exception e) {
                    CnfgLog.error("Could not run the manageprofiles.bat script '" + pArgs.toString() + "'" + e.getMessage());
                    return results;
                }
                String output = p.getErrorMsg();
                int indOpBr = output.indexOf("[");
                if (indOpBr < 0) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("CnfgWizardInstallAppPanel.discoverWAWSProfiles - no profiles can be found, return empty list. Output is: " + output);
                    }
                    return results;
                }
                int indClBr = output.indexOf("]", indOpBr + 1);
                if (indClBr < 0) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("CnfgWizardInstallAppPanel.discoverWAWSProfiles - Falied to retrieve WAS Profiles, the output is malformed, return empty list. Output is: " + output);
                    }
                    return results;
                }
                String[] profiles = output.substring(indOpBr + 1, indClBr).split(",");
                boolean profileExists = false;
                for (int i = 0; i < profiles.length; ++i) {
                    String profile = profiles[i].trim();
                    if (profile == null || profile.length() <= 0) continue;
                    results.put(profile, profile);
                }
            }
        }
        return results;
    }

    private HashMap<String, String> discoverWASServerInstances() {
        HashMap<String, String> results = new HashMap<String, String>();
        if (this.m_sWASPathParam != null && this.m_sWASProfileParam != null) {
            String sWASProfile;
            Object objPath = this.m_sWASPathParam.getParam().getValue();
            Object objProfile = this.m_sWASProfileParam.getParam().getValue();
            String sWASPath = objPath != null ? objPath.toString() : "";
            String string = sWASProfile = objProfile != null ? objProfile.toString() : "";
            if (sWASPath.length() > 0 && sWASProfile.length() > 0) {
                WebSphereAdmin wasAdmin = new WebSphereAdmin(sWASPath);
                String[] pArgs = wasAdmin.getServers(sWASProfile);
                ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                try {
                    p.executeExternalProcess();
                }
                catch (Exception e) {
                    CnfgLog.error("Could not run the wsadmin.bat script '" + pArgs[0] + " " + pArgs[1] + " " + pArgs[2] + " " + pArgs[3] + " " + pArgs[4] + "' , " + e.getMessage());
                    return results;
                }
                String output = p.getErrorMsg();
                BufferedReader reader = new BufferedReader(new StringReader(output));
                try {
                    String sLine = reader.readLine();
                    while (sLine != null) {
                        int indClBr;
                        int indOpBr = sLine.indexOf("(");
                        if (indOpBr > 0 && (indClBr = sLine.indexOf(")", indOpBr + 1)) > 0) {
                            StringTokenizer tokens = new StringTokenizer(sLine.substring(indOpBr + 1, indClBr - 1), "/");
                            boolean idx = false;
                            while (tokens.hasMoreTokens()) {
                                String serverName;
                                String token = tokens.nextToken();
                                if (token.equalsIgnoreCase("cells") || token.equalsIgnoreCase("nodes")) {
                                    token = tokens.nextToken();
                                    continue;
                                }
                                if (!token.equalsIgnoreCase("servers")) continue;
                                token = tokens.nextToken();
                                int endPos = token.indexOf("|");
                                if (endPos <= 0 || (serverName = token.substring(0, endPos)) == null || serverName.length() <= 0) break;
                                results.put(serverName, serverName);
                                break;
                            }
                        }
                        sLine = reader.readLine();
                    }
                    reader.close();
                }
                catch (IOException e) {
                    CnfgLog.error(e);
                    return new HashMap<String, String>();
                }
            }
        }
        return results;
    }

    @Override
    public void actionBack() {
        this.m_bDiscoverParamValues = false;
        super.actionBack();
        this.m_bDiscoverParamValues = true;
    }

    @Override
    public void actionNext() {
        WizardPageData wpd = this.getWizard().getCurrentWizardPage().getWizardPageData();
        if (wpd.getName().equals(WASPATH_PAGE_NAME) && this.m_WASPathEditor != null) {
            this.m_WASPathEditor.stopCellEditing();
        } else if (wpd.getName().equals(WASPROFILE_PAGE_NAME) && this.m_WASProfileEditor != null) {
            this.m_WASProfileEditor.stopCellEditing();
        } else if (wpd.getName().equals(WASSVRINSTANCE_PAGE_NAME) && this.m_WASServerEditor != null) {
            this.m_WASServerEditor.stopCellEditing();
        }
        if (wpd.getName().equals(WASPATH_PAGE_NAME) || wpd.getName().equals(WASPROFILE_PAGE_NAME) || wpd.getName().equals(WASSVRINSTANCE_PAGE_NAME)) {
            DialogMessage dlgProgress = DialogMessage.getWaitDialog(CnfgResource.getMessage("Message.request.user.to.wait"), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ACTION_RUNNING);
            BusyIndicationThread prg = new BusyIndicationThread(dlgProgress);
            prg.start();
            dlgProgress.setVisible(true);
        } else {
            super.actionNext();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void actionNextValidation(DialogMessage waitingDlg) {
        WizardPageData wpd = this.getWizard().getCurrentWizardPage().getWizardPageData();
        if (wpd.getName().equals(WASPATH_PAGE_NAME) && this.m_WASPathEditor != null) {
            String sWASPath = this.m_WASPathEditor.getCellEditorValue().toString();
            if (sWASPath == null || sWASPath.length() == 0) {
                waitingDlg.setVisible(false);
                DialogMessage.showDialog(CnfgResource.getMessage("Message.was.test.path.error"), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                return;
            }
            WebSphereAdmin wasAdmin = new WebSphereAdmin(sWASPath);
            if (!wasAdmin.isValid()) {
                waitingDlg.setVisible(false);
                DialogMessage.showDialog(CnfgResource.getMessage("Message.was.test.path.error"), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                return;
            }
        } else if (wpd.getName().equals(WASPROFILE_PAGE_NAME) && this.m_WASProfileEditor != null) {
            String sWASProfile = this.m_WASProfileEditor.getCellEditorValue().toString();
            String sWASPath = this.m_WASPathEditor.getCellEditorValue().toString();
            if (sWASProfile == null || sWASProfile.length() == 0) {
                waitingDlg.setVisible(false);
                DialogMessage.showDialog(CnfgResource.getMessage("Message.was.test.profile.error.notset"), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                return;
            }
            if (this.m_WASProfileWizParam == null) return;
            Parameter profileParam = this.m_WASProfileWizParam.getParam();
            if (profileParam == null) return;
            Map values = profileParam.getValues();
            if (values == null || values.get(sWASProfile) == null) {
                Object[] msgArgs = new Object[]{sWASProfile};
                Object[] oMsg = new Object[]{CnfgResource.getMessage("Message.was.test.profile.prompt.text", msgArgs) + "\n", CnfgResource.getMessage("Message.was.test.profile.prompt.question")};
                int result = DialogMessage.showDialog(oMsg, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1);
                if (0 != result) return;
                boolean bFailedToCreate = false;
                WebSphereAdmin wasAdmin = new WebSphereAdmin(sWASPath);
                String[] createArgs = wasAdmin.createProfile(sWASProfile);
                ExternalProcess p = new ExternalProcess(createArgs[0], createArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                try {
                    p.executeExternalProcess();
                }
                catch (Exception e) {
                    bFailedToCreate = true;
                }
                String output = p.getErrorMsg();
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug(output);
                }
                if (!bFailedToCreate) {
                    if (output.indexOf("INSTCONFSUCCESS") != -1) {
                        String sMsg = CnfgResource.getMessage("Message.was.createprofile.success", msgArgs);
                        DialogMessage.showDialog(sMsg, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                        values.put(sWASProfile, sWASProfile);
                    } else if (output.indexOf("INSTCONFPARTIALSUCCESS") != -1) {
                        String sMsg = CnfgResource.getMessage("Message.was.createprofile.partialsuccess", msgArgs) + "\n" + CnfgResource.getMessage("Message.was.createprofile.partialsuccess.question");
                        result = DialogMessage.showDialog(sMsg, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1);
                        if (0 != result) return;
                        values.put(sWASProfile, sWASProfile);
                    } else {
                        bFailedToCreate = true;
                    }
                }
                if (bFailedToCreate) {
                    DialogMessage.showDialog(CnfgResource.getMessage("Message.was.createprofile.fail", msgArgs), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                    return;
                }
            }
        } else if (wpd.getName().equals(WASSVRINSTANCE_PAGE_NAME) && this.m_WASServerEditor != null) {
            String sWASPath = this.m_WASPathEditor.getCellEditorValue().toString();
            String sWASProfile = this.m_WASProfileEditor.getCellEditorValue().toString();
            String sWASServer = this.m_WASServerEditor.getCellEditorValue().toString();
            if (sWASServer == null || sWASServer.length() == 0) {
                waitingDlg.setVisible(false);
                DialogMessage.showDialog(CnfgResource.getMessage("Message.was.test.server.error.notset"), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                return;
            }
            WebSphereAdmin wasAdmin = new WebSphereAdmin(sWASPath);
            String[] pArgs = wasAdmin.getServer(sWASServer, sWASProfile);
            ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
            try {
                p.executeExternalProcess();
                String output = p.getErrorMsg();
                int indServName = output.indexOf(sWASServer);
                if (indServName == -1) {
                    waitingDlg.setVisible(false);
                    Object[] msgArgs = new Object[]{sWASServer};
                    DialogMessage.showDialog(CnfgResource.getMessage("Message.was.test.server.error.invalid", msgArgs), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                    return;
                }
            }
            catch (Exception e) {
                waitingDlg.setVisible(false);
                Object[] msgArgs = new Object[]{sWASServer};
                DialogMessage.showDialog(CnfgResource.getMessage("Message.was.test.server.error.invalid", msgArgs) + "\n" + e.getMessage(), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                return;
            }
        }
        super.actionNext();
    }

    private class BusyIndicationThread
    extends Thread {
        DialogMessage m_dlg = null;

        public BusyIndicationThread(DialogMessage dlg) {
            this.m_dlg = dlg;
        }

        @Override
        public void run() {
            BusyIndicationThread.yield();
            CnfgWizardInstallAppPanel.this.actionNextValidation(this.m_dlg);
            this.m_dlg.Terminate();
        }
    }
}

