/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgComboBox;
import com.cognos.crconfig.CnfgField;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.WizardComplexPageData;
import com.cognos.crconfig.data.WizardData;
import com.cognos.crconfig.data.WizardOption;
import com.cognos.crconfig.data.WizardPageData;
import com.cognos.crconfig.data.WizardParameterData;
import com.cognos.crconfig.data.WizardTemplatedParameterData;
import com.cognos.crconfig.editors.EditorArrayParameter;
import com.cognos.crconfig.editors.EditorCredential;
import com.cognos.crconfig.editors.EditorCustomizedStringParameter;
import com.cognos.crconfig.editors.EditorDialog;
import com.cognos.crconfig.editors.EditorPathParameter;
import com.cognos.crconfig.editors.EditorSystemPassword;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.text.JTextComponent;

public class CnfgWizardPage
implements Cloneable {
    private final CnfgWizard m_wizard;
    private final WizardPageData m_wizardPageData;
    private final List<WizardData> m_lWizardPageData;
    private final WizardComplexPageData m_complexWizardPageData;
    private final WizardOption m_wizardCase;
    private final WizardPageData m_wizardTPageData;
    private final ArrayList m_lWizardTParam;
    private final WizardTemplatedParameterData m_wizardTParam;
    private final boolean m_bIsFirstPage;
    private final boolean m_bIsLastPage;
    private int m_paramBeginIndex;
    private int m_maxNumOfParam;
    private boolean m_bIsTemplated = false;
    private boolean m_bIsTEntryPage = false;
    private boolean m_bIsTActionPage = false;
    private boolean m_bIsTSummaryPage = false;

    public CnfgWizardPage(WizardComplexPageData cwPageData, WizardOption wCase, List<WizardData> wpList, WizardPageData wPageData, CnfgWizard wizard, boolean isFirstPage) {
        this.m_wizard = wizard;
        this.m_wizardPageData = wPageData;
        this.m_lWizardPageData = wpList;
        this.m_complexWizardPageData = cwPageData;
        this.m_wizardCase = wCase;
        this.m_bIsFirstPage = isFirstPage;
        this.m_bIsLastPage = wPageData.getIsLast();
        this.m_wizardTParam = null;
        this.m_lWizardTParam = null;
        this.m_wizardTPageData = null;
        this.m_paramBeginIndex = this.initParamBeginIndex(wPageData);
        this.m_maxNumOfParam = wPageData.getMaxNumOfParam();
    }

    public CnfgWizardPage(WizardPageData instanceWp, WizardTemplatedParameterData tParamData, ArrayList tList, WizardComplexPageData cwPageData, WizardOption wCase, List<WizardData> wpList, WizardPageData wPageData, CnfgWizard wizard, boolean isFirstPage, boolean isEntryPage) {
        this.m_wizard = wizard;
        this.m_wizardTPageData = instanceWp;
        this.m_wizardTParam = tParamData;
        this.m_lWizardTParam = tList;
        this.m_bIsTemplated = true;
        this.m_bIsFirstPage = isFirstPage;
        this.m_bIsTEntryPage = isEntryPage;
        this.m_wizardPageData = wPageData;
        this.m_lWizardPageData = wpList;
        this.m_complexWizardPageData = cwPageData;
        this.m_wizardCase = wCase;
        this.m_bIsLastPage = wPageData.getIsLast();
        this.m_paramBeginIndex = this.initParamBeginIndex(instanceWp);
        this.m_maxNumOfParam = instanceWp.getMaxNumOfParam();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            CnfgLog.error(e);
            throw new InternalError(e.toString());
        }
    }

    public CnfgWizard getWizard() {
        return this.m_wizard;
    }

    public WizardPageData getWizardPageData() {
        return this.m_wizardPageData;
    }

    public List<WizardData> getWizardPageDataList() {
        return this.m_lWizardPageData;
    }

    public WizardComplexPageData getComlexWizardPageData() {
        return this.m_complexWizardPageData;
    }

    public WizardOption getWizardCase() {
        return this.m_wizardCase;
    }

    public WizardTemplatedParameterData getWizardTParam() {
        return this.m_wizardTParam;
    }

    public ArrayList getWizardTParamList() {
        return this.m_lWizardTParam;
    }

    public WizardPageData getWizardTPageData() {
        return this.m_wizardTPageData;
    }

    public boolean isLastPage() {
        return this.m_bIsLastPage;
    }

    public boolean isFirstPage() {
        return this.m_bIsFirstPage;
    }

    public boolean isEntryPage() {
        return this.m_bIsTEntryPage;
    }

    public boolean isTemplatedPage() {
        return this.m_bIsTemplated;
    }

    public boolean isActionPage() {
        return this.m_bIsTActionPage;
    }

    public void setActionPage() {
        this.m_bIsTActionPage = true;
        this.m_paramBeginIndex = 0;
    }

    public boolean isSummaryPage() {
        return this.m_bIsTSummaryPage;
    }

    public void setSummaryPage() {
        this.m_bIsTSummaryPage = true;
    }

    public int getMaxNumOfParam() {
        return this.m_maxNumOfParam;
    }

    public void setMaxNumOfParam(int maxParam) {
        this.m_maxNumOfParam = maxParam;
    }

    public int getParamBeginIndex() {
        return this.m_paramBeginIndex;
    }

    public int initParamBeginIndex(WizardPageData wp) {
        ArrayList paramList = wp.getWizardParamList();
        for (int i = 0; i < paramList.size(); ++i) {
            WizardParameterData wparam = (WizardParameterData)paramList.get(i);
            if (wparam.isActionParam()) continue;
            return i;
        }
        return paramList.size();
    }

    public void setParamBeginIndex(int index) {
        this.m_paramBeginIndex = index;
    }

    public void setNextDisplayParams() {
        this.setParamBeginIndex(this.getParamBeginIndex() + this.getMaxNumOfParam());
    }

    public boolean setWizardValues() {
        WizardPageData wp = null;
        wp = this.isTemplatedPage() ? this.getWizardTPageData() : this.getWizardPageData();
        boolean bEntryIgnoreValidation = false;
        boolean bEntryIsValid = true;
        ArrayList<String> lEntryErrorMsg = new ArrayList<String>();
        if (wp != null) {
            int beginIdx;
            ArrayList paramList = wp.getWizardParamList();
            int capacity = wp.getMaxNumOfParam() > 0 ? wp.getMaxNumOfParam() : 5;
            for (int i = beginIdx = !this.isEntryPage() ? this.getParamBeginIndex() : 0; i < paramList.size(); ++i) {
                String opValue;
                Object paramValue;
                Object value;
                EditorDialog editor;
                WizardParameterData wParam = (WizardParameterData)paramList.get(i);
                if (!this.isEntryPage()) {
                    if (capacity == 0) break;
                    --capacity;
                }
                boolean bRetVal = true;
                Object compObj = wParam.getComponent();
                if (compObj == null) continue;
                Parameter param = wParam.getParam();
                if (CnfgField.class.isInstance(compObj)) {
                    CnfgField textField = (CnfgField)compObj;
                    String sValue = textField.getText();
                    bRetVal = param.setValue(sValue);
                    if (!bRetVal) {
                        textField.requestFocus();
                    }
                } else if (JCheckBox.class.isInstance(compObj)) {
                    bRetVal = ((JCheckBox)compObj).getSelectedObjects() == null ? param.setValue("false") : param.setValue("true");
                } else if (ButtonGroup.class.isInstance(compObj)) {
                    ButtonGroup group = (ButtonGroup)compObj;
                    String sKey = group.getSelection().getActionCommand();
                    if (sKey.equals("cogcnfg_wizard_usseditor")) {
                        Serializable editor2;
                        Object obj = wParam.getSelectedEditor();
                        String sVal = null;
                        if (EditorPathParameter.class.isInstance(obj)) {
                            editor2 = (EditorPathParameter)obj;
                            Object oVal = ((EditorPathParameter)editor2).getCellEditorValue();
                            sVal = oVal != null ? oVal.toString() : null;
                        } else {
                            editor2 = (CnfgField)obj;
                            sVal = ((JTextComponent)editor2).getText();
                        }
                        if (sVal != null) {
                            sKey = sVal;
                        }
                    }
                    bRetVal = param.setValue(sKey);
                } else if (CnfgComboBox.class.isInstance(compObj)) {
                    String sValue;
                    CnfgComboBox cComboBox = (CnfgComboBox)compObj;
                    int index = cComboBox.getSelectedIndex();
                    if (index != -1 && (sValue = wParam.getSelectedValue(index)) != null) {
                        bRetVal = param.setValue(sValue);
                    }
                } else if (EditorCredential.class.isInstance(compObj)) {
                    editor = (EditorCredential)compObj;
                    Object value2 = ((EditorCredential)editor).getCellEditorValue();
                    bRetVal = value2 != null ? param.setValue(value2) : !param.isBadValue();
                } else if (EditorSystemPassword.class.isInstance(compObj)) {
                    editor = (EditorSystemPassword)compObj;
                    Object value3 = ((EditorSystemPassword)editor).getCellEditorValue();
                    bRetVal = value3 != null ? param.setValue(value3) : !param.isBadValue();
                } else if (EditorArrayParameter.class.isInstance(compObj)) {
                    editor = (EditorArrayParameter)compObj;
                    Object value4 = ((EditorArrayParameter)editor).getCellEditorValue();
                    if (value4 != null) {
                        bRetVal = param.setValue(value4);
                    }
                } else if (EditorPathParameter.class.isInstance(compObj)) {
                    editor = (EditorPathParameter)compObj;
                    Object value5 = ((EditorPathParameter)editor).getCellEditorValue();
                    if (value5 != null) {
                        bRetVal = param.setValue(value5);
                    }
                } else if (EditorCustomizedStringParameter.class.isInstance(compObj) && (value = ((EditorCustomizedStringParameter)(editor = (EditorCustomizedStringParameter)compObj)).getCellEditorValue()) != null) {
                    bRetVal = param.setValue(value);
                }
                if (this.isEntryPage() && param.getName().equals("operation") && (paramValue = param.getValue()) != null && (opValue = paramValue.toString()) != null && !opValue.equals("create") && !opValue.equals("switch")) {
                    bEntryIgnoreValidation = true;
                }
                if (!bRetVal) {
                    if (!this.isEntryPage()) {
                        String sLabel = CnfgUIDocResource.getMessage(param.getLabel(), param.getMsgBase());
                        sLabel = sLabel == null ? param.getLabel() : sLabel;
                        Object[] args = new Object[]{sLabel};
                        ArrayList<String> lMsg = new ArrayList<String>(param.getErrorMsg());
                        lMsg.add(0, CnfgResource.getMessage("Message.errorOnWizard.badvalue.resolution", args));
                        DialogMessage.showDialog(lMsg, this.getWizard().getWizardLabel(), DialogMessage.ICON_WARNING, DialogMessage.OPTS_NOARGS, 0);
                        return false;
                    }
                    bEntryIsValid = bRetVal;
                    lEntryErrorMsg = new ArrayList<String>(param.getErrorMsg());
                    continue;
                }
                this.getWizard().resetParamValue(wParam, this);
            }
        }
        if (!bEntryIsValid && !bEntryIgnoreValidation) {
            lEntryErrorMsg.add(0, CnfgResource.getMessage("Message.errorOnValidation.info"));
            DialogMessage.showDialog(lEntryErrorMsg, this.getWizard().getWizardLabel(), DialogMessage.ICON_WARNING, DialogMessage.OPTS_NOARGS, 0);
            return false;
        }
        return true;
    }

    public boolean findWizardPage(String sName) {
        if (this.m_wizardTParam != null) {
            WizardPageData wPage;
            int i;
            ArrayList al = this.m_wizardTParam.getInstancesList();
            for (i = 0; i < al.size(); ++i) {
                wPage = (WizardPageData)al.get(i);
                if (wPage == null || !wPage.getName().equals(sName)) continue;
                return true;
            }
            al = this.getWizardTParam().getNewInstancesList();
            for (i = 0; i < al.size(); ++i) {
                wPage = (WizardPageData)al.get(i);
                if (wPage == null || !wPage.getName().equals(sName)) continue;
                return true;
            }
        }
        return false;
    }

    public void resetActionState() {
        WizardPageData curPage = this.isTemplatedPage() ? this.getWizardTPageData() : this.getWizardPageData();
        if (curPage != null) {
            curPage.setActionState(0);
        }
    }

    public boolean isActionsOnly() {
        WizardPageData curPage = null;
        curPage = this.isTemplatedPage() ? this.getWizardTPageData() : this.getWizardPageData();
        if (curPage != null) {
            return curPage.isActionsOnly();
        }
        return false;
    }
}

