/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgComboBox;
import com.cognos.crconfig.CnfgField;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgLabel;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgSplashScreen;
import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.CnfgWizardDialog;
import com.cognos.crconfig.CnfgWizardFrame;
import com.cognos.crconfig.CnfgWizardPage;
import com.cognos.crconfig.CnfgWizardTaskPanel;
import com.cognos.crconfig.CnfgWizardTransitionPanel;
import com.cognos.crconfig.DialogHelpBrowser;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.ICnfgActionClient;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTaskPrompt;
import com.cognos.crconfig.TaskCollectorException;
import com.cognos.crconfig.WebBrowser;
import com.cognos.crconfig.WizardEditorTemplatedParam;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.BooleanParameter;
import com.cognos.crconfig.data.CnfgAction;
import com.cognos.crconfig.data.CnfgActionEngine;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgActionSave;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.ICnfgAction;
import com.cognos.crconfig.data.Option;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.PathParameter;
import com.cognos.crconfig.data.SystemPasswordParameter;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.WizardActionTarget;
import com.cognos.crconfig.data.WizardPageData;
import com.cognos.crconfig.data.WizardParameterData;
import com.cognos.crconfig.data.WizardTemplatedParameterData;
import com.cognos.crconfig.editors.EditorArrayParameter;
import com.cognos.crconfig.editors.EditorCredential;
import com.cognos.crconfig.editors.EditorCustomizedPathParameter;
import com.cognos.crconfig.editors.EditorCustomizedStringParameter;
import com.cognos.crconfig.editors.EditorPathParameter;
import com.cognos.crconfig.editors.EditorSystemPassword;
import com.cognos.i18n.ui.I18NTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class CnfgWizardPanel
extends JPanel
implements CellEditorListener,
ItemListener,
ActionListener,
ICnfgActionClient,
DataManager.ITaskCollector {
    protected CnfgWizardFrame m_parentFrame = null;
    protected CnfgWizardDialog m_parentDialog = null;
    private CnfgWizard m_wizard;
    protected CnfgButton m_buttonBack;
    protected CnfgButton m_buttonNext;
    protected CnfgButton m_buttonCancel;
    protected CnfgButton m_buttonFinish;
    protected CnfgButton m_buttonHelp;
    protected JPanel m_bottomPanel;
    protected JPanel m_topPanel;
    protected JPanel m_contentPanel;
    private ButtonGroup m_entryOPGroup;
    private CnfgField m_entryNewNameText;
    private CnfgComboBox m_entryNewTypeCB;
    private Object[] m_entryTypeChoices;
    private CnfgComboBox m_entryEditCB;
    private Object[] m_entryEditChoices;
    private CnfgComboBox m_entryDeleteCB;
    private Object[] m_entryDeleteChoices;
    private WizardPageData m_currentPage;
    private boolean m_failedTasks;
    private JScrollPane m_innerScrollPane = null;
    boolean showBackground = false;
    protected static final int MIN_WIDTH = 500;
    protected static final int MIN_HEIGHT = 520;
    private int LEFT_MARGIN = 7;
    private int RIGHT_MARGIN = 7;
    private ArrayList m_sTaskOutput = new ArrayList();
    private boolean m_cancellable;

    public CnfgWizardPanel(CnfgWizardFrame parent, CnfgWizard cw) {
        this.m_parentFrame = parent;
        this.initPanel(cw);
    }

    public CnfgWizardPanel(CnfgWizardDialog parent, CnfgWizard cw) {
        this.m_parentDialog = parent;
        this.initPanel(cw);
    }

    private void initPanel(CnfgWizard cw) {
        this.m_wizard = cw;
        this.generateUI();
    }

    private Container getParentContainer() {
        if (this.m_parentFrame != null) {
            return this.m_parentFrame;
        }
        return this.m_parentDialog;
    }

    public CnfgWizard getWizard() {
        return this.m_wizard;
    }

    public String getNewName() {
        if (this.m_entryNewNameText != null) {
            return this.m_entryNewNameText.getText();
        }
        return null;
    }

    public Option getNewType() {
        int index;
        if (this.m_entryNewTypeCB != null && this.m_entryTypeChoices != null && (index = this.m_entryNewTypeCB.getSelectedIndex()) != -1) {
            return (Option)this.m_entryTypeChoices[index];
        }
        return null;
    }

    public WizardPageData getEditPage() {
        int index;
        if (this.m_entryEditCB != null && this.m_entryEditChoices != null && (index = this.m_entryEditCB.getSelectedIndex()) != -1) {
            return (WizardPageData)this.m_entryEditChoices[index];
        }
        return null;
    }

    public WizardPageData getDeletedPage() {
        int index;
        if (this.m_entryDeleteCB != null && this.m_entryDeleteChoices != null && (index = this.m_entryDeleteCB.getSelectedIndex()) != -1) {
            return (WizardPageData)this.m_entryDeleteChoices[index];
        }
        return null;
    }

    public WizardPageData getSwitchFromPage() {
        return this.m_currentPage;
    }

    public boolean isFinishPage() {
        return this.m_buttonFinish.isEnabled();
    }

    private void generateUI() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(500, 520));
        this.setPreferredSize(new Dimension(500, 520));
        this.createTopPanel();
        this.createBottomPanel();
        this.add((Component)this.m_topPanel, "Center");
        this.add((Component)this.m_bottomPanel, "South");
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JScrollBar vsb;
                if (CnfgWizardPanel.this.m_buttonNext.isEnabled()) {
                    CnfgWizardPanel.this.m_buttonNext.grabFocus();
                } else {
                    CnfgWizardPanel.this.m_buttonFinish.grabFocus();
                }
                if (CnfgWizardPanel.this.m_innerScrollPane != null && (vsb = CnfgWizardPanel.this.m_innerScrollPane.getVerticalScrollBar()) != null) {
                    vsb.setValue(0);
                }
            }
        };
        this.addFocusListener(focusAdapter);
    }

    public void setButtonFont(Font f) {
        this.m_buttonBack.setFont(f);
        this.m_buttonNext.setFont(f);
        this.m_buttonCancel.setFont(f);
        this.m_buttonFinish.setFont(f);
        this.m_buttonHelp.setFont(f);
    }

    private void createBottomPanel() {
        this.m_bottomPanel = new JPanel();
        this.m_bottomPanel.setLayout(new BoxLayout(this.m_bottomPanel, 1));
        this.m_bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(7, 0, 7, 0));
        if (this.showBackground) {
            this.m_bottomPanel.setBackground(Color.cyan);
        }
        this.m_buttonBack = new CnfgButton(CnfgResource.getMessage("Label.ButtonBack"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
        this.m_buttonNext = new CnfgButton(CnfgResource.getMessage("Label.ButtonNext"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
        this.m_buttonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
        this.m_buttonFinish = new CnfgButton(CnfgResource.getMessage("Label.ButtonFinish"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
        this.m_buttonHelp = new CnfgButton(CnfgResource.getMessage("Menu.help"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
        buttonPanel.add(this.m_buttonHelp);
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.m_buttonCancel);
        buttonPanel.add(Box.createHorizontalStrut(7));
        buttonPanel.add(this.m_buttonBack);
        buttonPanel.add(this.m_buttonNext);
        buttonPanel.add(Box.createHorizontalStrut(7));
        buttonPanel.add(this.m_buttonFinish);
        this.m_buttonBack.addActionListener(this);
        this.m_buttonNext.addActionListener(this);
        this.m_buttonCancel.addActionListener(this);
        this.m_buttonFinish.addActionListener(this);
        this.m_buttonHelp.addActionListener(this);
        JSeparator sep = new JSeparator();
        this.m_bottomPanel.add(sep);
        this.m_bottomPanel.add(buttonPanel);
    }

    private void createTopPanel() {
        this.m_topPanel = new JPanel();
        this.m_topPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.m_topPanel.setLayout(new BorderLayout());
        this.createContentPanel();
        this.m_topPanel.add((Component)this.m_contentPanel, "Center");
    }

    private void createContentPanel() {
        this.m_contentPanel = new JPanel();
        this.m_contentPanel.setBorder(BorderFactory.createEmptyBorder(0, this.LEFT_MARGIN, 0, this.RIGHT_MARGIN));
        if (this.showBackground) {
            this.m_contentPanel.setBackground(Color.red);
        }
    }

    protected void addHelpInfo(JPanel parentPanel, GridBagConstraints c, GridBagLayout gridBag, String helpText) {
        JTextAreaEx cDesc = new JTextAreaEx();
        cDesc.setText(helpText);
        JScrollPane infoScrollPane = this.getScrollPane();
        JViewport cInfoView = infoScrollPane.getViewport();
        cInfoView.add((Component)((Object)cDesc));
        c.insets = new Insets(1, 0, 6, 0);
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        c.weighty = 10.0;
        c.fill = 1;
        gridBag.setConstraints(infoScrollPane, c);
        parentPanel.add(infoScrollPane);
        if (this.showBackground) {
            infoScrollPane.setBorder(BorderFactory.createLineBorder(Color.yellow));
        }
        c.weighty = 0.0;
    }

    private void addDescriptionInfo(JPanel parentPanel, GridBagConstraints c, GridBagLayout gridBag, String desc) {
        if (desc == null || desc.length() == 0) {
            return;
        }
        JTextAreaEx cDesc = new JTextAreaEx();
        cDesc.setText(desc);
        cDesc.setBackground(this.m_contentPanel.getBackground());
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 2, 0);
        gridBag.setConstraints((Component)((Object)cDesc), c);
        parentPanel.add((Component)((Object)cDesc));
    }

    private void addTextField(JPanel parentPanel, GridBagConstraints c, GridBagLayout gridBag, String label, String text, WizardParameterData wParam) {
        CnfgLabel cLabel;
        String msgBase = wParam.getParam().getMsgBase();
        String sLabel = CnfgUIDocResource.getMessage(label, msgBase);
        CnfgField cTextField = new CnfgField(1, 1, 400, text);
        cTextField.setEditable(true);
        c.fill = 2;
        if (sLabel == null || sLabel.length() == 0) {
            cLabel = new CnfgLabel(300, label, cTextField);
        } else {
            char accKey = CnfgUIDocResource.getLastAccelerator();
            cLabel = new CnfgLabel(300, sLabel, accKey, cTextField);
        }
        c.gridx = 0;
        c.gridy = -1;
        c.insets = new Insets(1, 0, 0, 0);
        gridBag.setConstraints(cLabel, c);
        parentPanel.add(cLabel);
        if (this.showBackground) {
            cLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        }
        String descInfo = wParam.getParam().getDesc();
        this.addDescriptionInfo(parentPanel, c, gridBag, descInfo);
        c.gridx = 0;
        c.gridy = -1;
        c.insets = new Insets(0, 0, 6, 0);
        gridBag.setConstraints(cTextField, c);
        parentPanel.add(cTextField);
        if (this.showBackground) {
            cTextField.setBackground(Color.magenta);
        }
        wParam.addComponent(cTextField);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    private void addPropertyEditor(Parameter param, String editorType, Object[] args, GridBagConstraints c, GridBagLayout gridBag, JPanel parentPanel, WizardParameterData wParam, boolean bReadOnly, StringBuffer sbSummary) {
        if (bReadOnly) {
            String sParamValue;
            String msgBase;
            String sLabel = param.getLabel();
            String sParamLabel = CnfgUIDocResource.getMessage(sLabel, msgBase = wParam.getParam().getMsgBase());
            if (sParamLabel == null || sParamLabel.length() == 0) {
                sParamLabel = sLabel;
            }
            String string = sParamValue = param.getValue() != null ? param.getValue().toString() : "";
            if (param.getClass() == CredentialParameter.class || param.getClass() == SystemPasswordParameter.class) {
                sParamValue = "***************";
            }
            sbSummary.append(sParamLabel).append(": ").append(sParamValue).append("\n");
            return;
        }
        this.addPropertyEditor(editorType, args, c, gridBag, parentPanel, wParam);
    }

    private void addPropertyEditor(String editorType, Object[] args, GridBagConstraints c, GridBagLayout gridBag, JPanel parentPanel, WizardParameterData wParam) {
        String label;
        int indent;
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(gridBag);
        for (int i = indent = wParam.getLayoutSettings("indent"); i > 0; --i) {
            JLabel tlabel = new JLabel(CnfgImageLoader.loadIcon("none.gif"));
            c.gridx = indent - i;
            c.gridy = 0;
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 0.0;
            gridBag.setConstraints(tlabel, c);
            innerPanel.add(tlabel);
        }
        JPanel innerEditorPanel = new JPanel();
        innerEditorPanel.setLayout(gridBag);
        if (editorType.equalsIgnoreCase("checkbox") && args.length == 2) {
            label = (String)args[0];
            boolean selection = ((String)args[1]).equals("true");
            this.addCheckBox(label, selection, c, gridBag, innerEditorPanel, wParam);
        } else if (editorType.equalsIgnoreCase("textfield") && args.length == 2) {
            label = (String)args[0];
            String sValue = (String)args[1];
            this.addTextField(innerEditorPanel, c, gridBag, label, sValue, wParam);
        } else if (editorType.equalsIgnoreCase("radiobutton") && args.length == 3) {
            label = (String)args[0];
            Map values = (Map)args[1];
            String oValue = (String)args[2];
            this.addRadioButtonEditor(label, values, oValue, innerEditorPanel, c, gridBag, wParam);
        } else if (editorType.equalsIgnoreCase("complexeditor") && args.length == 2) {
            label = (String)args[0];
            String type = (String)args[1];
            this.addComplexEditor(innerEditorPanel, c, gridBag, label, wParam, type);
        } else if (editorType.equalsIgnoreCase("customradio") && args.length == 1) {
            label = (String)args[0];
            this.addCustomRadioButtonEditor(label, innerEditorPanel, c, gridBag, wParam);
        } else if (editorType.equalsIgnoreCase("combobox") && args.length == 3) {
            label = (String)args[0];
            Map values = (Map)args[1];
            String oValue = (String)args[2];
            this.addComboBox(label, values, oValue, innerEditorPanel, c, gridBag, wParam);
        }
        c.gridx = indent;
        c.gridy = -1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        gridBag.setConstraints(innerEditorPanel, c);
        innerPanel.add(innerEditorPanel);
        c.gridx = 0;
        c.gridy = -1;
        c.insets = new Insets(3 + wParam.getLayoutSettings("top") * 5, 0, 3 + wParam.getLayoutSettings("bottom") * 5, 0);
        gridBag.setConstraints(innerPanel, c);
        parentPanel.add(innerPanel);
    }

    private void addCheckBox(String label, boolean selection, GridBagConstraints c, GridBagLayout gridBag, JPanel parentPanel, WizardParameterData wParam) {
        JCheckBox cCheckBox;
        String msgBase = wParam.getParam().getMsgBase();
        String sLabel = CnfgUIDocResource.getMessage(label, msgBase);
        String descInfo = wParam.getParam().getDesc();
        this.addDescriptionInfo(parentPanel, c, gridBag, descInfo);
        if (sLabel == null || sLabel.length() == 0) {
            cCheckBox = new JCheckBox(label, selection);
        } else {
            char accKey = CnfgUIDocResource.getLastAccelerator();
            cCheckBox = new JCheckBox(sLabel, selection);
            cCheckBox.setMnemonic(accKey);
        }
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        gridBag.setConstraints(cCheckBox, c);
        parentPanel.add(cCheckBox);
        wParam.addComponent(cCheckBox);
        cCheckBox.addItemListener(this);
        if (this.showBackground) {
            cCheckBox.setBorder(BorderFactory.createLineBorder(Color.red));
        }
    }

    private Map sort(Locale locale, Map map) {
        Collator collator = Collator.getInstance(locale);
        TreeMap sortedMap = new TreeMap();
        for (Map.Entry pair : map.entrySet()) {
            String name = (String)pair.getValue() + ":" + pair.getKey();
            CollationKey key = collator.getCollationKey(name);
            sortedMap.put(key, pair);
        }
        return sortedMap;
    }

    private Map sortKey(Map map) {
        TreeMap sortedMap = new TreeMap();
        for (Map.Entry pair : map.entrySet()) {
            String key = (String)pair.getKey();
            sortedMap.put(key, pair);
        }
        return sortedMap;
    }

    private void addCustomRadioButtonEditor(String label, JPanel parentPanel, GridBagConstraints c, GridBagLayout gridBag, WizardParameterData wParam) {
        ButtonGroup group = new ButtonGroup();
        boolean selection = false;
        Object[] oEditor = new Object[1];
        Parameter param = wParam.getParam();
        Object obj = param.getValue();
        String sCurVal = obj != null ? obj.toString() : "";
        JLabel cLabel = new JLabel(label);
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.insets = new Insets(1, 0, 6, 0);
        c.fill = 2;
        c.anchor = 17;
        gridBag.setConstraints(cLabel, c);
        parentPanel.add(cLabel);
        String descInfo = wParam.getParam().getDesc();
        this.addDescriptionInfo(parentPanel, c, gridBag, descInfo);
        JPanel innerPanel = new JPanel();
        GridBagLayout igridbag = new GridBagLayout();
        GridBagConstraints ic = new GridBagConstraints();
        innerPanel.setLayout(igridbag);
        ic.anchor = 17;
        ArrayList lEnums = wParam.getEnumList();
        int selectedIdx = -1;
        for (int i = 0; i < lEnums.size(); ++i) {
            JRadioButton radioButton;
            WizardParameterData.WizardParamEnum wpe = (WizardParameterData.WizardParamEnum)lEnums.get(i);
            String sValue = wpe.getResolvedValue(wParam);
            if (sValue == null) continue;
            selection = sCurVal.equals(sValue) ? true : selectedIdx == -1 && i == lEnums.size() - 1;
            if (wpe.renderParamEditor()) {
                if (param.getValues() != null) {
                    this.addRadioButtons(param.getValues(), param.getValue(), innerPanel, ic, igridbag, group, wParam.getLayoutSettings("horizonal") > 0, wParam.getLayoutSettings("nosort") > 0, wParam.getLayoutSettings("wrap"), wParam.getParam().getMsgBase());
                    continue;
                }
                radioButton = new JRadioButton("", selection);
                radioButton.setActionCommand("cogcnfg_wizard_usseditor");
                ic.gridx = 0;
                ic.gridy = -1;
                ic.gridwidth = 1;
                ic.weightx = 0.0;
                ic.fill = 0;
                ic.insets = new Insets(1, 2, 2, 0);
                igridbag.setConstraints(radioButton, ic);
                group.add(radioButton);
                innerPanel.add(radioButton);
                ic.gridx = 1;
                ic.gridwidth = 1;
                ic.weightx = 1.0;
                ic.fill = 2;
                ic.insets = new Insets(1, 0, 2, 5);
                if (PathParameter.class.isInstance(param)) {
                    CnfgButton buttonBrowse = this.createOpenButton(param.getLabel());
                    EditorPathParameter editor = new EditorPathParameter(this.getParentContainer(), new JTextField(sCurVal), true, buttonBrowse, (PathParameter)param);
                    editor.setButtonSize(CnfgFontSetting.controlHeight + 1, CnfgFontSetting.controlHeight + 1);
                    editor.setInTable(false);
                    JPanel dispPanel = editor.getEditorPanel();
                    oEditor[0] = editor;
                    igridbag.setConstraints(dispPanel, ic);
                    innerPanel.add(dispPanel);
                    continue;
                }
                CnfgField cTextField = new CnfgField(1, 1, 400, sCurVal);
                cTextField.setEditable(true);
                oEditor[0] = cTextField;
                igridbag.setConstraints(cTextField, ic);
                innerPanel.add(cTextField);
                continue;
            }
            if (sValue == null) continue;
            radioButton = new JRadioButton(sValue, selection);
            radioButton.setActionCommand(sValue);
            ic.gridx = 0;
            ic.gridy = -1;
            ic.gridwidth = 2;
            ic.weightx = 1.0;
            ic.insets = new Insets(1, 2, 2, 5);
            ic.fill = 2;
            igridbag.setConstraints(radioButton, ic);
            group.add(radioButton);
            innerPanel.add(radioButton);
        }
        wParam.addComponent(group, oEditor);
        c.gridx = 0;
        c.gridy = -1;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        gridBag.setConstraints(innerPanel, c);
        parentPanel.add(innerPanel);
    }

    private void addRadioButtons(Map values, Object curValue, JPanel parentPanel, GridBagConstraints c, GridBagLayout gridBag, ButtonGroup group, boolean isHorizonalLayout, boolean bNoSort, int iWrapCount, String sMsgBase) {
        int yColumn;
        int xColumn;
        boolean selection = false;
        c.fill = 2;
        Map sortedMap = bNoSort ? this.sortKey(values) : this.sort(CnfgResource.getLocale(), values);
        Iterator it = sortedMap.values().iterator();
        String sCurValue = curValue != null ? curValue.toString() : "";
        int current = 0;
        if (isHorizonalLayout) {
            xColumn = -1;
            yColumn = 0;
        } else {
            xColumn = 0;
            yColumn = -1;
        }
        while (it.hasNext()) {
            JRadioButton radioButton;
            ++current;
            Map.Entry pair = (Map.Entry)it.next();
            String key = pair.getKey().toString();
            String value = pair.getValue().toString();
            selection = sCurValue.compareTo(key) == 0;
            String sLabel = CnfgUIDocResource.getMessage(value, sMsgBase);
            if (sLabel == null || sLabel.length() == 0) {
                radioButton = new JRadioButton(value, selection);
            } else {
                char accKey = CnfgUIDocResource.getLastAccelerator();
                radioButton = new JRadioButton(sLabel, selection);
                radioButton.setMnemonic(accKey);
            }
            radioButton.setActionCommand(key);
            radioButton.addActionListener(this);
            if (iWrapCount > 0) {
                int remainder = current % iWrapCount;
                if (isHorizonalLayout) {
                    xColumn = remainder == 1 ? 0 : -1;
                } else {
                    yColumn = remainder == 1 ? 0 : -1;
                }
            }
            c.gridx = ++xColumn;
            c.gridy = ++yColumn;
            c.insets = new Insets(0, 0, 3, 0);
            gridBag.setConstraints(radioButton, c);
            group.add(radioButton);
            parentPanel.add(radioButton);
        }
    }

    private void addRadioButtonEditor(String label, Map values, Object curValue, JPanel parentPanel, GridBagConstraints c, GridBagLayout gridBag, WizardParameterData wParam) {
        ButtonGroup group = new ButtonGroup();
        c.fill = 2;
        if (label == null || label.length() == 0) {
            JLabel cLabel = new JLabel(label);
            c.gridx = 0;
            c.gridy = -1;
            c.insets = new Insets(0, 0, 3, 0);
            gridBag.setConstraints(cLabel, c);
            parentPanel.add(cLabel);
        }
        String descInfo = wParam.getParam().getDesc();
        this.addDescriptionInfo(parentPanel, c, gridBag, descInfo);
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(gridBag);
        this.addRadioButtons(values, curValue, innerPanel, c, gridBag, group, wParam.getLayoutSettings("horizonal") > 0, wParam.getLayoutSettings("nosort") > 0, wParam.getLayoutSettings("wrap"), wParam.getParam().getMsgBase());
        c.gridx = 0;
        c.gridy = -1;
        c.insets = new Insets(0, 0, 0, 0);
        gridBag.setConstraints(innerPanel, c);
        parentPanel.add(innerPanel);
        wParam.addComponent(group);
    }

    private void addComboBox(String label, Map values, Object curValue, JPanel parentPanel, GridBagConstraints c, GridBagLayout gridBag, WizardParameterData wParam) {
        String _curValue;
        c.fill = 2;
        JLabel cLabel = new JLabel(label);
        c.gridx = 0;
        c.gridy = -1;
        c.insets = new Insets(1, 0, 6, 0);
        gridBag.setConstraints(cLabel, c);
        parentPanel.add(cLabel);
        Map sortedMap = wParam.getLayoutSettings("nosort") > 0 ? values : this.sort(CnfgResource.getLocale(), values);
        int index = 0;
        CnfgComboBox cComboBox = new CnfgComboBox();
        cComboBox.setMaximumRowCount(5);
        cComboBox.initUIandEditor();
        Object[] sChoices = new String[sortedMap.size()];
        Iterator it = sortedMap.values().iterator();
        String string = _curValue = curValue != null ? curValue.toString() : "";
        while (it.hasNext()) {
            Map.Entry pair = (Map.Entry)it.next();
            String key = pair.getKey().toString();
            String value = pair.getValue().toString();
            cComboBox.insertItemAt(value, index);
            sChoices[index] = key;
            if (_curValue.compareTo(key) == 0) {
                cComboBox.setSelectedIndex(index);
            }
            ++index;
        }
        c.gridx = 0;
        c.gridy = -1;
        c.insets = new Insets(0, 2, 0, 5);
        gridBag.setConstraints(cComboBox, c);
        parentPanel.add(cComboBox);
        wParam.addComponent(cComboBox, sChoices);
    }

    private void addComplexEditor(JPanel parentPanel, GridBagConstraints c, GridBagLayout gridBag, String label, WizardParameterData wParam, String sEditorType) {
        CnfgLabel cLabel;
        c.fill = 2;
        String msgBase = wParam.getParam().getMsgBase();
        String sLabel = CnfgUIDocResource.getMessage(label, msgBase);
        JTextField editorText = new JTextField();
        if (sLabel == null || sLabel.length() == 0) {
            cLabel = new CnfgLabel(300, label, editorText);
        } else {
            char accKey = CnfgUIDocResource.getLastAccelerator();
            cLabel = new CnfgLabel(300, sLabel, accKey, editorText);
        }
        c.gridx = 0;
        c.gridy = -1;
        c.insets = new Insets(1, 0, 0, 0);
        gridBag.setConstraints(cLabel, c);
        parentPanel.add(cLabel);
        if (this.showBackground) {
            cLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        }
        String descInfo = wParam.getParam().getDesc();
        this.addDescriptionInfo(parentPanel, c, gridBag, descInfo);
        CnfgButton button = CnfgButton.createEditButton(wParam.getParam());
        JPasswordField pwdField = new JPasswordField();
        pwdField.setEchoChar('*');
        pwdField.setText("***************");
        JPanel dispPanel = null;
        if (sEditorType.equalsIgnoreCase("credential")) {
            EditorCredential editor = new EditorCredential(this.getParentContainer(), pwdField, false, button, wParam.getParam());
            editor.setInTable(false);
            pwdField.setBorder(BorderFactory.createLoweredBevelBorder());
            dispPanel = editor.getEditorPanel();
            wParam.addComponent(editor);
        } else if (sEditorType.equalsIgnoreCase("syspass")) {
            EditorSystemPassword editor = new EditorSystemPassword(this.getParentContainer(), pwdField, false, button, wParam.getParam());
            editor.setInTable(false);
            pwdField.setBorder(BorderFactory.createLoweredBevelBorder());
            dispPanel = editor.getEditorPanel();
            wParam.addComponent(editor);
        } else if (sEditorType.equalsIgnoreCase("tempparam")) {
            WizardEditorTemplatedParam editor = new WizardEditorTemplatedParam(this.getParentContainer(), pwdField, false, button, (WizardTemplatedParameterData)wParam);
            pwdField.setBorder(BorderFactory.createLoweredBevelBorder());
            dispPanel = editor.getEditorPanel();
            wParam.addComponent(editor);
        } else if (sEditorType.equalsIgnoreCase("arrayparam")) {
            Object obj = wParam.getParam().getValue();
            String sValue = "";
            if (obj != null) {
                sValue = obj.toString();
            }
            editorText.setText(sValue);
            EditorArrayParameter editor = new EditorArrayParameter(this.getParentContainer(), editorText, false, button, (ArrayParameter)wParam.getParam());
            editor.setInTable(false);
            editorText.setBorder(BorderFactory.createLoweredBevelBorder());
            dispPanel = editor.getEditorPanel();
            editor.addCellEditorListener(this);
            wParam.addComponent(editor);
        } else if (sEditorType.equalsIgnoreCase("customizedstringparam")) {
            CnfgComboBox cComboBox = this.createCustomizedComboBox(wParam);
            EditorCustomizedStringParameter editor = new EditorCustomizedStringParameter(this.getParentContainer(), cComboBox, true);
            editor.setInTable(false);
            editorText.setBorder(BorderFactory.createLoweredBevelBorder());
            dispPanel = editor.getEditorPanel();
            wParam.addComponent(editor);
        } else if (sEditorType.equalsIgnoreCase("pathparam")) {
            String renderStyle = wParam.getStyle();
            if (renderStyle.equals("combobox")) {
                CnfgComboBox cComboBox = this.createCustomizedComboBox(wParam);
                CnfgButton buttonBrowse = this.createOpenButton(sLabel);
                EditorCustomizedPathParameter editor = new EditorCustomizedPathParameter(this.getParentContainer(), cComboBox, true, buttonBrowse, (PathParameter)wParam.getParam());
                editor.setButtonSize(CnfgFontSetting.controlHeight + 1, CnfgFontSetting.controlHeight + 1);
                editor.setInTable(false);
                editorText.setBorder(BorderFactory.createLoweredBevelBorder());
                dispPanel = editor.getEditorPanel();
                wParam.addComponent(editor);
            } else {
                Object obj = wParam.getParam().getValue();
                String sValue = "";
                if (obj != null) {
                    sValue = obj.toString();
                }
                editorText.setText(sValue);
                CnfgButton buttonBrowse = this.createOpenButton(sLabel);
                EditorPathParameter editor = new EditorPathParameter(this.getParentContainer(), editorText, true, buttonBrowse, (PathParameter)wParam.getParam());
                editor.setButtonSize(CnfgFontSetting.controlHeight + 1, CnfgFontSetting.controlHeight + 1);
                editor.setInTable(false);
                editorText.setBorder(BorderFactory.createLoweredBevelBorder());
                dispPanel = editor.getEditorPanel();
                wParam.addComponent(editor);
            }
        }
        c.gridx = 0;
        c.gridy = -1;
        c.insets = new Insets(1, 0, 6, 0);
        gridBag.setConstraints(dispPanel, c);
        parentPanel.add(dispPanel);
        if (this.showBackground) {
            dispPanel.setBackground(Color.magenta);
        }
    }

    private CnfgButton createOpenButton(String sztooltiptext) {
        CnfgButton buttonBrowse = new CnfgButton(CnfgImageLoader.loadIcon("icon_file_open.gif"), sztooltiptext);
        return buttonBrowse;
    }

    private CnfgComboBox createCustomizedComboBox(WizardParameterData wParam) {
        Parameter param = wParam.getParam();
        String curValue = (String)param.getValue();
        Map values = param.getValues();
        Map sortedMap = wParam.getLayoutSettings("nosort") > 0 ? values : this.sort(CnfgResource.getLocale(), values);
        int index = 0;
        CnfgComboBox cComboBox = new CnfgComboBox();
        cComboBox.setMaximumRowCount(5);
        cComboBox.initUIandEditor();
        Iterator it = sortedMap.values().iterator();
        String _curValue = curValue != null ? curValue.toString() : "";
        cComboBox.insertItemAt(_curValue, 0);
        index = 1;
        int iFoundIdx = -1;
        while (it.hasNext()) {
            Map.Entry pair = (Map.Entry)it.next();
            String key = pair.getKey().toString();
            String value = pair.getValue().toString();
            cComboBox.insertItemAt(value, index);
            if (_curValue.compareTo(key) == 0) {
                iFoundIdx = index;
            }
            ++index;
        }
        if (iFoundIdx >= 0) {
            cComboBox.removeItemAt(0);
            cComboBox.insertItemAt("", 0);
            cComboBox.setSelectedIndex(iFoundIdx);
        } else {
            cComboBox.setSelectedIndex(0);
        }
        return cComboBox;
    }

    private void addEntryPageCreateNewSection(CnfgWizardPage wp, String sCreate, GridBagConstraints c, GridBagLayout gridbag, JPanel innerPanel, boolean isSwitchTo, boolean isSelected) {
        String sNewName = "";
        String sNewType = "";
        WizardPageData wPageData = wp.getWizardTPageData();
        ArrayList paramList = wPageData.getWizardParamList();
        for (int j = 0; j < paramList.size(); ++j) {
            Object obj;
            WizardParameterData wParam = (WizardParameterData)paramList.get(j);
            Parameter param = wParam.getParam();
            if (param != null && param.getName().equals("newName")) {
                obj = param.getValue();
                String string = sNewName = obj != null ? obj.toString() : "";
            }
            if (param == null || !param.getName().equals("newType")) continue;
            obj = param.getValue();
            sNewType = obj != null ? obj.toString() : "";
        }
        this.m_entryNewNameText = new CnfgField(1, 1, 400, sNewName, false);
        this.m_entryNewTypeCB = new CnfgComboBox();
        String sCreateLabel = CnfgUIDocResource.getMessage(sCreate, "config_wizard");
        JRadioButton cRadioButton = new JRadioButton(sCreateLabel, true);
        cRadioButton.setMnemonic(CnfgUIDocResource.getLastAccelerator());
        if (isSwitchTo) {
            cRadioButton.setActionCommand("switch");
        } else {
            cRadioButton.setActionCommand("create");
        }
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.insets = new Insets(1, 2, 2, 5);
        gridbag.setConstraints(cRadioButton, c);
        this.m_entryOPGroup.add(cRadioButton);
        innerPanel.add(cRadioButton);
        if (this.showBackground) {
            cRadioButton.setBackground(Color.green);
        }
        JLabel spaceLabel = new JLabel("");
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(1, 20, 0, 0);
        gridbag.setConstraints(spaceLabel, c);
        innerPanel.add(spaceLabel);
        JLabel nLabel = new JLabel(CnfgResource.getMessage("Label.DialogWizard.Name"));
        nLabel.setDisplayedMnemonic(CnfgResource.getLastAccelerator());
        nLabel.setDisplayedMnemonicIndex(CnfgResource.getLastAcceleratorIndex());
        nLabel.setLabelFor(this.m_entryNewNameText);
        this.m_entryNewNameText.setFocusAccelerator(CnfgResource.getLastAccelerator());
        if (this.showBackground) {
            nLabel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        }
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(1, 0, 0, 0);
        gridbag.setConstraints(nLabel, c);
        innerPanel.add(nLabel);
        JLabel spaceLabel1 = new JLabel("");
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(1, 20, 2, 0);
        gridbag.setConstraints(spaceLabel1, c);
        innerPanel.add(spaceLabel1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 2, 0);
        gridbag.setConstraints(this.m_entryNewNameText, c);
        innerPanel.add(this.m_entryNewNameText);
        c.fill = 2;
        JLabel spaceLabel2 = new JLabel("");
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(1, 20, 0, 0);
        gridbag.setConstraints(spaceLabel2, c);
        innerPanel.add(spaceLabel2);
        JLabel tLabel = new JLabel(CnfgResource.getMessage("Label.DialogWizard.Type"));
        tLabel.setDisplayedMnemonic(CnfgResource.getLastAccelerator());
        tLabel.setDisplayedMnemonicIndex(CnfgResource.getLastAcceleratorIndex());
        tLabel.setLabelFor(this.m_entryNewTypeCB);
        this.m_entryNewTypeCB.registerKeyboardAction(this, KeyStroke.getKeyStroke((int)CnfgResource.getLastAccelerator(), 8), 2);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(1, 0, 0, 0);
        gridbag.setConstraints(tLabel, c);
        innerPanel.add(tLabel);
        if (this.showBackground) {
            tLabel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        }
        int index = 0;
        this.m_entryNewTypeCB.setMaximumRowCount(5);
        this.m_entryNewTypeCB.initUIandEditor();
        ArrayList al = wp.getWizardTParam().getAvailableOptions(isSwitchTo);
        Collator collator = Collator.getInstance();
        TreeMap<CollationKey, Option> sortedMap = new TreeMap<CollationKey, Option>();
        for (Option option : al) {
            CollationKey key;
            if (option == null || (key = collator.getCollationKey(option.toString())) == null) continue;
            sortedMap.put(key, option);
        }
        this.m_entryTypeChoices = new Object[sortedMap.size()];
        Iterator<Object> it = sortedMap.values().iterator();
        int selectedIdx = 0;
        while (it.hasNext()) {
            Option opt = (Option)it.next();
            if (opt != null) {
                this.m_entryNewTypeCB.insertItemAt(opt.toString(), index);
                this.m_entryTypeChoices[index] = opt;
                if (sNewType.equals(opt.toString())) {
                    selectedIdx = index;
                }
            }
            ++index;
        }
        if (index > 0) {
            this.m_entryNewTypeCB.setSelectedIndex(selectedIdx);
        }
        JLabel spaceLabel3 = new JLabel("");
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(1, 20, 3, 0);
        gridbag.setConstraints(spaceLabel3, c);
        innerPanel.add(spaceLabel3);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 2, 3, 5);
        gridbag.setConstraints(this.m_entryNewTypeCB, c);
        innerPanel.add(this.m_entryNewTypeCB);
        c.fill = 2;
        cRadioButton.setSelected(isSelected);
        if (al.size() == 0 && !isSwitchTo) {
            cRadioButton.setEnabled(false);
            cRadioButton.setSelected(false);
            tLabel.setEnabled(false);
            nLabel.setEnabled(false);
            this.m_entryNewNameText.setEnabled(false);
            this.m_entryNewTypeCB.setEnabled(false);
        }
    }

    private void addEntryPageEditSection(TreeMap sortedMap, String sEdit, GridBagConstraints c, GridBagLayout gridbag, JPanel innerPanel, boolean isSelected) {
        this.m_entryEditCB = new CnfgComboBox();
        String sEditLabel = CnfgUIDocResource.getMessage(sEdit, "config_wizard");
        JRadioButton eRadioButton = new JRadioButton(sEditLabel, true);
        eRadioButton.setMnemonic(CnfgUIDocResource.getLastAccelerator());
        eRadioButton.setActionCommand("edit");
        if (this.showBackground) {
            eRadioButton.setBackground(Color.green);
        }
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.insets = new Insets(1, 2, 3, 5);
        gridbag.setConstraints(eRadioButton, c);
        this.m_entryOPGroup.add(eRadioButton);
        innerPanel.add(eRadioButton);
        int index = 0;
        this.m_entryEditCB.setMaximumRowCount(5);
        this.m_entryEditCB.initUIandEditor();
        this.m_entryEditChoices = new Object[sortedMap.size()];
        for (WizardPageData wPage : sortedMap.values()) {
            if (wPage != null) {
                this.m_entryEditCB.insertItemAt(wPage.getName(), index);
                this.m_entryEditChoices[index] = wPage;
            }
            ++index;
        }
        if (index > 0) {
            this.m_entryEditCB.setSelectedIndex(0);
        }
        if (sortedMap.size() > 1) {
            JLabel spaceLabel2 = new JLabel("");
            c.gridx = 0;
            c.gridy = -1;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.insets = new Insets(0, 5, 2, 15);
            gridbag.setConstraints(spaceLabel2, c);
            innerPanel.add(spaceLabel2);
            c.gridx = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(0, 2, 2, 5);
            gridbag.setConstraints(this.m_entryEditCB, c);
            innerPanel.add(this.m_entryEditCB);
        }
        c.fill = 2;
        eRadioButton.setSelected(isSelected);
        if (sortedMap.size() == 0) {
            eRadioButton.setEnabled(false);
            eRadioButton.setSelected(false);
            this.m_entryEditCB.setEnabled(false);
        }
    }

    private void addEntryPageDeleteSection(TreeMap sortedMap, String sDelete, GridBagConstraints c, GridBagLayout gridbag, JPanel innerPanel, boolean isSelected) {
        this.m_entryDeleteCB = new CnfgComboBox();
        String sDeleteLabel = CnfgUIDocResource.getMessage(sDelete, "config_wizard");
        JRadioButton dRadioButton = new JRadioButton(sDeleteLabel, true);
        dRadioButton.setMnemonic(CnfgUIDocResource.getLastAccelerator());
        dRadioButton.setActionCommand("delete");
        if (this.showBackground) {
            dRadioButton.setBackground(Color.green);
        }
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.insets = new Insets(1, 2, 3, 5);
        gridbag.setConstraints(dRadioButton, c);
        this.m_entryOPGroup.add(dRadioButton);
        innerPanel.add(dRadioButton);
        JLabel spaceLabel3 = new JLabel("");
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 5, 2, 15);
        gridbag.setConstraints(spaceLabel3, c);
        innerPanel.add(spaceLabel3);
        int index = 0;
        this.m_entryDeleteCB.setMaximumRowCount(5);
        this.m_entryDeleteCB.initUIandEditor();
        this.m_entryDeleteChoices = new Object[sortedMap.size()];
        for (WizardPageData wPage : sortedMap.values()) {
            if (wPage != null) {
                this.m_entryDeleteCB.insertItemAt(wPage.getName(), index);
                this.m_entryDeleteChoices[index] = wPage;
            }
            ++index;
        }
        if (index > 0) {
            this.m_entryDeleteCB.setSelectedIndex(0);
        }
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 5);
        gridbag.setConstraints(this.m_entryDeleteCB, c);
        innerPanel.add(this.m_entryDeleteCB);
        c.fill = 2;
        dRadioButton.setSelected(isSelected);
        if (sortedMap.size() == 0) {
            dRadioButton.setEnabled(false);
            dRadioButton.setSelected(false);
            this.m_entryDeleteCB.setEnabled(false);
        }
    }

    private void addEntryPageExitSection(TreeMap sortedMap, String sExit, GridBagConstraints c, GridBagLayout gridbag, JPanel innerPanel) {
        JRadioButton xRadioButton = new JRadioButton(sExit, true);
        xRadioButton.setActionCommand("exit");
        if (this.showBackground) {
            xRadioButton.setBackground(Color.green);
        }
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.insets = new Insets(10, 2, 2, 5);
        gridbag.setConstraints(xRadioButton, c);
        this.m_entryOPGroup.add(xRadioButton);
        innerPanel.add(xRadioButton);
        if (sortedMap.size() != 0) {
            xRadioButton.setSelected(true);
        }
    }

    private void addEntryPageCurrentSettingsSection(TreeMap sortedMap, String sCurSettings, GridBagConstraints c, GridBagLayout gridbag, JPanel innerPanel) {
        WizardPageData wPage;
        Iterator instIt;
        this.m_currentPage = null;
        if (sortedMap.size() != 0 && (instIt = sortedMap.values().iterator()).hasNext() && (wPage = (WizardPageData)instIt.next()) != null) {
            this.m_currentPage = wPage;
        }
        JLabel curSettingLabel = new JLabel(sCurSettings);
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 3;
        c.insets = new Insets(25, 2, 2, 5);
        c.weightx = 1.0;
        gridbag.setConstraints(curSettingLabel, c);
        innerPanel.add(curSettingLabel);
        if (this.showBackground) {
            curSettingLabel.setBorder(new LineBorder(Color.green));
        }
        StringBuffer settingsInfo = new StringBuffer();
        StringBuffer actionsInfo = new StringBuffer();
        if (this.m_currentPage != null) {
            settingsInfo.append(CnfgResource.getMessage("Label.DialogCreateNew.name")).append(": ").append(this.m_currentPage.getName()).append("\n");
            settingsInfo.append(CnfgResource.getMessage("Label.DialogCreateNew.type")).append(": ").append(this.m_currentPage.getInstLabel()).append("\n");
            ArrayList curParmList = this.m_currentPage.getWizardParamList();
            for (int k = 0; k < curParmList.size(); ++k) {
                String sParamValue;
                WizardParameterData wParam = (WizardParameterData)curParmList.get(k);
                Parameter param = wParam.getParam();
                String sParamLabel = param.getLabel() != null ? param.getLabel() : "";
                String string = sParamValue = param.getValue() != null ? param.getValue().toString() : "";
                if (param.getClass() == CredentialParameter.class || param.getClass() == SystemPasswordParameter.class) {
                    sParamValue = "***************";
                }
                if (wParam.isActionParam()) {
                    if (wParam.getAction() != null) continue;
                    actionsInfo.append(sParamLabel).append(": ").append(sParamValue).append("\n");
                    continue;
                }
                settingsInfo.append(sParamLabel).append(": ").append(sParamValue).append("\n");
            }
        }
        this.addHelpInfo(innerPanel, c, gridbag, settingsInfo.append("\n").append(actionsInfo.toString()).toString());
    }

    private void addEntryPageParams(CnfgWizardPage wp, GridBagConstraints pc, GridBagLayout pgridBag, JPanel parentPanel) {
        Parameter param;
        WizardParameterData wParam;
        int j;
        JPanel innerPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        c.fill = 2;
        if (this.showBackground) {
            innerPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        }
        this.m_entryOPGroup = new ButtonGroup();
        WizardPageData wPageData = wp.getWizardTPageData();
        ArrayList paramList = wPageData.getWizardParamList();
        String sOperation = "";
        for (j = 0; j < paramList.size(); ++j) {
            wParam = (WizardParameterData)paramList.get(j);
            param = wParam.getParam();
            if (param == null || !param.getName().equals("operation")) continue;
            Object obj = param.getValue();
            sOperation = obj != null ? obj.toString() : "";
            Collator collator = Collator.getInstance();
            TreeMap<CollationKey, WizardPageData> sortedMap = new TreeMap<CollationKey, WizardPageData>();
            ArrayList al = wp.getWizardTParam().getInstancesList();
            for (WizardPageData wPage : al) {
                CollationKey key;
                if (wPage == null || (key = collator.getCollationKey(wPage.getName())) == null) continue;
                sortedMap.put(key, wPage);
            }
            ArrayList newList = wp.getWizardTParam().getNewInstancesList();
            for (WizardPageData wPage : newList) {
                CollationKey key;
                if (wPage == null || (key = collator.getCollationKey(wPage.getName())) == null) continue;
                sortedMap.put(key, wPage);
            }
            if (param.getValues().get("edit") != null) {
                boolean isSelected = false;
                if ((sOperation.equals("edit") || sOperation.equals("")) && sortedMap.size() > 0) {
                    isSelected = true;
                }
                String sEdit = param.getValues().get("edit").toString();
                this.addEntryPageEditSection(sortedMap, sEdit, c, gridbag, innerPanel, isSelected);
            }
            if (param.getValues().get("switch") != null) {
                String sSwitch = param.getValues().get("switch").toString();
                boolean isSelected = false;
                if (sOperation.equals("switch") || sortedMap.size() == 0) {
                    isSelected = true;
                }
                this.addEntryPageCreateNewSection(wp, sSwitch, c, gridbag, innerPanel, true, isSelected);
            }
            if (param.getValues().get("create") != null) {
                String sCreate = param.getValues().get("create").toString();
                boolean isSelected = false;
                if (sOperation.equals("create") || sortedMap.size() == 0) {
                    isSelected = true;
                }
                this.addEntryPageCreateNewSection(wp, sCreate, c, gridbag, innerPanel, false, isSelected);
            }
            if (param.getValues().get("delete") != null) {
                boolean isSelected = false;
                if (sOperation.equals("delete") && sortedMap.size() > 0) {
                    isSelected = true;
                }
                String sDelete = param.getValues().get("delete").toString();
                this.addEntryPageDeleteSection(sortedMap, sDelete, c, gridbag, innerPanel, isSelected);
            }
            String sCurSettings = CnfgResource.getMessage("Label.DialogWizard.CurrentSetting");
            this.addEntryPageCurrentSettingsSection(sortedMap, sCurSettings, c, gridbag, innerPanel);
            String wizStyle = DataManager.getInstance().getWizardStyle(this.getWizard().getWizardModeName());
            if (wizStyle != null && wizStyle.equals("loop")) {
                String sExit = param.getValues().get("exit").toString();
                this.addEntryPageExitSection(sortedMap, sExit, c, gridbag, innerPanel);
            }
            wParam.addComponent(this.m_entryOPGroup);
            break;
        }
        for (j = 0; j < paramList.size(); ++j) {
            wParam = (WizardParameterData)paramList.get(j);
            param = wParam.getParam();
            if (param != null && param.getName().equals("newName")) {
                wParam.addComponent(this.m_entryNewNameText);
            }
            if (param != null && param.getName().equals("newType")) {
                wParam.addComponent(this.m_entryNewTypeCB, this.m_entryTypeChoices);
            }
            if (param != null && param.getName().equals("editName")) {
                wParam.addComponent(this.m_entryEditCB, this.m_entryEditChoices);
            }
            if (param == null || !param.getName().equals("delName")) continue;
            wParam.addComponent(this.m_entryDeleteCB, this.m_entryDeleteChoices);
        }
        pc.gridx = 0;
        pc.gridy = -1;
        pc.weighty = 10.0;
        pc.insets = new Insets(0, 0, 0, 0);
        pc.fill = 1;
        pgridBag.setConstraints(innerPanel, pc);
        parentPanel.add(innerPanel);
    }

    private void addActionPageParams(CnfgWizardPage wp, GridBagConstraints c, GridBagLayout gridBag, JPanel parentPanel) {
        WizardPageData wPageData = wp.getWizardTPageData();
        ArrayList paramList = wPageData.getWizardParamList();
        int capacity = wPageData.getMaxNumOfParam() > 0 ? wPageData.getMaxNumOfParam() : 5;
        for (int j = wp.getParamBeginIndex(); j < paramList.size(); ++j) {
            WizardParameterData wParam = (WizardParameterData)paramList.get(j);
            if (capacity == 0) break;
            --capacity;
            Parameter param = wParam.getParam();
            if (!BooleanParameter.class.isInstance(param)) continue;
            Object paramVal = param.getValue();
            boolean selection = false;
            if (paramVal != null) {
                selection = (Boolean)paramVal;
            }
            Object[] args = new Object[]{param.getLabel(), selection ? "true" : "false"};
            this.addPropertyEditor("checkbox", args, c, gridBag, parentPanel, wParam);
        }
    }

    private void addSummaryPageParams(CnfgWizardPage wp, GridBagConstraints c, GridBagLayout gridbag, JPanel parentPanel) {
        JLabel curSettingLabel = new JLabel(CnfgResource.getMessage("Label.DialogWizard.CurrentSetting"));
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 6, 0);
        c.weightx = 1.0;
        gridbag.setConstraints(curSettingLabel, c);
        parentPanel.add(curSettingLabel);
        if (this.showBackground) {
            curSettingLabel.setBorder(new LineBorder(Color.yellow));
        }
        StringBuffer settingsInfo = new StringBuffer();
        StringBuffer actionsInfo = new StringBuffer();
        WizardPageData wPageData = wp.getWizardTPageData();
        if (wp.isTemplatedPage()) {
            settingsInfo.append(CnfgResource.getMessage("Label.DialogCreateNew.name")).append(": ").append(wPageData.getName()).append("\n");
            settingsInfo.append(CnfgResource.getMessage("Label.DialogCreateNew.type")).append(": ").append(wPageData.getInstLabel()).append("\n");
        }
        ArrayList paramList = wPageData.getWizardParamList();
        for (int j = 0; j < paramList.size(); ++j) {
            String sParamValue;
            WizardParameterData wParam = (WizardParameterData)paramList.get(j);
            Parameter param = wParam.getParam();
            String sParamLabel = param.getLabel() != null ? param.getLabel() : "";
            String string = sParamValue = param.getValue() != null ? param.getValue().toString() : "";
            if (param.getClass() == CredentialParameter.class || param.getClass() == SystemPasswordParameter.class) {
                sParamValue = "***************";
            }
            if (wParam.isActionParam()) {
                actionsInfo.append(sParamLabel).append(": ").append(sParamValue).append("\n");
                continue;
            }
            settingsInfo.append(sParamLabel).append(": ").append(sParamValue).append("\n");
        }
        this.addHelpInfo(parentPanel, c, gridbag, settingsInfo.append("\n").append(actionsInfo.toString()).toString());
        JLabel spaceLabel = new JLabel("");
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.insets = new Insets(30, 0, 0, 0);
        c.weightx = 1.0;
        gridbag.setConstraints(spaceLabel, c);
        parentPanel.add(spaceLabel);
    }

    private JScrollPane getScrollPane() {
        JScrollPane infoScrollPane = new JScrollPane();
        JViewport cInfoView = infoScrollPane.getViewport();
        infoScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        infoScrollPane.setOpaque(true);
        infoScrollPane.setHorizontalScrollBarPolicy(31);
        if (CnfgUtils.isWindowsPlatform()) {
            cInfoView.setBackground(SystemColor.window);
            infoScrollPane.setBackground(SystemColor.window);
        } else {
            cInfoView.setBackground(Color.white);
            infoScrollPane.setBackground(Color.white);
        }
        return infoScrollPane;
    }

    private void addPropertyPageParams(WizardPageData wPageData, CnfgWizardPage wp, GridBagConstraints c, GridBagLayout gridbag, JPanel wizParentPanel) {
        ArrayList paramList = wPageData.getWizardParamList();
        int capacity = wp.getMaxNumOfParam() > 0 ? wp.getMaxNumOfParam() : 5;
        JPanel parentPanel = wizParentPanel;
        StringBuffer sbReadOnlySummary = null;
        boolean bReadOnlyGroup = false;
        boolean bStyleScroll = false;
        for (int j = wp.getParamBeginIndex(); j < paramList.size(); ++j) {
            WizardParameterData wParam = (WizardParameterData)paramList.get(j);
            if (wParam.isActionParam()) continue;
            if (wParam.isGroupParam()) {
                if (wParam.isGroupEnd()) {
                    if (bReadOnlyGroup || bStyleScroll) {
                        JScrollPane infoScrollPane = this.getScrollPane();
                        int height = CnfgUtils.isWindowsPlatform() ? 60 : 75;
                        infoScrollPane.setMinimumSize(new Dimension(0, height));
                        c.insets = new Insets(1, 0, 6, 0);
                        c.gridx = 0;
                        c.gridy = -1;
                        c.weightx = 1.0;
                        c.weighty = 10.0;
                        c.fill = 1;
                        gridbag.setConstraints(infoScrollPane, c);
                        JViewport cInfoView = infoScrollPane.getViewport();
                        if (this.showBackground) {
                            infoScrollPane.setBorder(BorderFactory.createLineBorder(Color.yellow));
                            parentPanel.setBorder(BorderFactory.createLineBorder(Color.orange));
                        }
                        if (bReadOnlyGroup) {
                            bReadOnlyGroup = false;
                            JTextAreaEx cDesc = new JTextAreaEx();
                            cDesc.setText(sbReadOnlySummary.toString());
                            cInfoView.add((Component)((Object)cDesc));
                            parentPanel.add(infoScrollPane);
                            cDesc.setCaretPosition(0);
                        } else if (bStyleScroll) {
                            bStyleScroll = false;
                            cInfoView.add(parentPanel);
                            wizParentPanel.add(infoScrollPane);
                            parentPanel = wizParentPanel;
                            this.m_innerScrollPane = infoScrollPane;
                        }
                        c.weighty = 0.0;
                    }
                    if (parentPanel == wizParentPanel) continue;
                    c.fill = 2;
                    c.gridx = 0;
                    c.gridy = -1;
                    c.insets = new Insets(0, 0, 0, 0);
                    c.weightx = 1.0;
                    c.weighty = 0.0;
                    gridbag.setConstraints(parentPanel, c);
                    wizParentPanel.add(parentPanel);
                    if (this.showBackground) {
                        parentPanel.setBorder(BorderFactory.createLineBorder(Color.green));
                    }
                    parentPanel = wizParentPanel;
                    continue;
                }
                sbReadOnlySummary = new StringBuffer();
                bReadOnlyGroup = wParam.isGroupReadOnly();
                bStyleScroll = wParam.getStyle() != null ? wParam.getStyle().equalsIgnoreCase("scroll") : false;
                String sTitle = wParam.getParam().getLabel();
                JPanel innerPanel = new JPanel();
                innerPanel.setLayout(gridbag);
                Border emptyBorder = BorderFactory.createEmptyBorder(8, 8, 8, 8);
                TitledBorder titleBorder = BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), " " + sTitle + " ");
                innerPanel.setBorder(BorderFactory.createCompoundBorder(titleBorder, emptyBorder));
                innerPanel.setFocusable(true);
                innerPanel.getAccessibleContext().setAccessibleName(sTitle);
                parentPanel = innerPanel;
                continue;
            }
            if (capacity == 0) break;
            --capacity;
            this.discoverParamValues(wParam);
            Parameter param = wParam.getParam();
            if (BooleanParameter.class.isInstance(param)) {
                Object paramVal = param.getValue();
                boolean selection = false;
                if (paramVal != null) {
                    selection = (Boolean)paramVal;
                }
                Object[] args = new Object[]{param.getLabel(), selection ? "true" : "false"};
                this.addPropertyEditor(param, "checkbox", args, c, gridbag, parentPanel, wParam, bReadOnlyGroup, sbReadOnlySummary);
                continue;
            }
            if (CredentialParameter.class.isInstance(param)) {
                Object[] args = new Object[]{param.getLabel(), "credential"};
                this.addPropertyEditor(param, "complexeditor", args, c, gridbag, parentPanel, wParam, bReadOnlyGroup, sbReadOnlySummary);
                continue;
            }
            if (SystemPasswordParameter.class.isInstance(param)) {
                Object[] args = new Object[]{param.getLabel(), "syspass"};
                this.addPropertyEditor(param, "complexeditor", args, c, gridbag, parentPanel, wParam, bReadOnlyGroup, sbReadOnlySummary);
                continue;
            }
            if (ArrayParameter.class.isInstance(param)) {
                Object[] args = new Object[]{param.getLabel(), "arrayparam"};
                this.addPropertyEditor(param, "complexeditor", args, c, gridbag, parentPanel, wParam, bReadOnlyGroup, sbReadOnlySummary);
                continue;
            }
            if (wParam.hasWizEnums()) {
                Object[] args = new Object[]{param.getLabel()};
                this.addPropertyEditor(param, "customradio", args, c, gridbag, parentPanel, wParam, bReadOnlyGroup, sbReadOnlySummary);
                continue;
            }
            if (PathParameter.class.isInstance(param)) {
                Object[] args = new Object[]{param.getLabel(), "pathparam"};
                this.addPropertyEditor(param, "complexeditor", args, c, gridbag, parentPanel, wParam, bReadOnlyGroup, sbReadOnlySummary);
                continue;
            }
            if (wParam.getStyle() != null && wParam.getStyle().equalsIgnoreCase("combobox")) {
                Object[] args = new Object[]{param.getLabel(), "customizedstringparam"};
                this.addPropertyEditor(param, "complexeditor", args, c, gridbag, parentPanel, wParam, bReadOnlyGroup, sbReadOnlySummary);
                continue;
            }
            if (param.getValues() != null) {
                Object[] args;
                String style = wParam.getStyle();
                if (style.equals("radiobutton")) {
                    args = new Object[]{param.getLabel(), param.getValues(), param.getValue()};
                    this.addPropertyEditor(param, "radiobutton", args, c, gridbag, parentPanel, wParam, bReadOnlyGroup, sbReadOnlySummary);
                    continue;
                }
                args = new Object[]{param.getLabel(), param.getValues(), param.getValue()};
                this.addPropertyEditor(param, "combobox", args, c, gridbag, parentPanel, wParam, bReadOnlyGroup, sbReadOnlySummary);
                continue;
            }
            Object obj = param.getValue();
            String sValue = obj != null ? obj.toString() : "";
            String label = param.getLabel();
            Object[] args = new Object[]{label, sValue};
            this.addPropertyEditor(param, "textfield", args, c, gridbag, parentPanel, wParam, bReadOnlyGroup, sbReadOnlySummary);
        }
        if (parentPanel != wizParentPanel) {
            c.fill = 2;
            c.gridx = 0;
            c.gridy = -1;
            c.insets = new Insets(5, 5, 0, 5);
            gridbag.setConstraints(parentPanel, c);
            wizParentPanel.add(parentPanel);
            parentPanel = wizParentPanel;
        }
        if (capacity > 0) {
            ArrayList tparamList = wPageData.getWizardTParamList();
            for (int k = 0; k < tparamList.size(); ++k) {
                WizardTemplatedParameterData wtParam = (WizardTemplatedParameterData)tparamList.get(k);
                if (wtParam.isTopLevel()) continue;
                if (capacity == 0) break;
                --capacity;
                Parameter param = wtParam.getParam();
                if (!TemplatedParameter.class.isInstance(param)) continue;
                Object[] args = new Object[]{param.getLabel(), "tempparam"};
                this.addPropertyEditor("complexeditor", args, c, gridbag, parentPanel, wtParam);
            }
        }
    }

    private void browseHelpInfo(boolean bPageHelp) {
        String filename = "";
        if (!bPageHelp) {
            filename = this.getWizard().getWizardHelpFileName();
        } else {
            CnfgWizardPage cwp = this.getWizard().getCurrentWizardPage();
            WizardPageData wp = null;
            wp = cwp.isTemplatedPage() ? cwp.getWizardTPageData() : cwp.getWizardPageData();
            String string = filename = wp != null ? wp.getHelpFile() : "";
        }
        if (filename == null || filename.length() == 0) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("The Help file is not specified in the wizard ui doc.");
            }
            return;
        }
        if (CnfgUtils.getPlatform().equalsIgnoreCase("win")) {
            String sHelpFile = CRConfigFrame.getInstance().resolveHelpFilePath(filename);
            boolean helpExistis = new File(sHelpFile).exists();
            if (helpExistis) {
                String helpURL = "file://" + sHelpFile;
                WebBrowser.displayURL(helpURL);
            } else {
                Object[] args = new Object[]{sHelpFile};
                String erroMsg = CnfgResource.getMessage("Label.information.notavailable") + " " + CnfgResource.getMessage("Message.errorOnEditPath.filenotexist.notification", args);
                DialogMessage.showDialog(erroMsg, this.getWizard().getWizardLabel(), DialogMessage.ICON_ERROR, DialogMessage.OPTS_OK, 1);
            }
        } else {
            String unixHelpfilename = this.getWizard().getWizardHelpFileName();
            if (unixHelpfilename == null || unixHelpfilename.length() == 0) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("The Unix help file is not specified in the wizard ui doc.");
                }
                return;
            }
            String sHelpFile = CRConfigFrame.getInstance().resolveHelpFilePath(unixHelpfilename);
            boolean helpExistis = new File(sHelpFile).exists();
            if (helpExistis) {
                String pageHeading = filename.substring(0, filename.length() - 5);
                DialogHelpBrowser helpBrowser = new DialogHelpBrowser(sHelpFile, pageHeading);
                helpBrowser.setVisible(true);
            } else {
                Object[] args = new Object[]{sHelpFile};
                String erroMsg = CnfgResource.getMessage("Label.information.notavailable") + " " + CnfgResource.getMessage("Message.errorOnEditPath.filenotexist.notification", args);
                DialogMessage.showDialog(erroMsg, this.getWizard().getWizardLabel(), DialogMessage.ICON_ERROR, DialogMessage.OPTS_OK, 1);
            }
        }
    }

    private void addOverViewHelpLink(String sText, GridBagConstraints c, GridBagLayout gridbag, JPanel parentPanel) {
        ArrayList lPos = new ArrayList();
        JTextPane linkTextPane = new JTextPane();
        linkTextPane.setBackground(this.m_contentPanel.getBackground());
        CnfgUtils.addHyperlinkText(linkTextPane, sText, CnfgResource.getMessage("Label.DialogWizard.HelpLink"), 50, lPos);
        final int hypertextBeginPos = (Integer)lPos.get(0);
        final int hypertextEndPos = (Integer)lPos.get(1);
        linkTextPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int mark;
                int beginPos;
                int dot = e.getDot();
                int n = beginPos = dot < (mark = e.getMark()) ? dot : mark;
                if (beginPos >= hypertextBeginPos && beginPos < hypertextEndPos) {
                    CnfgWizardPanel.this.browseHelpInfo(false);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(linkTextPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(21);
        if (this.showBackground) {
            linkTextPane.setBorder(new LineBorder(Color.green));
        }
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        gridbag.setConstraints(scrollPane, c);
        parentPanel.add(scrollPane);
    }

    public void refresh(CnfgWizardPage wp) {
        this.refreshContentPanel(wp);
        this.refreshBottomPanel(wp);
        this.updateUI();
        this.grabFocus();
    }

    private void refreshContentPanel(CnfgWizardPage wp) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.m_contentPanel.removeAll();
        this.m_contentPanel.setLayout(gridbag);
        c.fill = 2;
        WizardPageData wPageData = null;
        wPageData = wp.isTemplatedPage() ? wp.getWizardTPageData() : wp.getWizardPageData();
        if (wPageData != null) {
            ArrayList overViewList = wPageData.getOverViewList();
            for (int i = 0; i < overViewList.size(); ++i) {
                WizardPageData.WizardOverView ov = (WizardPageData.WizardOverView)overViewList.get(i);
                if (ov.getStyle().equals("bottom") || ov.getStyle().equals("about")) continue;
                if (ov.getStyle().equals("help")) {
                    this.addOverViewHelpLink(ov.getLabel(), c, gridbag, this.m_contentPanel);
                    continue;
                }
                JTextAreaEx cDesc = new JTextAreaEx();
                cDesc.setText(ov.getLabel());
                cDesc.setBackground(this.m_contentPanel.getBackground());
                if (ov.getStyle().equals("title")) {
                    int size = CnfgFontSetting.getAdminFont().getSize() + 4;
                    cDesc.setFont(CnfgFontSetting.getAdminFont().deriveFont(1, size));
                    c.insets = new Insets(7, 0, 8, 0);
                } else {
                    c.insets = new Insets(0, 0, 16, 0);
                }
                c.gridx = 0;
                c.gridy = -1;
                c.weightx = 1.0;
                gridbag.setConstraints((Component)((Object)cDesc), c);
                this.m_contentPanel.add((Component)((Object)cDesc));
                if (!this.showBackground) continue;
                cDesc.setBorder(new LineBorder(Color.blue));
            }
            if (wp.isEntryPage()) {
                this.addEntryPageParams(wp, c, gridbag, this.m_contentPanel);
            } else if (wp.isActionPage()) {
                this.addActionPageParams(wp, c, gridbag, this.m_contentPanel);
            } else if (wp.isSummaryPage()) {
                this.addSummaryPageParams(wp, c, gridbag, this.m_contentPanel);
            } else {
                this.addPropertyPageParams(wPageData, wp, c, gridbag, this.m_contentPanel);
            }
        }
        JLabel endLabel = new JLabel("");
        if (this.showBackground) {
            endLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        }
        c.gridx = 0;
        c.gridy = -1;
        c.weighty = 0.1;
        c.insets = new Insets(0, 7, 0, 7);
        c.anchor = 15;
        gridbag.setConstraints(endLabel, c);
        this.m_contentPanel.add(endLabel);
        ArrayList overViewList = wPageData.getOverViewList();
        WizardPageData.WizardOverView aboutOV = null;
        for (int i = 0; i < overViewList.size(); ++i) {
            WizardPageData.WizardOverView ov = (WizardPageData.WizardOverView)overViewList.get(i);
            if (!ov.getStyle().equals("bottom")) {
                if (!ov.getStyle().equals("about")) continue;
                aboutOV = ov;
                continue;
            }
            JTextAreaEx cDesc = new JTextAreaEx();
            cDesc.setText(ov.getLabel());
            cDesc.setBackground(this.m_contentPanel.getBackground());
            c.gridx = 0;
            c.gridy = -1;
            c.insets = new Insets(0, 7, 6, 7);
            c.weighty = 0.0;
            c.weightx = 1.0;
            gridbag.setConstraints((Component)((Object)cDesc), c);
            this.m_contentPanel.add((Component)((Object)cDesc));
            if (!this.showBackground) continue;
            cDesc.setBorder(new LineBorder(Color.blue));
        }
        if (aboutOV != null) {
            ArrayList lPos = new ArrayList();
            JTextPane aboutText = new JTextPane();
            aboutText.setBackground(this.m_contentPanel.getBackground());
            CnfgUtils.addHyperlinkText(aboutText, "", CnfgResource.getMessage("Label.DialogWizard.About"), 50, lPos);
            final int hypertextBeginPos = (Integer)lPos.get(0);
            final int hypertextEndPos = (Integer)lPos.get(1);
            aboutText.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    int mark;
                    int beginPos;
                    int dot = e.getDot();
                    int n = beginPos = dot < (mark = e.getMark()) ? dot : mark;
                    if (beginPos >= hypertextBeginPos && beginPos < hypertextEndPos) {
                        CnfgSplashScreen cnfgSplashScreen = new CnfgSplashScreen(CRConfigFrame.getInstance(), "cogconfigspl", true);
                    }
                }
            });
            JPanel aboutPane = new JPanel();
            aboutPane.setLayout(new BorderLayout());
            aboutPane.add((Component)new JLabel(aboutOV.getLabel()), "West");
            aboutPane.add((Component)new JLabel(" "), "Center");
            aboutPane.add((Component)aboutText, "East");
            if (this.showBackground) {
                aboutPane.setBorder(new LineBorder(Color.green));
            }
            c.gridx = 0;
            c.insets = new Insets(0, 7, 6, 7);
            c.gridy = -1;
            c.anchor = 13;
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.fill = 2;
            gridbag.setConstraints(aboutPane, c);
            this.m_contentPanel.add(aboutPane);
            if (this.showBackground) {
                aboutText.setBorder(new LineBorder(Color.yellow));
            }
        }
    }

    private void refreshBottomPanel(CnfgWizardPage wp) {
        if (wp.isFirstPage() || wp.isEntryPage() && this.m_parentDialog != null && this.m_parentDialog.isSubDialog()) {
            this.m_buttonBack.setEnabled(false);
        } else {
            this.m_buttonBack.setEnabled(true);
        }
        if (wp.isLastPage()) {
            this.m_buttonBack.setEnabled(false);
            this.m_buttonCancel.setEnabled(false);
            this.m_buttonNext.setEnabled(false);
            this.m_buttonFinish.setEnabled(true);
        } else {
            this.m_buttonFinish.setEnabled(false);
        }
        if (wp.isTemplatedPage() && wp.isSummaryPage()) {
            this.m_buttonNext.setText(CnfgResource.getMessage("Label.ButtonApply"));
        } else {
            this.m_buttonNext.setText(CnfgResource.getMessage("Label.ButtonNext"));
        }
        String sHelpFile = wp.getWizardPageData().getHelpFile();
        if (sHelpFile == null || sHelpFile.length() == 0) {
            this.m_buttonHelp.setEnabled(false);
        } else {
            this.m_buttonHelp.setEnabled(true);
        }
    }

    public boolean doAction(CnfgWizardPage wp, ArrayList errorList) {
        CnfgActionEngine engine;
        WizardPageData curPage = null;
        curPage = wp.isTemplatedPage() ? wp.getWizardTPageData() : wp.getWizardPageData();
        if (curPage == null) {
            return true;
        }
        ArrayList<ICnfgTask> taskList = new ArrayList<ICnfgTask>();
        ArrayList<CnfgActionOld> dialogActionList = new ArrayList<CnfgActionOld>();
        ArrayList silentTaskList = new ArrayList();
        ArrayList<CnfgActionOld> silentActionList = new ArrayList<CnfgActionOld>();
        this.startTaskCollecting();
        ArrayList paramList = curPage.getWizardParamList();
        int capacity = paramList.size();
        int beginIndex = 0;
        if (!wp.isSummaryPage()) {
            capacity = wp.getMaxNumOfParam() > 0 ? wp.getMaxNumOfParam() : 5;
            beginIndex = wp.getParamBeginIndex();
        }
        for (int j = beginIndex; j < paramList.size() && capacity != 0; ++j) {
            --capacity;
            WizardParameterData wParam = (WizardParameterData)paramList.get(j);
            if (!wParam.isActionParam() || wParam.getAction() == null || wParam.getParam() == null) continue;
            Object paramVal = wParam.getParam().getValue();
            boolean bRunAction = false;
            if (paramVal != null) {
                bRunAction = (Boolean)paramVal;
            }
            if (!bRunAction) continue;
            CnfgActionOld action = wParam.getAction();
            if (CnfgActionSave.class.isInstance(action)) {
                this.getWizard().setConfigValues();
            }
            ArrayList wizParamList = curPage.getConfigParamList();
            this.getWizard().getUpdatedParamList(wizParamList);
            ICnfgTask[] tasks = action.getTasks(wizParamList, null);
            ArrayList<Object> list = null;
            if (action.isSilent()) {
                list = silentTaskList;
                silentActionList.add(action);
            } else {
                list = taskList;
                dialogActionList.add(action);
            }
            for (int i = 0; i < tasks.length; ++i) {
                list.add(tasks[i]);
            }
        }
        ArrayList targetList = curPage.getActionTargetList();
        for (int i = 0; i < targetList.size(); ++i) {
            WizardActionTarget target = (WizardActionTarget)targetList.get(i);
            ArrayList actionTargetList = new ArrayList();
            ArrayList actionTargetOptionList = new ArrayList();
            target.findActionTargets(actionTargetList, actionTargetOptionList);
            for (int j = 0; j < actionTargetList.size(); ++j) {
                Object obj = actionTargetList.get(j);
                ArrayList<Object> actionList = new ArrayList();
                ArrayList pList = new ArrayList();
                if (obj != null) {
                    if (CnfgActionOld.class.isInstance(obj)) {
                        actionList.add(obj);
                    } else if (WizardPageData.class.isInstance(obj)) {
                        WizardPageData page = (WizardPageData)obj;
                        pList = page.getConfigParamList();
                        Option op = (Option)actionTargetOptionList.get(j);
                        if (op != null) {
                            actionList = op.getActions();
                        }
                    }
                }
                this.getWizard().getUpdatedParamList(pList);
                for (int k = 0; k < actionList.size(); ++k) {
                    CnfgActionOld action = (CnfgActionOld)actionList.get(k);
                    if (CnfgActionSave.class.isInstance(action)) {
                        this.getWizard().setConfigValues();
                    }
                    ICnfgTask[] tasks = action.getTasks(pList, null);
                    ArrayList<Object> list = null;
                    if (action != null) {
                        if (action.isSilent()) {
                            list = silentTaskList;
                            silentActionList.add(action);
                        } else {
                            list = taskList;
                            dialogActionList.add(action);
                        }
                    }
                    for (int iTask = 0; iTask < tasks.length; ++iTask) {
                        list.add(tasks[iTask]);
                    }
                }
            }
        }
        this.endTaskCollecting();
        if (silentTaskList.size() > 0) {
            final ICnfgTask[] tasks = new ICnfgTask[silentTaskList.size()];
            for (int i = 0; i < silentTaskList.size(); ++i) {
                tasks[i] = (ICnfgTask)silentTaskList.get(i);
            }
            engine = new CnfgActionEngine();
            this.m_sTaskOutput.clear();
            boolean bSuccess = engine.run(new CnfgAction(){

                @Override
                public ICnfgTask[] getTasks() {
                    return tasks;
                }
            }, this);
            if (!bSuccess) {
                curPage.setActionState(-1);
                for (int j = 0; j < silentActionList.size(); ++j) {
                    CnfgActionOld action = (CnfgActionOld)silentActionList.get(j);
                    action.undo(errorList);
                }
                return false;
            }
            if (this.m_failedTasks) {
                curPage.setActionState(-1);
            } else if (curPage.getActionState() == 0) {
                curPage.setActionState(1);
            }
        }
        this.m_sTaskOutput.clear();
        if (taskList.size() > 0) {
            final ICnfgTask[] tasks = CnfgTask.createTaskArray(taskList);
            engine = new CnfgActionEngine();
            CnfgWizardDialog taskDialog = new CnfgWizardDialog(CRConfigFrame.getInstance(), this.getWizard(), true);
            taskDialog.setTitle(curPage.getLabel());
            CnfgWizardTaskPanel taskPage = new CnfgWizardTaskPanel(taskDialog, this.getWizard());
            taskPage.setLast(curPage.getIsLast());
            taskPage.setWizardContainer(this.m_parentFrame, this.m_parentDialog);
            taskPage.setEngine(engine);
            boolean bSuccess = engine.run(new CnfgAction(){

                @Override
                public ICnfgTask[] getTasks() {
                    return tasks;
                }
            }, taskPage);
            if (!bSuccess) {
                curPage.setActionState(-1);
                for (int j = 0; j < dialogActionList.size(); ++j) {
                    CnfgActionOld action = (CnfgActionOld)dialogActionList.get(j);
                    action.undo(errorList);
                }
                return false;
            }
            if (this.m_failedTasks) {
                curPage.setActionState(-1);
            } else if (curPage.getActionState() == 0) {
                curPage.setActionState(1);
            }
        }
        return true;
    }

    @Override
    public void begin() {
    }

    @Override
    public void end() {
    }

    @Override
    public void cancel() {
    }

    public boolean initialize(ICnfgAction action) {
        return true;
    }

    public Object prompt(ICnfgTaskPrompt prompt) {
        return null;
    }

    public boolean confirm(String message, boolean defaultValue) {
        return defaultValue;
    }

    @Override
    public void updateTaskStatus(ICnfgTask task, int status) {
        if (status == 3) {
            this.m_failedTasks |= true;
        }
    }

    @Override
    public void setCancellable(boolean cancellable) {
        this.m_cancellable = cancellable;
    }

    @Override
    public void lastTaskDisabled() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_buttonNext) {
            this.actionNext();
        } else if (e.getSource() == this.m_buttonBack) {
            this.actionBack();
        } else if (e.getSource() == this.m_buttonCancel) {
            this.actionCancel();
        } else if (e.getSource() == this.m_buttonHelp) {
            this.browseHelpInfo(true);
        } else if (e.getSource() == this.m_buttonFinish) {
            this.finish();
        }
    }

    public void actionNext() {
        String sNewName;
        String sAction;
        CnfgWizardPage wp = this.getWizard().getCurrentWizardPage();
        if (wp.isEntryPage() && this.m_entryOPGroup != null && ((sAction = this.m_entryOPGroup.getSelection().getActionCommand()).equals("create") || sAction.equals("switch")) && wp.findWizardPage(sNewName = this.m_entryNewNameText.getText())) {
            Object[] arrayOfObjects = new Object[]{CnfgResource.getMessage("Message.errorOnNew.namedup.notification"), CnfgResource.getMessage("Message.errorOnNew.namedup.resolution")};
            DialogMessage.showDialog(arrayOfObjects, this.getWizard().getWizardLabel(), DialogMessage.ICON_WARNING, DialogMessage.OPTS_NOARGS, 0);
            this.m_entryNewNameText.requestFocus();
            return;
        }
        if (wp != null) {
            if (!wp.setWizardValues()) {
                return;
            }
            if ((!wp.isTemplatedPage() || wp.isTemplatedPage() && wp.isSummaryPage()) && !this.executeActions(wp)) {
                return;
            }
        }
        if (wp.isSummaryPage() && this.m_parentDialog != null && this.m_parentDialog.isSubDialog()) {
            this.m_parentDialog.terminate(true);
            return;
        }
        wp = this.getWizard().generateNextWizardPage(this);
        if (wp != null) {
            if (wp.isActionsOnly()) {
                this.executeActions(wp);
                String sClicked = "";
                if (this.m_parentFrame != null) {
                    sClicked = this.m_parentFrame.getSubDialogAction();
                } else if (this.m_parentDialog != null) {
                    sClicked = this.m_parentDialog.getSubDialogAction();
                }
                if (sClicked != null && sClicked.equalsIgnoreCase("back")) {
                    wp = this.getWizard().getPreviousWizardPage();
                } else if (sClicked != null && sClicked.equalsIgnoreCase("next")) {
                    wp = this.getWizard().generateNextWizardPage(this);
                } else {
                    if (sClicked != null && sClicked.equalsIgnoreCase("finish")) {
                        this.finish();
                        return;
                    }
                    if (sClicked != null && sClicked.equalsIgnoreCase("cancel")) {
                        this.terminate(false);
                        return;
                    }
                }
                if (wp == null) {
                    this.finish();
                    return;
                }
            }
            if (wp.getWizardPageData().isTransitPage()) {
                CnfgWizardTransitionPanel transitPage = new CnfgWizardTransitionPanel(this.m_parentDialog, this.getWizard());
                transitPage.setTransitWizName(wp.getWizardPageData().getTransitWizName());
                this.m_parentDialog.updatePanel(transitPage);
            }
            if (this.m_parentFrame != null) {
                this.m_parentFrame.refresh(wp);
                this.m_parentFrame.setVisible(true);
            } else if (this.m_parentDialog != null) {
                this.m_parentDialog.refresh(wp);
                this.m_parentDialog.setVisible(true);
            }
        } else {
            this.finish();
        }
    }

    private boolean executeActions(CnfgWizardPage wp) {
        ArrayList errorList = new ArrayList();
        boolean actionResult = this.doAction(wp, errorList);
        while (!actionResult) {
            int i;
            if (errorList.size() > 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(CnfgResource.getMessage("Message.action.undo.failed.notification")).append("\n");
                if (this.m_sTaskOutput.size() > 0) {
                    errorList.addAll(0, this.m_sTaskOutput);
                }
                for (i = 0; i < errorList.size(); ++i) {
                    String sMsg = (String)errorList.get(i);
                    buffer.append(sMsg);
                    buffer.append('\n');
                }
                buffer.append("\n").append(CnfgResource.getMessage("Message.action.undo.failed.resolution")).append("\n");
                DialogMessage.showDialog(buffer.toString(), this.getWizard().getWizardLabel(), DialogMessage.ICON_ERROR, DialogMessage.OPTS_OK, 1);
                this.terminate(false);
            }
            if (this.m_sTaskOutput.size() > 0) {
                Object[] arrayOfObjects = new Object[this.m_sTaskOutput.size() + 1];
                for (i = 0; i < this.m_sTaskOutput.size(); ++i) {
                    arrayOfObjects[i] = this.m_sTaskOutput.get(i);
                }
                arrayOfObjects[this.m_sTaskOutput.size()] = CnfgResource.getMessage("Message.silentaction.failed.resolution") + "\n";
                if (DialogMessage.showDialog(arrayOfObjects, this.getWizard().getWizardLabel(), DialogMessage.ICON_ERROR, DialogMessage.OPTS_OKCANCEL, 1) == 0) {
                    actionResult = this.doAction(wp, errorList);
                    continue;
                }
                this.actionCancel();
                continue;
            }
            return false;
        }
        return true;
    }

    public void actionBack() {
        CnfgWizardPage wp = this.getWizard().getPreviousWizardPage();
        if (wp != null) {
            if (this.m_parentFrame != null) {
                this.m_parentFrame.refresh(wp);
            } else if (this.m_parentDialog != null) {
                this.m_parentDialog.refresh(wp);
            }
        }
    }

    public void actionCancel() {
        Object[] objMsgs = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.wizard.exit.notification")).append("\n").toString(), CnfgResource.getMessage("Message.wizard.exit.resolution")};
        if (DialogMessage.showDialog(objMsgs, this.getWizard().getWizardLabel(), DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1) == 0) {
            this.terminate(false);
        }
    }

    public void terminate(boolean bFinish) {
        if (this.m_parentDialog != null && this.m_parentDialog.isSubDialog()) {
            this.m_parentDialog.terminate(bFinish);
        } else {
            this.getWizard().initWizard();
            if (this.m_parentFrame != null) {
                this.m_parentFrame.terminate();
            } else if (this.m_parentDialog != null) {
                this.m_parentDialog.terminate(bFinish);
            }
        }
    }

    public void finish() {
        CnfgWizardPage wp = this.getWizard().getCurrentWizardPage();
        wp.setWizardValues();
        if (this.m_parentDialog != null) {
            this.getWizard().setConfigValues();
            DataManager.getInstance().newConfig();
        }
        this.terminate(true);
    }

    protected void discoverParamValues(WizardParameterData wparam) {
    }

    @Override
    public void setEngine(CnfgActionEngine engine) {
    }

    @Override
    public boolean initialize(ICnfgAction action, ICnfgTask[] tasks) {
        return false;
    }

    @Override
    public ICnfgFeedback getFeedback() {
        return null;
    }

    @Override
    public void setTasksLeft(int tasksLeftInList) {
    }

    @Override
    public void setEnginePaused(boolean value) {
    }

    @Override
    public void editingCanceled(ChangeEvent ce) {
    }

    @Override
    public void editingStopped(ChangeEvent ce) {
        Object editorObj = ce.getSource();
        if (editorObj instanceof EditorArrayParameter) {
            EditorArrayParameter editor = (EditorArrayParameter)ce.getSource();
            List newParams = (List)editor.getCellEditorValue();
            editor.getParam().setValue(newParams);
            editor.setTextFieldText(editor.getParam().getValue().toString());
            this.repaint();
        }
    }

    @Override
    public void startTaskCollecting() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void endTaskCollecting() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void error(TaskCollectorException e) {
    }

    class JTextAreaEx
    extends I18NTextArea {
        public JTextAreaEx() {
            super(CnfgResource.getLocale());
            this.setEditable(false);
            this.setRequestFocusEnabled(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }
    }
}

