/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgTaskFeedback;
import com.cognos.crconfig.CnfgTaskLabel;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.CnfgWizardDialog;
import com.cognos.crconfig.CnfgWizardFrame;
import com.cognos.crconfig.CnfgWizardPage;
import com.cognos.crconfig.CnfgWizardPanel;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.ICnfgActionClient;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionEngine;
import com.cognos.crconfig.data.ICnfgAction;
import com.cognos.i18n.ui.I18NTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class CnfgWizardTaskPanel
extends CnfgWizardPanel
implements ICnfgActionClient {
    CnfgWizardDialog m_wizardDialog;
    CnfgWizardFrame m_wizardFrame;
    private CnfgActionEngine m_engine;
    private CnfgTaskFeedback m_feedback;
    private ICnfgAction m_currentAction;
    private CnfgTaskLabel m_currentTask;
    private List m_taskList = new ArrayList();
    private JLabel m_icon;
    private JPanel m_detailsPanel;
    private I18NTextArea m_detailsView;
    private JPanel m_taskPanel;
    private Font m_normalFont = CnfgFontSetting.getAdminFont();
    private Font m_boldFont = CnfgFontSetting.getAdminBoldFont();
    private JLabel m_message;
    private boolean m_cancellable;
    private boolean m_bIsCancelled;
    private boolean m_bIsLastPage;

    public CnfgWizardTaskPanel(CnfgWizardFrame parent, CnfgWizard cw) {
        super(parent, cw);
        this.initUI();
        parent.setContentPane(this);
    }

    public CnfgWizardTaskPanel(CnfgWizardDialog parent, CnfgWizard cw) {
        super(parent, cw);
        this.initUI();
        parent.setContentPane(this);
    }

    @Override
    public void setEngine(CnfgActionEngine engine) {
        this.m_engine = engine;
    }

    public void setWizardContainer(CnfgWizardFrame wizFrame, CnfgWizardDialog wizDialog) {
        this.m_wizardFrame = wizFrame;
        this.m_wizardDialog = wizDialog;
    }

    public void setLast(boolean bIsLast) {
        this.m_bIsLastPage = bIsLast;
    }

    private void initUI() {
        this.m_contentPanel.removeAll();
        this.m_contentPanel.setLayout(new GridBagLayout());
        this.m_icon = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(68, 68);
            }
        };
        this.m_icon.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.m_contentPanel.add((Component)this.m_icon, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        JLabel messageLabel = new JLabel(CnfgResource.getMessage("Label.DialogSave.message"));
        messageLabel.setBorder(new EmptyBorder(10, 0, 10, 10));
        this.m_contentPanel.add((Component)messageLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.m_taskPanel = new JPanel(new GridBagLayout());
        this.m_contentPanel.add((Component)this.m_taskPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.m_detailsPanel = new JPanel(new BorderLayout());
        this.m_detailsPanel.setVisible(true);
        this.m_detailsView = new I18NTextArea(8, 0, CnfgResource.getLocale());
        this.m_detailsView.setLineWrap(true);
        this.m_detailsView.setWrapStyleWord(true);
        this.m_detailsView.setEditable(false);
        JScrollPane detailsScrollPane = new JScrollPane((Component)this.m_detailsView);
        this.m_detailsPanel.add((Component)detailsScrollPane, "Center");
        this.m_contentPanel.add((Component)this.m_detailsPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(50, 10, 10, 10), 0, 0));
        this.m_parentDialog.setDefaultCloseOperation(0);
        this.m_parentDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (CnfgWizardTaskPanel.this.isFinishPage()) {
                    CnfgWizardTaskPanel.this.finish();
                } else {
                    CnfgWizardTaskPanel.this.actionCancel();
                }
            }
        });
    }

    @Override
    public void begin() {
        String sHelpFile;
        CnfgWizardPage wp;
        this.m_buttonNext.setEnabled(false);
        this.m_buttonFinish.setEnabled(false);
        this.m_buttonBack.setEnabled(false);
        this.m_buttonCancel.setEnabled(true);
        if (!this.m_cancellable) {
            this.m_buttonCancel.setEnabled(false);
        }
        if (this.getWizard() != null && (wp = this.getWizard().getCurrentWizardPage()) != null && ((sHelpFile = wp.getWizardPageData().getHelpFile()) == null || sHelpFile.length() == 0)) {
            this.m_buttonHelp.setVisible(false);
        }
        this.m_icon.setIcon(CnfgTaskLabel.getIconMap().get("progress.gif"));
        if (this.m_wizardFrame != null) {
            this.m_wizardFrame.setVisible(false);
        } else if (this.m_wizardDialog != null) {
            this.m_wizardDialog.setVisible(false);
        }
        this.m_bIsCancelled = false;
        this.m_parentDialog.show();
    }

    @Override
    public void end() {
        if (this.m_bIsCancelled) {
            this.m_bIsCancelled = false;
            this.m_parentDialog.dispose();
            return;
        }
        int actionStatus = this.m_currentAction.getStatus();
        if (3 == actionStatus) {
            this.m_icon.setIcon(CnfgTaskLabel.getIconMap().get("dialog.failed"));
            this.m_buttonNext.setEnabled(false);
            this.m_buttonBack.setEnabled(true);
        } else {
            this.m_icon.setIcon(CnfgTaskLabel.getIconMap().get("dialog.information"));
            this.m_buttonBack.setEnabled(false);
            this.m_buttonNext.setEnabled(true);
        }
        this.m_buttonCancel.setEnabled(true);
        if (this.m_bIsLastPage) {
            this.m_buttonFinish.setEnabled(true);
            this.m_buttonNext.setEnabled(false);
            this.m_buttonCancel.setEnabled(false);
        } else {
            this.m_buttonFinish.setEnabled(false);
        }
        if (!this.m_cancellable && 3 == actionStatus) {
            this.m_buttonNext.setEnabled(false);
        }
        this.updateUI();
        this.grabFocus();
    }

    @Override
    public void cancel() {
        this.m_bIsCancelled = true;
    }

    private CnfgTaskLabel findTaskLabel(ICnfgTask task) {
        if (null != task) {
            for (int i = 0; i < this.m_taskList.size(); ++i) {
                CnfgTaskLabel tl = (CnfgTaskLabel)this.m_taskList.get(i);
                if (!task.equals(tl.m_task)) continue;
                return tl;
            }
        }
        return null;
    }

    @Override
    public void updateTaskStatus(ICnfgTask task, int status) {
        CnfgTaskLabel tl = this.findTaskLabel(task);
        if (null != tl) {
            if (3 == status) {
                if (this.m_currentTask.m_task.isMandatory()) {
                    tl.setIcon(CnfgTaskLabel.getIconMap().get("symbol_error.gif"));
                } else {
                    tl.setIcon(CnfgTaskLabel.getIconMap().get("symbol_warning.gif"));
                }
                tl.setFont(this.m_normalFont);
                if (this.m_currentTask == tl) {
                    this.m_currentTask = null;
                }
            } else if (2 == status) {
                tl.setIcon(CnfgTaskLabel.getIconMap().get("symbol_success.gif"));
                tl.setFont(this.m_normalFont);
                if (this.m_currentTask == tl) {
                    this.m_currentTask = null;
                }
            } else if (1 == status) {
                tl.setIcon(CnfgTaskLabel.getIconMap().get("current.gif"));
                tl.setFont(this.m_boldFont);
                this.m_currentTask = tl;
            } else if (4 == status) {
                tl.setIcon(CnfgTaskLabel.getIconMap().get("cancelled.gif"));
                tl.setFont(this.m_boldFont);
                this.m_currentTask = tl;
            } else {
                tl.setIcon(CnfgTaskLabel.getIconMap().get("none.gif"));
                tl.setFont(this.m_normalFont);
                if (this.m_currentTask == tl) {
                    this.m_currentTask = null;
                }
            }
        }
    }

    void updateFonts() {
        this.m_normalFont = CnfgFontSetting.getAdminFont();
        this.m_boldFont = CnfgFontSetting.getAdminBoldFont();
        this.setFont(this.m_normalFont);
        this.m_message.setFont(this.m_normalFont);
        this.m_detailsView.setFont(this.m_normalFont);
        this.m_buttonCancel.setFont(this.m_normalFont);
        this.m_buttonBack.setFont(this.m_normalFont);
        this.m_buttonNext.setFont(this.m_normalFont);
        this.m_buttonFinish.setFont(this.m_normalFont);
    }

    @Override
    public boolean initialize(ICnfgAction action, ICnfgTask[] tasks) {
        this.m_taskList.clear();
        this.m_taskPanel.removeAll();
        this.m_detailsView.setText(null);
        if (null != action) {
            this.m_currentAction = action;
            if (null != tasks) {
                for (int i = 0; i < tasks.length; ++i) {
                    CnfgTaskLabel tl = new CnfgTaskLabel(tasks[i]);
                    this.m_taskList.add(tl);
                    this.m_taskPanel.add((Component)tl, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
                }
                this.validate();
            }
        }
        return true;
    }

    @Override
    public ICnfgFeedback getFeedback() {
        if (null == this.m_feedback) {
            this.m_feedback = new CnfgTaskFeedback();
        }
        this.m_feedback.setValues(this.m_currentTask, (ArrayList)this.m_taskList, this.m_detailsView, null);
        return this.m_feedback;
    }

    @Override
    public void setCancellable(boolean cancellable) {
        this.m_cancellable = cancellable;
    }

    @Override
    public void actionCancel() {
        Object[] objMsgs = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.wizard.exit.notification")).append("\n").toString(), CnfgResource.getMessage("Message.wizard.exit.resolution")};
        if (!this.m_cancellable && this.m_currentAction != null) {
            if (this.m_currentAction.getStatus() <= 1) {
                return;
            }
        } else if (this.m_currentAction != null && this.m_currentAction.getStatus() == 1) {
            if (this.m_bIsCancelled) {
                return;
            }
            if (DialogMessage.showDialog(objMsgs, this.getWizard().getWizardLabel(), DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1) == 0) {
                this.exit("cancelTask");
                this.m_buttonCancel.setEnabled(false);
                this.m_engine.cancel();
            }
            return;
        }
        if (DialogMessage.showDialog(objMsgs, this.getWizard().getWizardLabel(), DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1) == 0) {
            this.exit("cancel");
        }
    }

    private void exit(String action) {
        if (this.m_wizardFrame != null) {
            this.m_wizardFrame.setSubDialogAction(action.equals("cancelTask") ? "cancel" : action);
        } else if (this.m_parentDialog != null) {
            this.m_wizardDialog.setSubDialogAction(action.equals("cancelTask") ? "cancel" : action);
        }
        if (!action.equalsIgnoreCase("cancelTask")) {
            this.m_parentDialog.dispose();
        }
    }

    @Override
    public void actionNext() {
        this.exit("next");
    }

    @Override
    public void actionBack() {
        this.exit("back");
    }

    @Override
    public void finish() {
        this.exit("finish");
    }
}

