/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.ConfigurationException;
import com.cognos.crconfig.ConfigurationImpl;
import com.cognos.crconfig.data.DataManager;
import com.cognos.i18n.ToolkitResources;
import com.cognos.indications.LogIPFControl;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Configuration {
    private static Object m_mutex = new Object();
    private static Configuration INSTANCE = null;
    private boolean m_bIPFInitialized = false;
    ConfigurationImpl mCnfgImpl = null;
    public static final short SAVE = 1;
    public static final short TEST = 4;
    public static final short START = 8;
    public static final short STOP = 16;
    public static final short RESTART = 32;

    private Configuration() throws ConfigurationException {
        int dotIndex;
        String sLocale = CnfgPreferences.getInstance().getProperty("language", "en");
        String sLang = "";
        String sCountry = "";
        String sVariant = "";
        int dashChar = 45;
        int dotChar = 46;
        String sNormalizedLocale = ToolkitResources.normalizeLocaleIdentifier((String)sLocale);
        int dashIndex = sNormalizedLocale.indexOf(dashChar);
        if (dashIndex < 0) {
            dotIndex = sNormalizedLocale.indexOf(dotChar);
            if (dotIndex >= 0) {
                sLang = sNormalizedLocale.substring(0, dotIndex).toLowerCase();
                sVariant = sNormalizedLocale.substring(dotIndex + 1);
            } else {
                sLang = sNormalizedLocale.toLowerCase();
            }
        } else {
            dotIndex = sNormalizedLocale.indexOf(dotChar, dashIndex + 1);
            sLang = sNormalizedLocale.substring(0, dashIndex).toLowerCase();
            if (dotIndex >= 0) {
                sCountry = sNormalizedLocale.substring(dashIndex + 1, dotIndex).toUpperCase();
                sVariant = sNormalizedLocale.substring(dotIndex + 1);
            } else {
                sCountry = sNormalizedLocale.substring(dashIndex + 1).toUpperCase();
            }
        }
        Locale locale = new Locale(sLang, sCountry, sVariant);
        try {
            CnfgResource.setJVMInitialLocale(Locale.getDefault());
            ResourceBundle rb = ResourceBundle.getBundle("cogconfig", locale);
            CnfgResource.setResourceBundle(rb);
            Locale rbLocale = rb.getLocale();
            if (rbLocale.getLanguage().length() == 0 && rbLocale.getCountry().length() == 0 && rbLocale.getVariant().length() == 0) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CRConfig - Reverted to the default 'cogconfig' property file (English), setting locale to English.");
                }
                Locale.setDefault(Locale.ENGLISH);
                CnfgResource.setLocale(Locale.ENGLISH);
            } else {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CRConfig - Found 'cogconfig' property file for locale '" + rbLocale + "'");
                }
                Locale.setDefault(rbLocale);
                CnfgResource.setLocale(rbLocale);
            }
        }
        catch (MissingResourceException mre) {
            CnfgLog.error(mre);
            CnfgLog.error("'cogconfig' property file for locale '" + locale.getDisplayName(Locale.ENGLISH) + "' not found. As well, unable to find the default property file.");
        }
        Configuration.setJavaSystemRoot();
        String sIPFConfigFileName = (String)CnfgPreferences.getInstance().getProperty("IPFConfigFileName", "../configuration/cogconfigipf.xml", String.class);
        this.m_bIPFInitialized = LogIPFControl.initialize((String)CCLConfigurationFactory.getInstance().resolveEffectivePath(sIPFConfigFileName));
        DataManager.getInstance().addView("CNFGUI");
        this.mCnfgImpl = new ConfigurationImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getInstance() throws ConfigurationException {
        if (INSTANCE == null) {
            Object object = m_mutex;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new Configuration();
                }
            }
        }
        return INSTANCE;
    }

    public void save() throws ConfigurationException {
        this.mCnfgImpl.save(true);
    }

    public void export(String exportFile) throws ConfigurationException {
        this.mCnfgImpl.export(exportFile);
    }

    public void executeAction(short action) throws ConfigurationException {
        if ((action & 1) == 1) {
            this.mCnfgImpl.save(true);
        }
        if ((action & 4) == 4) {
            this.mCnfgImpl.test();
        }
        if ((action & 8) == 8) {
            this.mCnfgImpl.startServices();
        }
        if ((action & 0x10) == 16) {
            this.mCnfgImpl.stopServices();
        }
        if ((action & 0x20) == 32) {
            this.mCnfgImpl.stopServices();
            this.mCnfgImpl.startServices();
        }
    }

    private static void setJavaSystemRoot() {
        String sVersion = System.getProperty("java.version");
        if (sVersion.startsWith("1.4") && !CnfgUtils.isWindowsPlatform()) {
            String sConDir = CCLConfigurationFactory.getInstance().resolveEffectivePath("../configuration");
            if (null == sConDir) {
                sConDir = ".";
            }
            System.setProperty("java.util.prefs.systemRoot", sConDir);
        }
    }

    public void finalize() {
        if (this.m_bIPFInitialized) {
            LogIPFControl.terminate();
        }
    }
}

