/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgActionClient;
import com.cognos.crconfig.CnfgConsoleClient;
import com.cognos.crconfig.CnfgLock;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.ConfigurationException;
import com.cognos.crconfig.ElementObject;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.cognos.crconfig.TaskCollectorException;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.CnfgAction;
import com.cognos.crconfig.data.CnfgActionEngine;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.ConfigFileNotFoundException;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Option;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.StartupFileException;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.service.CnfgServiceUtils;
import com.cognos.crconfig.data.service.ServiceFolder;
import com.cognos.crconfig.data.service.ServiceManager;
import com.cognos.crconfig.test.TestTaskManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigurationImpl
implements DataManager.ITaskCollector {
    private int m_errCode = 0;
    private static String PARAMVALUE_DELIMITER = "=";
    private static String PARAMNAME_CLASS = "class";
    private static String PARAMNAME_INSTANCENAME = "instanceName";
    private static String PARAMNAME_SERVER = "server";
    private static String PARAMNAME_USER = "user";
    private static String PARAMNAME_PASSWORD = "password";
    private static String PARAMNAME_NAME = "name";
    private static String PARAMNAME_SSLENABLED = "SSLencryptionEnabled";
    private static String PARAMNAME_SERVICENAME = "servicename";
    private static String PARAMNAME_SPECIFIER = "specifier";

    public ConfigurationImpl(boolean bSkipLockCheck) throws ConfigurationException {
        boolean bGotIt = CnfgLock.getLock(bSkipLockCheck);
        if (!bGotIt) {
            String dMessage = new String(CnfgResource.getMessage("Message.silent.getlock.failed.notification"));
            CnfgLog.error(dMessage);
            this.m_errCode = 7;
        }
        CnfgLock.deleteOnExit(bSkipLockCheck);
        DataManager dm = DataManager.getInstance();
        try {
            String sError;
            String sMessage;
            if (DataManager.getInstance().checkConfigurationFiles() && CnfgLog.isDebugEnabled()) {
                String dMessage = new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.explanation")).append("\n").append(CnfgResource.getMessage("Message.defaultConfig.create.notification")).toString();
                CnfgLog.debug(dMessage);
            }
            boolean bIsUpgraded = false;
            if (dm.checkUpgrade()) {
                try {
                    bIsUpgraded = dm.upgradeConfigFile();
                    if (bIsUpgraded && CnfgLog.isDebugEnabled()) {
                        sMessage = new StringBuffer(CnfgResource.getMessage("Message.upgradeConfig.notification")).append("\n").append(CnfgResource.getMessage("Message.upgradeConfig.success.notification")).toString();
                        CnfgLog.debug(sMessage);
                    }
                }
                catch (DataManagerException e) {
                    String sMessage2 = new StringBuffer(CnfgResource.getMessage("Message.upgradeConfig.notification")).append("\n").append(CnfgResource.getMessage("Message.upgradeConfig.failed.notification")).append("\n").toString();
                    DataManagerException upgradeException = new DataManagerException(sMessage2 + e.getMessage());
                    throw upgradeException;
                }
            }
            dm.getConfig();
            if (bIsUpgraded) {
                dm.mergeServicesList(dm.getAllServices());
                DataManager.getInstance().customizedUpgrade();
            }
            if (CnfgLog.isDebugEnabled()) {
                sMessage = new String(CnfgResource.getMessage("Message.silent.status.success"));
                CnfgLog.debug(sMessage);
            }
            if ((sError = CnfgUtils.checkJava()) != null) {
                CnfgLog.error(sError);
                this.m_errCode = 8;
                throw new ConfigurationException(this.m_errCode, sError);
            }
        }
        catch (DataManagerException e) {
            CnfgLog.error(e);
            this.m_errCode = 1;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
        catch (StartupFileException e) {
            CnfgLog.error(new String(CnfgResource.getMessage("Message.loadConfig.failed.notification")));
            CnfgLog.error(e);
            this.m_errCode = 3;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
        catch (ConfigFileNotFoundException e) {
            CnfgLog.error(new String(CnfgResource.getMessage("Message.loadConfig.failed.notification")));
            CnfgLog.error(e);
            this.m_errCode = 3;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
    }

    public void save(boolean defaultEncoding) throws ConfigurationException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(512);
        OutputStreamWriter sw = new OutputStreamWriter(byteArrayStream);
        try {
            this.save(defaultEncoding, sw);
        }
        catch (ConfigurationException ce) {
            throw new ConfigurationException(ce.getErrorCode(), byteArrayStream.toString());
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e) {
                CnfgLog.error(e);
            }
        }
    }

    public void save(boolean defaultEncoding, OutputStreamWriter sw) throws ConfigurationException {
        DataManager dm = DataManager.getInstance();
        try {
            CnfgConsoleClient actionClient = new CnfgConsoleClient(sw);
            CnfgActionEngine engine = new CnfgActionEngine();
            dm.useDefaultEncoding(defaultEncoding);
            final ICnfgTask[] tasklist = this.getSaveTasks(this, actionClient);
            if (!engine.run(new CnfgAction(){

                @Override
                public ICnfgTask[] getTasks() {
                    return tasklist;
                }
            }, actionClient)) {
                CnfgLog.error("Unable to save configuraiton.");
                this.m_errCode = 2;
                throw new ConfigurationException(this.m_errCode, "Unable to save configuraiton.");
            }
            if (CnfgLog.isDebugEnabled()) {
                String dMessage = new String(CnfgResource.getMessage("Message.silent.end"));
                CnfgLog.debug(dMessage);
            }
            if (this.m_errCode == 0) {
                CnfgUtils.saveJavaAndMachineInfo();
            }
        }
        catch (SecurityException e) {
            CnfgLog.error(e);
            this.m_errCode = 5;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
        catch (Exception e) {
            CnfgLog.error(e);
            this.m_errCode = 6;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
    }

    public void export(String exportFile) throws ConfigurationException {
        DataManager dm = DataManager.getInstance();
        try {
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(512);
            OutputStreamWriter m_sw = new OutputStreamWriter(byteArrayStream);
            CnfgConsoleClient actionClient = new CnfgConsoleClient(m_sw);
            CnfgActionEngine engine = new CnfgActionEngine();
            File file = new File(exportFile);
            final ICnfgTask[] tasks = dm.getExportTasks(file);
            if (!engine.run(new CnfgAction(){

                @Override
                public ICnfgTask[] getTasks() {
                    return tasks;
                }
            }, actionClient)) {
                CnfgLog.error(byteArrayStream.toString());
                this.m_errCode = 2;
                throw new ConfigurationException(this.m_errCode, byteArrayStream.toString());
            }
            m_sw.close();
            if (CnfgLog.isDebugEnabled()) {
                String dMessage = new String(CnfgResource.getMessage("Message.silent.end"));
                CnfgLog.debug(dMessage);
            }
            if (this.m_errCode == 0) {
                CnfgUtils.saveJavaAndMachineInfo();
            }
        }
        catch (SecurityException e) {
            CnfgLog.error(e);
            this.m_errCode = 5;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
        catch (Exception e) {
            CnfgLog.error(e);
            this.m_errCode = 6;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
    }

    public void test() throws ConfigurationException {
        DataManager dm = DataManager.getInstance();
        try {
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(512);
            OutputStreamWriter m_sw = new OutputStreamWriter(byteArrayStream);
            CnfgConsoleClient actionClient = new CnfgConsoleClient(m_sw);
            CnfgActionEngine engine = new CnfgActionEngine();
            final ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
            Map<String, ICnfgTest> initializedClasses = TestTaskManager.getTestTasks(this, dm.getRootFolder(), tasklist, false, true, false, actionClient.getFeedback());
            if (!engine.run(new CnfgAction(){

                @Override
                public ICnfgTask[] getTasks() {
                    return CnfgTask.createTaskArray(tasklist);
                }

                @Override
                public String getName() {
                    return "test";
                }
            }, actionClient)) {
                CnfgLog.error(byteArrayStream.toString());
                this.m_errCode = 9;
                throw new ConfigurationException(this.m_errCode, byteArrayStream.toString());
            }
            if (initializedClasses != null) {
                TestTaskManager.terminateTestProviders(initializedClasses, actionClient.getFeedback());
            }
            m_sw.close();
            if (CnfgLog.isDebugEnabled()) {
                String dMessage = new String(CnfgResource.getMessage("Message.silent.end"));
                CnfgLog.debug(dMessage);
            }
            if (this.m_errCode == 0) {
                CnfgUtils.saveJavaAndMachineInfo();
            }
        }
        catch (SecurityException e) {
            CnfgLog.error(e);
            this.m_errCode = 5;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
        catch (Exception e) {
            CnfgLog.error(e);
            this.m_errCode = 6;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
    }

    public void startServices() throws ConfigurationException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(512);
        OutputStreamWriter sw = new OutputStreamWriter(byteArrayStream);
        try {
            this.startServices(sw);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e) {
                CnfgLog.error(e);
            }
        }
    }

    public void startServices(OutputStreamWriter wg_sw) throws ConfigurationException {
        try {
            CnfgConsoleClient actionClient = new CnfgConsoleClient(wg_sw);
            CnfgActionEngine engine = new CnfgActionEngine();
            final ArrayList<ICnfgTask> tasklist = this.getStartTasks(this, actionClient);
            if (!engine.run(new CnfgAction(){

                @Override
                public ICnfgTask[] getTasks() {
                    return CnfgTask.createTaskArray(tasklist);
                }
            }, actionClient)) {
                CnfgLog.error("Unable to start BI services. Return false.");
                this.m_errCode = 2;
                throw new ConfigurationException(this.m_errCode, "Unable to start BI services.");
            }
            if (this.m_errCode == 0) {
                CnfgUtils.saveJavaAndMachineInfo();
            }
            CnfgLog.info("Start BI services... ... Succeed.");
        }
        catch (SecurityException e) {
            CnfgLog.error(e);
            this.m_errCode = 5;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
        catch (Exception e) {
            CnfgLog.error(e);
            this.m_errCode = 6;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
    }

    public void stopServices() throws ConfigurationException {
        DataManager dm = DataManager.getInstance();
        try {
            int i;
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(512);
            OutputStreamWriter m_sw = new OutputStreamWriter(byteArrayStream);
            CnfgConsoleClient actionClient = new CnfgConsoleClient(m_sw);
            CnfgActionEngine engine = new CnfgActionEngine();
            ArrayList<ICnfgTask> list = new ArrayList<ICnfgTask>();
            boolean bIsAvailable = ServiceManager.getCBSRegName() != null;
            boolean bBTSVIsInstalled = dm.isBTSVInstalled();
            boolean bIsRunning = ServiceManager.isRunning();
            if (bBTSVIsInstalled) {
                if (bIsAvailable && bIsRunning) {
                    CnfgServiceUtils.createStopTask(list, null);
                } else if (!bIsAvailable || !bBTSVIsInstalled) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(new String(CnfgResource.getMessage("Message.service.status.notavailable")));
                    }
                } else if (!bIsRunning) {
                    Object[] args = new Object[]{ServiceManager.getCBSRegName()};
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(new String(CnfgResource.getMessage("Message.service.status.notrunning", args)));
                    }
                }
                List<ServiceFolder> lServices = dm.getServiceFolders(true);
                for (i = 0; i < lServices.size(); ++i) {
                    ServiceFolder fSFolder = lServices.get(i);
                    if (fSFolder == null || fSFolder == dm.getCBS() || fSFolder.getDisabled() || !fSFolder.getVisibility()) continue;
                    CnfgActionOld actionStop = fSFolder.findAction("stop");
                    if (fSFolder.isRunning()) {
                        ICnfgTask[] lStop;
                        if (actionStop == null || (lStop = fSFolder.createStopTasks(actionStop)) == null) continue;
                        for (int j = 0; j < lStop.length; ++j) {
                            list.add(lStop[j]);
                        }
                        continue;
                    }
                    Object[] args = new Object[]{fSFolder.getLabel()};
                    if (!CnfgLog.isDebugEnabled()) continue;
                    CnfgLog.debug(new String(CnfgResource.getMessage("Message.service.status.notrunning", args)));
                }
            } else if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(new String(CnfgResource.getMessage("Message.service.status.notavailable")));
            }
            ICnfgTask[] tasks = new ICnfgTask[list.size()];
            for (i = 0; i < list.size(); ++i) {
                tasks[i] = list.get(i);
            }
            final ICnfgTask[] taskList = tasks;
            if (!engine.run(new CnfgAction(){

                @Override
                public ICnfgTask[] getTasks() {
                    return taskList;
                }
            }, actionClient)) {
                CnfgLog.error(byteArrayStream.toString());
                this.m_errCode = 2;
                throw new ConfigurationException(this.m_errCode, byteArrayStream.toString());
            }
            m_sw.close();
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(new String(CnfgResource.getMessage("Message.silent.end")));
            }
        }
        catch (SecurityException e) {
            CnfgLog.error(e);
            this.m_errCode = 5;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
        catch (Exception e) {
            CnfgLog.error(e);
            this.m_errCode = 6;
            throw new ConfigurationException(this.m_errCode, (Throwable)e);
        }
    }

    public ICnfgTask[] getSaveTasks(DataManager.ITaskCollector taskCollector, CnfgActionClient actionClient) {
        taskCollector.startTaskCollecting();
        ICnfgTask[] tasks = DataManager.getInstance().getSaveTasks();
        taskCollector.endTaskCollecting();
        return tasks;
    }

    public ArrayList<ICnfgTask> getStartTasks(DataManager.ITaskCollector taskCollector, CnfgActionClient actionClient) {
        taskCollector.startTaskCollecting();
        DataManager dm = DataManager.getInstance();
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        dm.getAllServiceFoldersActions("start", tasklist, true);
        CnfgServiceUtils.getCBSServiceActionTasks(dm, "start", 0, tasklist);
        taskCollector.endTaskCollecting();
        return tasklist;
    }

    @Override
    public void startTaskCollecting() {
    }

    @Override
    public void endTaskCollecting() {
    }

    @Override
    public void error(TaskCollectorException e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            CnfgLog.error(e.getCause());
        } else {
            CnfgLog.error(e.getMessage());
        }
        this.m_errCode = e.getErrorCode();
    }

    private Parameter findParameter(String paramName) {
        Parameter parm = null;
        Folder rootFolder = DataManager.getInstance().getRootFolder();
        if (rootFolder != null) {
            parm = rootFolder.findParm(paramName);
        }
        return parm;
    }

    public Object getParameterValue(String paramName) {
        Parameter parm = this.findParameter(paramName);
        if (parm != null) {
            Object value = parm.getValue();
            return value;
        }
        return null;
    }

    public void setParameterValue(String paramName, Object paramValue) {
        Parameter parm;
        Folder rootFolder = DataManager.getInstance().getRootFolder();
        if (rootFolder != null && (parm = rootFolder.findParm(paramName)) != null) {
            parm.setValue(paramValue);
        }
    }

    public void setComplexParameterValue(String paramName, String ... paramValues) {
        Parameter parm;
        Folder rootFolder = DataManager.getInstance().getRootFolder();
        if (rootFolder != null && (parm = rootFolder.findParm(paramName)) instanceof ArrayParameter) {
            ArrayParameter arrayParm = (ArrayParameter)parm;
            Set<Parameter> values = arrayParm.getCurrentValues();
            Iterator<Parameter> it = values.iterator();
            for (String itemValue : paramValues) {
                if (!it.hasNext()) continue;
                Parameter itemParm = it.next();
                itemParm.setValue(itemValue);
            }
        }
    }

    public boolean setDBInstance(boolean bAppend, String dbParamName, String ... dbParamValues) {
        Folder dbFolder;
        CnfgUtils.writeToOutput("INFO", "setDBInstance() - start setting db info for instance '" + dbParamName + "'.");
        boolean result = false;
        HashMap<String, String> dbParamsMap = new HashMap<String, String>();
        if (!this.parseParamValues(dbParamsMap, dbParamValues)) {
            CnfgUtils.writeToOutput("ERROR", "setDBInstance() - couldn't get db params, nothing to add, return false.");
            return false;
        }
        Folder rootFolder = DataManager.getInstance().getRootFolder();
        if (rootFolder != null && (dbFolder = rootFolder.findComplexFolder(dbParamName, true)) != null && !dbFolder.getDisabled()) {
            if (!bAppend) {
                List<Folder> subFolders = dbFolder.getFolders();
                for (Folder folder : subFolders) {
                    TemplatedParameter dbtp = folder.getTemplatedParameter();
                    if (dbtp == null || !this.isDBTempate(dbtp.getName())) continue;
                    dbFolder.remove(folder);
                    break;
                }
            }
            ArrayList<TemplatedParameter> tParams = dbFolder.getTParameters();
            TemplatedParameter tParam = null;
            for (TemplatedParameter tp : tParams) {
                if (tp == null || !this.isDBTempate(tp.getName())) continue;
                tParam = tp;
                break;
            }
            if (tParam != null) {
                String string = dbParamsMap.get(PARAMNAME_CLASS);
                String sInstName = dbParamsMap.get(PARAMNAME_INSTANCENAME);
                Option opt = tParam.getOption(string);
                if (opt != null) {
                    if (sInstName == null || sInstName.length() == 0) {
                        sInstName = "Instance_" + string;
                    }
                    Folder newFolder = dbFolder.addInstanceFolder(tParam, opt.getName(), sInstName, sInstName);
                    this.setDBParams(newFolder, dbParamsMap);
                    result = true;
                }
            }
        }
        CnfgUtils.writeToOutput("INFO", "setDBInstance() - setting db info for instance '" + dbParamName + "' ... ... " + (result ? "Succeed." : "Failed."));
        return result;
    }

    private boolean isDBTempate(String sName) {
        boolean result = false;
        if (sName != null && sName.contains("database")) {
            result = true;
        }
        return result;
    }

    private void setDBParams(Folder newFolder, HashMap<String, String> dbParamsMap) {
        Parameter dbSSLParam;
        Parameter dbSpecifierParam;
        Parameter dbServiceNameParam;
        Parameter dbNameParam;
        Parameter dbUserParam;
        Parameter serverParam = newFolder.findParm(PARAMNAME_SERVER);
        if (serverParam != null) {
            String sServer = dbParamsMap.get(PARAMNAME_SERVER);
            serverParam.setValue(sServer != null ? sServer : "");
        }
        if ((dbUserParam = newFolder.findParm(PARAMNAME_USER)) != null) {
            String sUser = dbParamsMap.get(PARAMNAME_USER);
            String sPwd = dbParamsMap.get(PARAMNAME_PASSWORD);
            if (dbUserParam instanceof CredentialParameter) {
                ElementObject valueElem = CnfgDataUtils.buildCredentialValueElem(sUser != null ? sUser : "", sPwd != null ? sPwd : "");
                dbUserParam.setValue(valueElem);
            }
        }
        if ((dbNameParam = newFolder.findParm(PARAMNAME_NAME)) != null) {
            String sName = dbParamsMap.get(PARAMNAME_NAME);
            dbNameParam.setValue(sName != null ? sName : "");
        }
        if ((dbServiceNameParam = newFolder.findParm(PARAMNAME_SERVICENAME)) != null) {
            String sName = dbParamsMap.get(PARAMNAME_SERVICENAME);
            dbServiceNameParam.setValue(sName != null ? sName : "");
        }
        if ((dbSpecifierParam = newFolder.findParm(PARAMNAME_SPECIFIER)) != null) {
            String sName = dbParamsMap.get(PARAMNAME_SPECIFIER);
            dbSpecifierParam.setValue(sName != null ? sName : "");
        }
        if ((dbSSLParam = newFolder.findParm(PARAMNAME_SSLENABLED)) != null) {
            String sSSL = dbParamsMap.get(PARAMNAME_SSLENABLED);
            boolean bSSL = false;
            if (sSSL != null && sSSL.equalsIgnoreCase("true")) {
                bSSL = true;
            }
            dbSSLParam.setValue(new Boolean(bSSL));
        }
    }

    private boolean parseParamValues(HashMap<String, String> paramValuesMap, String ... paramValues) {
        boolean result = false;
        for (String paramPair : paramValues) {
            int pos = paramPair.indexOf(PARAMVALUE_DELIMITER);
            if (pos <= 0) continue;
            String key = paramPair.substring(0, pos).trim();
            String value = paramPair.substring(pos + 1).trim();
            paramValuesMap.put(key, value);
            result = true;
        }
        return result;
    }
}

