/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Parameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;

public class DialogArrayOptions
extends JDialog
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private CnfgButton m_buttonOK;
    private CnfgButton m_buttonCancel;
    protected JPanel m_panel;
    ButtonGroup m_optGroup = new ButtonGroup();
    protected HashMap<String, ArrayList<Parameter>> m_availableOptions = new HashMap();
    ArrayList<Parameter> m_Parameters = new ArrayList();
    protected ArrayParameter m_param;

    public DialogArrayOptions(Frame owner, String sDialogTitle, ArrayParameter param) {
        super(owner, sDialogTitle, true);
        this.commonInit(owner, param);
    }

    public DialogArrayOptions(Dialog owner, String sDialogTitle, ArrayParameter param) {
        super(owner, sDialogTitle, true);
        this.commonInit(owner, param);
    }

    private void commonInit(Container owner, ArrayParameter param) {
        this.m_param = param;
        if (this.m_param.hasValues()) {
            this.loadAvailableValues();
        }
        this.setupDialogUI(owner);
    }

    protected void setupDialogUI(Component parent) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Insets ins1 = new Insets(10, 10, 0, 10);
        Insets margin = new Insets(8, 8, 8, 8);
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(false);
        this.m_panel = new JPanel();
        this.getContentPane().add((Component)this.m_panel, "Center");
        this.m_panel.setBorder(new CompoundBorder(new EmptyBorder(margin), new SoftBevelBorder(1)));
        this.m_panel.setLayout(gridbag);
        c.fill = 0;
        c.anchor = 18;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = ins1;
        this.m_panel.registerKeyboardAction(new DialogArrayOptionsCancelListener(), KeyStroke.getKeyStroke(27, 0), 1);
        this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(115, 8), 1);
        AbstractButton firstRadioButton = null;
        int gridYIdx = 1;
        if (this.m_availableOptions.size() > 0) {
            Iterator<String> iter = this.m_availableOptions.keySet().iterator();
            boolean bFoundOpt = false;
            while (iter.hasNext()) {
                String key = iter.next();
                ArrayList<Parameter> pList = this.m_availableOptions.get(key);
                StringBuffer labelStr = new StringBuffer();
                int pNum = 0;
                for (Parameter param : pList) {
                    if (pNum > 0) {
                        labelStr.append(",");
                    }
                    labelStr.append(param.getLabel());
                    ++pNum;
                }
                if (pNum > 1) {
                    labelStr.append(",TLS1.0");
                }
                boolean bSelect = this.isCurrentValue(pList);
                bFoundOpt = bFoundOpt || bSelect;
                JRadioButton radioButton = new JRadioButton(labelStr.toString(), bSelect);
                radioButton.setActionCommand(key);
                radioButton.addActionListener(this);
                this.m_optGroup.add(radioButton);
                if (key.equals("0")) {
                    firstRadioButton = radioButton;
                }
                c.gridx = 1;
                c.gridy = gridYIdx++;
                c.gridwidth = 8;
                c.insets = ins1;
                c.fill = 2;
                gridbag.setConstraints(radioButton, c);
                this.m_panel.add(radioButton);
                c.gridwidth = 1;
                c.fill = 0;
            }
            if (!bFoundOpt && firstRadioButton != null) {
                firstRadioButton.setSelected(true);
            }
        }
        Box p2 = new Box(0);
        c.gridx = 1;
        c.gridy = gridYIdx;
        c.gridwidth = 8;
        c.insets = new Insets(20, 10, 6, 10);
        c.anchor = 11;
        gridbag.setConstraints(p2, c);
        this.m_panel.add(p2);
        this.m_buttonOK = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
        this.getRootPane().setDefaultButton(this.m_buttonOK);
        p2.add(Box.createGlue());
        p2.add(this.m_buttonOK);
        p2.add(Box.createHorizontalStrut(6));
        this.m_buttonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
        p2.add(this.m_buttonCancel);
        p2.add(Box.createHorizontalStrut(6));
        this.m_buttonOK.addActionListener(this);
        this.m_buttonCancel.addActionListener(this);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogArrayOptions.this.Terminate();
            }
        };
        this.addWindowListener(l);
        CnfgUtils.pack(this);
        this.setLocationRelativeTo(parent);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DialogArrayOptions.this.m_buttonCancel.requestFocus();
            }
        });
    }

    protected void loadAvailableValues() {
        if (this.m_param == null) {
            return;
        }
        ArrayList<Parameter> fullList = new ArrayList<Parameter>();
        int order = 0;
        for (Parameter p : this.m_param.getAvailableValues()) {
            Integer i = p.getOrder();
            if (i != null && i != order) {
                p.setOrder(new Integer(order));
                this.m_param.setDirtyFlag(true);
            }
            Parameter newParam = (Parameter)p.clone();
            newParam.setFireValueChanged(false);
            ArrayList<Parameter> pList = new ArrayList<Parameter>();
            pList.add(newParam);
            this.m_availableOptions.put(String.valueOf(order), pList);
            Parameter newParamInFull = (Parameter)p.clone();
            newParamInFull.setFireValueChanged(false);
            fullList.add(newParamInFull);
            ++order;
        }
        this.m_availableOptions.put(String.valueOf(order), fullList);
    }

    private boolean isCurrentValue(ArrayList<Parameter> paramListOpt) {
        int pNum = paramListOpt.size();
        if (pNum > 0 && pNum == this.m_param.getCurrentValues().size()) {
            Parameter curP;
            String valCur;
            if (pNum > 1) {
                return true;
            }
            Parameter optP = paramListOpt.get(0);
            String valOpt = (String)optP.getValue();
            if (valOpt.equals(valCur = (String)(curP = this.m_param.getCurrentValues().iterator().next()).getValue())) {
                return true;
            }
        }
        return false;
    }

    public ArrayList<Parameter> getListParameters() {
        return this.m_Parameters;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getRootPane()) {
            this.Terminate();
        } else if (e.getSource() == this.m_buttonOK) {
            this.Action_OK();
        } else if (e.getSource() == this.m_buttonCancel) {
            this.Terminate();
        }
    }

    protected void Action_OK() {
        String optIdx = this.m_optGroup.getSelection().getActionCommand();
        this.m_Parameters = this.m_availableOptions.get(optIdx);
        this.m_param.setDirtyFlag(true);
        DataManager.getInstance().setWLPServerDirtyFlag(true);
        DataManager.getInstance().setSSLProtocolsChanged(true);
        this.Terminate();
    }

    public void Terminate() {
        this.dispose();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    class DialogArrayOptionsCancelListener
    implements ActionListener {
        DialogArrayOptionsCancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DialogArrayOptions.this.m_panel) {
                DialogArrayOptions.this.Terminate();
            }
        }
    }
}

