/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgComboBox;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.RendererParameterLabel;
import com.cognos.crconfig.RendererParameterValue;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.FontsMapParameter;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.PathParameter;
import com.cognos.crconfig.data.SystemPasswordParameter;
import com.cognos.crconfig.editors.EditorBase;
import com.cognos.crconfig.editors.EditorCredential;
import com.cognos.crconfig.editors.EditorFontsMap;
import com.cognos.crconfig.editors.EditorPathParameter;
import com.cognos.crconfig.editors.EditorSystemPassword;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DialogArrayParameter
extends JDialog
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private CnfgButton m_buttonOK;
    private CnfgButton m_buttonCancel;
    private CnfgButton m_buttonMoveOver;
    protected CnfgButton m_buttonAdd;
    protected CnfgButton m_buttonRemove;
    private CnfgButton m_buttonUp;
    private CnfgButton m_buttonDown;
    private CnfgButton m_buttonToTop;
    private CnfgButton m_buttonToBottom;
    protected Component[] m_addtionalUIItems = null;
    protected arrayParamTableModel m_inputTableModel;
    protected emTable m_inputTable;
    protected arrayParamTableModel m_outputTableModel;
    protected emTable m_outputTable;
    protected ArrayParameter m_param;
    public boolean m_bOK = false;

    public DialogArrayParameter(Frame owner, String sDialogTitle, ArrayParameter param) {
        super(owner, sDialogTitle, true);
        this.commonInit(owner, param);
    }

    public DialogArrayParameter(Dialog owner, String sDialogTitle, ArrayParameter param) {
        super(owner, sDialogTitle, true);
        this.commonInit(owner, param);
    }

    public DialogArrayParameter() {
    }

    private void commonInit(Container owner, ArrayParameter param) {
        if (param.hasValues()) {
            this.m_inputTableModel = new arrayParamTableModelWithoutErrorCol(CnfgResource.getMessage("Label.DialogArrayParameter.inputHdrValue"), false);
        }
        this.m_outputTableModel = param.isElementParameter() ? new arrayParamTableModelNameValuePair() : (param.hasValues() && !param.canAddValues() ? new arrayParamTableModelWithoutErrorCol(CnfgResource.getMessage("Label.DialogArrayParameter.outputHdrValue"), param.canAddValues()) : new arrayParamTableModel(CnfgResource.getMessage("Label.DialogArrayParameter.outputHdrValue"), param.canAddValues()));
        this.m_param = param;
        this.initCustomizedItems();
        this.setupDialogUI(owner);
    }

    public void initCustomizedItems() {
        this.m_addtionalUIItems = null;
    }

    public ArrayList<Parameter> getNewParameterList() {
        return this.m_outputTableModel.getListParameters();
    }

    private void setButtonStatus(int iCurNum) {
        Integer max = this.m_param.getMaxOccurs();
        if (max != -1 && max != 0 && this.m_param.canAddValues()) {
            if (iCurNum < max) {
                this.m_buttonAdd.setEnabled(true);
                if (this.m_buttonMoveOver != null) {
                    this.m_buttonMoveOver.setEnabled(true);
                }
            } else {
                this.m_buttonAdd.setEnabled(false);
                if (this.m_buttonMoveOver != null) {
                    this.m_buttonMoveOver.setEnabled(false);
                }
            }
        }
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogArrayParameter.this.terminate();
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getRootPane()) {
            this.terminate();
        } else if (e.getSource() == this.m_buttonOK) {
            this.action_OK();
        } else if (e.getSource() == this.m_buttonCancel) {
            this.terminate();
        } else if (e.getSource() == this.m_buttonAdd) {
            this.action_Add();
        } else if (e.getSource() == this.m_buttonRemove) {
            this.action_Remove();
        } else if (e.getSource() == this.m_buttonMoveOver) {
            this.action_MoveOver();
        } else if (e.getSource() == this.m_buttonUp) {
            this.action_Up();
        } else if (e.getSource() == this.m_buttonDown) {
            this.action_Down();
        } else if (e.getSource() == this.m_buttonToTop) {
            this.action_ToTop();
        } else if (e.getSource() == this.m_buttonToBottom) {
            this.action_ToBottom();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        Integer max;
        if (e.getSource() == this.m_outputTableModel) {
            this.m_buttonRemove.setEnabled(this.m_outputTableModel.isSelected());
        }
        if (e.getSource() == this.m_inputTableModel && (max = this.m_param.getMaxOccurs()) != -1 && max != 0 && this.m_param.canAddValues()) {
            if (this.m_outputTableModel.getRowCount() + this.m_inputTableModel.getSelectedRowCount() > max) {
                this.m_buttonMoveOver.setEnabled(false);
            } else {
                this.m_buttonMoveOver.setEnabled(true);
            }
        }
    }

    protected void setupDialogUI(Component parent) {
        JScrollPane outputScroll;
        Insets margin = new Insets(4, 4, 4, 4);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new EmptyBorder(margin));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        mainPanel.setLayout(gridbag);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(gridbag);
        this.m_outputTableModel.loadCurrentValues();
        this.m_outputTable = new emTable(this.m_outputTableModel, this.m_buttonAdd);
        this.m_outputTableModel.addTableModelListener(this);
        if (this.m_param.hasValues()) {
            this.m_inputTableModel.loadAvailableValues();
            this.m_inputTable = new emTable(this.m_inputTableModel, this.m_buttonAdd);
            this.m_inputTableModel.addTableModelListener(this);
            JScrollPane inputScroll = new JScrollPane(this.m_inputTable){
                private static final long serialVersionUID = 1L;

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(225, 200);
                }
            };
            inputScroll.setBorder(new CompoundBorder(new EmptyBorder(margin), new SoftBevelBorder(1)));
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(0, 0, 4, 4);
            c.anchor = 11;
            c.fill = 1;
            gridbag.setConstraints(inputScroll, c);
            topPanel.add(inputScroll);
            Icon imageMoveOver = CnfgImageLoader.loadIcon("move_right.gif");
            String moveOverlabel = CnfgResource.getMessage("Label.DialogArrayParameter.Button.Add");
            this.m_buttonMoveOver = new CnfgButton(moveOverlabel, imageMoveOver);
            Rectangle2D rec = CnfgFontSetting.getAdminFont().getStringBounds(moveOverlabel, new FontRenderContext(null, false, false));
            int widthChar = CnfgFontSetting.getMaxWidth(CnfgFontSetting.getAdminFont());
            int labelWidth = (int)rec.getWidth() + widthChar;
            int labelHeight = (int)rec.getHeight();
            this.m_buttonMoveOver.setMargin(new Insets(1, 1, 1, 1));
            this.m_buttonMoveOver.setDimWidth(imageMoveOver.getIconWidth() + labelWidth + this.m_buttonMoveOver.getInsets().left + this.m_buttonMoveOver.getInsets().right);
            this.m_buttonMoveOver.setDimHeight(labelHeight + this.m_buttonMoveOver.getInsets().top + this.m_buttonMoveOver.getInsets().bottom);
            this.m_buttonMoveOver.setVerticalTextPosition(0);
            this.m_buttonMoveOver.setHorizontalTextPosition(10);
            this.m_buttonMoveOver.addActionListener(this);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = margin;
            c.anchor = 10;
            c.fill = 0;
            gridbag.setConstraints(this.m_buttonMoveOver, c);
            topPanel.add(this.m_buttonMoveOver);
            outputScroll = new JScrollPane(this.m_outputTable){
                private static final long serialVersionUID = 1L;

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(225, 200);
                }
            };
        } else {
            outputScroll = new JScrollPane(this.m_outputTable);
        }
        outputScroll.setBorder(new CompoundBorder(new EmptyBorder(margin), new SoftBevelBorder(1)));
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 4, 4, 4);
        c.anchor = 11;
        c.fill = 1;
        gridbag.setConstraints(outputScroll, c);
        topPanel.add(outputScroll);
        if (this.m_param.isOrdered()) {
            Icon imageUp = CnfgImageLoader.loadIcon("move_up.gif");
            this.m_buttonUp = new CnfgButton(imageUp, CnfgResource.getMessage("Label.DialogArrayParameter.ButtonUp"));
            this.m_buttonUp.setMargin(new Insets(1, 1, 1, 1));
            this.m_buttonUp.setDimWidth(imageUp.getIconWidth() + this.m_buttonUp.getInsets().left + this.m_buttonUp.getInsets().right);
            this.m_buttonUp.setDimHeight(imageUp.getIconHeight() + this.m_buttonUp.getInsets().top + this.m_buttonUp.getInsets().bottom);
            this.m_buttonUp.addActionListener(this);
            Icon imageDown = CnfgImageLoader.loadIcon("move_down.gif");
            this.m_buttonDown = new CnfgButton(imageDown, CnfgResource.getMessage("Label.DialogArrayParameter.ButtonDown"));
            this.m_buttonDown.setMargin(new Insets(1, 1, 1, 1));
            this.m_buttonDown.setDimWidth(imageDown.getIconWidth() + this.m_buttonDown.getInsets().left + this.m_buttonDown.getInsets().right);
            this.m_buttonDown.setDimHeight(imageDown.getIconHeight() + this.m_buttonDown.getInsets().top + this.m_buttonDown.getInsets().bottom);
            this.m_buttonDown.addActionListener(this);
            Icon imageToTop = CnfgImageLoader.loadIcon("moveall_top.gif");
            this.m_buttonToTop = new CnfgButton(imageToTop, CnfgResource.getMessage("Label.DialogArrayParameter.ButtonTop"));
            this.m_buttonToTop.setMargin(new Insets(1, 1, 1, 1));
            this.m_buttonToTop.setDimWidth(imageToTop.getIconWidth() + this.m_buttonToTop.getInsets().left + this.m_buttonToTop.getInsets().right);
            this.m_buttonToTop.setDimHeight(imageToTop.getIconHeight() + this.m_buttonToTop.getInsets().top + this.m_buttonToTop.getInsets().bottom);
            this.m_buttonToTop.addActionListener(this);
            Icon imageToBottom = CnfgImageLoader.loadIcon("moveall_bottom.gif");
            this.m_buttonToBottom = new CnfgButton(imageToBottom, CnfgResource.getMessage("Label.DialogArrayParameter.ButtonBottom"));
            this.m_buttonToBottom.setMargin(new Insets(1, 1, 1, 1));
            this.m_buttonToBottom.setDimWidth(imageToBottom.getIconWidth() + this.m_buttonToBottom.getInsets().left + this.m_buttonToBottom.getInsets().right);
            this.m_buttonToBottom.setDimHeight(imageToBottom.getIconHeight() + this.m_buttonToBottom.getInsets().top + this.m_buttonToBottom.getInsets().bottom);
            this.m_buttonToBottom.addActionListener(this);
            Box boxUpDown = new Box(1);
            boxUpDown.add(Box.createGlue());
            boxUpDown.add(this.m_buttonToTop);
            boxUpDown.add(Box.createVerticalStrut(6));
            boxUpDown.add(this.m_buttonUp);
            boxUpDown.add(Box.createVerticalStrut(6));
            boxUpDown.add(this.m_buttonDown);
            boxUpDown.add(Box.createVerticalStrut(6));
            boxUpDown.add(this.m_buttonToBottom);
            c.gridx = 3;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = margin;
            c.anchor = 10;
            c.fill = 0;
            gridbag.setConstraints(boxUpDown, c);
            topPanel.add(boxUpDown);
        }
        this.m_buttonAdd = new CnfgButton(CnfgResource.getMessage("Label.DialogGlobalConfig.ButtonAdd"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
        this.m_buttonAdd.addActionListener(this);
        this.m_buttonAdd.setEnabled(this.m_param.canAddValues());
        this.m_buttonRemove = new CnfgButton(CnfgResource.getMessage("Label.DialogGlobalConfig.ButtonRemove"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
        this.m_buttonRemove.setEnabled(false);
        this.m_buttonRemove.addActionListener(this);
        Box boxAddRemove = new Box(0);
        if (this.m_param.canAddValues()) {
            boxAddRemove.add(this.m_buttonAdd);
            boxAddRemove.add(Box.createHorizontalStrut(6));
        }
        boxAddRemove.add(this.m_buttonRemove);
        boxAddRemove.add(Box.createHorizontalStrut(6));
        this.addAdditionItems(boxAddRemove);
        boxAddRemove.add(Box.createGlue());
        int iNumOfCurValues = 0;
        if (this.m_outputTableModel.getListParameters() != null) {
            iNumOfCurValues = this.m_outputTableModel.getListParameters().size();
        }
        this.setButtonStatus(iNumOfCurValues);
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        gridbag.setConstraints(boxAddRemove, c);
        topPanel.add(boxAddRemove);
        this.m_buttonOK = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
        this.m_buttonOK.addActionListener(this);
        this.m_buttonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
        this.m_buttonCancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_buttonOK);
        Box boxOKCancel = new Box(0);
        boxOKCancel.add(Box.createGlue());
        boxOKCancel.add(this.m_buttonOK);
        boxOKCancel.add(Box.createHorizontalStrut(6));
        boxOKCancel.add(this.m_buttonCancel);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        c.fill = 1;
        gridbag.setConstraints(topPanel, c);
        mainPanel.add(topPanel);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = margin;
        c.anchor = 15;
        c.fill = 2;
        gridbag.setConstraints(boxOKCancel, c);
        mainPanel.add(boxOKCancel);
        this.getContentPane().add((Component)mainPanel, "Center");
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogArrayParameter.this.terminate();
            }
        };
        this.addWindowListener(l);
        CnfgUtils.pack(this);
        this.setLocationRelativeTo(parent);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DialogArrayParameter.this.m_buttonCancel.requestFocus();
            }
        });
    }

    private void addAdditionItems(Box boxAddRemove) {
        if (this.m_addtionalUIItems != null) {
            for (Component bb : this.m_addtionalUIItems) {
                boxAddRemove.add(bb);
                boxAddRemove.add(Box.createHorizontalStrut(6));
            }
        }
    }

    private void action_Add() {
        int newRow = this.m_outputTableModel.addEmpty();
        if (this.m_outputTable.editCellAt(newRow, 1)) {
            this.m_outputTable.changeSelection(newRow, 1, false, false);
            this.m_outputTable.getEditorComponent().requestFocus();
        }
        this.setButtonStatus(this.m_outputTableModel.getRowCount());
        this.m_param.setDirtyFlag(true);
    }

    private void action_MoveOver() {
        boolean bItemMoved = false;
        for (int row = 0; row < this.m_inputTableModel.m_select.size(); ++row) {
            Boolean b = this.m_inputTableModel.m_select.get(row);
            if (!b.booleanValue()) continue;
            Parameter p1 = this.m_inputTableModel.m_Parameters.get(row);
            this.m_inputTableModel.m_select.set(row, Boolean.FALSE);
            this.m_inputTableModel.fireTableCellUpdated(row, this.m_inputTableModel.COL_SELECT);
            boolean bMatchFound = false;
            int dupRow = 0;
            for (Parameter p2 : this.m_outputTableModel.getListParameters()) {
                if (p1.getValue().toString().compareToIgnoreCase(p2.getValue().toString()) == 0) {
                    bMatchFound = true;
                    this.m_outputTableModel.m_select.set(dupRow, Boolean.TRUE);
                    this.m_outputTableModel.fireTableCellUpdated(dupRow, this.m_outputTableModel.COL_SELECT);
                    break;
                }
                ++dupRow;
            }
            if (bMatchFound) continue;
            this.m_outputTableModel.add(p1, true);
            bItemMoved = true;
        }
        if (bItemMoved) {
            this.setButtonStatus(this.m_outputTableModel.getRowCount());
            this.m_param.setDirtyFlag(true);
        }
    }

    private void action_Up() {
        for (int row = 0; row < this.m_outputTableModel.m_select.size(); ++row) {
            Boolean b2;
            Boolean b = this.m_outputTableModel.m_select.get(row);
            if (!b.booleanValue() || row == 0 || (b2 = this.m_outputTableModel.m_select.get(row - 1)).booleanValue()) continue;
            Parameter p1 = this.m_outputTableModel.m_Parameters.get(row);
            if (this.m_outputTableModel.getValidValue() != -1) {
                Boolean toBeMoved = this.m_outputTableModel.m_valid.get(row);
                this.m_outputTableModel.m_valid.add(row - 1, toBeMoved);
                this.m_outputTableModel.fireTableCellUpdated(row - 1, this.m_outputTableModel.COL_VALID);
                this.m_outputTableModel.m_valid.remove(row + 1);
                this.m_outputTableModel.fireTableCellUpdated(row + 1, this.m_outputTableModel.COL_VALID);
            }
            this.m_outputTableModel.m_Parameters.add(row - 1, p1);
            this.m_outputTableModel.m_select.add(row - 1, b);
            this.m_outputTableModel.fireTableCellUpdated(row - 1, this.m_outputTableModel.COL_VALUE);
            this.m_outputTableModel.fireTableCellUpdated(row - 1, this.m_outputTableModel.COL_SELECT);
            this.m_outputTableModel.m_Parameters.remove(row + 1);
            this.m_outputTableModel.m_select.remove(row + 1);
            this.m_outputTableModel.fireTableCellUpdated(row + 1, this.m_outputTableModel.COL_VALUE);
            this.m_outputTableModel.fireTableCellUpdated(row + 1, this.m_outputTableModel.COL_SELECT);
            this.m_param.setDirtyFlag(true);
        }
    }

    private void action_Down() {
        for (int row = this.m_outputTableModel.m_select.size() - 1; row >= 0; --row) {
            Boolean b2;
            Boolean b = this.m_outputTableModel.m_select.get(row);
            if (!b.booleanValue() || row == this.m_outputTableModel.m_select.size() - 1 || (b2 = this.m_outputTableModel.m_select.get(row + 1)).booleanValue()) continue;
            Parameter p1 = this.m_outputTableModel.m_Parameters.get(row);
            if (this.m_outputTableModel.getValidValue() != -1) {
                Boolean toBeMoved = this.m_outputTableModel.m_valid.get(row);
                this.m_outputTableModel.m_valid.add(row + 2, toBeMoved);
                this.m_outputTableModel.fireTableCellUpdated(row + 2, this.m_outputTableModel.COL_VALID);
                this.m_outputTableModel.m_valid.remove(row);
                this.m_outputTableModel.fireTableCellUpdated(row, this.m_outputTableModel.COL_VALID);
            }
            this.m_outputTableModel.m_Parameters.add(row + 2, p1);
            this.m_outputTableModel.m_select.add(row + 2, b);
            this.m_outputTableModel.fireTableCellUpdated(row + 2, this.m_outputTableModel.COL_VALUE);
            this.m_outputTableModel.fireTableCellUpdated(row + 2, this.m_outputTableModel.COL_SELECT);
            this.m_outputTableModel.m_Parameters.remove(row);
            this.m_outputTableModel.m_select.remove(row);
            this.m_outputTableModel.fireTableCellUpdated(row, this.m_outputTableModel.COL_VALUE);
            this.m_outputTableModel.fireTableCellUpdated(row, this.m_outputTableModel.COL_SELECT);
            this.m_param.setDirtyFlag(true);
        }
    }

    private void action_ToTop() {
        block0: for (int row1 = 0; row1 < this.m_outputTableModel.m_select.size(); ++row1) {
            Boolean b1 = this.m_outputTableModel.m_select.get(row1);
            if (!b1.booleanValue() || row1 == 0) continue;
            for (int row2 = 0; row2 < this.m_outputTableModel.m_select.size(); ++row2) {
                Boolean b2 = this.m_outputTableModel.m_select.get(row2);
                if (b2.booleanValue()) continue;
                if (row2 >= row1) continue block0;
                Parameter p1 = this.m_outputTableModel.m_Parameters.get(row1);
                if (this.m_outputTableModel.getValidValue() != -1) {
                    Boolean toBeMoved = this.m_outputTableModel.m_valid.get(row1);
                    this.m_outputTableModel.m_valid.add(row2, toBeMoved);
                    this.m_outputTableModel.fireTableCellUpdated(row2, this.m_outputTableModel.COL_VALID);
                    this.m_outputTableModel.m_valid.remove(row1 + 1);
                    this.m_outputTableModel.fireTableCellUpdated(row1 + 1, this.m_outputTableModel.COL_VALID);
                }
                this.m_outputTableModel.m_Parameters.add(row2, p1);
                this.m_outputTableModel.m_select.add(row2, b1);
                this.m_outputTableModel.fireTableCellUpdated(row2, this.m_outputTableModel.COL_VALUE);
                this.m_outputTableModel.fireTableCellUpdated(row2, this.m_outputTableModel.COL_SELECT);
                this.m_outputTableModel.m_Parameters.remove(row1 + 1);
                this.m_outputTableModel.m_select.remove(row1 + 1);
                this.m_outputTableModel.fireTableCellUpdated(row1 + 1, this.m_outputTableModel.COL_VALUE);
                this.m_outputTableModel.fireTableCellUpdated(row1 + 1, this.m_outputTableModel.COL_SELECT);
                this.m_param.setDirtyFlag(true);
                continue block0;
            }
        }
    }

    private void action_ToBottom() {
        block0: for (int row1 = this.m_outputTableModel.m_select.size() - 1; row1 >= 0; --row1) {
            Boolean b1 = this.m_outputTableModel.m_select.get(row1);
            if (!b1.booleanValue() || row1 == this.m_outputTableModel.m_select.size() - 1) continue;
            for (int row2 = this.m_outputTableModel.m_select.size() - 1; row2 >= 0; --row2) {
                Boolean b2 = this.m_outputTableModel.m_select.get(row2);
                if (b2.booleanValue()) continue;
                if (row2 <= row1) continue block0;
                Parameter p1 = this.m_outputTableModel.m_Parameters.get(row1);
                if (row2 == this.m_outputTableModel.m_select.size() - 1) {
                    this.m_outputTableModel.m_Parameters.add(p1);
                    this.m_outputTableModel.m_select.add(b1);
                } else {
                    this.m_outputTableModel.m_Parameters.add(row2 + 1, p1);
                    this.m_outputTableModel.m_select.add(row2 + 1, b1);
                }
                if (this.m_outputTableModel.getValidValue() != -1) {
                    Boolean toBeMoved = this.m_outputTableModel.m_valid.get(row1);
                    if (row2 == this.m_outputTableModel.m_select.size() - 1) {
                        this.m_outputTableModel.m_valid.add(toBeMoved);
                    } else {
                        this.m_outputTableModel.m_valid.add(row2 + 1, toBeMoved);
                    }
                    this.m_outputTableModel.fireTableCellUpdated(row2 + 1, this.m_outputTableModel.COL_VALID);
                    this.m_outputTableModel.m_valid.remove(row1);
                    this.m_outputTableModel.fireTableCellUpdated(row1, this.m_outputTableModel.COL_VALID);
                }
                this.m_outputTableModel.fireTableCellUpdated(row2 + 1, this.m_outputTableModel.COL_VALUE);
                this.m_outputTableModel.fireTableCellUpdated(row2 + 1, this.m_outputTableModel.COL_SELECT);
                this.m_outputTableModel.m_Parameters.remove(row1);
                this.m_outputTableModel.m_select.remove(row1);
                this.m_outputTableModel.fireTableCellUpdated(row1, this.m_outputTableModel.COL_VALUE);
                this.m_outputTableModel.fireTableCellUpdated(row1, this.m_outputTableModel.COL_SELECT);
                this.m_param.setDirtyFlag(true);
                continue block0;
            }
        }
    }

    private void action_Remove() {
        this.m_outputTable.removeEditor();
        this.m_outputTableModel.removeSelected();
        this.setButtonStatus(this.m_outputTableModel.getRowCount());
        this.m_param.setDirtyFlag(true);
    }

    private void action_OK() {
        TableCellEditor ed = this.m_outputTable.getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
        if (!this.m_outputTableModel.isValid()) {
            this.m_outputTable.changeSelection(this.m_outputTableModel.getLastErrorRow(), this.m_outputTableModel.getLastErrorCol(), false, false);
            this.m_outputTable.requestFocus();
            DialogMessage.showDialog(this.m_outputTableModel.getLastErrorMessage(), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
            return;
        }
        this.m_bOK = true;
        this.terminate();
    }

    private void terminate() {
        this.dispose();
    }

    protected class emTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private int m_prevColumn;
        private int m_prevRow;
        arrayParamTableModel m_model;

        public emTable(arrayParamTableModel model, JComponent nextFocus) {
            super(model);
            this.m_prevColumn = -1;
            this.m_prevRow = -1;
            this.m_model = model;
            this.setColumnSelectionAllowed(false);
            this.setSelectionMode(0);
            this.setNextFocusableComponent(nextFocus);
            this.setAutoResizeMode(3);
            JTableHeader cHeader = this.getTableHeader();
            cHeader.setReorderingAllowed(false);
            cHeader.setResizingAllowed(false);
            TableColumn tc = cHeader.getColumnModel().getColumn(0);
            tc.setMinWidth(22);
            tc.setMaxWidth(22);
            tc.setResizable(false);
            if (model.COL_VALUE >= 0) {
                TableColumn valCol = this.getColumnModel().getColumn(model.COL_VALUE);
                valCol.setCellRenderer(new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        return table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                });
            }
            if (model.COL_VALID >= 0) {
                TableColumn validCol = this.getColumnModel().getColumn(model.COL_VALID);
                validCol.setCellRenderer(new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        return table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                });
            }
            if (model.getValidValue() != -1) {
                tc = cHeader.getColumnModel().getColumn(model.getValidValue());
                tc.setMinWidth(22);
                tc.setMaxWidth(22);
                tc.setResizable(false);
            }
            cHeader.addMouseListener(model);
            int rowHeight = CnfgButton.m_imageEdit.getIconHeight() + 2;
            if (rowHeight > this.getRowHeight()) {
                this.setRowHeight(rowHeight);
            }
            this.setTableRowHeight();
            this.initKeyActionMap();
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            arrayParamTableModel model = (arrayParamTableModel)this.getModel();
            Color tableLineColor = CnfgUtils.isWindowsPlatform() ? SystemColor.control : Color.lightGray;
            if (column == model.COL_VALUE) {
                return new RendererParameterValue(2, tableLineColor);
            }
            if (column == model.COL_NAME) {
                return new RendererParameterLabel(2, tableLineColor, model.COL_NAME);
            }
            if (column == model.COL_VALID) {
                return new RendererCustomizeColumn();
            }
            return super.getCellRenderer(row, column);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            arrayParamTableModel model = (arrayParamTableModel)this.getModel();
            Parameter parm = (Parameter)model.getItemRow(row);
            if (column == model.COL_VALUE) {
                if (parm.getClass() == CredentialParameter.class) {
                    CnfgButton button = CnfgButton.createEditButton(parm);
                    JPasswordField pwdField = new JPasswordField();
                    pwdField.setEchoChar('*');
                    return new EditorCredential(this.getOwner(), pwdField, false, button);
                }
                if (parm.getClass() == SystemPasswordParameter.class) {
                    CnfgButton button = CnfgButton.createEditButton(parm);
                    JPasswordField pwdField = new JPasswordField();
                    pwdField.setEchoChar('*');
                    return new EditorSystemPassword(this.getOwner(), pwdField, false, button);
                }
                if (parm.getClass() == FontsMapParameter.class) {
                    CnfgButton button = CnfgButton.createEditButton(parm);
                    Object[] args = new Object[]{parm.getLabel()};
                    String title = CnfgResource.getMessage("Title.DialogEditValue.Parameter", args);
                    return new EditorFontsMap(this.getOwner(), new JTextField(), false, button, title);
                }
                if (parm.getClass() == PathParameter.class) {
                    CnfgButton button = CnfgButton.createEditButton(parm);
                    return new EditorPathParameter(this.getOwner(), new JTextField(), true, button, (PathParameter)parm);
                }
                if (parm.getValues() != null) {
                    CnfgComboBox cbox = new CnfgComboBox();
                    cbox.setBackground(this.getBackground());
                    return new EditorBase(this.getOwner(), cbox);
                }
                if (parm.isEncrypted()) {
                    JPasswordField pwdField = new JPasswordField();
                    pwdField.setEchoChar('*');
                    return new EditorBase(this.getOwner(), pwdField);
                }
                return new EditorBase(this.getOwner(), new JTextField());
            }
            if (model.COL_SELECT == column) {
                return super.getCellEditor(row, column);
            }
            if (model.COL_NAME == column) {
                return new EditorBase(this.getOwner(), new JTextField());
            }
            return null;
        }

        protected Container getOwner() {
            Container parent = this.getParent();
            while (!Dialog.class.isInstance(parent) && !Frame.class.isInstance(parent)) {
                parent = parent.getParent();
            }
            return parent;
        }

        public void setTableRowHeight() {
            this.setRowHeight(CnfgFontSetting.getMaxHeight(this.getFont()));
        }

        @Override
        public boolean isCellSelected(int row, int col) {
            return row == this.m_prevRow && col == this.m_prevColumn;
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            if (rowIndex == -1 || columnIndex == -1) {
                this.m_prevColumn = 0;
                this.m_prevRow = 0;
                super.changeSelection(0, 0, false, false);
            } else {
                this.m_prevColumn = columnIndex;
                this.m_prevRow = rowIndex;
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }
        }

        private void initKeyActionMap() {
            InputMap im = this.getInputMap(1);
            ActionMap am = this.getActionMap();
            KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
            KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            KeyStroke shiftEnter = KeyStroke.getKeyStroke(10, 1);
            im.put(enter, "CNFGSelectEnterNextRow");
            im.put(shiftEnter, "CNFGSelectEnterPreviousRow");
            am.put("CNFGSelectEnterNextRow", new SelectNextRow(this));
            am.put("CNFGSelectEnterPreviousRow", new SelectPreviousRow(this));
            im.put(tab, "CNFGSelectTabNextRow");
            im.put(shiftTab, "CNFGSelectTabPreviousRow");
            am.put("CNFGSelectTabNextRow", new SelectNextRow(this));
            am.put("CNFGSelectTabPreviousRow", new SelectPreviousRow(this));
            KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
            Action escAction = am.get(im.get(esc));
            FilteredAction newAction = new FilteredAction(this, escAction);
            im.put(esc, "CNFGCancelEditing");
            am.put("CNFGCancelEditing", newAction);
        }

        class SelectPreviousRow
        extends AbstractAction {
            private static final long serialVersionUID = 1L;
            JTable table;

            public SelectPreviousRow(JTable aTable) {
                this.table = aTable;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (this.table.isEditing() && !this.table.getCellEditor().stopCellEditing()) {
                    return;
                }
                arrayParamTableModel model = (arrayParamTableModel)this.table.getModel();
                if (emTable.this.m_prevColumn == -1 || emTable.this.m_prevRow == -1) {
                    if (model.getRowCount() > 0) {
                        this.table.changeSelection(0, 0, false, false);
                    }
                } else {
                    int columnIndex = emTable.this.m_prevColumn;
                    int rowIndex = emTable.this.m_prevRow;
                    if (emTable.this.m_prevColumn <= 0) {
                        columnIndex = model.getColValue();
                        rowIndex = rowIndex == 0 ? model.getRowCount() - 1 : --rowIndex;
                    } else if (--columnIndex == model.COL_VALID && model.isRowValid(rowIndex)) {
                        --columnIndex;
                    }
                    this.table.changeSelection(rowIndex, columnIndex, false, false);
                }
            }
        }

        class SelectNextRow
        extends AbstractAction {
            private static final long serialVersionUID = 1L;
            JTable table;

            public SelectNextRow(JTable aTable) {
                this.table = aTable;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (this.table.isEditing() && !this.table.getCellEditor().stopCellEditing()) {
                    return;
                }
                arrayParamTableModel model = (arrayParamTableModel)this.table.getModel();
                if (emTable.this.m_prevColumn == -1 || emTable.this.m_prevRow == -1) {
                    if (model.getRowCount() > 0) {
                        this.table.changeSelection(0, 0, false, false);
                    }
                } else {
                    int columnIndex = emTable.this.m_prevColumn;
                    int rowIndex = emTable.this.m_prevRow;
                    if (emTable.this.m_prevColumn >= model.getColValue()) {
                        columnIndex = 0;
                        rowIndex = rowIndex == model.getRowCount() - 1 ? 0 : ++rowIndex;
                    } else if (++columnIndex == model.COL_VALID && model.isRowValid(rowIndex)) {
                        ++columnIndex;
                    }
                    this.table.changeSelection(rowIndex, columnIndex, false, false);
                }
            }
        }
    }

    protected class arrayParamTableModelNameValuePair
    extends arrayParamTableModel {
        private static final long serialVersionUID = 1L;

        public arrayParamTableModelNameValuePair() {
            super(CnfgResource.getMessage("Label.value"), true);
            this.COL_SELECT = 0;
            this.COL_NAME = 2;
            this.COL_VALUE = 3;
            this.COL_VALID = 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == this.COL_NAME) {
                Parameter p = (Parameter)this.m_Parameters.get(row);
                return p.getName() != null ? p.getName() : "";
            }
            return super.getValueAt(row, col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (aValue == null) {
                return;
            }
            if (col == this.COL_NAME) {
                Parameter p;
                String sName = "";
                if (aValue != null) {
                    sName = aValue.toString().trim();
                }
                if ((p = (Parameter)this.m_Parameters.get(row)).getName() == null || !p.getName().equals(sName) || DialogArrayParameter.this.m_param.isSupported(sName)) {
                    p.setName(sName);
                    p.setLabel(sName);
                    DialogArrayParameter.this.m_param.setDirtyFlag(true);
                    this.fireTableCellUpdated(row, col);
                }
                if (this.COL_VALID != -1) {
                    if (this.validateParmName(sName)) {
                        this.m_valid.set(row, new Boolean(true));
                        this.fireTableCellUpdated(row, this.COL_VALID);
                    } else {
                        this.m_valid.set(row, new Boolean(false));
                        this.fireTableCellUpdated(row, this.COL_VALID);
                    }
                }
            } else if (col == this.COL_VALUE) {
                String sName;
                super.setValueAt(aValue, row, col);
                if (this.COL_VALID != -1 && !this.validateParmName(sName = ((Parameter)this.m_Parameters.get(row)).getName())) {
                    this.m_valid.set(row, new Boolean(false));
                }
                this.fireTableCellUpdated(row, this.COL_VALID);
            } else {
                super.setValueAt(aValue, row, col);
            }
        }

        private boolean validateParmName(String sName) {
            return sName != null && sName.length() > 0 && sName.indexOf(" ") == -1 && DialogArrayParameter.this.m_param.isSupported(sName);
        }

        @Override
        public String getColumnName(int col) {
            if (col == this.COL_NAME) {
                return CnfgResource.getMessage("Label.property");
            }
            return super.getColumnName(col);
        }

        @Override
        public boolean isValid() {
            this.m_lastErrorRow = -1;
            this.m_lastErrorCol = -1;
            for (int i = 0; i < this.m_count; ++i) {
                Parameter p = (Parameter)this.m_Parameters.get(i);
                String sName = "";
                if (p.getName() != null) {
                    sName = p.getName().trim();
                }
                if (sName.length() == 0) {
                    this.m_lastErrorMessage = new ArrayList();
                    this.m_lastErrorMessage.add(CnfgResource.getMessage("Message.arrayParameter.invalid.emptyname"));
                    this.m_lastErrorCol = this.COL_NAME;
                    this.m_lastErrorRow = i;
                    return false;
                }
                if (sName.indexOf(" ") > 0) {
                    this.m_lastErrorMessage = new ArrayList();
                    this.m_lastErrorMessage.add(CnfgResource.getMessage("Message.arrayParameter.invalid.spaceinname"));
                    this.m_lastErrorCol = this.COL_NAME;
                    this.m_lastErrorRow = i;
                    return false;
                }
                if (p.isBadValue()) {
                    this.m_lastErrorMessage = p.getErrorMsg();
                    this.m_lastErrorCol = this.COL_VALUE;
                    this.m_lastErrorRow = i;
                    return false;
                }
                if (DialogArrayParameter.this.m_param.isSupported(sName)) continue;
                this.m_lastErrorMessage = new ArrayList();
                Object[] args = new Object[]{DialogArrayParameter.this.m_param.getSupportedNames()};
                this.m_lastErrorMessage.add(CnfgResource.getMessage("Message.arrayParameter.invalid.unsupportedname", args));
                this.m_lastErrorCol = this.COL_NAME;
                this.m_lastErrorRow = i;
                return false;
            }
            return true;
        }

        @Override
        public int addEmpty() {
            String sType = "xsd:string";
            String sPrefix = "xsd";
            Parameter p = DialogArrayParameter.this.m_param.createParamElement(sType, sPrefix);
            return super.addEmpty(p);
        }
    }

    protected class arrayParamTableModelWithoutErrorCol
    extends arrayParamTableModel {
        private static final long serialVersionUID = 1L;

        public arrayParamTableModelWithoutErrorCol(String headerValue, boolean bIsValueEditable) {
            super(headerValue, bIsValueEditable);
            this.COL_SELECT = 0;
            this.COL_VALID = -1;
            this.COL_VALUE = 1;
            this.COL_NAME = -1;
        }
    }

    protected class arrayParamTableModel
    extends AbstractTableModel
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        protected int m_count;
        protected ArrayList<Boolean> m_select = new ArrayList();
        protected ArrayList<Parameter> m_Parameters = new ArrayList();
        protected ArrayList<Boolean> m_valid = new ArrayList();
        protected int m_lastErrorRow;
        protected int m_lastErrorCol;
        protected List<String> m_lastErrorMessage;
        protected int COL_SELECT;
        protected int COL_VALUE;
        protected int COL_NAME;
        protected int COL_VALID;
        protected String m_sHeaderValue;
        private boolean m_bIsValueEditable = false;
        public int m_bSelected = 0;

        public arrayParamTableModel(String headerValue, boolean bIsValueEditable) {
            this.m_sHeaderValue = headerValue;
            this.m_bIsValueEditable = bIsValueEditable;
            this.COL_SELECT = 0;
            this.COL_VALID = 1;
            this.COL_VALUE = 2;
            this.COL_NAME = -1;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader th;
            int column;
            if (e.getSource().getClass() == JTableHeader.class && (column = (th = (JTableHeader)e.getSource()).getColumnModel().getColumnIndexAtX(e.getX())) == this.COL_SELECT) {
                Boolean b;
                if (this.m_bSelected == 0) {
                    this.m_bSelected = 1;
                    b = Boolean.TRUE;
                } else {
                    this.m_bSelected = 0;
                    b = Boolean.FALSE;
                }
                for (int row = 0; row < this.m_select.size(); ++row) {
                    this.m_select.set(row, b);
                }
                this.fireTableDataChanged();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        public int getColValue() {
            return this.COL_VALUE;
        }

        public void setColValue(int toSet) {
            this.COL_VALUE = toSet;
        }

        public int getValidValue() {
            return this.COL_VALID;
        }

        public void setValidValue(int toSet) {
            this.COL_VALID = toSet;
        }

        public ArrayList<Parameter> getListParameters() {
            return this.m_Parameters;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == this.COL_SELECT) {
                return this.m_select.get(row);
            }
            if (col == this.COL_VALUE) {
                return this.m_Parameters.get(row);
            }
            if (col == this.COL_VALID) {
                return this.m_valid.get(row);
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            Parameter p;
            if (aValue == null) {
                return;
            }
            if (col == this.COL_SELECT) {
                this.m_select.set(row, (Boolean)aValue);
                this.fireTableCellUpdated(row, col);
            } else if (col == this.COL_VALUE && !(p = this.m_Parameters.get(row)).isEqual(aValue)) {
                p.setValue(aValue);
                DialogArrayParameter.this.m_param.setDirtyFlag(true);
                this.fireTableCellUpdated(row, col);
                if (this.COL_VALID != -1) {
                    this.m_valid.set(row, new Boolean(!p.isBadValue()));
                    Parameter lookingAt = this.m_Parameters.get(row);
                    if (DialogArrayParameter.this.m_param.isMandatory() && this.isCellEditable(0, this.COL_VALUE) && (lookingAt.getDisplayValue() == null || lookingAt.getDisplayValue() != null && lookingAt.getDisplayValue().length() == 0)) {
                        this.m_valid.set(row, new Boolean(false));
                    }
                    this.fireTableCellUpdated(row, this.COL_VALID);
                }
            }
        }

        @Override
        public String getColumnName(int col) {
            if (col == this.COL_VALUE) {
                return this.m_sHeaderValue;
            }
            if (col == this.COL_SELECT) {
                return "*";
            }
            return " ";
        }

        public boolean isRowValid(int row) {
            Boolean bValid;
            if (row >= 0 && row < this.m_valid.size() && (bValid = this.m_valid.get(row)) != null) {
                return bValid;
            }
            return false;
        }

        public boolean isValid() {
            this.m_lastErrorRow = -1;
            this.m_lastErrorCol = -1;
            if (DialogArrayParameter.this.m_param.isMandatory() && this.m_count == 0 && DialogArrayParameter.this.m_param.getMinOccurs() > 0) {
                this.m_lastErrorCol = this.COL_VALUE;
                this.m_lastErrorMessage = new ArrayList<String>();
                this.m_lastErrorMessage.add(CnfgResource.getMessage("Message.errorOnValidation.mandatory.values"));
                return false;
            }
            for (int i = 0; i < this.m_count; ++i) {
                Parameter p = this.m_Parameters.get(i);
                if (p.isBadValue()) {
                    this.m_lastErrorRow = i;
                    this.m_lastErrorCol = this.COL_VALUE;
                    this.m_lastErrorMessage = p.getErrorMsg();
                    return false;
                }
                if (!DialogArrayParameter.this.m_param.isMandatory() || !this.isCellEditable(0, this.COL_VALUE) || p.getDisplayValue() != null && (p.getDisplayValue() == null || p.getDisplayValue().length() != 0)) continue;
                this.m_lastErrorRow = i;
                this.m_lastErrorCol = this.COL_VALUE;
                this.m_lastErrorMessage = new ArrayList<String>();
                this.m_lastErrorMessage.add(CnfgResource.getMessage("Message.errorOnValidation.mandatory"));
                return false;
            }
            boolean isValid = DialogArrayParameter.this.m_param.validateValues(this.m_Parameters);
            if (!isValid) {
                this.m_lastErrorCol = this.COL_VALUE;
                this.m_lastErrorMessage = new ArrayList<String>();
                Object[] args = new Object[]{DialogArrayParameter.this.m_param.getLabel()};
                String sMessage = CnfgResource.getMessage("Message.errorOnValidation.globalparam.badvalue.resolution", args);
                this.m_lastErrorMessage.add(sMessage);
                return false;
            }
            return true;
        }

        @Override
        public int getColumnCount() {
            return 2 + (this.COL_NAME != -1 ? 1 : 0) + (this.COL_VALID != -1 ? 1 : 0);
        }

        @Override
        public int getRowCount() {
            return this.m_count;
        }

        public Object getItemRow(int row) {
            return this.m_Parameters.get(row);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == this.COL_SELECT || col == this.COL_VALID) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == this.COL_SELECT) {
                return true;
            }
            if (col == this.COL_VALID) {
                return false;
            }
            return this.m_bIsValueEditable;
        }

        public boolean isSelected() {
            for (int i = 0; i < this.m_count; ++i) {
                if (!this.m_select.get(i).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public int getSelectedRowCount() {
            int iSelectedRows = 0;
            for (int i = 0; i < this.m_count; ++i) {
                if (!this.m_select.get(i).booleanValue()) continue;
                ++iSelectedRows;
            }
            return iSelectedRows;
        }

        public void removeSelected() {
            for (int i = this.m_count - 1; i >= 0; --i) {
                if (!this.m_select.get(i).booleanValue()) continue;
                this.m_select.remove(i);
                --this.m_count;
                this.m_Parameters.remove(i);
                if (this.COL_VALID != -1) {
                    this.m_valid.remove(i);
                }
                this.fireTableRowsDeleted(i, i);
            }
        }

        public void removeAllEntires() {
            for (int i = this.m_count - 1; i >= 0; --i) {
                this.m_select.remove(i);
                --this.m_count;
                this.m_Parameters.remove(i);
                if (this.COL_VALID != -1) {
                    this.m_valid.remove(i);
                }
                this.fireTableRowsDeleted(i, i);
            }
        }

        public int getLastErrorRow() {
            return this.m_lastErrorRow;
        }

        public int getLastErrorCol() {
            return this.m_lastErrorCol;
        }

        public List<String> getLastErrorMessage() {
            return this.m_lastErrorMessage;
        }

        public String getErrorMessage() {
            return CnfgResource.getMessage("Message.errorOnValidation.info");
        }

        public int addEmpty() {
            Parameter p = DialogArrayParameter.this.m_param.createParamElement(DialogArrayParameter.this.m_param.getElemType());
            return this.addEmpty(p);
        }

        public int addEmpty(Parameter param) {
            this.m_select.add(new Boolean(false));
            if (this.COL_VALID != -1) {
                this.m_valid.add(new Boolean(true));
            }
            param.load(null, DialogArrayParameter.this.m_param.getMetaData());
            param.setEncrypted(DialogArrayParameter.this.m_param.isEncrypted());
            param.setFireValueChanged(false);
            this.m_Parameters.add(param);
            int rowIdx = this.m_count++;
            this.fireTableRowsInserted(rowIdx, rowIdx);
            return rowIdx;
        }

        private int add(Parameter param, boolean bMakeSelected) {
            this.m_select.add(new Boolean(bMakeSelected));
            if (this.COL_VALID != -1) {
                this.m_valid.add(new Boolean(!param.isBadValue()));
            }
            Parameter newParam = (Parameter)param.clone();
            newParam.setFireValueChanged(false);
            this.m_Parameters.add(newParam);
            ++this.m_count;
            this.fireTableRowsInserted(this.m_count - 1, this.m_count - 1);
            return this.m_count;
        }

        protected void loadCurrentValues() {
            if (DialogArrayParameter.this.m_param == null) {
                return;
            }
            int order = 0;
            for (Parameter p : DialogArrayParameter.this.m_param.getCurrentValues()) {
                Integer i = p.getOrder();
                if (i != null && i != order) {
                    p.setOrder(new Integer(order));
                    DialogArrayParameter.this.m_param.setDirtyFlag(true);
                }
                this.add(p, false);
                ++order;
            }
        }

        protected void loadAvailableValues() {
            if (DialogArrayParameter.this.m_param == null) {
                return;
            }
            int order = 0;
            for (Parameter p : DialogArrayParameter.this.m_param.getAvailableValues()) {
                Integer i = p.getOrder();
                if (i != null && i != order) {
                    p.setOrder(new Integer(order));
                    DialogArrayParameter.this.m_param.setDirtyFlag(true);
                }
                this.add(p, false);
                ++order;
            }
        }
    }

    private class RendererCustomizeColumn
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Icon[] m_images;

        public RendererCustomizeColumn() {
            if (this.m_images == null) {
                this.m_images = new Icon[2];
                this.m_images[0] = CnfgImageLoader.loadIcon("mnu_null.gif");
                this.m_images[1] = CnfgImageLoader.loadIcon("parameter_error.gif");
            }
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null && value.getClass() == Boolean.class && !((Boolean)value).booleanValue()) {
                this.setIcon(this.m_images[1]);
                arrayParamTableModel model = (arrayParamTableModel)table.getModel();
                this.setToolTipText(model.getErrorMessage());
            } else {
                this.setIcon(this.m_images[0]);
            }
            if (isSelected) {
                if (table.hasFocus()) {
                    this.setBackground(SystemColor.textHighlight);
                    this.setForeground(SystemColor.textHighlightText);
                } else {
                    this.setBackground(SystemColor.control);
                    this.setForeground(SystemColor.controlText);
                }
            } else if (CnfgUtils.isWindowsPlatform()) {
                this.setBackground(SystemColor.window);
                this.setForeground(SystemColor.windowText);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    public class FilteredAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        Action myaction;
        emTable mytable;

        public FilteredAction(emTable comp, Action action) {
            this.mytable = comp;
            this.myaction = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mytable.isEditing()) {
                this.myaction.actionPerformed(e);
            } else {
                DialogArrayParameter.this.terminate();
            }
        }
    }
}

