/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.DialogArrayParameter;
import com.cognos.crconfig.DialogRetrieveConfiguration;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.ConfigServersArrayParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Parameter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import java.util.Set;

public class DialogConfigServersParameter
extends DialogArrayParameter
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private CnfgButton m_buttonRetrieve;
    private CnfgButton m_buttonResetToDefault;
    private String m_username;
    private String m_password;
    private String m_namespaceID;
    private String m_remoteURL;

    public DialogConfigServersParameter(Dialog owner, String sDialogTitle, ArrayParameter param) {
        super(owner, sDialogTitle, param);
        this.initialize();
    }

    public DialogConfigServersParameter(Frame owner, String sDialogTitle, ArrayParameter param) {
        super(owner, sDialogTitle, param);
        this.initialize();
    }

    public DialogConfigServersParameter() {
    }

    private void initialize() {
        DataManager dm = DataManager.getInstance();
        Parameter userP = dm.findParm("retrieveConfigUser");
        this.m_username = userP != null ? (String)userP.getValue() : "";
        Parameter pwdP = dm.findParm("retrieveConfigPassword");
        this.m_password = pwdP != null ? (String)pwdP.getValue() : "";
        Parameter nsP = dm.findParm("retrieveConfigNamespaceID");
        this.m_namespaceID = nsP != null ? (String)nsP.getValue() : "CognosEx";
        this.m_remoteURL = this.getPortalURIViaCMURI();
    }

    public void setRetrieveInfo() {
        Parameter nsP;
        Parameter pwdP;
        DataManager dm = DataManager.getInstance();
        Parameter userP = dm.findParm("retrieveConfigUser");
        if (userP != null) {
            userP.setValue(this.m_username);
        }
        if ((pwdP = dm.findParm("retrieveConfigPassword")) != null) {
            pwdP.setValue(this.m_password);
        }
        if ((nsP = dm.findParm("retrieveConfigNamespaceID")) != null) {
            nsP.setValue(this.m_namespaceID);
        }
    }

    public String getPortalURIViaCMURI() {
        Parameter cmsParm = DataManager.getInstance().findParm("contentManagers");
        if (cmsParm != null) {
            ArrayParameter arrayParm = (ArrayParameter)cmsParm;
            Set<Parameter> values = arrayParm.getCurrentValues();
            for (Parameter parm : values) {
                String hostport;
                String value = (String)parm.getValue();
                if (value == null || value.length() <= 0 || (hostport = this.getHostPortFromURL(value)) == null || hostport.length() == 0) continue;
                return hostport + "/bi";
            }
        }
        return "";
    }

    protected String getHostPortFromURL(String url) {
        int nextIdx = url.indexOf("://");
        if (nextIdx == -1) {
            return null;
        }
        int slashIdx = url.indexOf("/", nextIdx += 3);
        if (slashIdx == -1) {
            return null;
        }
        return url.substring(0, slashIdx);
    }

    @Override
    public void initCustomizedItems() {
        this.m_buttonRetrieve = new CnfgButton(CnfgResource.getMessage("Label.DialogConfigServersParameter.Button.Retrieve"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
        this.m_buttonRetrieve.setEnabled(true);
        this.m_buttonRetrieve.addActionListener(this);
        this.m_buttonResetToDefault = new CnfgButton(CnfgResource.getMessage("Menu.edit.resetToDefault"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
        this.m_buttonResetToDefault.setEnabled(true);
        this.m_buttonResetToDefault.addActionListener(this);
        this.m_addtionalUIItems = new Component[2];
        this.m_addtionalUIItems[0] = this.m_buttonRetrieve;
        this.m_addtionalUIItems[1] = this.m_buttonResetToDefault;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_buttonRetrieve) {
            this.action_retrieve();
        } else if (e.getSource() == this.m_buttonResetToDefault) {
            this.action_resetToDefault();
        } else {
            super.actionPerformed(e);
        }
    }

    private void action_resetToDefault() {
        ConfigServersArrayParameter configSvrP = (ConfigServersArrayParameter)this.m_param;
        this.setValues(configSvrP.getDefaultValue());
    }

    private void action_retrieve() {
        String sTitle = CnfgResource.getMessage("Label.DialogRetrieveConfiguration.title");
        DialogRetrieveConfiguration dlg = new DialogRetrieveConfiguration(this, sTitle, this.m_username, this.m_password, this.m_namespaceID, this.m_remoteURL);
        if (dlg.isOk()) {
            Properties res = dlg.getConfigProps();
            this.setValues(res);
            this.m_username = dlg.getUserName();
            this.m_password = dlg.getPassword();
            this.m_namespaceID = dlg.getNamespaceID();
            this.m_remoteURL = dlg.getURL();
            this.requestFocus();
        }
    }

    private void setValues(Object value) {
        if (value == null) {
            return;
        }
        Properties values = new Properties();
        values.setProperty("zkserver.1", (String)value);
        this.setValues(values);
    }

    private void setValues(Properties values) {
        this.m_outputTableModel.removeAllEntires();
        for (String name : values.stringPropertyNames()) {
            String value;
            if (!name.startsWith("zkserver.") || (value = values.getProperty(name)) == null || value.length() <= 0) continue;
            int newRow = this.m_outputTableModel.addEmpty();
            this.m_outputTableModel.setValueAt(value, newRow, this.m_outputTableModel.COL_VALUE);
        }
        this.m_param.setDirtyFlag(true);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isFirstInstallSelected = e.getStateChange() == 1;
        this.m_buttonRetrieve.setEnabled(!isFirstInstallSelected);
        this.m_buttonAdd.setEnabled(!isFirstInstallSelected);
        this.m_buttonRemove.setEnabled(!isFirstInstallSelected);
    }
}

