/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgComboBox;
import com.cognos.crconfig.CnfgField;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgLabel;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.data.CnfgNodeInsertedEvent;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Option;
import com.cognos.crconfig.data.TemplatedParameter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;

public class DialogCreateNew
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 651575114186132224L;
    private String m_instanceName;
    private JPanel m_panel;
    private CnfgField m_fieldInstanceName;
    private CnfgComboBox m_instanceType;
    private CnfgButton m_buttonOK;
    private CnfgButton m_buttonCancel;
    private TemplatedParameter m_tp;
    private DefaultMutableTreeNode m_treeNode;
    private CnfgComboBox m_instanceSubType;

    public DialogCreateNew(CRConfigFrame parent, String instanceName, TemplatedParameter tp, DefaultMutableTreeNode treeNode, String title) {
        super(parent, title, true);
        this.m_instanceName = instanceName;
        this.m_tp = tp;
        this.m_treeNode = treeNode;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Insets ins1 = new Insets(10, 10, 0, 10);
        Insets ins2 = new Insets(2, 10, 0, 10);
        this.setResizable(false);
        this.m_panel = new JPanel();
        this.getContentPane().add((Component)this.m_panel, "Center");
        this.m_panel.setLayout(gridbag);
        c.fill = 0;
        c.anchor = 18;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = ins1;
        this.m_panel.registerKeyboardAction(new DialogCreateNewCancelListener(), KeyStroke.getKeyStroke(27, 0), 1);
        this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(115, 8), 1);
        this.m_fieldInstanceName = new CnfgField(1, 1, 300, instanceName, false);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 8;
        c.insets = ins2;
        c.fill = 2;
        gridbag.setConstraints(this.m_fieldInstanceName, c);
        this.m_panel.add(this.m_fieldInstanceName);
        c.gridwidth = 1;
        c.fill = 0;
        CnfgLabel xcLabelInstanceName = new CnfgLabel(300, CnfgResource.getMessage("Label.DialogCreateNew.name"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex(), this.m_fieldInstanceName);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 8;
        c.insets = ins1;
        c.fill = 2;
        gridbag.setConstraints(xcLabelInstanceName, c);
        this.m_panel.add(xcLabelInstanceName);
        c.gridwidth = 1;
        c.fill = 0;
        this.m_instanceType = new CnfgComboBox(){
            private static final long serialVersionUID = -4809870746181792194L;
            Dimension d = new Dimension(230, CnfgFontSetting.controlHeight + 1);

            @Override
            public Dimension getPreferredSize() {
                return this.d;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.d;
            }
        };
        this.m_instanceType.setEditable(false);
        this.m_instanceType.initUIandEditor();
        this.m_instanceType.setMaximumRowCount(10);
        boolean bRenderSubTypeComboBox = this.loadChoiceItems();
        int itemCount = this.m_instanceType.getItemCount();
        if (itemCount <= 1) {
            this.m_instanceType.setEnabled(false);
        }
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 6;
        c.insets = ins2;
        c.fill = 2;
        gridbag.setConstraints(this.m_instanceType, c);
        this.m_panel.add(this.m_instanceType);
        c.gridwidth = 1;
        c.fill = 0;
        CnfgLabel xcLabelTemplateType = new CnfgLabel(300, CnfgResource.getMessage("Label.DialogCreateNew.type"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex(), this.m_instanceType);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 8;
        c.insets = ins1;
        c.fill = 2;
        gridbag.setConstraints(xcLabelTemplateType, c);
        this.m_panel.add(xcLabelTemplateType);
        c.gridwidth = 1;
        c.fill = 0;
        int gridy_idx = 5;
        if (bRenderSubTypeComboBox) {
            this.m_instanceType.addItemListener(this);
            this.createInstanceSubTypeComboBox();
            c.gridx = 1;
            c.gridy = gridy_idx + 1;
            c.gridwidth = 6;
            c.insets = ins2;
            c.fill = 2;
            gridbag.setConstraints(this.m_instanceSubType, c);
            this.m_panel.add(this.m_instanceSubType);
            c.gridwidth = 1;
            c.fill = 0;
            CnfgLabel xcLabelTemplateSubType = new CnfgLabel(300, CnfgResource.getMessage("Label.DialogCreateNew.subtype"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex(), this.m_instanceSubType);
            c.gridx = 1;
            c.gridy = gridy_idx;
            c.gridwidth = 8;
            c.insets = ins1;
            c.fill = 2;
            gridbag.setConstraints(xcLabelTemplateSubType, c);
            this.m_panel.add(xcLabelTemplateSubType);
            c.gridwidth = 1;
            c.fill = 0;
            gridy_idx += 2;
        }
        Box p2 = new Box(0);
        c.gridx = 1;
        c.gridy = gridy_idx;
        c.gridwidth = 8;
        c.insets = new Insets(20, 10, 6, 10);
        c.anchor = 11;
        gridbag.setConstraints(p2, c);
        this.m_panel.add(p2);
        this.m_buttonOK = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
        this.getRootPane().setDefaultButton(this.m_buttonOK);
        p2.add(Box.createGlue());
        p2.add(this.m_buttonOK);
        p2.add(Box.createHorizontalStrut(6));
        this.m_buttonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
        p2.add(this.m_buttonCancel);
        p2.add(Box.createHorizontalStrut(6));
        this.m_buttonOK.addActionListener(this);
        this.m_buttonCancel.addActionListener(this);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogCreateNew.this.Terminate();
            }
        };
        this.addWindowListener(l);
        CnfgUtils.pack(this);
        this.setLocationRelativeTo(parent);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DialogCreateNew.this.m_fieldInstanceName.requestFocus();
            }
        });
    }

    private boolean loadChoiceItems() {
        boolean hasGrpOption = false;
        List<Option> al = this.m_tp.getAvailableOptions(true);
        Collator collator = Collator.getInstance();
        TreeMap<CollationKey, Option> sortedMap = new TreeMap<CollationKey, Option>();
        for (Option option : al) {
            CollationKey key;
            if (option == null || (key = collator.getCollationKey(option.toString())) == null) continue;
            sortedMap.put(key, option);
        }
        ArrayList<String> groupList = new ArrayList<String>();
        for (Option opt : sortedMap.values()) {
            if (opt == null) continue;
            String groupName = opt.getGroupName();
            if (groupName != null) {
                if (!groupList.contains(groupName)) {
                    Option groupOpt = new Option();
                    groupOpt.setGroupOption(true);
                    groupOpt.setLabel(opt.getGroupLabel());
                    groupOpt.setName(groupName);
                    groupList.add(groupName);
                    this.m_instanceType.addItem(groupOpt);
                }
                hasGrpOption = true;
                continue;
            }
            this.m_instanceType.addItem(opt);
        }
        return hasGrpOption;
    }

    private void createInstanceSubTypeComboBox() {
        this.m_instanceSubType = new CnfgComboBox(){
            private static final long serialVersionUID = -4809870746181792194L;
            Dimension d = new Dimension(230, CnfgFontSetting.controlHeight + 1);

            @Override
            public Dimension getPreferredSize() {
                return this.d;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.d;
            }
        };
        this.m_instanceSubType.setEditable(false);
        this.m_instanceSubType.initUIandEditor();
        this.m_instanceSubType.setMaximumRowCount(10);
        Option firstOption = (Option)this.m_instanceType.getItemAt(0);
        this.loadChoiceItemsForSubType(firstOption);
    }

    private void loadChoiceItemsForSubType(Option grpOption) {
        int itemCount;
        this.m_instanceSubType.removeAllItems();
        if (grpOption != null && grpOption.isGroupOption()) {
            String grpName = grpOption.getName();
            List<Option> al = this.m_tp.getAvailableOptions(true);
            Collator collator = Collator.getInstance();
            TreeMap<CollationKey, Option> sortedMap = new TreeMap<CollationKey, Option>();
            for (Option option : al) {
                CollationKey key;
                if (option == null || option.getGroupName() == null || !option.getGroupName().equals(grpName) || !option.isOptionVisible() || (key = collator.getCollationKey(option.toString())) == null) continue;
                sortedMap.put(key, option);
            }
            for (Option opt : sortedMap.values()) {
                if (opt == null) continue;
                this.m_instanceSubType.addItem(opt);
            }
        }
        if ((itemCount = this.m_instanceSubType.getItemCount()) < 1) {
            this.m_instanceSubType.setEnabled(false);
        } else {
            this.m_instanceSubType.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getRootPane()) {
            this.Terminate();
        } else if (e.getSource() == this.m_buttonOK) {
            this.Action_OK();
        } else if (e.getSource() == this.m_buttonCancel) {
            this.Terminate();
        }
    }

    private void Action_OK() {
        this.m_instanceName = this.m_fieldInstanceName.getText();
        Option option = (Option)this.m_instanceType.getSelectedItem();
        if (this.m_instanceName.length() != 0 && option != null) {
            Folder f;
            if (option.isGroupOption()) {
                Option subTypeOption = (Option)this.m_instanceSubType.getSelectedItem();
                if (subTypeOption != null) {
                    option = subTypeOption;
                } else {
                    Object[] arrayOfObjects = new Object[]{CnfgResource.getMessage("Message.errorOnNew.noname.resolution")};
                    DialogMessage.showDialog(arrayOfObjects, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_NOARGS, 0);
                    this.m_instanceSubType.requestFocus();
                    return;
                }
            }
            if (null != (f = this.m_tp.getParent().findFolder(this.m_instanceName, false)) && !f.getDisabled() && f.getVisibility()) {
                Object[] arrayOfObjects = new Object[]{CnfgResource.getMessage("Message.errorOnNew.namedup.notification"), CnfgResource.getMessage("Message.errorOnNew.namedup.resolution")};
                DialogMessage.showDialog(arrayOfObjects, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_NOARGS, 0);
                this.m_fieldInstanceName.requestFocus();
            } else {
                if (null != f && (f.getDisabled() || !f.getVisibility())) {
                    f.setName(this.generateUniqueName(f));
                }
                Folder currentFolder = (Folder)this.m_treeNode.getUserObject();
                Folder newFolder = currentFolder.addInstanceFolder(this.m_tp, option.getName(), this.m_instanceName, this.m_instanceName);
                CnfgNodeInsertedEvent e = new CnfgNodeInsertedEvent(newFolder, this.m_treeNode);
                DataManager.getInstance().fireNodeInserted(e);
                this.Terminate();
            }
        } else {
            Object[] arrayOfObjects = new Object[]{CnfgResource.getMessage("Message.errorOnNew.noname.resolution")};
            DialogMessage.showDialog(arrayOfObjects, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_NOARGS, 0);
            this.m_fieldInstanceName.requestFocus();
        }
    }

    private String generateUniqueName(Folder folder) {
        StringBuffer result = new StringBuffer(folder.getName());
        int i = 2;
        while (true) {
            result.append(" (");
            result.append(i);
            result.append(")");
            if (null == folder.getParent().findFolder(result.toString(), false)) break;
            ++i;
            int start = -1;
            for (int pos = result.length(); 0 <= pos; --pos) {
                if ('(' != result.charAt(pos)) continue;
                start = pos;
                break;
            }
            if (-1 != start) {
                result.delete(start, result.length());
                continue;
            }
            result.delete(0, result.length());
            result.append(folder.getName());
        }
        return result.toString();
    }

    public void Terminate() {
        this.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.m_instanceType) {
            Option option = (Option)this.m_instanceType.getSelectedItem();
            this.loadChoiceItemsForSubType(option);
        }
    }

    class DialogCreateNewCancelListener
    implements ActionListener {
        DialogCreateNewCancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DialogCreateNew.this.m_panel) {
                DialogCreateNew.this.Terminate();
            }
        }
    }
}

