/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class DialogFontChooser
extends JDialog {
    private static final String cBOLD = CnfgResource.getMessage("Label.DialogFontChooser.FontBold");
    private static final String cPLAIN = CnfgResource.getMessage("Label.DialogFontChooser.FontPlain");
    private static final String cITALIC = CnfgResource.getMessage("Label.DialogFontChooser.FontItalic");
    protected static final int nSTYLE = 3;
    protected static final int nSIZE = 13;
    private boolean m_selectionOk;
    private static int m_nameIdx = -1;
    private static int m_styleIdx = -1;
    private static int m_sizeIdx = -1;
    private static String m_defaultName;
    private static String m_defaultStyle;
    private static Integer m_defaultSize;
    private static HashMap m_fontMap;
    private static String m_fontDir;
    private static Vector m_names;
    private static String[] m_styles;
    private static Integer[] m_sizes;
    private static boolean m_windows;
    private CnfgButton m_buttonCancel;
    private CnfgButton m_buttonOK;
    private JPanel m_bottomPanel;
    private JPanel m_topPanel;
    private static JList m_listFontStyle;
    private static JList m_listFontName;
    private static JList m_listFontSize;
    private JScrollPane m_scrollPaneSize;
    private JScrollPane m_scrollPaneStyle;
    private JScrollPane m_scrollPaneName;
    private JLabel m_labelFontStyle;
    private JLabel m_labelFontName;
    private JLabel m_labelFontSize;
    private JPanel m_panelFontSize;
    private JPanel m_panelFontStyle;
    private JPanel m_panelFontName;

    private void setFont(Container container, Font font) {
        Component[] components = container.getComponents();
        for (int idx = 0; idx < components.length; ++idx) {
            components[idx].setFont(font);
            if (!(components[idx] instanceof Container)) continue;
            this.setFont((Container)components[idx], font);
        }
    }

    private static void loadFontData() {
        int idx;
        String name;
        boolean foundDefault;
        Vector<String> fontNames;
        block16: {
            fontNames = new Vector<String>();
            foundDefault = false;
            Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            for (int idx2 = 0; idx2 < fonts.length; ++idx2) {
                name = fonts[idx2].getFontName();
                m_fontMap.put(name, fonts[idx2]);
                fontNames.addElement(name);
                if (!name.equalsIgnoreCase(m_defaultName)) continue;
                foundDefault = true;
            }
            if (m_fontDir.length() > 0) {
                try {
                    File userFonts = new File(m_fontDir);
                    String[] fontnames = userFonts.list();
                    for (int idx3 = 0; idx3 < fontnames.length; ++idx3) {
                        try {
                            File file;
                            Font font;
                            String fontname = fontnames[idx3];
                            if (!fontname.endsWith(".ttf") || m_fontMap.get(name = (font = Font.createFont(0, file = new File(m_fontDir + "/" + fontname))).getFontName()) != null) continue;
                            m_fontMap.put(name, font);
                            fontNames.addElement(name);
                            if (!name.equalsIgnoreCase(m_defaultName)) continue;
                            foundDefault = true;
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            CnfgLog.error(e.getMessage());
                            continue;
                        }
                        catch (FontFormatException e) {
                            CnfgLog.error(e.getMessage());
                            continue;
                        }
                        catch (IOException e) {
                            CnfgLog.error(e.getMessage());
                            continue;
                        }
                        catch (Exception e) {
                            if (!CnfgLog.isDebugEnabled()) continue;
                            CnfgLog.debug(e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    if (!CnfgLog.isDebugEnabled()) break block16;
                    CnfgLog.debug(e.getMessage());
                }
            }
        }
        Object[] nameList = fontNames.toArray();
        Collator collator = Collator.getInstance(CnfgResource.getLocale());
        collator.setStrength(2);
        TreeMap<CollationKey, String> sortedMap = new TreeMap<CollationKey, String>();
        for (int i = 0; i < nameList.length; ++i) {
            CollationKey key = collator.getCollationKey((String)nameList[i]);
            sortedMap.put(key, (String)nameList[i]);
        }
        Iterator it = sortedMap.values().iterator();
        nameList = new Object[sortedMap.size()];
        if (!foundDefault) {
            m_defaultName = new Font(null).getFamily();
        }
        int index = 0;
        while (it.hasNext()) {
            name = (String)it.next();
            if (name.equalsIgnoreCase(m_defaultName) || name.equalsIgnoreCase(m_defaultName + ".plain")) {
                m_nameIdx = index;
            }
            m_names.addElement(name);
            ++index;
        }
        DialogFontChooser.m_styles[0] = cPLAIN;
        DialogFontChooser.m_styles[1] = cBOLD;
        DialogFontChooser.m_styles[2] = cITALIC;
        for (idx = 0; idx < 3; ++idx) {
            if (!m_styles[idx].equals(m_defaultStyle)) continue;
            m_styleIdx = idx;
            break;
        }
        DialogFontChooser.m_sizes[0] = new Integer("8");
        DialogFontChooser.m_sizes[1] = new Integer("9");
        DialogFontChooser.m_sizes[2] = new Integer("10");
        DialogFontChooser.m_sizes[3] = new Integer("11");
        DialogFontChooser.m_sizes[4] = new Integer("12");
        DialogFontChooser.m_sizes[5] = new Integer("14");
        DialogFontChooser.m_sizes[6] = new Integer("16");
        DialogFontChooser.m_sizes[7] = new Integer("18");
        DialogFontChooser.m_sizes[8] = new Integer("20");
        DialogFontChooser.m_sizes[9] = new Integer("22");
        DialogFontChooser.m_sizes[10] = new Integer("24");
        DialogFontChooser.m_sizes[11] = new Integer("26");
        DialogFontChooser.m_sizes[12] = new Integer("28");
        for (idx = 0; idx < 13; ++idx) {
            if (!m_sizes[idx].equals(m_defaultSize)) continue;
            m_sizeIdx = idx;
            break;
        }
        m_listFontName.setListData(m_names);
        m_listFontStyle.setListData(m_styles);
        m_listFontSize.setListData(m_sizes);
        m_listFontName.setSelectedIndex(m_nameIdx);
        m_listFontStyle.setSelectedIndex(m_styleIdx);
        m_listFontSize.setSelectedIndex(m_sizeIdx);
    }

    public DialogFontChooser(Frame parent, String fontDir, String fontname, String fontstyle, int fontsize) {
        super(parent, true);
        m_fontDir = fontDir;
        m_defaultName = fontname;
        m_defaultStyle = fontstyle;
        m_defaultSize = new Integer(fontsize);
        this.initComponents();
    }

    @Override
    public void setFont(Font font) {
        this.setFont(this, font);
        super.setFont(font);
        CnfgUtils.pack(this);
    }

    private void initComponents() {
        this.m_topPanel = new JPanel();
        this.m_panelFontName = new JPanel();
        this.m_labelFontName = new JLabel();
        this.m_scrollPaneName = new JScrollPane();
        m_listFontName = new JList();
        this.m_panelFontStyle = new JPanel();
        this.m_labelFontStyle = new JLabel();
        this.m_scrollPaneStyle = new JScrollPane();
        m_listFontStyle = new JList();
        this.m_panelFontSize = new JPanel();
        this.m_labelFontSize = new JLabel();
        this.m_scrollPaneSize = new JScrollPane();
        m_listFontSize = new JList();
        this.m_bottomPanel = new JPanel();
        this.m_buttonOK = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
        this.m_buttonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
        this.setTitle(CnfgResource.getMessage("Title.DialogFontChooser"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                if (!DialogFontChooser.this.m_buttonOK.hasFocus()) {
                    DialogFontChooser.this.m_buttonOK.grabFocus();
                }
            }
        });
        this.m_panelFontName.setLayout(new BorderLayout());
        this.m_labelFontName.setText(CnfgResource.getMessage("Label.DialogFontChooser.Name"));
        this.m_panelFontName.add((Component)this.m_labelFontName, "North");
        this.m_scrollPaneName.setViewportView(m_listFontName);
        this.m_panelFontName.add((Component)this.m_scrollPaneName, "South");
        this.m_topPanel.add(this.m_panelFontName);
        this.m_panelFontStyle.setLayout(new BorderLayout());
        this.m_labelFontStyle.setText(CnfgResource.getMessage("Label.DialogFontChooser.Style"));
        this.m_panelFontStyle.add((Component)this.m_labelFontStyle, "North");
        this.m_scrollPaneStyle.setViewportView(m_listFontStyle);
        this.m_panelFontStyle.add((Component)this.m_scrollPaneStyle, "South");
        this.m_topPanel.add(this.m_panelFontStyle);
        this.m_panelFontSize.setLayout(new BorderLayout());
        this.m_labelFontSize.setText(CnfgResource.getMessage("Label.DialogFontChooser.Size"));
        this.m_panelFontSize.add((Component)this.m_labelFontSize, "North");
        this.m_scrollPaneSize.setViewportView(m_listFontSize);
        this.m_panelFontSize.add((Component)this.m_scrollPaneSize, "South");
        this.m_topPanel.add(this.m_panelFontSize);
        MouseAdapter mAdapt = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DialogFontChooser.this.getRootPane().getDefaultButton() == null || !DialogFontChooser.this.getRootPane().getDefaultButton().equals(DialogFontChooser.this.m_buttonOK)) {
                    DialogFontChooser.this.getRootPane().setDefaultButton(DialogFontChooser.this.m_buttonOK);
                    if (!m_windows) {
                        DialogFontChooser.this.getContentPane().repaint();
                    }
                }
            }
        };
        m_listFontName.addMouseListener(mAdapt);
        m_listFontStyle.addMouseListener(mAdapt);
        m_listFontSize.addMouseListener(mAdapt);
        this.m_buttonCancel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (DialogFontChooser.this.getRootPane().getDefaultButton() == null || !DialogFontChooser.this.getRootPane().getDefaultButton().equals(DialogFontChooser.this.m_buttonCancel)) {
                    DialogFontChooser.this.getRootPane().setDefaultButton(DialogFontChooser.this.m_buttonCancel);
                    if (!m_windows) {
                        DialogFontChooser.this.getContentPane().repaint();
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (DialogFontChooser.this.getRootPane().getDefaultButton() == null || DialogFontChooser.this.getRootPane().getDefaultButton().equals(DialogFontChooser.this.m_buttonCancel)) {
                    DialogFontChooser.this.getRootPane().setDefaultButton(DialogFontChooser.this.m_buttonOK);
                    if (!m_windows) {
                        DialogFontChooser.this.getContentPane().repaint();
                    }
                }
            }
        });
        if (!CnfgUtils.isWindowsPlatform()) {
            this.getRootPane().setDefaultButton(this.m_buttonOK);
            this.m_buttonOK.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (DialogFontChooser.this.getRootPane().getDefaultButton() == null || !DialogFontChooser.this.getRootPane().getDefaultButton().equals(DialogFontChooser.this.m_buttonOK)) {
                        DialogFontChooser.this.getRootPane().setDefaultButton(DialogFontChooser.this.m_buttonOK);
                        DialogFontChooser.this.getContentPane().repaint();
                    }
                }
            });
        }
        DialogFontChooser.loadFontData();
        this.m_buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFontChooser.this.actionPerformedOK(evt);
            }
        });
        this.m_bottomPanel.add(this.m_buttonOK);
        this.m_buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFontChooser.this.actionPerformedCancel(evt);
            }
        });
        this.m_bottomPanel.add(this.m_buttonCancel);
        this.getContentPane().add((Component)this.m_bottomPanel, "South");
        this.getContentPane().add((Component)this.m_topPanel, "North");
        CnfgUtils.pack(this);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void actionPerformedOK(ActionEvent evt) {
        this.m_selectionOk = true;
        this.setVisible(false);
        this.dispose();
    }

    private void actionPerformedCancel(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public String getFontName() {
        return m_defaultName;
    }

    public String getFontStyle() {
        return m_defaultStyle;
    }

    public String getFontSize() {
        return m_defaultSize.toString();
    }

    public void setFontName(String sName) {
        if (sName != null) {
            for (int idx = 0; idx < m_names.size(); ++idx) {
                String name = (String)m_names.get(idx);
                if (!name.equalsIgnoreCase(sName)) continue;
                m_nameIdx = idx;
                m_defaultName = sName;
                m_listFontName.setSelectedIndex(m_nameIdx);
                break;
            }
        }
    }

    public void setFontStyle(String sStyle) {
        if (sStyle != null) {
            for (int idx = 0; idx < 3; ++idx) {
                if (!m_styles[idx].equals(sStyle)) continue;
                m_styleIdx = idx;
                m_defaultStyle = sStyle;
                m_listFontStyle.setSelectedIndex(m_styleIdx);
                break;
            }
        }
    }

    public void setFontSize(String sSize) {
        if (sSize != null) {
            Integer iSize = new Integer(sSize);
            for (int idx = 0; idx < 13; ++idx) {
                if (!m_sizes[idx].equals(iSize)) continue;
                m_sizeIdx = idx;
                m_defaultSize = iSize;
                m_listFontSize.setSelectedIndex(m_sizeIdx);
                break;
            }
        }
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogFontChooser.this.dispose();
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    public static Font getFont(String name) {
        if (name != null) {
            Font f = (Font)m_fontMap.get(name);
            return f;
        }
        return null;
    }

    public boolean showDialog() {
        this.m_selectionOk = false;
        m_listFontName.setSelectedIndex(m_nameIdx);
        m_listFontStyle.setSelectedIndex(m_styleIdx);
        m_listFontSize.setSelectedIndex(m_sizeIdx);
        m_listFontName.ensureIndexIsVisible(m_nameIdx);
        m_listFontStyle.ensureIndexIsVisible(m_styleIdx);
        m_listFontSize.ensureIndexIsVisible(m_sizeIdx);
        CnfgUtils.pack(this);
        this.show();
        return this.m_selectionOk;
    }

    public Font getSelectedFont() {
        m_nameIdx = m_listFontName.getSelectedIndex();
        m_styleIdx = m_listFontStyle.getSelectedIndex();
        m_sizeIdx = m_listFontSize.getSelectedIndex();
        m_defaultName = (String)m_names.elementAt(m_nameIdx);
        m_defaultStyle = m_styles[m_styleIdx];
        int style = m_defaultStyle.equals(cBOLD) ? 1 : (m_defaultStyle.equals(cITALIC) ? 2 : 0);
        m_defaultSize = m_sizes[m_sizeIdx];
        Integer trueFontSize = new Integer(CnfgFontSetting.getTrueFontSize(m_sizes[m_sizeIdx]));
        return ((Font)m_fontMap.get(m_defaultName)).deriveFont(style, trueFontSize.floatValue());
    }

    static {
        m_fontMap = new HashMap();
        m_fontDir = new String();
        m_names = new Vector();
        m_styles = new String[3];
        m_sizes = new Integer[13];
        m_windows = CnfgUtils.isWindowsPlatform();
    }
}

