/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.DialogMessage;
import com.cognos.i18n.ui.I18NTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class DialogHelpBrowser
extends JDialog
implements ActionListener {
    private JScrollPane m_cPane;
    private I18NTextArea m_cTextArea;
    protected CnfgButton m_cButtonOk;
    private static HashMap m_helpMap = new HashMap();

    public DialogHelpBrowser(String helpPath, String helpHeading) {
        super(CRConfigFrame.getInstance(), CnfgResource.getMessage("Title.DialogHelp"), true);
        String displayText = this.getDisplayText(helpPath, helpHeading);
        this.initUI(displayText, null);
    }

    public DialogHelpBrowser(String displayText, Dimension prefSize) {
        super(CRConfigFrame.getInstance(), CnfgResource.getMessage("Title.DialogHelp"), true);
        this.initUI(displayText, prefSize);
    }

    public DialogHelpBrowser(String title, String displayText, Dimension prefSize) {
        super(CRConfigFrame.getInstance(), title, true);
        this.initUI(displayText, prefSize);
    }

    public DialogHelpBrowser(String displayText) {
        super(CRConfigFrame.getInstance(), CnfgResource.getMessage("Title.DialogHelp"), true);
        this.initUI(displayText, null);
    }

    public void initUI(String displayText, Dimension prefSize) {
        this.setResizable(true);
        JPanel xcPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        this.m_cButtonOk = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(7, 0, 7, 0));
        bottomPanel.add(Box.createGlue());
        bottomPanel.add(this.m_cButtonOk);
        bottomPanel.add(Box.createHorizontalStrut(10));
        this.getRootPane().setDefaultButton(this.m_cButtonOk);
        this.m_cButtonOk.addActionListener(this);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        xcPanel.setLayout(gridbag);
        c.fill = 0;
        c.anchor = 18;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.m_cTextArea = new I18NTextArea(CnfgResource.getLocale());
        this.m_cTextArea.setLineWrap(true);
        this.m_cTextArea.setWrapStyleWord(true);
        this.m_cTextArea.setMargin(new Insets(2, 2, 2, 2));
        this.m_cTextArea.setEditable(false);
        this.m_cTextArea.append(displayText);
        final Dimension pf = prefSize;
        this.m_cPane = new JScrollPane((Component)this.m_cTextArea){
            final Dimension m_pf;
            {
                super(x0);
                this.m_pf = pf;
            }

            @Override
            public Dimension getPreferredSize() {
                if (this.m_pf == null) {
                    return new Dimension(400, 410);
                }
                return this.m_pf;
            }
        };
        this.m_cPane.setHorizontalScrollBarPolicy(30);
        this.m_cPane.setVerticalScrollBarPolicy(20);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 10, 10, 10);
        c.fill = 1;
        gridbag.setConstraints(this.m_cPane, c);
        xcPanel.add(this.m_cPane);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.getContentPane().add((Component)xcPanel, "Center");
        this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(115, 8), 1);
        CnfgUtils.pack(this);
        this.setLocationRelativeTo(CRConfigFrame.getInstance());
        this.m_cTextArea.setCaretPosition(0);
    }

    @Override
    public void actionPerformed(ActionEvent xcEvent) {
        if (xcEvent.getSource() == this.getRootPane()) {
            this.dispose();
        }
        if (xcEvent.getSource() == this.m_cButtonOk) {
            this.dispose();
        }
    }

    private String getDisplayText(String helpPath, String helpHeading) {
        String helpString = (String)m_helpMap.get(helpPath + '[' + helpHeading + ']');
        if (helpString != null) {
            return helpString;
        }
        StringBuffer text = new StringBuffer();
        try {
            String sLine;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(helpPath), "UTF8"));
            boolean foundHelpText = false;
            while ((sLine = reader.readLine()) != null) {
                if (sLine.startsWith("[" + helpHeading + "]")) {
                    foundHelpText = true;
                    sLine = reader.readLine();
                    if (sLine != null && sLine.startsWith("help=")) {
                        text.append(sLine.substring(5, sLine.length())).append("\n");
                        continue;
                    }
                    if (sLine == null) continue;
                    text.append(sLine).append("\n");
                    continue;
                }
                if (foundHelpText && sLine.startsWith("[" + helpHeading.substring(0, helpHeading.length() - 1))) break;
                if (!foundHelpText) continue;
                text.append(sLine).append("\n");
            }
            reader.close();
        }
        catch (Exception e) {
            DialogMessage.showDialog(e.getMessage(), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(e);
                CnfgLog.debug("Can't load the help file '" + helpPath + "'.");
            }
            return "";
        }
        m_helpMap.put(helpPath + '[' + helpHeading + ']', text.toString());
        return text.toString();
    }
}

