/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.i18n.ui.I18NTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DialogJavaValidation
extends JDialog {
    private static String m_showDetailsCaption = CnfgResource.getMessage("Label.ButtonDetails");
    private static String m_hideDetailsCaption;
    private static char m_showDetailsAccel;
    private static int m_showDetailsAccelIndex;
    private static char m_hideDetailsAccel;
    private static int m_hideDetailsAccelIndex;
    protected I18NTextArea m_area;
    private JLabel m_icon;
    private JPanel m_detailsPanel;
    private I18NTextArea m_detailsView;
    private Component m_parent;
    private CnfgButton m_exitButton;
    private CnfgButton m_detailsButton;
    private boolean m_bCanContinue;
    private CnfgButton m_continueButton;
    private int m_iExitValue = -1;
    private static boolean m_detailsVisible;

    public DialogJavaValidation(Frame parent, String message, List lErrors, boolean bCanContinue) {
        super(parent, CnfgResource.getMessage("Application.title"), true);
        this.m_parent = parent;
        this.m_bCanContinue = bCanContinue;
        this.initFixedComponents(message, lErrors);
    }

    public void setIcon() {
        this.m_icon.setIcon(CnfgImageLoader.loadIcon("msg_error.gif"));
        this.repaint();
    }

    public CnfgButton getExitButton() {
        return this.m_exitButton;
    }

    @Override
    public void show() {
        CnfgUtils.pack(this);
        this.setLocationRelativeTo(this.m_parent);
        super.show();
    }

    private void setExitValue(int code) {
        this.m_iExitValue = code;
    }

    public int getExitValue() {
        return this.m_iExitValue;
    }

    private void initFixedComponents(String message, List lErrors) {
        this.m_icon = new JLabel();
        this.m_icon.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setIcon();
        this.m_icon.setSize(this.m_icon.getIcon().getIconHeight() + 2, this.m_icon.getIcon().getIconWidth() + 2);
        this.m_area = new I18NTextArea(CnfgResource.getLocale());
        EmptyBorder border = new EmptyBorder(2, 2, 2, 2);
        this.m_area.setBorder((Border)border);
        this.m_area.setBackground(UIManager.getColor("OptionPane.messageBackground"));
        this.m_area.setWrapStyleWord(true);
        this.m_area.setLineWrap(true);
        this.m_area.setEditable(false);
        this.m_area.setRequestFocusEnabled(false);
        JPanel messagePane = new JPanel();
        messagePane.add((Component)this.m_area, 0);
        messagePane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_area.append(message);
        int iFontSize = CnfgFontSetting.getCurrentFontSize();
        Rectangle2D rec = this.m_area.getFont().getStringBounds(message, new FontRenderContext(null, false, false));
        int widthChar = CnfgFontSetting.getMaxWidth(this.m_area.getFont());
        int width = (int)rec.getWidth() + widthChar;
        if (width < 200) {
            width = 200;
        } else if (width > 800) {
            width = iFontSize >= 26 ? 850 : 550;
        }
        this.m_area.setSize(width, 1000);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.m_icon, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)messagePane, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 10), 0, 0));
        this.m_exitButton = new CnfgButton(CnfgResource.getMessage("Label.ButtonExit"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
        this.m_exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogJavaValidation.this.setExitValue(1);
                DialogJavaValidation.this.terminate();
            }
        });
        if (this.m_bCanContinue) {
            this.m_continueButton = new CnfgButton(CnfgResource.getMessage("Label.ButtonRegenerate"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
            this.m_continueButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogJavaValidation.this.setExitValue(0);
                    DialogJavaValidation.this.terminate();
                }
            });
        }
        this.m_detailsButton = m_detailsVisible ? new CnfgButton(m_hideDetailsCaption, m_hideDetailsAccel, m_hideDetailsAccelIndex) : new CnfgButton(m_showDetailsCaption, m_showDetailsAccel, m_showDetailsAccelIndex);
        this.m_detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (m_detailsVisible) {
                    DialogJavaValidation.this.hideDetails();
                } else {
                    DialogJavaValidation.this.showDetails();
                }
            }
        });
        JPanel m_buttonPanel = new JPanel(new FlowLayout(2, 5, 0));
        m_buttonPanel.add(this.m_exitButton);
        if (this.m_bCanContinue) {
            m_buttonPanel.add(this.m_continueButton);
        }
        m_buttonPanel.add(this.m_detailsButton);
        this.getContentPane().add((Component)m_buttonPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 14, 2, new Insets(0, 5, 10, 5), 0, 0));
        this.m_detailsPanel = new JPanel(new BorderLayout());
        this.m_detailsPanel.setVisible(m_detailsVisible);
        this.m_detailsView = new I18NTextArea(8, 0, CnfgResource.getLocale());
        this.m_detailsView.setLineWrap(true);
        this.m_detailsView.setWrapStyleWord(true);
        this.m_detailsView.setEditable(false);
        JScrollPane detailsScrollPane = new JScrollPane((Component)this.m_detailsView);
        this.m_detailsPanel.add((Component)detailsScrollPane, "Center");
        if (lErrors != null) {
            for (int i = 0; i < lErrors.size(); ++i) {
                Object obj = lErrors.get(i);
                if (obj == null) continue;
                String s = (String)obj;
                this.m_detailsView.append("[" + CnfgResource.getMessage("Message.task.validate") + "] " + s.concat("\n"));
            }
        }
        this.getContentPane().add((Component)this.m_detailsPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.setResizable(false);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogJavaValidation.this.setExitValue(1);
                DialogJavaValidation.this.terminate();
            }
        };
        this.addWindowListener(l);
    }

    private void showDetails() {
        m_detailsVisible = true;
        this.m_detailsPanel.setVisible(true);
        this.m_detailsButton.setText(m_hideDetailsCaption);
        this.m_detailsButton.setMnemonic(m_hideDetailsAccel);
        this.m_detailsButton.setDisplayedMnemonicIndex(m_hideDetailsAccelIndex);
        CnfgUtils.pack(this);
        String osName = System.getProperty("os.name");
        if (osName.equalsIgnoreCase("SunOS") || osName.equalsIgnoreCase("HP-UX")) {
            Point p = this.getLocation();
            p.translate(0, 1);
            this.setLocation(p);
        }
    }

    private void hideDetails() {
        m_detailsVisible = false;
        this.m_detailsPanel.setVisible(false);
        this.m_detailsButton.setText(m_showDetailsCaption);
        this.m_detailsButton.setMnemonic(m_showDetailsAccel);
        this.m_detailsButton.setDisplayedMnemonicIndex(m_showDetailsAccelIndex);
        CnfgUtils.pack(this);
        String osName = System.getProperty("os.name");
        if (osName.equalsIgnoreCase("SunOS") || osName.equalsIgnoreCase("HP-UX")) {
            Point p = this.getLocation();
            p.translate(0, -1);
            this.setLocation(p);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = d.width < 500 ? 500 : d.width;
        return d;
    }

    private void terminate() {
        this.removeAll();
        this.dispose();
    }

    static {
        m_showDetailsAccel = CnfgResource.getLastAccelerator();
        m_showDetailsAccelIndex = CnfgResource.getLastAcceleratorIndex();
        m_hideDetailsCaption = CnfgResource.getMessage("Label.ButtonDetailsHide");
        m_hideDetailsAccel = CnfgResource.getLastAccelerator();
        m_hideDetailsAccelIndex = CnfgResource.getLastAcceleratorIndex();
    }
}

