/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.AliasRoot;
import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgTable;
import com.cognos.crconfig.CnfgTableModel;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.InformationPanel;
import com.cognos.crconfig.MappingBaseModel;
import com.cognos.crconfig.MenuToolbarLogicListener;
import com.cognos.crconfig.ResetToDefaultListener;
import com.cognos.crconfig.State;
import com.cognos.crconfig.data.CnfgActionTest;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.editors.EditorAliasRootURI;
import com.cognos.crconfig.editors.EditorBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.dom4j.Element;

public abstract class DialogMappingBase
extends JDialog
implements ActionListener,
TableModelListener {
    protected MappingBaseModel m_dataModel;
    protected CnfgButton m_buttonOK;
    protected CnfgButton m_buttonCancel;
    protected JTabbedPane m_tabPane;
    private CnfgButton[] m_buttonAdd;
    private CnfgButton[] m_buttonRemove;
    private CnfgButton[] m_buttonResetToDefault;
    private CnfgButton[] m_buttonTest;
    private emTable[] m_tPages;
    private CnfgTable[] m_tParamPages;

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogMappingBase.this.action_Cancel();
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    public DialogMappingBase(Frame owner, String title, boolean modal, MappingBaseModel dataModel) {
        super(owner, title, modal);
        this.m_dataModel = dataModel;
    }

    public DialogMappingBase(Dialog owner, String title, boolean modal, MappingBaseModel dataModel) {
        super(owner, title, modal);
        this.m_dataModel = dataModel;
    }

    protected MappingBaseModel.emTableModel getPageModel(int index) {
        return this.m_dataModel.m_tmPageModels[index];
    }

    protected CnfgTableModel getParamPageModel(int index) {
        return this.m_dataModel.m_tmParamPageModels[index];
    }

    public void setDirtyFlag(boolean bDirty) {
        this.m_dataModel.setDirtyFlag(bDirty);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getRootPane()) {
            this.action_Cancel();
        } else if (e.getSource() == this.m_buttonOK) {
            this.action_OK();
        } else if (e.getSource() == this.m_buttonCancel) {
            this.action_Cancel();
        } else {
            int i;
            for (i = 0; i < this.m_dataModel.getTabCount(); ++i) {
                if (e.getSource() == this.m_buttonAdd[i]) {
                    this.action_Add(i);
                    return;
                }
                if (e.getSource() != this.m_buttonRemove[i]) continue;
                this.action_Remove(i);
                return;
            }
            for (i = 0; i < this.m_dataModel.getParamTabCount(); ++i) {
                if (e.getSource() == this.m_buttonResetToDefault[i]) {
                    this.action_resetToDefault(this.m_buttonResetToDefault[i], i);
                    return;
                }
                if (e.getSource() != this.m_buttonTest[i]) continue;
                this.action_Test(this.m_buttonTest[i], i);
                return;
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        for (int i = 0; i < this.m_dataModel.getTabCount(); ++i) {
            if (e.getSource() != this.getPageModel(i)) continue;
            this.m_buttonRemove[i].setEnabled(this.getPageModel(i).isSelected());
        }
    }

    protected void setupDialogUI(Component parent) {
        int i;
        int tabCount = this.m_dataModel.getTabCount();
        int paramTabCount = this.m_dataModel.getParamTabCount();
        this.m_buttonAdd = new CnfgButton[tabCount];
        this.m_buttonRemove = new CnfgButton[tabCount];
        this.m_buttonResetToDefault = new CnfgButton[paramTabCount];
        this.m_buttonTest = new CnfgButton[paramTabCount];
        this.m_tPages = new emTable[tabCount];
        this.m_tParamPages = new emParamTable[paramTabCount];
        Insets margin = new Insets(4, 4, 4, 4);
        JPanel client = new JPanel();
        client.setBorder(new EmptyBorder(margin));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        client.setLayout(gridbag);
        this.m_buttonOK = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
        this.m_buttonOK.addActionListener(this);
        this.m_buttonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
        this.m_buttonCancel.addActionListener(this);
        for (int i2 = 0; i2 < tabCount; ++i2) {
            this.m_buttonAdd[i2] = new CnfgButton(CnfgResource.getMessage("Label.DialogGlobalConfig.ButtonAdd"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
            this.m_buttonAdd[i2].addActionListener(this);
            this.m_buttonRemove[i2] = new CnfgButton(CnfgResource.getMessage("Label.DialogGlobalConfig.ButtonRemove"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
            this.m_buttonRemove[i2].setEnabled(false);
            this.m_buttonRemove[i2].addActionListener(this);
        }
        for (int j = 0; j < paramTabCount; ++j) {
            this.m_buttonResetToDefault[j] = new CnfgButton(CnfgResource.getMessage("Menu.edit.resetToDefault"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
            this.m_buttonResetToDefault[j].setEnabled(false);
            this.m_buttonResetToDefault[j].addActionListener(this);
            this.m_buttonTest[j] = new CnfgButton(CnfgResource.getMessage("Menu.actions.test"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
            this.m_buttonTest[j].setEnabled(false);
            this.m_buttonTest[j].addActionListener(this);
        }
        this.getRootPane().setDefaultButton(this.m_buttonOK);
        this.m_tabPane = new JTabbedPane();
        JPanel[] innerTab = new JPanel[tabCount + paramTabCount];
        JSplitPane[] innerSplitTab = new JSplitPane[paramTabCount];
        JScrollPane[] scroll = new JScrollPane[tabCount + paramTabCount];
        JScrollPane[] infoScroll = new JScrollPane[paramTabCount];
        InformationPanel[] infoPanel = new InformationPanel[paramTabCount];
        Box[] boxAddRemove = new Box[tabCount];
        Box[] boxResetToDefaultTest = new Box[paramTabCount];
        GridBagLayout[] gridbag2 = new GridBagLayout[tabCount + paramTabCount];
        for (i = 0; i < paramTabCount; ++i) {
            this.m_tParamPages[i] = new emParamTable(this, this.getParamPageModel(i), this.m_buttonResetToDefault[i], this.m_buttonTest[i]);
            innerTab[i] = new JPanel();
            innerTab[i].setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
            gridbag2[i] = new GridBagLayout();
            innerTab[i].setLayout(gridbag2[i]);
            boxResetToDefaultTest[i] = new Box(0);
            boxResetToDefaultTest[i].add(Box.createVerticalGlue());
            boxResetToDefaultTest[i].add(this.m_buttonResetToDefault[i]);
            boxResetToDefaultTest[i].add(Box.createHorizontalStrut(6));
            boxResetToDefaultTest[i].add(this.m_buttonTest[i]);
            scroll[tabCount + i] = new JScrollPane(this.m_tParamPages[i]);
            scroll[tabCount + i].setBorder(new CompoundBorder(new EmptyBorder(margin), new SoftBevelBorder(1)));
            infoPanel[i] = new InformationPanel(this.m_tParamPages[i], this.getParamPageModel(i), innerSplitTab[i], infoScroll[i]){
                Dimension d;
                {
                    this.d = new Dimension(100, 20);
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.d;
                }
            };
            infoScroll[i] = new JScrollPane(infoPanel[i]);
            infoScroll[i].setBorder(new CompoundBorder(new EmptyBorder(margin), new SoftBevelBorder(1)));
            infoScroll[i].setHorizontalScrollBarPolicy(30);
            innerSplitTab[i] = new JSplitPane(0, true, scroll[tabCount + i], infoScroll[i]);
            innerSplitTab[i].setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
            innerSplitTab[i].setDividerSize(5);
            innerSplitTab[i].setDividerLocation(375);
            infoPanel[i].setParentPanels(innerSplitTab[i], infoScroll[i]);
            final JSplitPane splitP = innerSplitTab[i];
            final JScrollPane scrollP = infoScroll[i];
            final InformationPanel infoP = infoPanel[i];
            infoScroll[i].addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Object obj = e.getSource();
                    if (obj != null && JScrollPane.class.isInstance(obj)) {
                        CRConfigFrame.getInstance().resizeInfoPane(splitP, scrollP, infoP);
                    }
                }
            });
            MenuToolbarLogicListener mtblListener = new MenuToolbarLogicListener(CRConfigFrame.getInstance(), this.m_tParamPages[i], this.getParamPageModel(i));
            ResetToDefaultListener rtdListener = new ResetToDefaultListener(CRConfigFrame.getInstance(), this.m_tParamPages[i], this.getParamPageModel(i));
            ListSelectionModel lsm = this.m_tParamPages[i].getSelectionModel();
            lsm.addListSelectionListener(infoPanel[i]);
            lsm.addListSelectionListener(mtblListener);
            lsm.addListSelectionListener(rtdListener);
            this.m_tParamPages[i].addFocusListener(mtblListener);
            this.m_tParamPages[i].addFocusListener(rtdListener);
            this.m_tParamPages[i].addFocusListener(infoPanel[i]);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 11;
            c.fill = 1;
            gridbag2[i].setConstraints(innerSplitTab[i], c);
            innerTab[i].add(innerSplitTab[i]);
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = margin;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 15;
            c.fill = 2;
            gridbag2[i].setConstraints(boxResetToDefaultTest[i], c);
            innerTab[i].add(boxResetToDefaultTest[i]);
            this.m_tabPane.addTab(this.getParamPageModel(i).getCaption(), innerTab[i]);
            int tabIndex = this.m_tabPane.indexOfComponent(innerTab[i]);
            this.m_tabPane.setSelectedIndex(tabIndex);
            this.getParamPageModel(i).addTableModelListener(this);
        }
        for (i = 0; i < tabCount; ++i) {
            this.m_tPages[i] = new emTable(this.getPageModel(i), this.m_buttonAdd[i]);
            innerTab[i] = new JPanel();
            innerTab[i].setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
            gridbag2[i] = new GridBagLayout();
            innerTab[i].setLayout(gridbag2[i]);
            boxAddRemove[i] = new Box(0);
            boxAddRemove[i].add(Box.createVerticalGlue());
            boxAddRemove[i].add(this.m_buttonAdd[i]);
            boxAddRemove[i].add(Box.createHorizontalStrut(6));
            boxAddRemove[i].add(this.m_buttonRemove[i]);
            scroll[i] = new JScrollPane(this.m_tPages[i]);
            scroll[i].setBorder(new CompoundBorder(new EmptyBorder(margin), new SoftBevelBorder(1)));
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 11;
            c.fill = 1;
            gridbag2[i].setConstraints(scroll[i], c);
            innerTab[i].add(scroll[i]);
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = margin;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 15;
            c.fill = 2;
            gridbag2[i].setConstraints(boxAddRemove[i], c);
            innerTab[i].add(boxAddRemove[i]);
            this.m_tabPane.addTab(this.getPageModel(i).getCaption(), innerTab[i]);
            this.getPageModel(i).addTableModelListener(this);
        }
        Box boxOKCancel = new Box(0);
        boxOKCancel.add(Box.createGlue());
        boxOKCancel.add(this.m_buttonOK);
        boxOKCancel.add(Box.createHorizontalStrut(6));
        boxOKCancel.add(this.m_buttonCancel);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = margin;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        c.fill = 1;
        gridbag.setConstraints(this.m_tabPane, c);
        client.add(this.m_tabPane);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = margin;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 15;
        c.fill = 2;
        gridbag.setConstraints(boxOKCancel, c);
        client.add(boxOKCancel);
        this.getContentPane().add((Component)client, "Center");
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogMappingBase.this.action_Cancel();
            }
        };
        this.addWindowListener(l);
        CnfgUtils.pack(this);
        this.setLocationRelativeTo(parent);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DialogMappingBase.this.m_buttonCancel.requestFocus();
            }
        });
        if (CnfgUtils.isWindowsPlatform()) {
            this.m_tabPane.setUI(new BasicTabbedPaneUIBis());
        }
        for (int i3 = 0; i3 < paramTabCount; ++i3) {
            this.m_tParamPages[i3].changeSelection(0, 0, false, false);
            this.m_tParamPages[i3].requestFocus();
        }
    }

    private void action_Add(int i) {
        int newRow = this.getPageModel(i).addEmpty();
        this.m_tPages[i].changeSelection(newRow, 2, false, false);
        if (this.m_tPages[i].editCellAt(newRow, 2)) {
            this.m_tPages[i].getEditorComponent().requestFocus();
        }
        this.setDirtyFlag(true);
    }

    private void action_Remove(int i) {
        boolean ret = this.getPageModel(i).removeSelected();
        if (ret) {
            this.setDirtyFlag(true);
            this.m_tPages[i].removeEditor();
        }
    }

    private void action_resetToDefault(JButton rtdButton, int i) {
        int row = this.m_tParamPages[i].getSelectionModel().getMinSelectionIndex();
        if (row != -1) {
            Parameter parm = this.getParamPageModel(i).getItem(row);
            if (parm != null) {
                parm.setToDefault();
                this.setDirtyFlag(true);
                rtdButton.setEnabled(false);
            }
            this.m_tParamPages[i].removeEditor();
            this.getParamPageModel(i).fireTableRowsUpdated(row, row);
            this.m_tParamPages[i].requestFocus();
        }
    }

    private void action_Test(JButton rtdButton, int i) {
        Parameter parm;
        int row;
        TableCellEditor ed = this.m_tParamPages[i].getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
        if ((row = this.m_tParamPages[i].getSelectionModel().getMinSelectionIndex()) != -1 && (parm = this.getParamPageModel(i).getItem(row)) != null) {
            CRConfigFrame.getInstance().runTestAction(parm);
        }
    }

    private void action_Cancel() {
        if (this.m_dataModel.isDirty()) {
            this.m_dataModel.cancelParamChanges();
        }
        this.terminate();
    }

    private void action_OK() {
        if (!this.m_dataModel.isDirty()) {
            this.terminate();
            return;
        }
        try {
            TableCellEditor ed;
            int i;
            Element rootElement = DataManager.getInstance().getLocaleMapsElement();
            for (i = 0; i < this.m_dataModel.getTabCount(); ++i) {
                ed = this.m_tPages[i].getCellEditor();
                if (ed != null) {
                    ed.stopCellEditing();
                }
                if (!this.getPageModel(i).isValid()) {
                    this.m_tabPane.setSelectedIndex(i);
                    this.m_tPages[i].changeSelection(this.getPageModel(i).getLastErrorRow(), 1, false, false);
                    this.m_tPages[i].requestFocus();
                    Object[] args = new Object[]{CnfgResource.getMessage("Message.globalConfiguration.validation.error.notification"), CnfgResource.getMessage("Message.globalConfiguration.validation.error.resolution")};
                    DialogMessage.showDialog(args, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
                    return;
                }
                this.getPageModel(i).save(rootElement);
            }
            for (i = 0; i < this.m_dataModel.getParamTabCount(); ++i) {
                ed = this.m_tParamPages[i].getCellEditor();
                if (ed != null) {
                    ed.stopCellEditing();
                }
                if (!this.getParamPageModel(i).isValid()) {
                    this.m_tabPane.setSelectedIndex(this.m_dataModel.getTabCount() + i);
                    this.m_tParamPages[i].changeSelection(this.getParamPageModel(i).getLastErrorRow(), this.getParamPageModel(i).getLastErrorCol(), false, false);
                    this.m_tParamPages[i].requestFocus();
                    DialogMessage.showDialog(this.getParamPageModel(i).getLastErrorMessage(), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
                    return;
                }
                this.getParamPageModel(i).save(rootElement);
            }
            DataManager.getInstance().setLocaleDocument(rootElement.getDocument());
            this.terminate();
        }
        catch (DataManagerException e) {
            CnfgLog.error(e);
            DialogMessage.showDialog(e.getMessage(), DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
        }
    }

    private void terminate() {
        this.dispose();
    }

    private class BasicTabbedPaneUIBis
    extends BasicTabbedPaneUI {
        private BasicTabbedPaneUIBis() {
        }

        @Override
        protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
            g.setFont(font);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex) && !isSelected) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                g.drawString(title, textRect.x, textRect.y + metrics.getAscent() - 3);
            } else if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex) && isSelected) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                g.drawString(title, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    private class RendererCustomizeColumn
    extends JLabel
    implements TableCellRenderer {
        private Icon[] m_images;

        public RendererCustomizeColumn() {
            if (this.m_images == null) {
                this.m_images = new Icon[3];
                this.m_images[0] = CnfgImageLoader.loadIcon("mnu_null.gif");
                this.m_images[1] = CnfgImageLoader.loadIcon("parameter_error.gif");
                this.m_images[2] = CnfgImageLoader.loadIcon("parameter_warning.gif");
            }
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null && value.getClass() == State.class) {
                State state = (State)value;
                if (state.getValue() == State.ERROR) {
                    this.setIcon(this.m_images[1]);
                }
                if (state.getValue() == State.WARNING) {
                    this.setIcon(this.m_images[2]);
                }
                MappingBaseModel.emTableModel model = (MappingBaseModel.emTableModel)table.getModel();
                this.setToolTipText(model.getErrorMessage(row));
            } else {
                this.setIcon(this.m_images[0]);
            }
            if (isSelected) {
                if (table.hasFocus()) {
                    this.setBackground(SystemColor.textHighlight);
                    this.setForeground(SystemColor.textHighlightText);
                } else {
                    this.setBackground(SystemColor.control);
                    this.setForeground(SystemColor.controlText);
                }
            } else if (CnfgUtils.isWindowsPlatform()) {
                this.setBackground(SystemColor.window);
                this.setForeground(SystemColor.windowText);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    private class RendererEmbedTableColumn
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String txtStr;
            if (value == null) {
                return this;
            }
            MappingBaseModel.emTableModel model = (MappingBaseModel.emTableModel)table.getModel();
            String accStr = txtStr = value.toString();
            if (column == model.COL_DESC) {
                txtStr = CnfgUtils.handleBidiString(txtStr);
                accStr = CnfgUtils.getAccessibleBidiString(value.toString());
            }
            this.getAccessibleContext().setAccessibleName(accStr);
            this.setText(txtStr);
            if (isSelected) {
                if (table.hasFocus()) {
                    this.setBackground(SystemColor.textHighlight);
                    this.setForeground(SystemColor.textHighlightText);
                } else {
                    this.setBackground(SystemColor.control);
                    this.setForeground(SystemColor.controlText);
                }
            } else if (CnfgUtils.isWindowsPlatform()) {
                this.setBackground(SystemColor.window);
                this.setForeground(SystemColor.windowText);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    protected class emParamTable
    extends CnfgTable {
        JButton m_resetToDefaultButton;
        JButton m_testButton;

        public emParamTable(Dialog parent, CnfgTableModel dataModel, JButton rtdButton, JButton tButton) {
            super(parent, dataModel);
            this.setAutoResizeMode(3);
            this.m_resetToDefaultButton = rtdButton;
            this.m_testButton = tButton;
            InputMap im = this.getInputMap(1);
            ActionMap am = this.getActionMap();
            KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
            Action escAction = am.get(im.get(esc));
            FilteredAction newAction = new FilteredAction(this, escAction);
            im.put(esc, "CNFGCancelEditing");
            am.put("CNFGCancelEditing", newAction);
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            Parameter parm = ((CnfgTableModel)this.getModel()).getItem(rowIndex);
            this.refreshResetToDefaultButton(parm);
            this.refreshTestButton(parm);
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }

        @Override
        public void valueChanged(CnfgValueChangedEvent e) {
            Object obj = e.getSource();
            if (Parameter.class.isInstance(obj)) {
                this.refreshResetToDefaultButton((Parameter)obj);
                this.refreshTestButton((Parameter)obj);
            }
            super.valueChanged(e);
        }

        private void refreshResetToDefaultButton(Parameter parm) {
            if (parm != null && parm.hasDefault()) {
                if (!parm.isDefault()) {
                    this.m_resetToDefaultButton.setEnabled(true);
                } else {
                    this.m_resetToDefaultButton.setEnabled(false);
                }
            } else {
                this.m_resetToDefaultButton.setEnabled(false);
            }
        }

        private void refreshTestButton(Parameter parm) {
            List<CnfgActionTest> actionElems = parm.getTestActions();
            boolean bRetValue = false;
            if (actionElems.size() > 0) {
                bRetValue = true;
            }
            this.m_testButton.setEnabled(bRetValue);
        }
    }

    protected class emTable
    extends JTable {
        private int m_prevColumn;
        private int m_prevRow;

        public emTable(MappingBaseModel.emTableModel model, JComponent nextFocus) {
            int rowHeight;
            super(model);
            this.m_prevColumn = -1;
            this.m_prevRow = -1;
            this.setColumnSelectionAllowed(false);
            this.setSelectionMode(0);
            this.setNextFocusableComponent(nextFocus);
            JTableHeader cHeader = this.getTableHeader();
            cHeader.setReorderingAllowed(false);
            cHeader.setResizingAllowed(true);
            TableColumn tc = cHeader.getColumnModel().getColumn(0);
            tc.setMinWidth(22);
            tc.setMaxWidth(22);
            tc.setResizable(false);
            if (model.COL_CUSTOM != -1) {
                TableColumn cc = cHeader.getColumnModel().getColumn(model.COL_CUSTOM);
                cc.setMinWidth(22);
                cc.setMaxWidth(22);
                cc.setResizable(false);
            }
            if (model.COL_DESC >= 0) {
                TableColumn descCol = this.getColumnModel().getColumn(model.COL_DESC);
                descCol.setCellRenderer(new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        return table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                });
            }
            if ((rowHeight = CnfgButton.m_imageEdit.getIconHeight() + 2) > this.getRowHeight()) {
                this.setRowHeight(rowHeight);
            }
            this.setTableRowHeight();
            this.initKeyActionMap();
        }

        @Override
        public void editingStopped(ChangeEvent ce) {
            super.editingStopped(ce);
            this.repaint();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            MappingBaseModel.emTableModel model = (MappingBaseModel.emTableModel)this.getModel();
            if (column == model.COL_VALUE && model.m_browser != null) {
                CnfgButton button = this.createEditButton(column);
                if (model.m_browser.getName().equals(EditorAliasRootURI.class.getName())) {
                    Class[] params = new Class[]{Container.class, AliasRoot.class, CnfgButton.class};
                    try {
                        Constructor c = model.m_browser.getDeclaredConstructor(params);
                        AliasRoot value = new AliasRoot((AliasRoot)this.getValueAt(row, column));
                        Object[] p = new Object[]{this.getOwner(), value, button};
                        return (TableCellEditor)c.newInstance(p);
                    }
                    catch (Throwable e) {
                        CnfgLog.error(e);
                    }
                } else {
                    Class[] params = new Class[]{Container.class, JTextField.class, Boolean.TYPE, CnfgButton.class};
                    try {
                        Constructor c = model.m_browser.getDeclaredConstructor(params);
                        Object[] p = new Object[]{this.getOwner(), new JTextField(this.getValueAt(row, column).toString()), Boolean.TRUE, button};
                        return (TableCellEditor)c.newInstance(p);
                    }
                    catch (Throwable e) {
                        CnfgLog.error(e);
                    }
                }
            } else if (column == model.COL_VALUE || column == model.COL_KEY) {
                return new EditorBase(this.getOwner(), new JTextField(this.getValueAt(row, column).toString()));
            }
            return super.getCellEditor(row, column);
        }

        private CnfgButton createEditButton(int column) {
            final CnfgButton button = new CnfgButton(CnfgButton.m_imageEdit, this.getColumnName(column));
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    button.requestFocus();
                }
            });
            this.transferFocusBackward();
            return button;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            MappingBaseModel.emTableModel model = (MappingBaseModel.emTableModel)this.getModel();
            if (column == model.COL_CUSTOM) {
                return new RendererCustomizeColumn();
            }
            if (column == model.COL_KEY || column == model.COL_VALUE || column == model.COL_DESC) {
                return new RendererEmbedTableColumn();
            }
            return super.getCellRenderer(row, column);
        }

        protected Container getOwner() {
            Container parent = this.getParent();
            while (!Dialog.class.isInstance(parent) && !Frame.class.isInstance(parent)) {
                parent = parent.getParent();
            }
            return parent;
        }

        public void setTableRowHeight() {
            this.setRowHeight(CnfgFontSetting.getMaxHeight(this.getFont()));
        }

        @Override
        public boolean isCellSelected(int row, int col) {
            return row == this.m_prevRow && col == this.m_prevColumn;
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            if (rowIndex == -1 || columnIndex == -1) {
                this.m_prevColumn = 0;
                this.m_prevRow = 0;
                super.changeSelection(0, 0, false, false);
            } else {
                this.m_prevColumn = columnIndex;
                this.m_prevRow = rowIndex;
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }
        }

        private void initKeyActionMap() {
            InputMap im = this.getInputMap(1);
            ActionMap am = this.getActionMap();
            KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
            KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            KeyStroke shiftEnter = KeyStroke.getKeyStroke(10, 1);
            im.put(enter, "CNFGSelectEnterNextCell");
            im.put(shiftEnter, "CNFGSelectEnterPreviousCell");
            am.put("CNFGSelectEnterNextCell", new SelectNextCell(this));
            am.put("CNFGSelectEnterPreviousCell", new SelectPreviousCell(this));
            im.put(tab, "CNFGSelectTabNextCell");
            im.put(shiftTab, "CNFGSelectTabPreviousCell");
            am.put("CNFGSelectTabNextCell", new SelectNextCell(this));
            am.put("CNFGSelectTabPreviousCell", new SelectPreviousCell(this));
            KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
            Action escAction = am.get(im.get(esc));
            FilteredAction newAction = new FilteredAction(this, escAction);
            im.put(esc, "CNFGCancelEditing");
            am.put("CNFGCancelEditing", newAction);
        }

        class SelectPreviousCell
        extends AbstractAction {
            JTable table;

            public SelectPreviousCell(JTable aTable) {
                this.table = aTable;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (this.table.isEditing() && !this.table.getCellEditor().stopCellEditing()) {
                    return;
                }
                MappingBaseModel.emTableModel model = (MappingBaseModel.emTableModel)this.table.getModel();
                if (emTable.this.m_prevColumn == -1 || emTable.this.m_prevRow == -1) {
                    if (model.getRowCount() > 0) {
                        this.table.changeSelection(0, 0, false, false);
                    }
                } else {
                    int iRes;
                    int columnIndex = emTable.this.m_prevColumn;
                    int rowIndex = emTable.this.m_prevRow;
                    if (emTable.this.m_prevColumn <= 0) {
                        columnIndex = model.getColValue();
                        rowIndex = rowIndex == 0 ? model.getRowCount() - 1 : --rowIndex;
                    } else if (--columnIndex == model.COL_CUSTOM && (iRes = model.isRowValid(rowIndex)) == 0) {
                        --columnIndex;
                    }
                    this.table.changeSelection(rowIndex, columnIndex, false, false);
                }
            }
        }

        class SelectNextCell
        extends AbstractAction {
            JTable table;

            public SelectNextCell(JTable aTable) {
                this.table = aTable;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (this.table.isEditing() && !this.table.getCellEditor().stopCellEditing()) {
                    return;
                }
                MappingBaseModel.emTableModel model = (MappingBaseModel.emTableModel)this.table.getModel();
                if (emTable.this.m_prevColumn == -1 || emTable.this.m_prevRow == -1) {
                    if (model.getRowCount() > 0) {
                        this.table.changeSelection(0, 0, false, false);
                    }
                } else {
                    int iRes;
                    int columnIndex = emTable.this.m_prevColumn;
                    int rowIndex = emTable.this.m_prevRow;
                    if (emTable.this.m_prevColumn >= model.getColValue()) {
                        columnIndex = 0;
                        rowIndex = rowIndex == model.getRowCount() - 1 ? 0 : ++rowIndex;
                    } else if (++columnIndex == model.COL_CUSTOM && (iRes = model.isRowValid(rowIndex)) == 0) {
                        ++columnIndex;
                    }
                    this.table.changeSelection(rowIndex, columnIndex, false, false);
                }
            }
        }
    }

    public class FilteredAction
    extends AbstractAction {
        Action myaction;
        JTable mytable;

        public FilteredAction(JTable comp, Action action) {
            this.mytable = comp;
            this.myaction = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mytable.isEditing()) {
                this.myaction.actionPerformed(e);
            } else {
                DialogMappingBase.this.action_Cancel();
            }
        }
    }
}

