/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgSplashScreen;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.i18n.ui.I18NTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class DialogMessage
extends JDialog {
    public static final Icon ICON_ERROR = CnfgImageLoader.loadIcon("msg_error.gif");
    public static final Icon ICON_WARNING = CnfgImageLoader.loadIcon("msg_warning.gif");
    public static final Icon ICON_INFORMATION = CnfgImageLoader.loadIcon("msg_information.gif");
    public static final Icon ICON_ACTION_RUNNING = CnfgImageLoader.loadIcon("progress.gif");
    public static final String DEFAULT_CAPTION = CnfgResource.getMessage("Application.title");
    private static final CnfgButton m_ButtonOK = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
    private static final CnfgButton m_ButtonCancelNoAccelerator = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
    private static final CnfgButton m_ButtonYES = new CnfgButton(CnfgResource.getMessage("Label.ButtonYes"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
    private static final CnfgButton m_ButtonNO = new CnfgButton(CnfgResource.getMessage("Label.ButtonNo"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
    private static final CnfgButton m_ButtonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
    private static final CnfgButton m_ButtonExit = new CnfgButton(CnfgResource.getMessage("Label.ButtonExit"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
    private static final CnfgButton m_ButtonContinue = new CnfgButton(CnfgResource.getMessage("Label.ButtonContinue"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
    public static final Object[] OPTS_NOARGS = null;
    public static final Object[] OPTS_OK = new Object[]{m_ButtonOK};
    public static final Object[] OPTS_YESNO = new Object[]{m_ButtonYES, m_ButtonNO};
    public static final Object[] OPTS_OKCANCEL = new Object[]{m_ButtonOK, m_ButtonCancelNoAccelerator};
    public static final Object[] OPTS_YESNOCANCEL = new Object[]{m_ButtonYES, m_ButtonNO, m_ButtonCancelNoAccelerator};
    public static final Object[] OPTS_YESCANCEL = new Object[]{m_ButtonYES, m_ButtonCancelNoAccelerator};
    public static final Object[] OPTS_EXITCONTINUE = new Object[]{m_ButtonExit, m_ButtonContinue};
    public static final Object[] OPTS_NO_BUTTONS = new Object[0];
    protected I18NTextArea m_area;
    private int m_value = -1;
    private Object m_message = null;
    private Icon m_icon = null;
    private Object[] m_opts = OPTS_NOARGS;
    private int m_defaultOption = 0;

    public static int showDialog(Object message, String caption, Icon icon, Object[] opts, int defaultOption) {
        CRConfigFrame frame = CRConfigFrame.getInstance();
        CnfgSplashScreen splash = frame.getSplashScreeen();
        if (splash != null) {
            splash.setVisible(false);
        }
        DialogMessage dlg = new DialogMessage(frame, message, caption, icon, opts, defaultOption);
        return dlg.getValue();
    }

    public static int showDialog(Dialog parent, Object message, String caption, Icon icon, Object[] opts, int defaultOption) {
        DialogMessage dlg = new DialogMessage(parent, message, caption, icon, opts, defaultOption);
        return dlg.getValue();
    }

    private DialogMessage(Dialog parent, Object message, String caption, Icon icon, Object[] opts, int defaultOption) {
        super(parent, caption, true);
        this._commonInit(message, caption, icon, opts, defaultOption);
    }

    public static DialogMessage getWaitDialog(Object message, String caption, Icon icon) {
        DialogMessage dlg = new DialogMessage(CRConfigFrame.getInstance(), message, caption, icon, OPTS_NO_BUTTONS, 0);
        return dlg;
    }

    private DialogMessage(Frame parent, Object message, String caption, Icon icon, Object[] opts, int defaultOption) {
        super(parent, caption, true);
        this._commonInit(message, caption, icon, opts, defaultOption);
    }

    private void _commonInit(Object message, String caption, Icon icon, Object[] opts, int defaultOption) {
        this.m_message = message;
        this.m_icon = icon;
        this.m_defaultOption = defaultOption;
        Object[] objectArray = this.m_opts = opts != OPTS_NOARGS ? opts : OPTS_OK;
        if (this.m_opts != OPTS_NO_BUTTONS) {
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DialogMessage.this.m_area = null;
                    DialogMessage.this.Terminate();
                }
            };
            this.addWindowListener(l);
        } else {
            this.setDefaultCloseOperation(0);
        }
        this.getContentPane().add((Component)this.createMessageArea(), "Center");
        if (this.m_opts != OPTS_NO_BUTTONS) {
            this.getContentPane().add((Component)this.createButtonArea(), "South");
        }
        if (opts == OPTS_OKCANCEL || opts == OPTS_YESNOCANCEL) {
            ((JComponent)this.getContentPane()).registerKeyboardAction(new CancelListener(), KeyStroke.getKeyStroke(27, 0), 2);
        }
        CnfgUtils.pack(this);
        this.setLocationRelativeTo(this.getOwner());
        this.setResizable(false);
        if (this.m_opts != OPTS_NO_BUTTONS) {
            this.setVisible(true);
        }
    }

    private Container createMessageArea() {
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        top.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel body = new JPanel(){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(5000, 1);
            }
        };
        body.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = 17;
        this.addMessageComponents(body, cons, this.m_message);
        top.add((Component)body, "Center");
        this.addIcon(top);
        return top;
    }

    public void Terminate() {
        this.removeAll();
        this.dispose();
    }

    private Container createButtonArea() {
        JPanel bottom = new JPanel();
        bottom.setLayout(new FlowLayout());
        this.addButtonComponents(bottom, this.m_opts, this.m_defaultOption);
        return bottom;
    }

    private void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        if (buttons != null && buttons.length > 0) {
            boolean sizeButtonsToSame = true;
            boolean createdAll = true;
            int numButtons = buttons.length;
            CnfgButton[] createdButtons = null;
            int maxWidth = 0;
            if (sizeButtonsToSame) {
                createdButtons = new CnfgButton[numButtons];
            }
            for (int counter = 0; counter < numButtons; ++counter) {
                CnfgButton initialFocusComponent;
                CnfgButton aButton = (CnfgButton)buttons[counter];
                container.add(aButton);
                ActionListener buttonListener = this.createButtonActionListener(counter);
                if (buttonListener != null) {
                    aButton.addActionListener(buttonListener);
                }
                CnfgButton newComponent = aButton;
                if (sizeButtonsToSame && createdAll && newComponent instanceof CnfgButton) {
                    createdButtons[counter] = newComponent;
                    if (newComponent.equals(m_ButtonCancel) || newComponent.equals(m_ButtonCancelNoAccelerator)) {
                        this.m_value = counter;
                    }
                    maxWidth = Math.max(maxWidth, ((Component)newComponent).getMinimumSize().width);
                }
                if (counter != initialIndex || !((initialFocusComponent = newComponent) instanceof CnfgButton)) continue;
                CnfgButton defaultB = initialFocusComponent;
                defaultB.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent e) {
                        CnfgButton defaultButton = (CnfgButton)e.getComponent();
                        JRootPane root = SwingUtilities.getRootPane(defaultButton);
                        if (root != null) {
                            root.setDefaultButton(defaultButton);
                        }
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent event) {
                    }
                });
            }
        }
    }

    private ActionListener createButtonActionListener(int buttonIndex) {
        return new ButtonActionListener(buttonIndex);
    }

    private int getValue() {
        return this.m_value;
    }

    private void setValue(int index) {
        this.m_value = index;
    }

    private void addIcon(Container top) {
        JLabel iconLabel = new JLabel(" ", this.m_icon, 10);
        iconLabel.setVerticalAlignment(1);
        top.add((Component)iconLabel, "West");
    }

    private void addMessageComponents(Container container, GridBagConstraints cons, Object msg) {
        if (msg == null) {
            return;
        }
        if (msg instanceof Component) {
            if (msg instanceof JScrollPane || msg instanceof JPanel) {
                cons.fill = 1;
                cons.weighty = 1.0;
            } else {
                cons.fill = 2;
            }
            cons.weightx = 1.0;
            container.add((Component)msg, cons);
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.fill = 0;
            ++cons.gridy;
        } else if (msg instanceof Object[]) {
            Object[] msgs = (Object[])msg;
            for (int i = 0; i < msgs.length; ++i) {
                this.addMessageComponents(container, cons, msgs[i]);
            }
        } else if (msg instanceof ArrayList) {
            ArrayList lMsg = (ArrayList)msg;
            for (int i = 0; i < lMsg.size(); ++i) {
                this.addMessageComponents(container, cons, lMsg.get(i));
            }
        } else {
            String s = msg.toString();
            int len = s.length();
            if (len <= 0) {
                return;
            }
            if (this.m_area == null) {
                this.m_area = new I18NTextArea(s);
                EmptyBorder border = new EmptyBorder(2, 2, 2, 2);
                this.m_area.setBorder((Border)border);
                this.m_area.setBackground(UIManager.getColor("OptionPane.messageBackground"));
                this.m_area.setWrapStyleWord(true);
                this.m_area.setLineWrap(true);
                this.m_area.setEditable(false);
                this.m_area.setRequestFocusEnabled(false);
                DialogMessage.burstStringInto(s, 0, this.m_area, 200, 550, 850);
                container.add((Component)this.m_area, 0);
            } else {
                this.m_area.append("\n" + s);
                DialogMessage.burstStringInto(s, this.m_area.getSize().width, this.m_area, 200, 550, 850);
            }
        }
    }

    public static int burstStringInto(String d, int currentWidth, I18NTextArea area, int minWidth, int maxWidthSmallFont, int maxWidthLargeFont) {
        int iFontSize = CnfgFontSetting.getCurrentFontSize();
        Rectangle2D rec = area.getFont().getStringBounds(d, new FontRenderContext(null, false, false));
        int widthChar = CnfgFontSetting.getMaxWidth(area.getFont());
        int width = (int)rec.getWidth() + widthChar;
        if (width < 200) {
            width = minWidth;
        } else if (width > 750) {
            width = iFontSize >= 26 ? maxWidthLargeFont : maxWidthSmallFont;
        }
        if (width < currentWidth) {
            width = currentWidth;
        } else {
            area.setSize(width, 1000);
        }
        return width;
    }

    public static void updateFont(Font f) {
        m_ButtonOK.setFont(f);
        m_ButtonYES.setFont(f);
        m_ButtonNO.setFont(f);
        m_ButtonCancel.setFont(f);
        m_ButtonCancelNoAccelerator.setFont(f);
        m_ButtonExit.setFont(f);
        m_ButtonContinue.setFont(f);
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == (JComponent)DialogMessage.this.getContentPane()) {
                DialogMessage.this.Terminate();
            }
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public ButtonActionListener(int buttonIndex) {
            this.buttonIndex = buttonIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogMessage.this.setValue(this.buttonIndex);
            DialogMessage.this.Terminate();
        }
    }
}

