/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.BooleanParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Parameter;
import com.cognos.i18n.ui.I18NTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class DialogProperties
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private JTabbedPane pane;
    private JPanel mainPanel;
    private Insets margin = new Insets(4, 4, 4, 4);
    private CnfgButton m_buttonOk;
    private JCheckBox m_cbEnableInternalNS;
    private Parameter m_pEnableInternalNS;
    private static final String PARAM_EnableInternalNS = "enableInternalNS";

    public DialogProperties(CRConfigFrame owner) {
        super(owner, CnfgResource.getMessage("Label.DialogProperties.FrameTitle"), true);
        this.commoninit();
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(new EmptyBorder(this.margin));
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.mainPanel.setLayout(layout);
        this.pane = new JTabbedPane();
        this.pane.addTab(CnfgResource.getMessage("Label.DialogProperties.SystemPanelTitle"), new PropertiesPanel(this));
        this.pane.addTab(CnfgResource.getMessage("Label.DialogProperties.InstalledComponentsTitle"), new InstalledComponentsPanel(this));
        this.pane.addTab("Customized", new CustomizedPropertiesPanel(this));
        c.gridx = 0;
        c.gridy = 0;
        c.insets = this.margin;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        c.fill = 1;
        layout.setConstraints(this.pane, c);
        this.mainPanel.add(this.pane);
        this.m_buttonOk = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK"));
        this.m_buttonOk.addActionListener(this);
        Box boxOK = new Box(0);
        boxOK.add(Box.createGlue());
        boxOK.add(this.m_buttonOk);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = this.margin;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 14;
        c.fill = 2;
        layout.setConstraints(boxOK, c);
        this.mainPanel.add(boxOK);
        this.getRootPane().setDefaultButton(this.m_buttonOk);
        this.mainPanel.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 1);
        this.mainPanel.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
        this.setContentPane(this.mainPanel);
        Dimension d = this.mainPanel.getPreferredSize();
        if (d.width < 400) {
            d.width = 400;
        }
        this.mainPanel.setPreferredSize(d);
        CnfgUtils.pack(this);
        this.setLocationRelativeTo(owner);
    }

    private void commoninit() {
        this.m_pEnableInternalNS = DataManager.getInstance().findParam(PARAM_EnableInternalNS);
    }

    @Override
    public void actionPerformed(ActionEvent eee) {
        this.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.m_cbEnableInternalNS && this.m_pEnableInternalNS != null) {
            boolean value = e.getStateChange() == 1;
            this.m_pEnableInternalNS.setValue(new Boolean(value));
        }
    }

    private class PropertiesPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Insets spaceLeftBottom = new Insets(0, 10, 10, 0);
        private Insets spaceTopLeftBottom = new Insets(10, 10, 10, 0);
        private Insets spaceLeft = new Insets(0, 10, 0, 0);
        private DialogProperties owner;

        public PropertiesPanel(DialogProperties anOwner) {
            String IPaddress;
            String machineName;
            this.owner = anOwner;
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(layout);
            JLabel jVersion = new JLabel(CnfgResource.getMessage("Label.DialogProperties.JavaVersion"));
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceTopLeftBottom;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(jVersion, c);
            this.add(jVersion);
            JLabel jVersionValue = new JLabel(System.getProperty("java.version"));
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceTopLeftBottom;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(jVersionValue, c);
            this.add(jVersionValue);
            JLabel jVendor = new JLabel(CnfgResource.getMessage("Label.DialogProperties.JavaVendor"));
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeftBottom;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(jVendor, c);
            this.add(jVendor);
            JLabel jVendorValue = new JLabel(System.getProperty("java.vendor"));
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeftBottom;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(jVendorValue, c);
            this.add(jVendorValue);
            JLabel jInstallPath = new JLabel(CnfgResource.getMessage("Label.DialogProperties.JavaInstallPath"));
            c.gridx = 0;
            c.gridy = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeft;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(jInstallPath, c);
            this.add(jInstallPath);
            JLabel jInstallPathValue = new JLabel(System.getProperty("java.home"));
            c.gridx = 1;
            c.gridy = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeft;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(jInstallPathValue, c);
            this.add(jInstallPathValue);
            JSeparator separator = new JSeparator();
            separator.setMinimumSize(new Dimension(this.owner.getMinimumSize().width, 2));
            c.gridx = 0;
            c.gridy = 3;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 2;
            c.insets = new Insets(10, 10, 10, 10);
            c.fill = 1;
            c.anchor = 10;
            layout.setConstraints(separator, c);
            this.add(separator);
            JLabel lName = new JLabel(CnfgResource.getMessage("Label.DialogProperties.LocalHostName"));
            c.gridx = 0;
            c.gridy = 4;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeftBottom;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(lName, c);
            this.add(lName);
            try {
                InetAddress current = InetAddress.getLocalHost();
                machineName = current.getHostName();
                IPaddress = current.getHostAddress();
            }
            catch (UnknownHostException eee) {
                machineName = CnfgResource.getMessage("Label.DialogProperties.HostError");
                IPaddress = CnfgResource.getMessage("Label.DialogProperties.HostError");
            }
            JLabel lNameValue = new JLabel(machineName);
            c.gridx = 1;
            c.gridy = 4;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeftBottom;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(lNameValue, c);
            this.add(lNameValue);
            JLabel lIP = new JLabel(CnfgResource.getMessage("Label.DialogProperties.LocalHostIP"));
            c.gridx = 0;
            c.gridy = 5;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeftBottom;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(lIP, c);
            this.add(lIP);
            JLabel lIPValue = new JLabel(IPaddress);
            c.gridx = 1;
            c.gridy = 5;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeftBottom;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(lIPValue, c);
            this.add(lIPValue);
            JLabel lCognosInstallPath = new JLabel(CnfgResource.getMessage("Label.DialogProperties.CognosInstallPath"));
            c.gridx = 0;
            c.gridy = 6;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeftBottom;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(lCognosInstallPath, c);
            this.add(lCognosInstallPath);
            JLabel lCognosInstallPathValue = new JLabel(DataManager.getPathToInstallDir());
            c.gridx = 1;
            c.gridy = 6;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeftBottom;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(lCognosInstallPathValue, c);
            this.add(lCognosInstallPathValue);
            JSeparator otherSeparator = new JSeparator();
            otherSeparator.setMinimumSize(new Dimension(this.owner.getMinimumSize().width, 2));
            c.gridx = 0;
            c.gridy = 7;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 2;
            c.fill = 1;
            c.insets = new Insets(0, 10, 10, 10);
            c.anchor = 10;
            layout.setConstraints(otherSeparator, c);
            this.add(otherSeparator);
            JLabel textAreaCaption = new JLabel(CnfgResource.getMessage("Label.DialogProperties.SystemTextBoxCaption"));
            c.gridx = 0;
            c.gridy = 8;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = this.spaceLeft;
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(textAreaCaption, c);
            this.add(textAreaCaption);
            I18NTextArea cTextArea = new I18NTextArea(CnfgResource.getLocale());
            cTextArea.setLineWrap(true);
            cTextArea.setWrapStyleWord(true);
            cTextArea.setMargin(new Insets(2, 2, 2, 2));
            cTextArea.setEditable(false);
            cTextArea.append(this.getAllSystemProperties().toString());
            cTextArea.setCaretPosition(0);
            JScrollPane scroll = new JScrollPane((Component)cTextArea);
            scroll.setHorizontalScrollBarPolicy(31);
            scroll.setVerticalScrollBarPolicy(20);
            scroll.setPreferredSize(new Dimension(300, 200));
            c.gridx = 0;
            c.gridy = 9;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 2;
            c.insets = new Insets(5, 10, 10, 10);
            c.fill = 1;
            layout.setConstraints(scroll, c);
            this.add(scroll);
        }

        private StringBuffer getAllSystemProperties() {
            StringBuffer buff = new StringBuffer();
            Enumeration<Object> keys = System.getProperties().keys();
            while (keys.hasMoreElements()) {
                String current = (String)keys.nextElement();
                buff.append(current).append("=").append(System.getProperties().get(current)).append("\n");
            }
            return buff;
        }
    }

    private class InstalledComponentsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private I18NTextArea cTextArea;
        private JScrollPane scroller;
        private DialogProperties owner;

        public InstalledComponentsPanel(DialogProperties anOwner) {
            this.owner = anOwner;
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(layout);
            this.cTextArea = new I18NTextArea(CnfgResource.getLocale());
            this.cTextArea.setLineWrap(true);
            this.cTextArea.setWrapStyleWord(true);
            this.cTextArea.setMargin(new Insets(2, 2, 2, 2));
            this.cTextArea.setEditable(false);
            HashMap cmps = DataManager.getInstance().getCmpLst();
            if (cmps.size() == 0) {
                this.cTextArea.append(CnfgResource.getMessage("Label.DialogProperties.LoadError"));
            } else {
                StringBuffer gather = new StringBuffer();
                Object[] keys = cmps.keySet().toArray();
                Arrays.sort(keys);
                for (int i = 0; i < keys.length; ++i) {
                    gather.append(keys[i].toString()).append(" = ").append(cmps.get(keys[i]).toString()).append("\n");
                }
                this.cTextArea.append(gather.toString());
            }
            this.cTextArea.setCaretPosition(0);
            this.scroller = new JScrollPane((Component)this.cTextArea);
            this.scroller.setHorizontalScrollBarPolicy(31);
            this.scroller.setVerticalScrollBarPolicy(20);
            this.scroller.setPreferredSize(new Dimension(350, 350));
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(10, 10, 10, 10);
            c.fill = 1;
            layout.setConstraints(this.scroller, c);
            this.add(this.scroller);
        }
    }

    private class CustomizedPropertiesPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private DialogProperties owner;

        public CustomizedPropertiesPanel(DialogProperties anOwner) {
            this.owner = anOwner;
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(layout);
            DialogProperties.this.m_cbEnableInternalNS = new JCheckBox("Enable Internal Namespace", this.isSelected(DialogProperties.PARAM_EnableInternalNS));
            DialogProperties.this.m_cbEnableInternalNS.setBorderPainted(true);
            DialogProperties.this.m_cbEnableInternalNS.setBorder(new EmptyBorder(1, 1, 1, 1));
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(10, 10, 10, 10);
            c.fill = 0;
            c.anchor = 17;
            layout.setConstraints(DialogProperties.this.m_cbEnableInternalNS, c);
            this.add(DialogProperties.this.m_cbEnableInternalNS);
            DialogProperties.this.m_cbEnableInternalNS.addItemListener(this.owner);
            JSeparator separator = new JSeparator();
            separator.setMinimumSize(new Dimension(this.owner.getMinimumSize().width, 2));
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 2;
            c.insets = new Insets(10, 10, 10, 10);
            c.fill = 1;
            c.anchor = 10;
            layout.setConstraints(separator, c);
            this.add(separator);
            JPanel spacePanel = new JPanel();
            c.gridx = 0;
            c.gridy = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 2;
            c.insets = new Insets(1, 1, 1, 1);
            c.fill = 1;
            layout.setConstraints(spacePanel, c);
            this.add(spacePanel);
        }

        private boolean isSelected(String paramName) {
            Object paramVal;
            if (paramName.equals(DialogProperties.PARAM_EnableInternalNS) && DialogProperties.this.m_pEnableInternalNS != null && BooleanParameter.class.isInstance(DialogProperties.this.m_pEnableInternalNS) && (paramVal = DialogProperties.this.m_pEnableInternalNS.getValue()) != null) {
                return (Boolean)paramVal;
            }
            return false;
        }
    }
}

