/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgField;
import com.cognos.crconfig.CnfgLabel;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.data.CnfgNodeRenamedEvent;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;

public class DialogRename
extends JDialog
implements ActionListener {
    private JPanel m_panel;
    private CnfgField m_newName;
    private CnfgButton m_buttonOK;
    private CnfgButton m_buttonCancel;
    private String m_sNewName;
    private Folder m_renamedFolder;
    private DefaultMutableTreeNode m_treeNode;

    public DialogRename(CRConfigFrame parent, String initialObjectName, Folder renamedFolder, DefaultMutableTreeNode treeNode, int maxNameLength) {
        super(parent, CnfgResource.getMessage("Title.DialogRename"), true);
        this.m_treeNode = treeNode;
        this.m_renamedFolder = renamedFolder;
        this.m_sNewName = initialObjectName;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(false);
        this.m_panel = new JPanel();
        this.getContentPane().add((Component)this.m_panel, "Center");
        this.m_panel.setLayout(gridbag);
        c.fill = 0;
        c.anchor = 18;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = new Insets(10, 10, 0, 10);
        this.m_panel.registerKeyboardAction(new CnfgRenameCancelListener(), KeyStroke.getKeyStroke(27, 0), 1);
        this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(115, 8), 1);
        Box p2 = new Box(0);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 8;
        c.insets = new Insets(20, 10, 6, 10);
        c.anchor = 11;
        gridbag.setConstraints(p2, c);
        this.m_panel.add(p2);
        this.m_buttonOK = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
        this.getRootPane().setDefaultButton(this.m_buttonOK);
        p2.add(Box.createGlue());
        p2.add(this.m_buttonOK);
        p2.add(Box.createHorizontalStrut(6));
        this.m_buttonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
        p2.add(this.m_buttonCancel);
        p2.add(Box.createHorizontalStrut(6));
        this.m_newName = new CnfgField(150, this.m_sNewName, maxNameLength);
        this.m_newName.setEditable(true);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 3;
        c.insets = new Insets(2, 10, 0, 10);
        c.fill = 2;
        gridbag.setConstraints(this.m_newName, c);
        this.m_panel.add(this.m_newName);
        c.fill = 0;
        c.gridwidth = 1;
        CnfgLabel xcLabelName = new CnfgLabel(290, CnfgResource.getMessage("Label.DialogRename.name"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex(), this.m_newName);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(10, 10, 0, 10);
        c.fill = 2;
        gridbag.setConstraints(xcLabelName, c);
        this.m_panel.add(xcLabelName);
        this.m_buttonOK.addActionListener(this);
        this.m_buttonCancel.addActionListener(this);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogRename.this.Terminate();
            }
        };
        this.addWindowListener(l);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DialogRename.this.m_newName.requestFocus();
            }
        });
        CnfgUtils.pack(this);
        this.setLocationRelativeTo(parent);
    }

    private void Action_OK() {
        String oldObjectName = this.m_renamedFolder.getLabel();
        this.m_sNewName = this.m_newName.getText();
        if (this.m_sNewName.compareTo(oldObjectName) != 0) {
            if (this.m_sNewName.length() != 0) {
                Folder f = this.m_renamedFolder.getParent().findFolder(this.m_sNewName, false);
                if (null != f && !f.getDisabled() && f.getVisibility()) {
                    Object[] args1 = new Object[]{oldObjectName};
                    String sNotification = CnfgResource.getMessage("Message.errorOnRename.notification", args1);
                    String sExplanation = CnfgResource.getMessage("Message.errorOnNew.namedup.notification");
                    String sResolution = CnfgResource.getMessage("Message.errorOnRename.resolution");
                    Object[] arrayOfObjects = new Object[]{sNotification, sExplanation, sResolution};
                    DialogMessage.showDialog(arrayOfObjects, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_NOARGS, 0);
                    this.m_newName.requestFocus();
                } else {
                    if (null != f && (f.getDisabled() || !f.getVisibility())) {
                        f.setName(this.generateUniqueName(f));
                    }
                    this.m_renamedFolder.setName(this.m_sNewName);
                    this.m_renamedFolder.setLabel(this.m_sNewName);
                    this.m_renamedFolder.resetActionContext();
                    CnfgNodeRenamedEvent e = new CnfgNodeRenamedEvent(this.m_renamedFolder, this.m_treeNode);
                    DataManager.getInstance().fireNodeRenamed(e);
                    this.Terminate();
                }
            } else {
                Object[] arrayOfObjects = new Object[]{CnfgResource.getMessage("Message.errorOnNew.noname.resolution")};
                DialogMessage.showDialog(arrayOfObjects, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_NOARGS, 0);
                this.m_newName.requestFocus();
            }
        } else {
            this.Terminate();
        }
    }

    private String generateUniqueName(Folder folder) {
        StringBuffer result = new StringBuffer(folder.getName());
        int i = 2;
        while (true) {
            result.append(" (");
            result.append(i);
            result.append(")");
            if (null == folder.getParent().findFolder(result.toString(), false)) break;
            ++i;
            int start = -1;
            for (int pos = result.length(); 0 <= pos; --pos) {
                if ('(' != result.charAt(pos)) continue;
                start = pos;
                break;
            }
            if (-1 != start) {
                result.delete(start, result.length());
                continue;
            }
            result.delete(0, result.length());
            result.append(folder.getName());
        }
        return result.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_buttonOK) {
            this.Action_OK();
        } else if (e.getSource() == this.m_buttonCancel) {
            this.Terminate();
        }
    }

    public String getNewObjectName() {
        return this.m_sNewName;
    }

    public void Terminate() {
        this.dispose();
    }

    class CnfgRenameCancelListener
    implements ActionListener {
        CnfgRenameCancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DialogRename.this.m_panel) {
                DialogRename.this.Terminate();
            }
        }
    }
}

