/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.MappingBaseModel;
import com.cognos.crconfig.State;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.editors.EditorFontBrowser;
import java.util.ArrayList;
import java.util.List;

public class FontsMappingModel
extends MappingBaseModel {
    private String m_fontPath;

    @Override
    protected void loadModel() throws DataManagerException {
        this.m_tmPageModels = new MappingBaseModel.emTableModel[1];
        this.m_tmPageModels[0] = new emTableModelFontsMap("fontsMap");
        this.m_tabCount = 1;
        this.m_paramTabCount = 0;
        Parameter fontPaths = DataManager.getInstance().findParm("fontPaths");
        this.m_fontPath = fontPaths != null ? (String)fontPaths.getValue() : "";
        this.loadData();
    }

    public void validate(List lErrors) {
        if (!this.m_tmPageModels[0].isValid()) {
            String sLabel = "";
            String sParentLabel = "";
            Parameter fontsMap = DataManager.getInstance().findParm("fontsMap");
            if (fontsMap != null) {
                sLabel = fontsMap.getLabel();
                if (fontsMap.getParent() != null) {
                    sParentLabel = fontsMap.getParent().getLabel();
                }
            }
            Object[] args = new Object[]{sLabel, sParentLabel};
            String sMessage = CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args);
            lErrors.add(sMessage);
        }
    }

    private class emTableModelFontsMap
    extends MappingBaseModel.emTableModel {
        public emTableModelFontsMap(String tagName) {
            super(FontsMappingModel.this, tagName, "fontMap");
            this.m_key = new ArrayList();
            this.COL_CUSTOM = 1;
            this.COL_KEY = 2;
            this.COL_VALUE = 3;
            this.COL_DESC = -1;
            this.m_browser = EditorFontBrowser.class;
        }

        @Override
        public String getColumnName(int col) {
            if (col == this.COL_KEY) {
                return CnfgResource.getMessage("Label.DialogFontsMapping.hdrKey");
            }
            if (col == this.COL_VALUE) {
                return CnfgResource.getMessage("Label.DialogFontsMapping.hdrValue");
            }
            return super.getColumnName(col);
        }

        @Override
        public int isRowValid(int row) {
            Object[] args;
            int errorCode = 0;
            String errorMessage = null;
            String value = this.m_value.get(row).toString();
            if (((String)this.m_key.get(row)).toString().length() == 0) {
                errorCode = 1;
                args = new Object[]{CnfgResource.getMessage("Label.DialogFontsMapping.hdrKey")};
                errorMessage = CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args);
            } else if (value.length() == 0) {
                errorCode = 1;
                args = new Object[]{CnfgResource.getMessage("Label.DialogFontsMapping.hdrValue")};
                errorMessage = CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args);
            } else if (!EditorFontBrowser.FontMapperListModel.isValidFont(value.toString())) {
                errorCode = 2;
                args = new Object[]{value.toString(), FontsMappingModel.this.m_fontPath};
                errorMessage = CnfgResource.getMessage("Message.FontName.invalid", args);
            }
            if (errorCode == 0) {
                String sKey = ((String)this.m_key.get(row)).toString();
                for (int j = 0; j < this.m_key.size(); ++j) {
                    String sName;
                    if (j == row || sKey.compareTo(sName = ((String)this.m_key.get(j)).toString()) != 0) continue;
                    errorCode = 4;
                    Object[] args2 = new Object[]{sKey};
                    errorMessage = CnfgResource.getMessage("Message.globalConfiguration.existing.entry", args2);
                    break;
                }
            }
            State state = new State(errorCode == 0 ? State.OK : State.ERROR);
            state.setCode(errorCode);
            state.setMessage(errorMessage);
            if (this.m_valid.size() > row) {
                this.m_valid.set(row, state);
            } else {
                this.m_valid.add(state);
            }
            return errorCode;
        }
    }
}

