/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgTableModel;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.MappingBaseModel;
import com.cognos.crconfig.State;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.i18n.ToolkitResources;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class GlobalConfigModel
extends MappingBaseModel {
    @Override
    protected void loadModel() throws DataManagerException {
        List<Folder> lGlobalFolders = DataManager.getInstance().getGlobalConfigFolders();
        this.m_tmPageModels = new MappingBaseModel.emTableModel[6];
        this.m_tmPageModels[0] = new emTableModelLocaleList("supportedProductLocales", false);
        this.m_tmPageModels[1] = new emTableModelLocaleList("supportedContentLocales", false);
        this.m_tmPageModels[2] = new emTableModelLocaleMap("productLocaleMap", false);
        this.m_tmPageModels[3] = new emTableModelLocaleMap("contentLocaleMap", false);
        this.m_tmPageModels[4] = new emTableModelCurrency();
        this.m_tmPageModels[5] = new emTableModelFont();
        this.m_tmParamPageModels = new CnfgTableModel[lGlobalFolders.size()];
        for (int i = 0; i < lGlobalFolders.size(); ++i) {
            Folder globalFolder = lGlobalFolders.get(i);
            this.m_tmParamPageModels[i] = new emTableModelGlobalParams(globalFolder);
        }
        this.m_tabCount = 6;
        this.m_paramTabCount = lGlobalFolders.size();
        this.loadData();
    }

    public void validate(List<String> lErrors) {
        int ierr;
        ArrayList<String> errors;
        String sLabel;
        for (int i = 0; i < this.m_tabCount; ++i) {
            sLabel = this.m_tmPageModels[i].getCaption();
            Object[] args = new Object[]{CnfgResource.getMessage("Title.DialogGlobalConfig"), sLabel};
            String sMessage = CnfgResource.getMessage("Message.errorOnValidation.locale.badvalue.resolution", args);
            errors = new ArrayList<String>();
            this.m_tmPageModels[i].getErrorMessages(errors);
            for (ierr = 0; ierr < errors.size(); ++ierr) {
                String sErr = (String)errors.get(ierr);
                lErrors.add(sMessage + " " + sErr);
            }
        }
        for (int j = 0; j < this.m_paramTabCount; ++j) {
            sLabel = this.m_tmParamPageModels[j].getCaption();
            Object[] args1 = new Object[]{CnfgResource.getMessage("Title.DialogGlobalConfig"), sLabel};
            String sMessage1 = CnfgResource.getMessage("Message.errorOnValidation.locale.badvalue.resolution", args1);
            errors = new ArrayList();
            ((emTableModelGlobalParams)this.m_tmParamPageModels[j]).getErrorMessages(errors);
            for (ierr = 0; ierr < errors.size(); ++ierr) {
                String sParamLabel = (String)errors.get(ierr);
                Object[] args2 = new Object[]{sParamLabel};
                String sMessage2 = CnfgResource.getMessage("Message.errorOnValidation.globalparam.badvalue.resolution", args2);
                lErrors.add(sMessage1 + " " + sMessage2);
            }
        }
    }

    @Override
    protected void cancelParamChanges() {
        for (int i = 0; i < this.m_paramTabCount; ++i) {
            this.m_tmParamPageModels[i].cancelParamChanges();
        }
    }

    private class emTableModelGlobalParams
    extends CnfgTableModel {
        private Folder m_globalParamFolder;
        protected int m_lastErrorRow;
        protected int m_lastErrorCol;
        protected List<String> m_lastErrorMessage;
        protected ArrayList m_lOriginalParamValues = new ArrayList();

        public emTableModelGlobalParams(Folder f) {
            this.m_globalParamFolder = f;
            this.buildDisplayData(f);
        }

        @Override
        protected String getCaption() {
            return this.m_globalParamFolder != null ? this.m_globalParamFolder.getLabel() : "???";
        }

        @Override
        protected void load(Element parentElement) {
            for (Element paramElem : parentElement.elements("parameter")) {
                Element valueElem;
                String sPName = paramElem.attributeValue("name", "");
                Parameter param = this.m_globalParamFolder.findParm(sPName);
                if (param == null || (valueElem = paramElem.element("value")) == null) continue;
                param.setFireValueChanged(false);
                param.setValue(valueElem);
            }
            List<Parameter> paramList = this.m_globalParamFolder.getParameters();
            for (int i = 0; i < paramList.size(); ++i) {
                this.fireTableRowsInserted(i, i);
                Parameter p = paramList.get(i);
                this.m_lOriginalParamValues.add(p.getValue());
            }
        }

        @Override
        protected void cancelParamChanges() {
            List<Parameter> lp = this.m_globalParamFolder.getParameters();
            for (int i = 0; i < lp.size(); ++i) {
                Parameter p = lp.get(i);
                Object oValue = this.m_lOriginalParamValues.get(i);
                p.setValue(oValue);
            }
        }

        private Element removeAllParametersExceptAliasRoots(Element parentElement) {
            List globalParameters = parentElement.elements("parameter");
            for (Element parameterElement : globalParameters) {
                Parameter parameter;
                String parameterName = parameterElement.attributeValue("name", "");
                if (parameterName.compareTo("aliasRoots") == 0 || (parameter = this.m_globalParamFolder.findParm(parameterName)) == null) continue;
                parentElement.remove(parameterElement);
            }
            return parentElement;
        }

        @Override
        protected void save(Element parentElement) throws DataManagerException {
            this.removeAllParametersExceptAliasRoots(parentElement);
            List<Parameter> paramList = this.m_globalParamFolder.getParameters();
            for (Parameter parameter : paramList) {
                if (parameter.isLocal()) continue;
                parameter.serialize(parentElement, false, null, false, false);
            }
        }

        @Override
        protected boolean isValid() {
            this.m_lastErrorRow = -1;
            this.m_lastErrorCol = -1;
            List<Parameter> paramList = this.m_globalParamFolder.getParameters();
            for (int i = 0; i < paramList.size(); ++i) {
                Parameter param = paramList.get(i);
                if (param == null || !param.isBadValue()) continue;
                this.m_lastErrorRow = i;
                this.m_lastErrorCol = 3;
                this.m_lastErrorMessage = param.getErrorMsg();
                return false;
            }
            return true;
        }

        protected void getErrorMessages(List<String> lErrors) {
            List<Parameter> paramList = this.m_globalParamFolder.getParameters();
            for (int i = 0; i < paramList.size(); ++i) {
                Parameter param = paramList.get(i);
                if (param == null || !param.isBadValue()) continue;
                lErrors.add(param.getLabel());
            }
        }

        @Override
        public int getLastErrorRow() {
            return this.m_lastErrorRow;
        }

        @Override
        public int getLastErrorCol() {
            return this.m_lastErrorCol;
        }

        @Override
        public List<String> getLastErrorMessage() {
            return this.m_lastErrorMessage;
        }
    }

    private class emTableModelFont
    extends MappingBaseModel.emTableModel {
        public emTableModelFont() {
            super(GlobalConfigModel.this, "supportedFonts", "font");
            this.COL_CUSTOM = 1;
            this.COL_VALUE = 2;
            this.COL_DESC = -1;
            this.COL_KEY = -1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == this.COL_DESC) {
                return null;
            }
            return super.getValueAt(row, col);
        }

        @Override
        public String getColumnName(int col) {
            if (col == this.COL_VALUE) {
                return CnfgResource.getMessage("Label.DialogGlobalConfig.hdrFont");
            }
            return super.getColumnName(col);
        }

        @Override
        public int isRowValid(int row) {
            int errorCode = 0;
            String errorMessage = null;
            if (this.m_value.get(row).toString().length() == 0) {
                errorCode = 1;
                Object[] args = new Object[]{CnfgResource.getMessage("Label.DialogGlobalConfig.hdrFont")};
                errorMessage = CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args);
            } else {
                String value = this.m_value.get(row).toString();
                for (int j = 0; j < this.m_value.size(); ++j) {
                    String sName;
                    if (j == row || (sName = this.m_value.get(j).toString()).compareTo(value) != 0) continue;
                    errorCode = 4;
                    Object[] args = new Object[]{value};
                    errorMessage = CnfgResource.getMessage("Message.globalConfiguration.existing.entry", args);
                    break;
                }
            }
            State state = new State(errorCode == 0 ? State.OK : State.ERROR);
            state.setCode(errorCode);
            state.setMessage(errorMessage);
            if (this.m_valid.size() > row) {
                this.m_valid.set(row, state);
            } else {
                this.m_valid.add(state);
            }
            return errorCode;
        }
    }

    private class emTableModelCurrency
    extends MappingBaseModel.emTableModel {
        public emTableModelCurrency() {
            super(GlobalConfigModel.this, "supportedCurrencies", "currency");
            this.COL_CUSTOM = 1;
            this.COL_VALUE = 2;
            this.COL_DESC = 3;
            this.COL_KEY = -1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object o;
            if (col == this.COL_DESC && null != (o = this.m_value.get(row))) {
                try {
                    ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
                    String sLocale = cfg.normalizeLocale(CnfgResource.getLocale().toString());
                    return ToolkitResources.getCurrencyDescription((String)o.toString(), (String)sLocale);
                }
                catch (CCLConfigurationException e) {
                    CnfgLog.debug(e);
                }
            }
            return super.getValueAt(row, col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == this.COL_VALUE) {
                aValue = aValue.toString().toUpperCase();
            }
            super.setValueAt(aValue, row, col);
        }

        @Override
        public String getColumnName(int col) {
            if (col == this.COL_VALUE) {
                return CnfgResource.getMessage("Label.DialogGlobalConfig.hdrCurrency");
            }
            return super.getColumnName(col);
        }

        @Override
        public int isRowValid(int row) {
            int errorCode = 0;
            String errorMessage = null;
            if (this.m_value.get(row).toString().length() == 0) {
                errorCode = 1;
                Object[] args = new Object[]{CnfgResource.getMessage("Label.DialogGlobalConfig.hdrCurrency")};
                errorMessage = CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args);
            } else {
                String value = this.m_value.get(row).toString();
                for (int j = 0; j < this.m_value.size(); ++j) {
                    String sName;
                    if (j == row || value.compareTo(sName = this.m_value.get(j).toString()) != 0) continue;
                    errorCode = 4;
                    Object[] args = new Object[]{value};
                    errorMessage = CnfgResource.getMessage("Message.globalConfiguration.existing.entry", args);
                    break;
                }
            }
            State state = new State(errorCode == 0 ? State.OK : State.ERROR);
            state.setCode(errorCode);
            state.setMessage(errorMessage);
            if (this.m_valid.size() > row) {
                this.m_valid.set(row, state);
            } else {
                this.m_valid.add(state);
            }
            return errorCode;
        }
    }

    private class emTableModelLocaleList
    extends MappingBaseModel.emTableModel {
        private boolean m_languageOnly;

        public emTableModelLocaleList(String tagName, boolean languageOnly) {
            super(GlobalConfigModel.this, tagName, "locale");
            this.m_languageOnly = languageOnly;
            this.COL_CUSTOM = 1;
            this.COL_VALUE = 2;
            this.COL_DESC = 3;
            this.COL_KEY = -1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object o;
            if (col == this.COL_DESC && null != (o = this.m_value.get(row))) {
                try {
                    ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
                    String sLocale = cfg.normalizeLocale(CnfgResource.getLocale().toString());
                    return ToolkitResources.getLocaleDescription((String)o.toString(), (String)sLocale);
                }
                catch (CCLConfigurationException e) {
                    CnfgLog.debug(e);
                }
            }
            return super.getValueAt(row, col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == this.COL_VALUE) {
                ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
                try {
                    aValue = cfg.normalizeLocale(aValue.toString());
                }
                catch (CCLConfigurationException e) {
                    CnfgLog.error(e);
                    return;
                }
            }
            super.setValueAt(aValue, row, col);
        }

        @Override
        public String getColumnName(int col) {
            if (col == this.COL_VALUE) {
                return CnfgResource.getMessage("Label.DialogGlobalConfig.hdrSupportedLocale");
            }
            return super.getColumnName(col);
        }

        @Override
        public int isRowValid(int row) {
            Object[] args;
            int errorCode = 0;
            String errorMessage = null;
            String value = this.m_value.get(row).toString();
            if (value.length() == 0) {
                errorCode = 1;
                args = new Object[]{CnfgResource.getMessage("Label.DialogGlobalConfig.hdrSupportedLocale")};
                errorMessage = CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args);
            } else if (value.indexOf(45) != -1 && this.m_languageOnly) {
                errorCode = 3;
                args = new Object[]{CnfgResource.getMessage("Label.DialogGlobalConfig.hdrSupportedLocale")};
                errorMessage = CnfgResource.getMessage("Message.globalConfiguration.language.only", args);
            } else if (!ToolkitResources.validateLocaleId((String)value)) {
                errorCode = 2;
                args = new Object[]{value};
                errorMessage = CnfgResource.getMessage("Message.globalConfiguration.invalid.locale", args);
            }
            if (errorCode == 0) {
                for (int j = 0; j < this.m_value.size(); ++j) {
                    String sName;
                    if (j == row || value.compareTo(sName = this.m_value.get(j).toString()) != 0) continue;
                    errorCode = 4;
                    Object[] args2 = new Object[]{value};
                    errorMessage = CnfgResource.getMessage("Message.globalConfiguration.existing.entry", args2);
                    break;
                }
            }
            State state = new State(errorCode == 0 ? State.OK : State.ERROR);
            state.setCode(errorCode);
            state.setMessage(errorMessage);
            if (this.m_valid.size() > row) {
                this.m_valid.set(row, state);
            } else {
                this.m_valid.add(state);
            }
            return errorCode;
        }

        @Override
        public boolean removeSelected() {
            int count = 0;
            for (int j = 0; j < this.m_count; ++j) {
                if (!((Boolean)this.m_select.get(j)).booleanValue()) continue;
                ++count;
            }
            if (count == this.m_count) {
                if (this.m_count == 1) {
                    Object[] messages = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.globalConfiguration.warning.deleting.one.locale")).append("\n").toString(), CnfgResource.getMessage("Message.globalConfiguration.warning.deleting.one.locale.fix")};
                    DialogMessage.showDialog(messages, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 0);
                } else if (this.m_count > 1) {
                    Object[] messages = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.globalConfiguration.warning.deleting.locales")).append("\n").toString(), CnfgResource.getMessage("Message.globalConfiguration.warning.deleting.locales.fix")};
                    DialogMessage.showDialog(messages, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 0);
                }
                return false;
            }
            for (int i = this.m_count - 1; i >= 0; --i) {
                if (!((Boolean)this.m_select.get(i)).booleanValue()) continue;
                this.m_select.remove(i);
                String sOldVal = null;
                if (this.m_key != null) {
                    sOldVal = ((String)this.m_key.get(i)).toString();
                    this.m_key.remove(i);
                } else {
                    sOldVal = this.m_value.get(i).toString();
                }
                this.m_value.remove(i);
                this.m_valid.remove(i);
                --this.m_count;
                if (sOldVal != null && sOldVal.length() > 0) {
                    this.scanDuplicates(sOldVal, this.m_key != null ? this.m_key : this.m_value);
                }
                this.fireTableRowsDeleted(i, i);
            }
            return true;
        }
    }

    private class emTableModelLocaleMap
    extends MappingBaseModel.emTableModel {
        private boolean m_languageOnly;

        public emTableModelLocaleMap(String tagName, boolean languageOnly) {
            super(GlobalConfigModel.this, tagName, "localeMap");
            this.m_languageOnly = languageOnly;
            this.m_key = new ArrayList();
            this.COL_CUSTOM = 1;
            this.COL_KEY = 2;
            this.COL_VALUE = 3;
            this.COL_DESC = 4;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object o;
            if (col == this.COL_DESC && null != (o = this.m_value.get(row))) {
                try {
                    ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
                    String sLocale = cfg.normalizeLocale(CnfgResource.getLocale().toString());
                    return ToolkitResources.getLocaleDescription((String)o.toString(), (String)sLocale);
                }
                catch (CCLConfigurationException e) {
                    CnfgLog.debug(e);
                }
            }
            return super.getValueAt(row, col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == this.COL_VALUE) {
                ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
                try {
                    aValue = cfg.normalizeLocale(aValue.toString());
                }
                catch (CCLConfigurationException e) {
                    CnfgLog.error(e);
                    return;
                }
            }
            super.setValueAt(aValue, row, col);
        }

        @Override
        public String getColumnName(int col) {
            if (col == this.COL_VALUE) {
                return CnfgResource.getMessage("Label.DialogGlobalConfig.hdrLocaleMapping");
            }
            return super.getColumnName(col);
        }

        @Override
        public int isRowValid(int row) {
            Object[] args;
            State state = new State();
            String value = this.m_value.get(row).toString();
            if (((String)this.m_key.get(row)).toString().length() == 0) {
                state.setValue(State.ERROR);
                state.setCode(1);
                args = new Object[]{CnfgResource.getMessage("Label.DialogGlobalConfig.hdrKey")};
                state.setMessage(CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args));
            } else if (value.length() == 0) {
                state.setValue(State.ERROR);
                state.setCode(1);
                args = new Object[]{CnfgResource.getMessage("Label.DialogGlobalConfig.hdrLocaleMapping")};
                state.setMessage(CnfgResource.getMessage("Message.globalConfiguration.empty.entry", args));
            } else if (value.indexOf(45) != -1 && this.m_languageOnly) {
                state.setValue(State.ERROR);
                state.setCode(3);
                args = new Object[]{CnfgResource.getMessage("Label.DialogGlobalConfig.hdrLocaleMapping")};
                state.setMessage(CnfgResource.getMessage("Message.globalConfiguration.language.only", args));
            } else if (!ToolkitResources.validateLocaleId((String)value)) {
                state.setValue(State.ERROR);
                state.setCode(2);
                args = new Object[]{value};
                state.setMessage(CnfgResource.getMessage("Message.globalConfiguration.invalid.locale", args));
            }
            if (state.getValue() == State.OK) {
                String sKey = ((String)this.m_key.get(row)).toString();
                for (int j = 0; j < this.m_key.size(); ++j) {
                    String sName;
                    if (j == row || sKey.compareTo(sName = ((String)this.m_key.get(j)).toString()) != 0) continue;
                    state.setCode(4);
                    Object[] args2 = new Object[]{sKey};
                    state.setMessage(CnfgResource.getMessage("Message.globalConfiguration.existing.entry", args2));
                    break;
                }
            }
            if (this.m_valid.size() > row) {
                this.m_valid.set(row, state);
            } else {
                this.m_valid.add(state);
            }
            return state.getCode();
        }
    }
}

