/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgTable;
import com.cognos.crconfig.CnfgTableModel;
import com.cognos.crconfig.CnfgTree;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.WebBrowser;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.CnfgValueChangedListener;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.i18n.ui.I18NBasicTextAreaUI;
import com.cognos.i18n.ui.I18NTextArea;
import com.cognos.i18n.ui.I18NWrappedPlainView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.WrappedPlainView;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringUtils;

public class InformationPanel
extends JPanel
implements CnfgValueChangedListener,
ListSelectionListener,
TreeSelectionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private static final Color m_BColor = new Color(255, 255, 204);
    private static final Color m_FColor = new Color(66, 66, 0);
    private I18NTextArea m_cInfoDesc;
    private I18NTextArea m_cInfoError;
    private I18NTextArea sDescTmp;
    private I18NTextArea sErrorTmp;
    Icon errorIcon = CnfgImageLoader.loadIcon("parameter_error.gif");
    Icon warningIcon = CnfgImageLoader.loadIcon("parameter_warning.gif");
    private JLabel m_cLabelError;
    private JPanel m_cPanelError;
    private JPanel m_cPanelHelpLink;
    private JLabel m_cLabelHelpLink;
    private JLabel m_cLabelHelpLinkDesc;
    private CRConfigFrame m_parentFrame;
    private JSplitPane m_parentSplitPane;
    private JScrollPane m_parentScrollPane;
    private CnfgTable m_table;
    private CnfgTableModel m_tableModel;

    public InformationPanel(CnfgTable table, CnfgTableModel tableModel, JSplitPane parentPane, JScrollPane scrollPane) {
        this.m_parentSplitPane = parentPane;
        this.m_parentScrollPane = scrollPane;
        this.m_parentFrame = null;
        this.initUI(table, tableModel);
    }

    public InformationPanel(CnfgTable table, CnfgTableModel tableModel, CRConfigFrame pframe) {
        this.m_parentFrame = pframe;
        this.m_parentSplitPane = null;
        this.initUI(table, tableModel);
    }

    private void initUI(CnfgTable table, CnfgTableModel tableModel) {
        this.m_table = table;
        this.m_tableModel = tableModel;
        this.setLayout(new BorderLayout());
        this.m_cInfoDesc = new I18NTextArea(CnfgResource.getLocale());
        this.m_cInfoDesc.setEditable(false);
        this.m_cInfoDesc.setRequestFocusEnabled(true);
        this.m_cInfoDesc.setLineWrap(true);
        this.m_cInfoDesc.setWrapStyleWord(true);
        this.setupHelpLinkPanel();
        this.m_cPanelError = new JPanel(new BorderLayout());
        this.m_cPanelError.setVisible(false);
        this.m_cLabelError = new JLabel(" ");
        this.m_cLabelError.setIcon(this.errorIcon);
        this.m_cLabelError.setVerticalAlignment(1);
        this.m_cLabelError.setIconTextGap(0);
        this.m_cInfoError = new I18NTextArea(CnfgResource.getLocale());
        this.m_cInfoError.setEditable(false);
        this.m_cInfoError.setRequestFocusEnabled(true);
        this.m_cInfoError.setLineWrap(true);
        this.m_cInfoError.setWrapStyleWord(true);
        this.setInfoPanelColor();
        this.m_cPanelError.add((Component)this.m_cLabelError, "West");
        this.m_cPanelError.add((Component)this.m_cInfoError, "Center");
        this.add((Component)this.m_cPanelError, "North");
        this.add((Component)this.m_cInfoDesc, "Center");
        this.add((Component)this.m_cPanelHelpLink, "South");
        this.sErrorTmp = new I18NTextArea("", CnfgResource.getLocale());
        this.sErrorTmp.setUI((TextUI)((Object)new CnfgBasicTextAreaUI(CnfgResource.getLocale())));
        this.sErrorTmp.setLineWrap(true);
        this.sErrorTmp.setWrapStyleWord(true);
        this.sDescTmp = new I18NTextArea("", CnfgResource.getLocale());
        this.sDescTmp.setUI((TextUI)((Object)new CnfgBasicTextAreaUI(CnfgResource.getLocale())));
        this.sDescTmp.setLineWrap(true);
        this.sDescTmp.setWrapStyleWord(true);
    }

    private void setupHelpLinkPanel() {
        String helplabel = CnfgResource.getMessage("Label.helplink.information");
        this.m_cPanelHelpLink = new JPanel(new BorderLayout());
        this.m_cLabelHelpLinkDesc = new JLabel(helplabel + " ");
        this.m_cLabelHelpLink = new JLabel(" ");
        this.m_cLabelHelpLink.setCursor(Cursor.getPredefinedCursor(12));
        this.m_cLabelHelpLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    JLabel linklabel = (JLabel)e.getSource();
                    WebBrowser.displayURL(linklabel.getToolTipText());
                }
                catch (Exception e1) {
                    CnfgLog.error("mouseClicked - exception: " + e1.getMessage());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JLabel linklabel = (JLabel)e.getSource();
                InformationPanel.this.m_cLabelHelpLink.setText(linklabel.getToolTipText());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JLabel linklabel = (JLabel)e.getSource();
                InformationPanel.this.m_cLabelHelpLink.setText("<html><a href=''>" + linklabel.getToolTipText() + "</a></html>");
            }
        });
        this.m_cPanelHelpLink.add((Component)this.m_cLabelHelpLinkDesc, "West");
        this.m_cPanelHelpLink.add((Component)this.m_cLabelHelpLink, "Center");
    }

    private void setInfoPanelColor() {
        if (CnfgUtils.isHighContrastWin()) {
            this.m_cInfoDesc.setForeground((Color)SystemColor.windowText);
            this.m_cInfoDesc.setBackground((Color)SystemColor.window);
            this.m_cPanelError.setBackground(SystemColor.window);
            this.m_cPanelError.setForeground(SystemColor.windowText);
            this.m_cLabelError.setBackground(SystemColor.window);
            this.m_cInfoError.setBackground((Color)SystemColor.window);
            this.m_cInfoError.setForeground((Color)SystemColor.windowText);
            this.m_cPanelHelpLink.setBackground(SystemColor.window);
            this.m_cPanelHelpLink.setForeground(SystemColor.windowText);
            this.m_cLabelHelpLinkDesc.setBackground(SystemColor.window);
            this.m_cLabelHelpLink.setBackground(SystemColor.window);
            this.m_cLabelHelpLink.setForeground(SystemColor.windowText);
        } else {
            this.m_cInfoDesc.setForeground(m_FColor);
            this.m_cInfoDesc.setBackground(m_BColor);
            this.m_cPanelError.setBackground(Color.white);
            this.m_cPanelError.setForeground(Color.black);
            this.m_cLabelError.setBackground(Color.white);
            this.m_cInfoError.setBackground(Color.white);
            this.m_cPanelHelpLink.setBackground(m_BColor);
            this.m_cPanelHelpLink.setForeground(m_FColor);
            this.m_cLabelHelpLinkDesc.setBackground(m_BColor);
            this.m_cLabelHelpLink.setBackground(m_BColor);
            this.m_cLabelHelpLink.setForeground(Color.BLUE);
        }
    }

    public void setParentPanels(JSplitPane splitPane, JScrollPane scrollPane) {
        this.m_parentSplitPane = splitPane;
        this.m_parentScrollPane = scrollPane;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.getPath() != null) {
            DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            Folder f = (Folder)cNode.getUserObject();
            this.updateContent(f);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateContent();
    }

    @Override
    public void valueChanged(CnfgValueChangedEvent e) {
        this.updateContent();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object obj = focusEvent.getSource();
        if (obj != null) {
            if (obj.getClass() == CnfgTree.class) {
                CnfgTree tree = (CnfgTree)obj;
                if (tree.getSelectionPath() != null) {
                    DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)tree.getSelectionPath().getLastPathComponent();
                    this.updateContent((Folder)cNode.getUserObject());
                } else {
                    this.displayInfo();
                }
            } else if (obj.getClass() == CnfgTable.class) {
                this.updateContent();
            }
        } else {
            this.displayInfo();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private void updateContent(Folder f) {
        this.displayInfo(f.getDesc(), f.getHelp(), f.getDocLink());
    }

    public void updateContent() {
        int row = this.m_table.getSelectionModel().getMinSelectionIndex();
        if (row != -1) {
            Parameter parm = this.m_tableModel.getItem(row);
            if (parm != null) {
                this.displayInfo(parm);
            } else {
                this.displayInfo();
            }
        }
    }

    private void displayInfo(Parameter parameter) {
        String error = parameter.getErrorMsgString();
        if (error != null && error.length() > 0) {
            if (parameter.hasWarnings()) {
                this.m_cLabelError.setIcon(this.warningIcon);
            } else {
                this.m_cLabelError.setIcon(this.errorIcon);
            }
            this.m_cInfoError.setText(error);
            this.m_cPanelError.setVisible(true);
        } else {
            this.m_cPanelError.setVisible(false);
        }
        String doclink = parameter.getDocLink();
        if (StringUtils.isBlank((String)doclink) && parameter.getParent() != null) {
            doclink = parameter.getParent().getDocLink();
        }
        this.displayInfo(parameter.getDesc(), parameter.getHelp(), doclink);
    }

    private void displayInfo(String desc, String help, String doclink) {
        if (desc != null && help != null) {
            StringBuffer sb = new StringBuffer(desc);
            sb.append("\n\n").append(help);
            this.m_cInfoDesc.setText(sb.toString());
        } else if (desc != null && help == null) {
            this.m_cInfoDesc.setText(desc);
        } else if (desc == null && help == null) {
            this.m_cInfoDesc.setText(CnfgResource.getMessage("Label.information.notavailable"));
        } else if (desc == null && help != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(CnfgResource.getMessage("Label.information.notavailable")).append("\n\n").append(help);
            this.m_cInfoDesc.setText(sb.toString());
        }
        if (!StringUtils.isBlank((String)doclink)) {
            this.m_cPanelHelpLink.setVisible(true);
            this.m_cLabelHelpLink.setToolTipText(doclink);
            this.m_cLabelHelpLink.setText(doclink);
        } else {
            this.m_cPanelHelpLink.setVisible(false);
        }
        this.displayInfo();
    }

    private void displayInfo() {
        this.m_cInfoDesc.setCaretPosition(0);
        this.m_cInfoError.setCaretPosition(0);
        if (this.m_parentFrame != null) {
            this.m_parentFrame.resizeInfoPane(this.m_parentFrame.m_infoTableSplitPane, this.m_parentFrame.m_infoScrollPane, this.m_parentFrame.m_infoPanel);
        } else if (this.m_parentSplitPane != null && this.m_parentScrollPane != null) {
            CRConfigFrame.getInstance().resizeInfoPane(this.m_parentSplitPane, this.m_parentScrollPane, this);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.m_cInfoDesc != null) {
            this.m_cInfoDesc.setFont(f);
        }
        if (this.m_cLabelError != null) {
            this.m_cLabelError.setFont(f);
        }
        if (this.m_cInfoError != null) {
            this.m_cInfoError.setFont(f);
        }
        if (this.m_parentFrame != null) {
            this.m_parentFrame.setScrollPaneMinSize(this.m_parentFrame.m_infoPanel, this.m_parentFrame.m_infoScrollPane);
        } else if (this.m_parentSplitPane != null) {
            this.m_parentFrame.setScrollPaneMinSize(this, this.m_parentScrollPane);
        }
    }

    public void resizeWidth(int width) {
        int len2 = 0;
        this.sDescTmp.setText(this.m_cInfoDesc.getText());
        if (this.m_cPanelError.isVisible()) {
            int len1 = 0;
            int labelWidth = this.m_cLabelError.getSize().width;
            this.sErrorTmp.setText(this.m_cInfoError.getText());
            this.sErrorTmp.setSize(width - labelWidth, this.m_cInfoError.getSize().height);
            len1 = this.getMinimumWidth((CnfgBasicTextAreaUI)((Object)this.sErrorTmp.getUI()));
            this.sDescTmp.setSize(width, this.m_cInfoError.getSize().height);
            len2 = this.getMinimumWidth((CnfgBasicTextAreaUI)((Object)this.sDescTmp.getUI()));
            if (len2 > width) {
                this.m_cInfoDesc.setSize(len2, this.m_cInfoDesc.getSize().height);
            } else {
                this.m_cInfoDesc.setSize(width, this.m_cInfoDesc.getSize().height);
            }
            if (len1 > width) {
                this.m_cInfoError.setSize(len1, this.m_cInfoError.getSize().height);
            } else {
                this.m_cInfoError.setSize(width - labelWidth, this.m_cInfoError.getSize().height);
            }
        } else {
            this.sDescTmp.setSize(width, this.m_cInfoError.getSize().height);
            len2 = this.getMinimumWidth((CnfgBasicTextAreaUI)((Object)this.sDescTmp.getUI()));
            if (len2 > width) {
                this.m_cInfoDesc.setSize(len2, this.m_cInfoDesc.getSize().height);
            } else {
                this.m_cInfoDesc.setSize(width, this.m_cInfoDesc.getSize().height);
            }
        }
    }

    protected int getMinimumWidth(CnfgBasicTextAreaUI bui) {
        int min = 0;
        CnfgWrappedPlainView v = bui.getCnfgView();
        if (v != null) {
            return v.getWrappedLineWidth();
        }
        return min;
    }

    @Override
    public void paint(Graphics g) {
        if (CnfgFontSetting.useSystemFontAndColor()) {
            CnfgFontSetting.refreshWithSystemFont();
        }
        super.paint(g);
    }

    public class CnfgWrappedPlainView
    extends I18NWrappedPlainView {
        Segment lineBuffer;
        FontMetrics metrics;

        public CnfgWrappedPlainView(Element elem, boolean wordWrap, Locale locale) {
            super(elem, wordWrap, locale);
        }

        public int getWrappedLineWidth() {
            int min = 0;
            int lineWidth = 0;
            Container host = this.getContainer();
            if (host == null) {
                return lineWidth;
            }
            Font f = host.getFont();
            this.metrics = host.getFontMetrics(f);
            int p1 = this.getEndOffset();
            if (this.lineBuffer == null) {
                this.lineBuffer = new Segment();
            }
            int p0 = this.getStartOffset();
            while (p0 < p1) {
                int p = this.calculateBreakPosition(p0, p1);
                if (p0 == p) {
                    if (min < p1 - p0) {
                        this.loadText(p0, p1);
                        lineWidth = Utilities.getTabbedTextWidth(this.lineBuffer, this.metrics, this.getTabSize(), (TabExpander)((Object)this), p0);
                        min = p1 - p0;
                    }
                } else if (min < p - p0) {
                    this.loadText(p0, p);
                    min = p - p0;
                    lineWidth = Utilities.getTabbedTextWidth(this.lineBuffer, this.metrics, this.getTabSize(), (TabExpander)((Object)this), p0);
                }
                p0 = p == p0 ? p1 : p;
            }
            return lineWidth;
        }

        final void loadText(int p0, int p1) {
            try {
                Document doc = this.getDocument();
                doc.getText(p0, p1 - p0, this.lineBuffer);
            }
            catch (BadLocationException bl) {
                CnfgLog.error(CnfgResource.getMessage("Message.errorOnWrapping.getDocument"));
            }
        }
    }

    class CnfgBasicTextAreaUI
    extends I18NBasicTextAreaUI {
        CnfgWrappedPlainView cnfgView;

        public CnfgBasicTextAreaUI(Locale locale) {
            super(locale);
        }

        public View create(Element elem) {
            View view = super.create(elem);
            if (view instanceof WrappedPlainView) {
                CnfgWrappedPlainView i18nView;
                this.cnfgView = i18nView = new CnfgWrappedPlainView(elem, true, CnfgResource.getLocale());
                return i18nView;
            }
            return view;
        }

        public CnfgWrappedPlainView getCnfgView() {
            return this.cnfgView;
        }
    }
}

